// Generated by delombok at Wed Sep 05 10:26:02 PDT 2018
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.math.BigDecimal;
import java.util.Map;

public class ExchangeRate extends ApiResource implements HasId {
  String id;
  String object;
  Map<String, BigDecimal> rates;

  // <editor-fold desc="list">
  /**
   * List all exchange rates.
   */
  public static ExchangeRateCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all exchange rates.
   */
  public static ExchangeRateCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(ExchangeRate.class), params, ExchangeRateCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve an exchange rate.
   */
  public static ExchangeRate retrieve(String currency) throws StripeException {
    return retrieve(currency, null);
  }

  /**
   * Retrieve an exchange rate.
   */
  public static ExchangeRate retrieve(String currency, RequestOptions options) throws StripeException {
    return retrieve(currency, null, options);
  }

  /**
   * Retrieve an exchange rate.
   */
  public static ExchangeRate retrieve(String currency, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(ExchangeRate.class, currency), params, ExchangeRate.class, options);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, BigDecimal> getRates() {
    return this.rates;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRates(final Map<String, BigDecimal> rates) {
    this.rates = rates;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ExchangeRate)) return false;
    final ExchangeRate other = (ExchangeRate) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$rates = this.getRates();
    final java.lang.Object other$rates = other.getRates();
    if (this$rates == null ? other$rates != null : !this$rates.equals(other$rates)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ExchangeRate;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $rates = this.getRates();
    result = result * PRIME + ($rates == null ? 43 : $rates.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
  // </editor-fold>
}
