// Generated by delombok at Wed Sep 05 15:06:54 PDT 2018
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class Sku extends ApiResource implements HasId, MetadataStore<Sku> {
  String id;
  String object;
  Boolean active;
  Map<String, String> attributes;
  Long created;
  String currency;
  String image;
  Inventory inventory;
  Boolean livemode;
  Map<String, String> metadata;
  PackageDimensions packageDimensions;
  Long price;
  ExpandableField<Product> product;
  Long updated;
  Boolean deleted;

  // <editor-fold desc="product">
  public String getProduct() {
    return (this.product != null) ? this.product.getId() : null;
  }

  public void setProduct(String productId) {
    this.product = setExpandableFieldId(productId, this.product);
  }

  public Product getProductObject() {
    return (this.product != null) ? this.product.getExpanded() : null;
  }

  public void setProductObject(Product product) {
    this.product = new ExpandableField<Product>(product.getId(), product);
  }

  // </editor-fold>
  // <editor-fold desc="create">
  /**
   * Create a SKU.
   */
  public static Sku create(Map<String, Object> params) throws StripeException {
    return create(params, null);
  }

  /**
   * Create a SKU.
   */
  public static Sku create(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, classUrl(Sku.class), params, Sku.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="delete">
  /**
   * Delete a SKU.
   */
  public Sku delete() throws StripeException {
    return delete(null);
  }

  /**
   * Delete a SKU.
   */
  public Sku delete(RequestOptions options) throws StripeException {
    return request(RequestMethod.DELETE, instanceUrl(Sku.class, this.id), null, Sku.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="list">
  /**
   * List all SKUs.
   */
  public static SkuCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all SKUs.
   */
  public static SkuCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(Sku.class), params, SkuCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve a SKU.
   */
  public static Sku retrieve(String id) throws StripeException {
    return retrieve(id, null);
  }

  /**
   * Retrieve a SKU.
   */
  public static Sku retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve a SKU.
   */
  public static Sku retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(Sku.class, id), params, Sku.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="update">
  /**
   * Update a SKU.
   */
  @Override
  public Sku update(Map<String, Object> params) throws StripeException {
    return update(params, null);
  }

  /**
   * Update a SKU.
   */
  @Override
  public Sku update(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, instanceUrl(Sku.class, this.id), params, Sku.class, options);
  }

  // </editor-fold>
  public static class Inventory {
    String type;
    Long quantity;
    String value;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQuantity() {
      return this.quantity;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setQuantity(final Long quantity) {
      this.quantity = quantity;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setValue(final String value) {
      this.value = value;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Sku.Inventory)) return false;
      final Sku.Inventory other = (Sku.Inventory) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      final java.lang.Object this$quantity = this.getQuantity();
      final java.lang.Object other$quantity = other.getQuantity();
      if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) return false;
      final java.lang.Object this$value = this.getValue();
      final java.lang.Object other$value = other.getValue();
      if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Sku.Inventory;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      final java.lang.Object $quantity = this.getQuantity();
      result = result * PRIME + ($quantity == null ? 43 : $quantity.hashCode());
      final java.lang.Object $value = this.getValue();
      result = result * PRIME + ($value == null ? 43 : $value.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getActive() {
    return this.active;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getAttributes() {
    return this.attributes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getImage() {
    return this.image;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Inventory getInventory() {
    return this.inventory;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PackageDimensions getPackageDimensions() {
    return this.packageDimensions;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getPrice() {
    return this.price;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getUpdated() {
    return this.updated;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setActive(final Boolean active) {
    this.active = active;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAttributes(final Map<String, String> attributes) {
    this.attributes = attributes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setImage(final String image) {
    this.image = image;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setInventory(final Inventory inventory) {
    this.inventory = inventory;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPackageDimensions(final PackageDimensions packageDimensions) {
    this.packageDimensions = packageDimensions;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPrice(final Long price) {
    this.price = price;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUpdated(final Long updated) {
    this.updated = updated;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Sku)) return false;
    final Sku other = (Sku) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$active = this.getActive();
    final java.lang.Object other$active = other.getActive();
    if (this$active == null ? other$active != null : !this$active.equals(other$active)) return false;
    final java.lang.Object this$attributes = this.getAttributes();
    final java.lang.Object other$attributes = other.getAttributes();
    if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$image = this.getImage();
    final java.lang.Object other$image = other.getImage();
    if (this$image == null ? other$image != null : !this$image.equals(other$image)) return false;
    final java.lang.Object this$inventory = this.getInventory();
    final java.lang.Object other$inventory = other.getInventory();
    if (this$inventory == null ? other$inventory != null : !this$inventory.equals(other$inventory)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$packageDimensions = this.getPackageDimensions();
    final java.lang.Object other$packageDimensions = other.getPackageDimensions();
    if (this$packageDimensions == null ? other$packageDimensions != null : !this$packageDimensions.equals(other$packageDimensions)) return false;
    final java.lang.Object this$price = this.getPrice();
    final java.lang.Object other$price = other.getPrice();
    if (this$price == null ? other$price != null : !this$price.equals(other$price)) return false;
    final java.lang.Object this$product = this.getProduct();
    final java.lang.Object other$product = other.getProduct();
    if (this$product == null ? other$product != null : !this$product.equals(other$product)) return false;
    final java.lang.Object this$updated = this.getUpdated();
    final java.lang.Object other$updated = other.getUpdated();
    if (this$updated == null ? other$updated != null : !this$updated.equals(other$updated)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Sku;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $active = this.getActive();
    result = result * PRIME + ($active == null ? 43 : $active.hashCode());
    final java.lang.Object $attributes = this.getAttributes();
    result = result * PRIME + ($attributes == null ? 43 : $attributes.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $image = this.getImage();
    result = result * PRIME + ($image == null ? 43 : $image.hashCode());
    final java.lang.Object $inventory = this.getInventory();
    result = result * PRIME + ($inventory == null ? 43 : $inventory.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $packageDimensions = this.getPackageDimensions();
    result = result * PRIME + ($packageDimensions == null ? 43 : $packageDimensions.hashCode());
    final java.lang.Object $price = this.getPrice();
    result = result * PRIME + ($price == null ? 43 : $price.hashCode());
    final java.lang.Object $product = this.getProduct();
    result = result * PRIME + ($product == null ? 43 : $product.hashCode());
    final java.lang.Object $updated = this.getUpdated();
    result = result * PRIME + ($updated == null ? 43 : $updated.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
