/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.model.CustomerCardCollection;
import com.stripe.model.CustomerCollection;
import com.stripe.model.CustomerSubscriptionCollection;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExternalAccount;
import com.stripe.model.ExternalAccountCollection;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.ShippingDetails;
import com.stripe.model.StripeObject;
import com.stripe.model.Subscription;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.Map;
import lombok.Generated;

public class Customer
extends ApiResource
implements MetadataStore<Customer>,
HasId {
    String id;
    String object;
    Long accountBalance;
    Long created;
    String currency;
    ExpandableField<ExternalAccount> defaultSource;
    Boolean deleted;
    Boolean delinquent;
    String description;
    Discount discount;
    String email;
    Boolean livemode;
    Map<String, String> metadata;
    ShippingDetails shipping;
    ExternalAccountCollection sources;
    CustomerSubscriptionCollection subscriptions;
    TaxInfo taxInfo;
    TaxInfoVerification taxInfoVerification;
    @Deprecated
    String businessVatId;
    @Deprecated
    CustomerCardCollection cards;
    @Deprecated
    String defaultCard;
    @Deprecated
    NextRecurringCharge nextRecurringCharge;
    @Deprecated
    Subscription subscription;
    @Deprecated
    Long trialEnd;

    public String getDefaultSource() {
        return this.defaultSource != null ? this.defaultSource.getId() : null;
    }

    public void setDefaultSource(String defaultSourceId) {
        this.defaultSource = Customer.setExpandableFieldId(defaultSourceId, this.defaultSource);
    }

    public ExternalAccount getDefaultSourceObject() {
        return this.defaultSource != null ? this.defaultSource.getExpanded() : null;
    }

    public void setDefaultSourceObject(ExternalAccount c) {
        this.defaultSource = new ExpandableField<ExternalAccount>(c.getId(), c);
    }

    public static Customer create(Map<String, Object> params) throws StripeException {
        return Customer.create(params, null);
    }

    public static Customer create(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Customer.request(ApiResource.RequestMethod.POST, Customer.classUrl(Customer.class), params, Customer.class, options);
    }

    public Customer delete() throws StripeException {
        return this.delete(null);
    }

    public Customer delete(RequestOptions options) throws StripeException {
        return Customer.request(ApiResource.RequestMethod.DELETE, Customer.instanceUrl(Customer.class, this.id), null, Customer.class, options);
    }

    public void deleteDiscount() throws StripeException {
        this.deleteDiscount(null);
    }

    public void deleteDiscount(RequestOptions options) throws StripeException {
        Customer.request(ApiResource.RequestMethod.DELETE, String.format("%s/discount", Customer.instanceUrl(Customer.class, this.id)), null, Discount.class, options);
    }

    public static CustomerCollection list(Map<String, Object> params) throws StripeException {
        return Customer.list(params, null);
    }

    public static CustomerCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Customer.requestCollection(Customer.classUrl(Customer.class), params, CustomerCollection.class, options);
    }

    public static Customer retrieve(String id) throws StripeException {
        return Customer.retrieve(id, null);
    }

    public static Customer retrieve(String id, RequestOptions options) throws StripeException {
        return Customer.retrieve(id, null, options);
    }

    public static Customer retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        return Customer.request(ApiResource.RequestMethod.GET, Customer.instanceUrl(Customer.class, id), params, Customer.class, options);
    }

    public Customer update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Customer update(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Customer.request(ApiResource.RequestMethod.POST, Customer.instanceUrl(Customer.class, this.id), params, Customer.class, options);
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getAccountBalance() {
        return this.accountBalance;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public Boolean getDelinquent() {
        return this.delinquent;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Discount getDiscount() {
        return this.discount;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public ShippingDetails getShipping() {
        return this.shipping;
    }

    @Generated
    public ExternalAccountCollection getSources() {
        return this.sources;
    }

    @Generated
    public CustomerSubscriptionCollection getSubscriptions() {
        return this.subscriptions;
    }

    @Generated
    public TaxInfo getTaxInfo() {
        return this.taxInfo;
    }

    @Generated
    public TaxInfoVerification getTaxInfoVerification() {
        return this.taxInfoVerification;
    }

    @Deprecated
    @Generated
    public String getBusinessVatId() {
        return this.businessVatId;
    }

    @Deprecated
    @Generated
    public CustomerCardCollection getCards() {
        return this.cards;
    }

    @Deprecated
    @Generated
    public String getDefaultCard() {
        return this.defaultCard;
    }

    @Deprecated
    @Generated
    public NextRecurringCharge getNextRecurringCharge() {
        return this.nextRecurringCharge;
    }

    @Deprecated
    @Generated
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Deprecated
    @Generated
    public Long getTrialEnd() {
        return this.trialEnd;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setAccountBalance(Long accountBalance) {
        this.accountBalance = accountBalance;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDelinquent(Boolean delinquent) {
        this.delinquent = delinquent;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    @Generated
    public void setSources(ExternalAccountCollection sources) {
        this.sources = sources;
    }

    @Generated
    public void setSubscriptions(CustomerSubscriptionCollection subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Generated
    public void setTaxInfo(TaxInfo taxInfo) {
        this.taxInfo = taxInfo;
    }

    @Generated
    public void setTaxInfoVerification(TaxInfoVerification taxInfoVerification) {
        this.taxInfoVerification = taxInfoVerification;
    }

    @Deprecated
    @Generated
    public void setBusinessVatId(String businessVatId) {
        this.businessVatId = businessVatId;
    }

    @Deprecated
    @Generated
    public void setCards(CustomerCardCollection cards) {
        this.cards = cards;
    }

    @Deprecated
    @Generated
    public void setDefaultCard(String defaultCard) {
        this.defaultCard = defaultCard;
    }

    @Deprecated
    @Generated
    public void setNextRecurringCharge(NextRecurringCharge nextRecurringCharge) {
        this.nextRecurringCharge = nextRecurringCharge;
    }

    @Deprecated
    @Generated
    public void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    @Deprecated
    @Generated
    public void setTrialEnd(Long trialEnd) {
        this.trialEnd = trialEnd;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Customer)) {
            return false;
        }
        Customer other = (Customer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$accountBalance = this.getAccountBalance();
        Long other$accountBalance = other.getAccountBalance();
        if (this$accountBalance == null ? other$accountBalance != null : !((Object)this$accountBalance).equals(other$accountBalance)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$defaultSource = this.getDefaultSource();
        String other$defaultSource = other.getDefaultSource();
        if (this$defaultSource == null ? other$defaultSource != null : !this$defaultSource.equals(other$defaultSource)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$delinquent = this.getDelinquent();
        Boolean other$delinquent = other.getDelinquent();
        if (this$delinquent == null ? other$delinquent != null : !((Object)this$delinquent).equals(other$delinquent)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Discount this$discount = this.getDiscount();
        Discount other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        ShippingDetails this$shipping = this.getShipping();
        ShippingDetails other$shipping = other.getShipping();
        if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
            return false;
        }
        ExternalAccountCollection this$sources = this.getSources();
        ExternalAccountCollection other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources)) {
            return false;
        }
        CustomerSubscriptionCollection this$subscriptions = this.getSubscriptions();
        CustomerSubscriptionCollection other$subscriptions = other.getSubscriptions();
        if (this$subscriptions == null ? other$subscriptions != null : !((Object)this$subscriptions).equals(other$subscriptions)) {
            return false;
        }
        TaxInfo this$taxInfo = this.getTaxInfo();
        TaxInfo other$taxInfo = other.getTaxInfo();
        if (this$taxInfo == null ? other$taxInfo != null : !((Object)this$taxInfo).equals(other$taxInfo)) {
            return false;
        }
        TaxInfoVerification this$taxInfoVerification = this.getTaxInfoVerification();
        TaxInfoVerification other$taxInfoVerification = other.getTaxInfoVerification();
        if (this$taxInfoVerification == null ? other$taxInfoVerification != null : !((Object)this$taxInfoVerification).equals(other$taxInfoVerification)) {
            return false;
        }
        String this$businessVatId = this.getBusinessVatId();
        String other$businessVatId = other.getBusinessVatId();
        if (this$businessVatId == null ? other$businessVatId != null : !this$businessVatId.equals(other$businessVatId)) {
            return false;
        }
        CustomerCardCollection this$cards = this.getCards();
        CustomerCardCollection other$cards = other.getCards();
        if (this$cards == null ? other$cards != null : !((Object)this$cards).equals(other$cards)) {
            return false;
        }
        String this$defaultCard = this.getDefaultCard();
        String other$defaultCard = other.getDefaultCard();
        if (this$defaultCard == null ? other$defaultCard != null : !this$defaultCard.equals(other$defaultCard)) {
            return false;
        }
        NextRecurringCharge this$nextRecurringCharge = this.getNextRecurringCharge();
        NextRecurringCharge other$nextRecurringCharge = other.getNextRecurringCharge();
        if (this$nextRecurringCharge == null ? other$nextRecurringCharge != null : !((Object)this$nextRecurringCharge).equals(other$nextRecurringCharge)) {
            return false;
        }
        Subscription this$subscription = this.getSubscription();
        Subscription other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !((Object)this$subscription).equals(other$subscription)) {
            return false;
        }
        Long this$trialEnd = this.getTrialEnd();
        Long other$trialEnd = other.getTrialEnd();
        return !(this$trialEnd == null ? other$trialEnd != null : !((Object)this$trialEnd).equals(other$trialEnd));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Customer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $accountBalance = this.getAccountBalance();
        result = result * 59 + ($accountBalance == null ? 43 : ((Object)$accountBalance).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $defaultSource = this.getDefaultSource();
        result = result * 59 + ($defaultSource == null ? 43 : $defaultSource.hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $delinquent = this.getDelinquent();
        result = result * 59 + ($delinquent == null ? 43 : ((Object)$delinquent).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Discount $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        ShippingDetails $shipping = this.getShipping();
        result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
        ExternalAccountCollection $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        CustomerSubscriptionCollection $subscriptions = this.getSubscriptions();
        result = result * 59 + ($subscriptions == null ? 43 : ((Object)$subscriptions).hashCode());
        TaxInfo $taxInfo = this.getTaxInfo();
        result = result * 59 + ($taxInfo == null ? 43 : ((Object)$taxInfo).hashCode());
        TaxInfoVerification $taxInfoVerification = this.getTaxInfoVerification();
        result = result * 59 + ($taxInfoVerification == null ? 43 : ((Object)$taxInfoVerification).hashCode());
        String $businessVatId = this.getBusinessVatId();
        result = result * 59 + ($businessVatId == null ? 43 : $businessVatId.hashCode());
        CustomerCardCollection $cards = this.getCards();
        result = result * 59 + ($cards == null ? 43 : ((Object)$cards).hashCode());
        String $defaultCard = this.getDefaultCard();
        result = result * 59 + ($defaultCard == null ? 43 : $defaultCard.hashCode());
        NextRecurringCharge $nextRecurringCharge = this.getNextRecurringCharge();
        result = result * 59 + ($nextRecurringCharge == null ? 43 : ((Object)$nextRecurringCharge).hashCode());
        Subscription $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : ((Object)$subscription).hashCode());
        Long $trialEnd = this.getTrialEnd();
        result = result * 59 + ($trialEnd == null ? 43 : ((Object)$trialEnd).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class TaxInfoVerification
    extends StripeObject {
        String status;
        String verifiedName;

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public String getVerifiedName() {
            return this.verifiedName;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setVerifiedName(String verifiedName) {
            this.verifiedName = verifiedName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaxInfoVerification)) {
                return false;
            }
            TaxInfoVerification other = (TaxInfoVerification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$verifiedName = this.getVerifiedName();
            String other$verifiedName = other.getVerifiedName();
            return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaxInfoVerification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $verifiedName = this.getVerifiedName();
            result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
            return result;
        }
    }

    public static class TaxInfo
    extends StripeObject {
        String taxId;
        String type;

        @Generated
        public String getTaxId() {
            return this.taxId;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setTaxId(String taxId) {
            this.taxId = taxId;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaxInfo)) {
                return false;
            }
            TaxInfo other = (TaxInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$taxId = this.getTaxId();
            String other$taxId = other.getTaxId();
            if (this$taxId == null ? other$taxId != null : !this$taxId.equals(other$taxId)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaxInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $taxId = this.getTaxId();
            result = result * 59 + ($taxId == null ? 43 : $taxId.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }

    public static class NextRecurringCharge
    extends StripeObject {
        Long amount;
        String date;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public String getDate() {
            return this.date;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setDate(String date) {
            this.date = date;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextRecurringCharge)) {
                return false;
            }
            NextRecurringCharge other = (NextRecurringCharge)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$date = this.getDate();
            String other$date = other.getDate();
            return !(this$date == null ? other$date != null : !this$date.equals(other$date));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NextRecurringCharge;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : $date.hashCode());
            return result;
        }
    }
}

