// Generated by delombok at Thu Sep 06 09:04:47 PDT 2018
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class ApplePayDomain extends ApiResource implements HasId {
  String id;
  String object;
  Long created;
  String domainName;
  Boolean livemode;
  Boolean deleted;

  // <editor-fold desc="create">
  /**
   * Create an Apple Pay domain.
   */
  public static ApplePayDomain create(Map<String, Object> params) throws StripeException {
    return create(params, null);
  }

  /**
   * Create an Apple Pay domain.
   */
  public static ApplePayDomain create(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, getClassUrl(), params, ApplePayDomain.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="delete">
  /**
   * Delete an Apple Pay domain.
   */
  public ApplePayDomain delete() throws StripeException {
    return delete(null);
  }

  /**
   * Delete an Apple Pay domain.
   */
  public ApplePayDomain delete(RequestOptions options) throws StripeException {
    return request(RequestMethod.DELETE, getInstanceUrl(id), null, ApplePayDomain.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="list">
  /**
   * List all Apple Pay domains.
   */
  public static ApplePayDomainCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all Apple Pay domains.
   */
  public static ApplePayDomainCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(getClassUrl(), params, ApplePayDomainCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve an Apple Pay domain.
   */
  public static ApplePayDomain retrieve(String id) throws StripeException {
    return retrieve(id, null);
  }

  /**
   * Retrieve an Apple Pay domain.
   */
  public static ApplePayDomain retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve an Apple Pay domain.
   */
  public static ApplePayDomain retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, getInstanceUrl(id), params, ApplePayDomain.class, options);
  }

  // </editor-fold>
  private static String getClassUrl() {
    return String.format("%s/v1/%s", Stripe.getApiBase(), "apple_pay/domains");
  }

  private static String getInstanceUrl(String id) {
    if (id != null && !id.isEmpty()) {
      return String.format("%s/%s", getClassUrl(), id);
    }
    return null;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDomainName() {
    return this.domainName;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDomainName(final String domainName) {
    this.domainName = domainName;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ApplePayDomain)) return false;
    final ApplePayDomain other = (ApplePayDomain) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$domainName = this.getDomainName();
    final java.lang.Object other$domainName = other.getDomainName();
    if (this$domainName == null ? other$domainName != null : !this$domainName.equals(other$domainName)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ApplePayDomain;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $domainName = this.getDomainName();
    result = result * PRIME + ($domainName == null ? 43 : $domainName.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
