// Generated by delombok at Thu Aug 02 11:02:27 CEST 2018
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class CountrySpec extends ApiResource implements HasId {
  String id;
  String object;
  String defaultCurrency;
  Map<String, List<String>> supportedBankAccountCurrencies;
  List<String> supportedPaymentCurrencies;
  List<String> supportedPaymentMethods;
  VerificationFields verificationFields;

  // <editor-fold desc="list">
  /**
   * List country specs.
   */
  public static CountrySpecCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List country specs.
   */
  public static CountrySpecCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(CountrySpec.class), params, CountrySpecCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve a country spec.
   */
  public static CountrySpec retrieve(String country) throws StripeException {
    return retrieve(country, null);
  }

  /**
   * Retrieve a country spec.
   */
  public static CountrySpec retrieve(String country, RequestOptions options) throws StripeException {
    return retrieve(country, null, options);
  }

  /**
   * Retrieve a country spec.
   */
  public static CountrySpec retrieve(String country, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(CountrySpec.class, country), params, CountrySpec.class, options);
  }

  // </editor-fold>
  public static class VerificationFields extends StripeObject {
    Details individual;
    Details company;


    public static class Details extends StripeObject {
      List<String> additional;
      List<String> minimum;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getAdditional() {
        return this.additional;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getMinimum() {
        return this.minimum;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAdditional(final List<String> additional) {
        this.additional = additional;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMinimum(final List<String> minimum) {
        this.minimum = minimum;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CountrySpec.VerificationFields.Details)) return false;
        final CountrySpec.VerificationFields.Details other = (CountrySpec.VerificationFields.Details) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$additional = this.getAdditional();
        final java.lang.Object other$additional = other.getAdditional();
        if (this$additional == null ? other$additional != null : !this$additional.equals(other$additional)) return false;
        final java.lang.Object this$minimum = this.getMinimum();
        final java.lang.Object other$minimum = other.getMinimum();
        if (this$minimum == null ? other$minimum != null : !this$minimum.equals(other$minimum)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof CountrySpec.VerificationFields.Details;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $additional = this.getAdditional();
        result = result * PRIME + ($additional == null ? 43 : $additional.hashCode());
        final java.lang.Object $minimum = this.getMinimum();
        result = result * PRIME + ($minimum == null ? 43 : $minimum.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Details getIndividual() {
      return this.individual;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Details getCompany() {
      return this.company;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIndividual(final Details individual) {
      this.individual = individual;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCompany(final Details company) {
      this.company = company;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof CountrySpec.VerificationFields)) return false;
      final CountrySpec.VerificationFields other = (CountrySpec.VerificationFields) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$individual = this.getIndividual();
      final java.lang.Object other$individual = other.getIndividual();
      if (this$individual == null ? other$individual != null : !this$individual.equals(other$individual)) return false;
      final java.lang.Object this$company = this.getCompany();
      final java.lang.Object other$company = other.getCompany();
      if (this$company == null ? other$company != null : !this$company.equals(other$company)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof CountrySpec.VerificationFields;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $individual = this.getIndividual();
      result = result * PRIME + ($individual == null ? 43 : $individual.hashCode());
      final java.lang.Object $company = this.getCompany();
      result = result * PRIME + ($company == null ? 43 : $company.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDefaultCurrency() {
    return this.defaultCurrency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, List<String>> getSupportedBankAccountCurrencies() {
    return this.supportedBankAccountCurrencies;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getSupportedPaymentCurrencies() {
    return this.supportedPaymentCurrencies;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getSupportedPaymentMethods() {
    return this.supportedPaymentMethods;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public VerificationFields getVerificationFields() {
    return this.verificationFields;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDefaultCurrency(final String defaultCurrency) {
    this.defaultCurrency = defaultCurrency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSupportedBankAccountCurrencies(final Map<String, List<String>> supportedBankAccountCurrencies) {
    this.supportedBankAccountCurrencies = supportedBankAccountCurrencies;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSupportedPaymentCurrencies(final List<String> supportedPaymentCurrencies) {
    this.supportedPaymentCurrencies = supportedPaymentCurrencies;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSupportedPaymentMethods(final List<String> supportedPaymentMethods) {
    this.supportedPaymentMethods = supportedPaymentMethods;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVerificationFields(final VerificationFields verificationFields) {
    this.verificationFields = verificationFields;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof CountrySpec)) return false;
    final CountrySpec other = (CountrySpec) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$defaultCurrency = this.getDefaultCurrency();
    final java.lang.Object other$defaultCurrency = other.getDefaultCurrency();
    if (this$defaultCurrency == null ? other$defaultCurrency != null : !this$defaultCurrency.equals(other$defaultCurrency)) return false;
    final java.lang.Object this$supportedBankAccountCurrencies = this.getSupportedBankAccountCurrencies();
    final java.lang.Object other$supportedBankAccountCurrencies = other.getSupportedBankAccountCurrencies();
    if (this$supportedBankAccountCurrencies == null ? other$supportedBankAccountCurrencies != null : !this$supportedBankAccountCurrencies.equals(other$supportedBankAccountCurrencies)) return false;
    final java.lang.Object this$supportedPaymentCurrencies = this.getSupportedPaymentCurrencies();
    final java.lang.Object other$supportedPaymentCurrencies = other.getSupportedPaymentCurrencies();
    if (this$supportedPaymentCurrencies == null ? other$supportedPaymentCurrencies != null : !this$supportedPaymentCurrencies.equals(other$supportedPaymentCurrencies)) return false;
    final java.lang.Object this$supportedPaymentMethods = this.getSupportedPaymentMethods();
    final java.lang.Object other$supportedPaymentMethods = other.getSupportedPaymentMethods();
    if (this$supportedPaymentMethods == null ? other$supportedPaymentMethods != null : !this$supportedPaymentMethods.equals(other$supportedPaymentMethods)) return false;
    final java.lang.Object this$verificationFields = this.getVerificationFields();
    final java.lang.Object other$verificationFields = other.getVerificationFields();
    if (this$verificationFields == null ? other$verificationFields != null : !this$verificationFields.equals(other$verificationFields)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof CountrySpec;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $defaultCurrency = this.getDefaultCurrency();
    result = result * PRIME + ($defaultCurrency == null ? 43 : $defaultCurrency.hashCode());
    final java.lang.Object $supportedBankAccountCurrencies = this.getSupportedBankAccountCurrencies();
    result = result * PRIME + ($supportedBankAccountCurrencies == null ? 43 : $supportedBankAccountCurrencies.hashCode());
    final java.lang.Object $supportedPaymentCurrencies = this.getSupportedPaymentCurrencies();
    result = result * PRIME + ($supportedPaymentCurrencies == null ? 43 : $supportedPaymentCurrencies.hashCode());
    final java.lang.Object $supportedPaymentMethods = this.getSupportedPaymentMethods();
    result = result * PRIME + ($supportedPaymentMethods == null ? 43 : $supportedPaymentMethods.hashCode());
    final java.lang.Object $verificationFields = this.getVerificationFields();
    result = result * PRIME + ($verificationFields == null ? 43 : $verificationFields.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
