/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.DisputeCollection;
import com.stripe.model.issuing.Transaction;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.Map;
import lombok.Generated;

public class Dispute
extends ApiResource
implements MetadataStore<Dispute>,
HasId {
    String id;
    String object;
    Long amount;
    Long created;
    Evidence evidence;
    Boolean livemode;
    Map<String, String> metadata;
    String reason;
    String status;
    ExpandableField<Transaction> transaction;

    public String getTransaction() {
        return this.transaction != null ? this.transaction.getId() : null;
    }

    public void setTransaction(String transactionId) {
        this.transaction = Dispute.setExpandableFieldId(transactionId, this.transaction);
    }

    public Transaction getTransactionObject() {
        return this.transaction != null ? this.transaction.getExpanded() : null;
    }

    public void setTransactionObject(Transaction c) {
        this.transaction = new ExpandableField<Transaction>(c.getId(), c);
    }

    public static Dispute create(Map<String, Object> params) throws StripeException {
        return Dispute.create(params, null);
    }

    public static Dispute create(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Dispute.request(ApiResource.RequestMethod.POST, Dispute.classUrl(Dispute.class), params, Dispute.class, options);
    }

    public static DisputeCollection list(Map<String, Object> params) throws StripeException {
        return Dispute.list(params, null);
    }

    public static DisputeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Dispute.requestCollection(Dispute.classUrl(Dispute.class), params, DisputeCollection.class, options);
    }

    public static Dispute retrieve(String id) throws StripeException {
        return Dispute.retrieve(id, null);
    }

    public static Dispute retrieve(String id, RequestOptions options) throws StripeException {
        return Dispute.retrieve(id, null, options);
    }

    public static Dispute retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        return Dispute.request(ApiResource.RequestMethod.GET, Dispute.instanceUrl(Dispute.class, id), params, Dispute.class, options);
    }

    public Dispute update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Dispute update(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Dispute.request(ApiResource.RequestMethod.POST, Dispute.instanceUrl(Dispute.class, this.id), params, Dispute.class, options);
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Evidence getEvidence() {
        return this.evidence;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setEvidence(Evidence evidence) {
        this.evidence = evidence;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dispute)) {
            return false;
        }
        Dispute other = (Dispute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Evidence this$evidence = this.getEvidence();
        Evidence other$evidence = other.getEvidence();
        if (this$evidence == null ? other$evidence != null : !((Object)this$evidence).equals(other$evidence)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$transaction = this.getTransaction();
        String other$transaction = other.getTransaction();
        return !(this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Dispute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Evidence $evidence = this.getEvidence();
        result = result * 59 + ($evidence == null ? 43 : ((Object)$evidence).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $transaction = this.getTransaction();
        result = result * 59 + ($transaction == null ? 43 : $transaction.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public final class Evidence
    extends StripeObject {
        EvidenceFraudulent fraudulent;
        EvidenceOther other;

        @Generated
        public EvidenceFraudulent getFraudulent() {
            return this.fraudulent;
        }

        @Generated
        public EvidenceOther getOther() {
            return this.other;
        }

        @Generated
        public void setFraudulent(EvidenceFraudulent fraudulent) {
            this.fraudulent = fraudulent;
        }

        @Generated
        public void setOther(EvidenceOther other) {
            this.other = other;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Evidence)) {
                return false;
            }
            Evidence other = (Evidence)o;
            if (!other.canEqual(this)) {
                return false;
            }
            EvidenceFraudulent this$fraudulent = this.getFraudulent();
            EvidenceFraudulent other$fraudulent = other.getFraudulent();
            if (this$fraudulent == null ? other$fraudulent != null : !((Object)this$fraudulent).equals(other$fraudulent)) {
                return false;
            }
            EvidenceOther this$other = this.getOther();
            EvidenceOther other$other = other.getOther();
            return !(this$other == null ? other$other != null : !((Object)this$other).equals(other$other));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Evidence;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EvidenceFraudulent $fraudulent = this.getFraudulent();
            result = result * 59 + ($fraudulent == null ? 43 : ((Object)$fraudulent).hashCode());
            EvidenceOther $other = this.getOther();
            result = result * 59 + ($other == null ? 43 : ((Object)$other).hashCode());
            return result;
        }
    }

    public final class EvidenceOther
    extends StripeObject {
        String disputeExplanation;
        String uncategorizedFile;

        @Generated
        public String getDisputeExplanation() {
            return this.disputeExplanation;
        }

        @Generated
        public String getUncategorizedFile() {
            return this.uncategorizedFile;
        }

        @Generated
        public void setDisputeExplanation(String disputeExplanation) {
            this.disputeExplanation = disputeExplanation;
        }

        @Generated
        public void setUncategorizedFile(String uncategorizedFile) {
            this.uncategorizedFile = uncategorizedFile;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EvidenceOther)) {
                return false;
            }
            EvidenceOther other = (EvidenceOther)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$disputeExplanation = this.getDisputeExplanation();
            String other$disputeExplanation = other.getDisputeExplanation();
            if (this$disputeExplanation == null ? other$disputeExplanation != null : !this$disputeExplanation.equals(other$disputeExplanation)) {
                return false;
            }
            String this$uncategorizedFile = this.getUncategorizedFile();
            String other$uncategorizedFile = other.getUncategorizedFile();
            return !(this$uncategorizedFile == null ? other$uncategorizedFile != null : !this$uncategorizedFile.equals(other$uncategorizedFile));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EvidenceOther;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $disputeExplanation = this.getDisputeExplanation();
            result = result * 59 + ($disputeExplanation == null ? 43 : $disputeExplanation.hashCode());
            String $uncategorizedFile = this.getUncategorizedFile();
            result = result * 59 + ($uncategorizedFile == null ? 43 : $uncategorizedFile.hashCode());
            return result;
        }
    }

    public final class EvidenceFraudulent
    extends StripeObject {
        String disputeExplanation;
        String uncategorizedFile;

        @Generated
        public String getDisputeExplanation() {
            return this.disputeExplanation;
        }

        @Generated
        public String getUncategorizedFile() {
            return this.uncategorizedFile;
        }

        @Generated
        public void setDisputeExplanation(String disputeExplanation) {
            this.disputeExplanation = disputeExplanation;
        }

        @Generated
        public void setUncategorizedFile(String uncategorizedFile) {
            this.uncategorizedFile = uncategorizedFile;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EvidenceFraudulent)) {
                return false;
            }
            EvidenceFraudulent other = (EvidenceFraudulent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$disputeExplanation = this.getDisputeExplanation();
            String other$disputeExplanation = other.getDisputeExplanation();
            if (this$disputeExplanation == null ? other$disputeExplanation != null : !this$disputeExplanation.equals(other$disputeExplanation)) {
                return false;
            }
            String this$uncategorizedFile = this.getUncategorizedFile();
            String other$uncategorizedFile = other.getUncategorizedFile();
            return !(this$uncategorizedFile == null ? other$uncategorizedFile != null : !this$uncategorizedFile.equals(other$uncategorizedFile));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EvidenceFraudulent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $disputeExplanation = this.getDisputeExplanation();
            result = result * 59 + ($disputeExplanation == null ? 43 : $disputeExplanation.hashCode());
            String $uncategorizedFile = this.getUncategorizedFile();
            result = result * 59 + ($uncategorizedFile == null ? 43 : $uncategorizedFile.hashCode());
            return result;
        }
    }
}

