// Generated by delombok at Thu Aug 16 07:06:39 PDT 2018
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class Plan extends ApiResource implements MetadataStore<Plan>, HasId {
  String id;
  String object;
  Boolean active;
  Long amount;
  String billingScheme;
  Long created;
  String currency;
  String interval;
  Long intervalCount;
  Boolean livemode;
  Map<String, String> metadata;
  String nickname;
  ExpandableField<Product> product;
  List<Tier> tiers;
  String tiersMode;
  TransformUsage transformUsage;
  String usageType;
  Boolean deleted;
  /**
   * The {@code name} attribute.
   *
   * @deprecated Prefer using the {@code getProduct().getName()} method instead.
   * @see <a href="https://stripe.com/docs/upgrades#2018-02-05">API version 2018-02-05</a>
   */
  @Deprecated
  String name;
  /**
   * The {@code statement_description} attribute.
   *
   * @deprecated Prefer using the {@code getProduct().getStatementDescriptor()} method instead.
   * @see <a href="https://stripe.com/docs/upgrades#2014-12-17">API version 2014-12-17</a>
   * @see <a href="https://stripe.com/docs/upgrades#2018-02-05">API version 2018-02-05</a>
   */
  @Deprecated
  String statementDescription;
  /**
   * The {@code statement_descriptor} attribute.
   *
   * @deprecated Prefer using the {@code getProduct().getStatementDescriptor()} method instead.
   * @see <a href="https://stripe.com/docs/upgrades#2018-02-05">API version 2018-02-05</a>
   */
  @Deprecated
  String statementDescriptor;
  /**
   * The {@code trial_period_days} attribute.
   *
   * @deprecated Prefer using the {@link Subscription#create} method with the {@code trial_end}
   *     parameter instead.
   * @see <a href="https://stripe.com/docs/upgrades#2018-02-05">API version 2018-02-05</a>
   */
  @Deprecated
  Long trialPeriodDays;

  // <editor-fold desc="product">
  public String getProduct() {
    return (this.product != null) ? this.product.getId() : null;
  }

  public void setProduct(String productId) {
    this.product = setExpandableFieldId(productId, this.product);
  }

  public Product getProductObject() {
    return (this.product != null) ? this.product.getExpanded() : null;
  }

  public void setProductObject(Product product) {
    this.product = new ExpandableField<Product>(product.getId(), product);
  }

  // </editor-fold>
  // <editor-fold desc="create">
  /**
   * Create a plan.
   */
  public static Plan create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Create a plan.
   */
  public static Plan create(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, classUrl(Plan.class), params, Plan.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="delete">
  /**
   * Delete a plan.
   */
  public Plan delete() throws StripeException {
    return delete((RequestOptions) null);
  }

  /**
   * Delete a plan.
   */
  public Plan delete(RequestOptions options) throws StripeException {
    return request(RequestMethod.DELETE, instanceUrl(Plan.class, this.id), null, Plan.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="list">
  /**
   * List all plans.
   */
  public static PlanCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all plans.
   */
  public static PlanCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(Plan.class), params, PlanCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve a plan.
   */
  public static Plan retrieve(String id) throws StripeException {
    return retrieve(id, (RequestOptions) null);
  }

  /**
   * Retrieve a plan.
   */
  public static Plan retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve a plan.
   */
  public static Plan retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(Plan.class, id), params, Plan.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="update">
  /**
   * Update a plan.
   */
  @Override
  public Plan update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Update a plan.
   */
  @Override
  public Plan update(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, instanceUrl(Plan.class, this.id), params, Plan.class, options);
  }

  // </editor-fold>
  public static class Tier extends StripeObject {
    Long amount;
    Long upTo;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getUpTo() {
      return this.upTo;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUpTo(final Long upTo) {
      this.upTo = upTo;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Plan.Tier)) return false;
      final Plan.Tier other = (Plan.Tier) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$upTo = this.getUpTo();
      final java.lang.Object other$upTo = other.getUpTo();
      if (this$upTo == null ? other$upTo != null : !this$upTo.equals(other$upTo)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Plan.Tier;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $upTo = this.getUpTo();
      result = result * PRIME + ($upTo == null ? 43 : $upTo.hashCode());
      return result;
    }
  }


  public static class TransformUsage extends StripeObject {
    Long divideBy;
    String round;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDivideBy() {
      return this.divideBy;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRound() {
      return this.round;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDivideBy(final Long divideBy) {
      this.divideBy = divideBy;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRound(final String round) {
      this.round = round;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Plan.TransformUsage)) return false;
      final Plan.TransformUsage other = (Plan.TransformUsage) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$divideBy = this.getDivideBy();
      final java.lang.Object other$divideBy = other.getDivideBy();
      if (this$divideBy == null ? other$divideBy != null : !this$divideBy.equals(other$divideBy)) return false;
      final java.lang.Object this$round = this.getRound();
      final java.lang.Object other$round = other.getRound();
      if (this$round == null ? other$round != null : !this$round.equals(other$round)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Plan.TransformUsage;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $divideBy = this.getDivideBy();
      result = result * PRIME + ($divideBy == null ? 43 : $divideBy.hashCode());
      final java.lang.Object $round = this.getRound();
      result = result * PRIME + ($round == null ? 43 : $round.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getActive() {
    return this.active;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBillingScheme() {
    return this.billingScheme;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getInterval() {
    return this.interval;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getIntervalCount() {
    return this.intervalCount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getNickname() {
    return this.nickname;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<Tier> getTiers() {
    return this.tiers;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTiersMode() {
    return this.tiersMode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TransformUsage getTransformUsage() {
    return this.transformUsage;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getUsageType() {
    return this.usageType;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  /**
   * The {@code name} attribute.
   *
   * @return the {@code name} attribute
   * @deprecated Prefer using the {@code getProduct().getName()} method instead.
   * @see <a href="https://stripe.com/docs/upgrades#2018-02-05">API version 2018-02-05</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getName() {
    return this.name;
  }

  /**
   * The {@code statement_description} attribute.
   *
   * @return the {@code statement_description} attribute
   * @deprecated Prefer using the {@code getProduct().getStatementDescriptor()} method instead.
   * @see <a href="https://stripe.com/docs/upgrades#2014-12-17">API version 2014-12-17</a>
   * @see <a href="https://stripe.com/docs/upgrades#2018-02-05">API version 2018-02-05</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatementDescription() {
    return this.statementDescription;
  }

  /**
   * The {@code statement_descriptor} attribute.
   *
   * @return the {@code statement_descriptor} attribute
   * @deprecated Prefer using the {@code getProduct().getStatementDescriptor()} method instead.
   * @see <a href="https://stripe.com/docs/upgrades#2018-02-05">API version 2018-02-05</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatementDescriptor() {
    return this.statementDescriptor;
  }

  /**
   * The {@code trial_period_days} attribute.
   *
   * @return the {@code trial_period_days} attribute
   * @deprecated Prefer using the {@link Subscription#create} method with the {@code trial_end}
   *     parameter instead.
   * @see <a href="https://stripe.com/docs/upgrades#2018-02-05">API version 2018-02-05</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getTrialPeriodDays() {
    return this.trialPeriodDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setActive(final Boolean active) {
    this.active = active;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillingScheme(final String billingScheme) {
    this.billingScheme = billingScheme;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setInterval(final String interval) {
    this.interval = interval;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIntervalCount(final Long intervalCount) {
    this.intervalCount = intervalCount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNickname(final String nickname) {
    this.nickname = nickname;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTiers(final List<Tier> tiers) {
    this.tiers = tiers;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTiersMode(final String tiersMode) {
    this.tiersMode = tiersMode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransformUsage(final TransformUsage transformUsage) {
    this.transformUsage = transformUsage;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUsageType(final String usageType) {
    this.usageType = usageType;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * The {@code name} attribute.
   *
   * @deprecated Prefer using the {@code getProduct().getName()} method instead.
   * @see <a href="https://stripe.com/docs/upgrades#2018-02-05">API version 2018-02-05</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setName(final String name) {
    this.name = name;
  }

  /**
   * The {@code statement_description} attribute.
   *
   * @deprecated Prefer using the {@code getProduct().getStatementDescriptor()} method instead.
   * @see <a href="https://stripe.com/docs/upgrades#2014-12-17">API version 2014-12-17</a>
   * @see <a href="https://stripe.com/docs/upgrades#2018-02-05">API version 2018-02-05</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatementDescription(final String statementDescription) {
    this.statementDescription = statementDescription;
  }

  /**
   * The {@code statement_descriptor} attribute.
   *
   * @deprecated Prefer using the {@code getProduct().getStatementDescriptor()} method instead.
   * @see <a href="https://stripe.com/docs/upgrades#2018-02-05">API version 2018-02-05</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatementDescriptor(final String statementDescriptor) {
    this.statementDescriptor = statementDescriptor;
  }

  /**
   * The {@code trial_period_days} attribute.
   *
   * @deprecated Prefer using the {@link Subscription#create} method with the {@code trial_end}
   *     parameter instead.
   * @see <a href="https://stripe.com/docs/upgrades#2018-02-05">API version 2018-02-05</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTrialPeriodDays(final Long trialPeriodDays) {
    this.trialPeriodDays = trialPeriodDays;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Plan)) return false;
    final Plan other = (Plan) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$active = this.getActive();
    final java.lang.Object other$active = other.getActive();
    if (this$active == null ? other$active != null : !this$active.equals(other$active)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$billingScheme = this.getBillingScheme();
    final java.lang.Object other$billingScheme = other.getBillingScheme();
    if (this$billingScheme == null ? other$billingScheme != null : !this$billingScheme.equals(other$billingScheme)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$interval = this.getInterval();
    final java.lang.Object other$interval = other.getInterval();
    if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) return false;
    final java.lang.Object this$intervalCount = this.getIntervalCount();
    final java.lang.Object other$intervalCount = other.getIntervalCount();
    if (this$intervalCount == null ? other$intervalCount != null : !this$intervalCount.equals(other$intervalCount)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$nickname = this.getNickname();
    final java.lang.Object other$nickname = other.getNickname();
    if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) return false;
    final java.lang.Object this$product = this.getProduct();
    final java.lang.Object other$product = other.getProduct();
    if (this$product == null ? other$product != null : !this$product.equals(other$product)) return false;
    final java.lang.Object this$tiers = this.getTiers();
    final java.lang.Object other$tiers = other.getTiers();
    if (this$tiers == null ? other$tiers != null : !this$tiers.equals(other$tiers)) return false;
    final java.lang.Object this$tiersMode = this.getTiersMode();
    final java.lang.Object other$tiersMode = other.getTiersMode();
    if (this$tiersMode == null ? other$tiersMode != null : !this$tiersMode.equals(other$tiersMode)) return false;
    final java.lang.Object this$transformUsage = this.getTransformUsage();
    final java.lang.Object other$transformUsage = other.getTransformUsage();
    if (this$transformUsage == null ? other$transformUsage != null : !this$transformUsage.equals(other$transformUsage)) return false;
    final java.lang.Object this$usageType = this.getUsageType();
    final java.lang.Object other$usageType = other.getUsageType();
    if (this$usageType == null ? other$usageType != null : !this$usageType.equals(other$usageType)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$name = this.getName();
    final java.lang.Object other$name = other.getName();
    if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
    final java.lang.Object this$statementDescription = this.getStatementDescription();
    final java.lang.Object other$statementDescription = other.getStatementDescription();
    if (this$statementDescription == null ? other$statementDescription != null : !this$statementDescription.equals(other$statementDescription)) return false;
    final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
    final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
    if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
    final java.lang.Object this$trialPeriodDays = this.getTrialPeriodDays();
    final java.lang.Object other$trialPeriodDays = other.getTrialPeriodDays();
    if (this$trialPeriodDays == null ? other$trialPeriodDays != null : !this$trialPeriodDays.equals(other$trialPeriodDays)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Plan;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $active = this.getActive();
    result = result * PRIME + ($active == null ? 43 : $active.hashCode());
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $billingScheme = this.getBillingScheme();
    result = result * PRIME + ($billingScheme == null ? 43 : $billingScheme.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $interval = this.getInterval();
    result = result * PRIME + ($interval == null ? 43 : $interval.hashCode());
    final java.lang.Object $intervalCount = this.getIntervalCount();
    result = result * PRIME + ($intervalCount == null ? 43 : $intervalCount.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $nickname = this.getNickname();
    result = result * PRIME + ($nickname == null ? 43 : $nickname.hashCode());
    final java.lang.Object $product = this.getProduct();
    result = result * PRIME + ($product == null ? 43 : $product.hashCode());
    final java.lang.Object $tiers = this.getTiers();
    result = result * PRIME + ($tiers == null ? 43 : $tiers.hashCode());
    final java.lang.Object $tiersMode = this.getTiersMode();
    result = result * PRIME + ($tiersMode == null ? 43 : $tiersMode.hashCode());
    final java.lang.Object $transformUsage = this.getTransformUsage();
    result = result * PRIME + ($transformUsage == null ? 43 : $transformUsage.hashCode());
    final java.lang.Object $usageType = this.getUsageType();
    result = result * PRIME + ($usageType == null ? 43 : $usageType.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $name = this.getName();
    result = result * PRIME + ($name == null ? 43 : $name.hashCode());
    final java.lang.Object $statementDescription = this.getStatementDescription();
    result = result * PRIME + ($statementDescription == null ? 43 : $statementDescription.hashCode());
    final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
    result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
    final java.lang.Object $trialPeriodDays = this.getTrialPeriodDays();
    result = result * PRIME + ($trialPeriodDays == null ? 43 : $trialPeriodDays.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
