/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.stripe.model.HasSourceTypeData;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class SourceTypeDataDeserializer<T extends HasSourceTypeData>
implements JsonDeserializer<T> {
    private void populateMapFromJsonObject(Map<String, String> objMap, JsonObject jsonObject) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement val = (JsonElement)entry.getValue();
            if (val.isJsonNull()) continue;
            String value = ((JsonElement)entry.getValue()).getAsString();
            objMap.put(key, value);
        }
    }

    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonNull()) {
            return null;
        }
        if (!json.isJsonObject()) {
            throw new JsonParseException("type was not an object, which is problematic.");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        String type = jsonObject.getAsJsonPrimitive("type").getAsString();
        HashMap<String, String> typeData = new HashMap<String, String>();
        this.populateMapFromJsonObject(typeData, jsonObject.getAsJsonObject(type));
        jsonObject.remove(type);
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        HasSourceTypeData parsedData = (HasSourceTypeData)gson.fromJson(json, typeOfT);
        parsedData.setTypeData(typeData);
        return (T)parsedData;
    }
}

