// Generated by delombok at Wed Oct 10 17:29:51 CEST 2018
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class SubscriptionItem extends ApiResource implements HasId {
  String id;
  String object;
  Long created;
  Plan plan;
  Long quantity;
  Boolean deleted;

  // <editor-fold desc="create">
  /**
   * Create a subscription item.
   */
  public static SubscriptionItem create(Map<String, Object> params) throws StripeException {
    return create(params, null);
  }

  /**
   * Create a subscription item.
   */
  public static SubscriptionItem create(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, classUrl(SubscriptionItem.class), params, SubscriptionItem.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="delete">
  /**
   * Delete a subscription item.
   */
  public SubscriptionItem delete() throws StripeException {
    return delete(null, null);
  }

  /**
   * Delete a subscription item.
   */
  public SubscriptionItem delete(RequestOptions options) throws StripeException {
    return delete(null, options);
  }

  /**
   * Delete a subscription item.
   */
  public SubscriptionItem delete(Map<String, Object> params) throws StripeException {
    return delete(params, null);
  }

  /**
   * Delete a subscription item.
   */
  public SubscriptionItem delete(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.DELETE, instanceUrl(SubscriptionItem.class, id), params, SubscriptionItem.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="list">
  /**
   * List all subscription items.
   */
  public static SubscriptionItemCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all subscription items.
   */
  public static SubscriptionItemCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(SubscriptionItem.class), params, SubscriptionItemCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve a subscription item.
   */
  public static SubscriptionItem retrieve(String id) throws StripeException {
    return retrieve(id, null);
  }

  /**
   * Retrieve a subscription item.
   */
  public static SubscriptionItem retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve a subscription item.
   */
  public static SubscriptionItem retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(SubscriptionItem.class, id), params, SubscriptionItem.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="usageRecordSummaries">
  /**
   * Retrieve a subscription item's usage record summaries.
   */
  public UsageRecordSummaryCollection usageRecordSummaries(Map<String, Object> params) throws StripeException {
    return usageRecordSummaries(params, null);
  }

  /**
   * Retrieve a subscription item's usage record summaries.
   */
  public UsageRecordSummaryCollection usageRecordSummaries(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = instanceUrl(SubscriptionItem.class, this.getId()) + "/usage_record_summaries";
    return requestCollection(url, params, UsageRecordSummaryCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="update">
  /**
   * Update a subscription item.
   */
  public SubscriptionItem update(Map<String, Object> params) throws StripeException {
    return update(params, null);
  }

  /**
   * Update a subscription item.
   */
  public SubscriptionItem update(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, instanceUrl(SubscriptionItem.class, id), params, SubscriptionItem.class, options);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Plan getPlan() {
    return this.plan;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getQuantity() {
    return this.quantity;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPlan(final Plan plan) {
    this.plan = plan;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setQuantity(final Long quantity) {
    this.quantity = quantity;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof SubscriptionItem)) return false;
    final SubscriptionItem other = (SubscriptionItem) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$plan = this.getPlan();
    final java.lang.Object other$plan = other.getPlan();
    if (this$plan == null ? other$plan != null : !this$plan.equals(other$plan)) return false;
    final java.lang.Object this$quantity = this.getQuantity();
    final java.lang.Object other$quantity = other.getQuantity();
    if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof SubscriptionItem;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $plan = this.getPlan();
    result = result * PRIME + ($plan == null ? 43 : $plan.hashCode());
    final java.lang.Object $quantity = this.getQuantity();
    result = result * PRIME + ($quantity == null ? 43 : $quantity.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
  // </editor-fold>
}
