// Generated by delombok at Tue Jan 08 08:18:17 PST 2019
package com.stripe.model.issuing;

import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class Card extends ApiResource implements MetadataStore<Card>, HasId {
  String id;
  String object;
  AuthorizationControls authorizationControls;
  Billing billing;
  String brand;
  Cardholder cardholder;
  Long created;
  String currency;
  Integer expMonth;
  Integer expYear;
  String last4;
  Boolean livemode;
  Map<String, String> metadata;
  String name;
  String status;
  String type;

  // <editor-fold desc="create">
  /**
   * Create an issuing card.
   */
  public static Card create(Map<String, Object> params) throws StripeException {
    return create(params, null);
  }

  /**
   * Create an issuing card.
   */
  public static Card create(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, classUrl(Card.class), params, Card.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="details">
  /**
   * Retrieve the card details associated with an issuing card.
   */
  public CardDetails details(Map<String, Object> params) throws StripeException {
    return details(params, null);
  }

  /**
   * Retrieve the card details associated with an issuing card.
   */
  public CardDetails details(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, String.format("%s/details", instanceUrl(Card.class, this.getId())), params, CardDetails.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="list">
  /**
   * List all issuing cards.
   */
  public static CardCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all issuing cards.
   */
  public static CardCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(Card.class), params, CardCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve an issuing card.
   */
  public static Card retrieve(String id) throws StripeException {
    return retrieve(id, null);
  }

  /**
   * Retrieve an issuing card.
   */
  public static Card retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve an issuing card.
   */
  public static Card retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(Card.class, id), params, Card.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="update">
  /**
   * Update an issuing card.
   */
  @Override
  public Card update(Map<String, Object> params) throws StripeException {
    return update(params, null);
  }

  /**
   * Update an issuing card.
   */
  @Override
  public Card update(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, instanceUrl(Card.class, this.id), params, Card.class, options);
  }

  // </editor-fold>
  public final class AuthorizationControls extends StripeObject {
    List<String> allowedCategories;
    List<String> blockedCategories;
    String currency;
    Long maxAmount;
    Long maxApprovals;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getAllowedCategories() {
      return this.allowedCategories;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getBlockedCategories() {
      return this.blockedCategories;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCurrency() {
      return this.currency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMaxAmount() {
      return this.maxAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMaxApprovals() {
      return this.maxApprovals;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAllowedCategories(final List<String> allowedCategories) {
      this.allowedCategories = allowedCategories;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBlockedCategories(final List<String> blockedCategories) {
      this.blockedCategories = blockedCategories;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrency(final String currency) {
      this.currency = currency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMaxAmount(final Long maxAmount) {
      this.maxAmount = maxAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMaxApprovals(final Long maxApprovals) {
      this.maxApprovals = maxApprovals;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Card.AuthorizationControls)) return false;
      final Card.AuthorizationControls other = (Card.AuthorizationControls) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$allowedCategories = this.getAllowedCategories();
      final java.lang.Object other$allowedCategories = other.getAllowedCategories();
      if (this$allowedCategories == null ? other$allowedCategories != null : !this$allowedCategories.equals(other$allowedCategories)) return false;
      final java.lang.Object this$blockedCategories = this.getBlockedCategories();
      final java.lang.Object other$blockedCategories = other.getBlockedCategories();
      if (this$blockedCategories == null ? other$blockedCategories != null : !this$blockedCategories.equals(other$blockedCategories)) return false;
      final java.lang.Object this$currency = this.getCurrency();
      final java.lang.Object other$currency = other.getCurrency();
      if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
      final java.lang.Object this$maxAmount = this.getMaxAmount();
      final java.lang.Object other$maxAmount = other.getMaxAmount();
      if (this$maxAmount == null ? other$maxAmount != null : !this$maxAmount.equals(other$maxAmount)) return false;
      final java.lang.Object this$maxApprovals = this.getMaxApprovals();
      final java.lang.Object other$maxApprovals = other.getMaxApprovals();
      if (this$maxApprovals == null ? other$maxApprovals != null : !this$maxApprovals.equals(other$maxApprovals)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Card.AuthorizationControls;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $allowedCategories = this.getAllowedCategories();
      result = result * PRIME + ($allowedCategories == null ? 43 : $allowedCategories.hashCode());
      final java.lang.Object $blockedCategories = this.getBlockedCategories();
      result = result * PRIME + ($blockedCategories == null ? 43 : $blockedCategories.hashCode());
      final java.lang.Object $currency = this.getCurrency();
      result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
      final java.lang.Object $maxAmount = this.getMaxAmount();
      result = result * PRIME + ($maxAmount == null ? 43 : $maxAmount.hashCode());
      final java.lang.Object $maxApprovals = this.getMaxApprovals();
      result = result * PRIME + ($maxApprovals == null ? 43 : $maxApprovals.hashCode());
      return result;
    }
  }


  public final class Billing extends StripeObject {
    Address address;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Address getAddress() {
      return this.address;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddress(final Address address) {
      this.address = address;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Card.Billing)) return false;
      final Card.Billing other = (Card.Billing) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$address = this.getAddress();
      final java.lang.Object other$address = other.getAddress();
      if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Card.Billing;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $address = this.getAddress();
      result = result * PRIME + ($address == null ? 43 : $address.hashCode());
      return result;
    }
  }


  public final class Shipping extends StripeObject {
    Address address;
    String carrier;
    Long eta;
    String name;
    String phone;
    String status;
    String trackingNumber;
    String trackingUrl;
    String type;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Address getAddress() {
      return this.address;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCarrier() {
      return this.carrier;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getEta() {
      return this.eta;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
      return this.name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPhone() {
      return this.phone;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTrackingNumber() {
      return this.trackingNumber;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTrackingUrl() {
      return this.trackingUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddress(final Address address) {
      this.address = address;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCarrier(final String carrier) {
      this.carrier = carrier;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEta(final Long eta) {
      this.eta = eta;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
      this.name = name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPhone(final String phone) {
      this.phone = phone;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTrackingNumber(final String trackingNumber) {
      this.trackingNumber = trackingNumber;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTrackingUrl(final String trackingUrl) {
      this.trackingUrl = trackingUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Card.Shipping)) return false;
      final Card.Shipping other = (Card.Shipping) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$address = this.getAddress();
      final java.lang.Object other$address = other.getAddress();
      if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
      final java.lang.Object this$carrier = this.getCarrier();
      final java.lang.Object other$carrier = other.getCarrier();
      if (this$carrier == null ? other$carrier != null : !this$carrier.equals(other$carrier)) return false;
      final java.lang.Object this$eta = this.getEta();
      final java.lang.Object other$eta = other.getEta();
      if (this$eta == null ? other$eta != null : !this$eta.equals(other$eta)) return false;
      final java.lang.Object this$name = this.getName();
      final java.lang.Object other$name = other.getName();
      if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
      final java.lang.Object this$phone = this.getPhone();
      final java.lang.Object other$phone = other.getPhone();
      if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      final java.lang.Object this$trackingNumber = this.getTrackingNumber();
      final java.lang.Object other$trackingNumber = other.getTrackingNumber();
      if (this$trackingNumber == null ? other$trackingNumber != null : !this$trackingNumber.equals(other$trackingNumber)) return false;
      final java.lang.Object this$trackingUrl = this.getTrackingUrl();
      final java.lang.Object other$trackingUrl = other.getTrackingUrl();
      if (this$trackingUrl == null ? other$trackingUrl != null : !this$trackingUrl.equals(other$trackingUrl)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Card.Shipping;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $address = this.getAddress();
      result = result * PRIME + ($address == null ? 43 : $address.hashCode());
      final java.lang.Object $carrier = this.getCarrier();
      result = result * PRIME + ($carrier == null ? 43 : $carrier.hashCode());
      final java.lang.Object $eta = this.getEta();
      result = result * PRIME + ($eta == null ? 43 : $eta.hashCode());
      final java.lang.Object $name = this.getName();
      result = result * PRIME + ($name == null ? 43 : $name.hashCode());
      final java.lang.Object $phone = this.getPhone();
      result = result * PRIME + ($phone == null ? 43 : $phone.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      final java.lang.Object $trackingNumber = this.getTrackingNumber();
      result = result * PRIME + ($trackingNumber == null ? 43 : $trackingNumber.hashCode());
      final java.lang.Object $trackingUrl = this.getTrackingUrl();
      result = result * PRIME + ($trackingUrl == null ? 43 : $trackingUrl.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AuthorizationControls getAuthorizationControls() {
    return this.authorizationControls;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Billing getBilling() {
    return this.billing;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBrand() {
    return this.brand;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Cardholder getCardholder() {
    return this.cardholder;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getExpMonth() {
    return this.expMonth;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getExpYear() {
    return this.expYear;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLast4() {
    return this.last4;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getName() {
    return this.name;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAuthorizationControls(final AuthorizationControls authorizationControls) {
    this.authorizationControls = authorizationControls;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBilling(final Billing billing) {
    this.billing = billing;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBrand(final String brand) {
    this.brand = brand;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCardholder(final Cardholder cardholder) {
    this.cardholder = cardholder;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExpMonth(final Integer expMonth) {
    this.expMonth = expMonth;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExpYear(final Integer expYear) {
    this.expYear = expYear;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLast4(final String last4) {
    this.last4 = last4;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setName(final String name) {
    this.name = name;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Card)) return false;
    final Card other = (Card) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$authorizationControls = this.getAuthorizationControls();
    final java.lang.Object other$authorizationControls = other.getAuthorizationControls();
    if (this$authorizationControls == null ? other$authorizationControls != null : !this$authorizationControls.equals(other$authorizationControls)) return false;
    final java.lang.Object this$billing = this.getBilling();
    final java.lang.Object other$billing = other.getBilling();
    if (this$billing == null ? other$billing != null : !this$billing.equals(other$billing)) return false;
    final java.lang.Object this$brand = this.getBrand();
    final java.lang.Object other$brand = other.getBrand();
    if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) return false;
    final java.lang.Object this$cardholder = this.getCardholder();
    final java.lang.Object other$cardholder = other.getCardholder();
    if (this$cardholder == null ? other$cardholder != null : !this$cardholder.equals(other$cardholder)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$expMonth = this.getExpMonth();
    final java.lang.Object other$expMonth = other.getExpMonth();
    if (this$expMonth == null ? other$expMonth != null : !this$expMonth.equals(other$expMonth)) return false;
    final java.lang.Object this$expYear = this.getExpYear();
    final java.lang.Object other$expYear = other.getExpYear();
    if (this$expYear == null ? other$expYear != null : !this$expYear.equals(other$expYear)) return false;
    final java.lang.Object this$last4 = this.getLast4();
    final java.lang.Object other$last4 = other.getLast4();
    if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$name = this.getName();
    final java.lang.Object other$name = other.getName();
    if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Card;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $authorizationControls = this.getAuthorizationControls();
    result = result * PRIME + ($authorizationControls == null ? 43 : $authorizationControls.hashCode());
    final java.lang.Object $billing = this.getBilling();
    result = result * PRIME + ($billing == null ? 43 : $billing.hashCode());
    final java.lang.Object $brand = this.getBrand();
    result = result * PRIME + ($brand == null ? 43 : $brand.hashCode());
    final java.lang.Object $cardholder = this.getCardholder();
    result = result * PRIME + ($cardholder == null ? 43 : $cardholder.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $expMonth = this.getExpMonth();
    result = result * PRIME + ($expMonth == null ? 43 : $expMonth.hashCode());
    final java.lang.Object $expYear = this.getExpYear();
    result = result * PRIME + ($expYear == null ? 43 : $expYear.hashCode());
    final java.lang.Object $last4 = this.getLast4();
    result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $name = this.getName();
    result = result * PRIME + ($name == null ? 43 : $name.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
