/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.model.CountrySpecCollection;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CountrySpec
extends ApiResource
implements HasId {
    String id;
    String object;
    String defaultCurrency;
    Map<String, List<String>> supportedBankAccountCurrencies;
    List<String> supportedPaymentCurrencies;
    List<String> supportedPaymentMethods;
    List<String> supportedTransferCountries;
    VerificationFields verificationFields;

    public static CountrySpecCollection list(Map<String, Object> params) throws StripeException {
        return CountrySpec.list(params, null);
    }

    public static CountrySpecCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        return CountrySpec.requestCollection(CountrySpec.classUrl(CountrySpec.class), params, CountrySpecCollection.class, options);
    }

    public static CountrySpec retrieve(String country) throws StripeException {
        return CountrySpec.retrieve(country, null);
    }

    public static CountrySpec retrieve(String country, RequestOptions options) throws StripeException {
        return CountrySpec.retrieve(country, null, options);
    }

    public static CountrySpec retrieve(String country, Map<String, Object> params, RequestOptions options) throws StripeException {
        return CountrySpec.request(ApiResource.RequestMethod.GET, CountrySpec.instanceUrl(CountrySpec.class, country), params, CountrySpec.class, options);
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    @Generated
    public Map<String, List<String>> getSupportedBankAccountCurrencies() {
        return this.supportedBankAccountCurrencies;
    }

    @Generated
    public List<String> getSupportedPaymentCurrencies() {
        return this.supportedPaymentCurrencies;
    }

    @Generated
    public List<String> getSupportedPaymentMethods() {
        return this.supportedPaymentMethods;
    }

    @Generated
    public List<String> getSupportedTransferCountries() {
        return this.supportedTransferCountries;
    }

    @Generated
    public VerificationFields getVerificationFields() {
        return this.verificationFields;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setDefaultCurrency(String defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    @Generated
    public void setSupportedBankAccountCurrencies(Map<String, List<String>> supportedBankAccountCurrencies) {
        this.supportedBankAccountCurrencies = supportedBankAccountCurrencies;
    }

    @Generated
    public void setSupportedPaymentCurrencies(List<String> supportedPaymentCurrencies) {
        this.supportedPaymentCurrencies = supportedPaymentCurrencies;
    }

    @Generated
    public void setSupportedPaymentMethods(List<String> supportedPaymentMethods) {
        this.supportedPaymentMethods = supportedPaymentMethods;
    }

    @Generated
    public void setSupportedTransferCountries(List<String> supportedTransferCountries) {
        this.supportedTransferCountries = supportedTransferCountries;
    }

    @Generated
    public void setVerificationFields(VerificationFields verificationFields) {
        this.verificationFields = verificationFields;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CountrySpec)) {
            return false;
        }
        CountrySpec other = (CountrySpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$defaultCurrency = this.getDefaultCurrency();
        String other$defaultCurrency = other.getDefaultCurrency();
        if (this$defaultCurrency == null ? other$defaultCurrency != null : !this$defaultCurrency.equals(other$defaultCurrency)) {
            return false;
        }
        Map<String, List<String>> this$supportedBankAccountCurrencies = this.getSupportedBankAccountCurrencies();
        Map<String, List<String>> other$supportedBankAccountCurrencies = other.getSupportedBankAccountCurrencies();
        if (this$supportedBankAccountCurrencies == null ? other$supportedBankAccountCurrencies != null : !((Object)this$supportedBankAccountCurrencies).equals(other$supportedBankAccountCurrencies)) {
            return false;
        }
        List<String> this$supportedPaymentCurrencies = this.getSupportedPaymentCurrencies();
        List<String> other$supportedPaymentCurrencies = other.getSupportedPaymentCurrencies();
        if (this$supportedPaymentCurrencies == null ? other$supportedPaymentCurrencies != null : !((Object)this$supportedPaymentCurrencies).equals(other$supportedPaymentCurrencies)) {
            return false;
        }
        List<String> this$supportedPaymentMethods = this.getSupportedPaymentMethods();
        List<String> other$supportedPaymentMethods = other.getSupportedPaymentMethods();
        if (this$supportedPaymentMethods == null ? other$supportedPaymentMethods != null : !((Object)this$supportedPaymentMethods).equals(other$supportedPaymentMethods)) {
            return false;
        }
        List<String> this$supportedTransferCountries = this.getSupportedTransferCountries();
        List<String> other$supportedTransferCountries = other.getSupportedTransferCountries();
        if (this$supportedTransferCountries == null ? other$supportedTransferCountries != null : !((Object)this$supportedTransferCountries).equals(other$supportedTransferCountries)) {
            return false;
        }
        VerificationFields this$verificationFields = this.getVerificationFields();
        VerificationFields other$verificationFields = other.getVerificationFields();
        return !(this$verificationFields == null ? other$verificationFields != null : !((Object)this$verificationFields).equals(other$verificationFields));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CountrySpec;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $defaultCurrency = this.getDefaultCurrency();
        result = result * 59 + ($defaultCurrency == null ? 43 : $defaultCurrency.hashCode());
        Map<String, List<String>> $supportedBankAccountCurrencies = this.getSupportedBankAccountCurrencies();
        result = result * 59 + ($supportedBankAccountCurrencies == null ? 43 : ((Object)$supportedBankAccountCurrencies).hashCode());
        List<String> $supportedPaymentCurrencies = this.getSupportedPaymentCurrencies();
        result = result * 59 + ($supportedPaymentCurrencies == null ? 43 : ((Object)$supportedPaymentCurrencies).hashCode());
        List<String> $supportedPaymentMethods = this.getSupportedPaymentMethods();
        result = result * 59 + ($supportedPaymentMethods == null ? 43 : ((Object)$supportedPaymentMethods).hashCode());
        List<String> $supportedTransferCountries = this.getSupportedTransferCountries();
        result = result * 59 + ($supportedTransferCountries == null ? 43 : ((Object)$supportedTransferCountries).hashCode());
        VerificationFields $verificationFields = this.getVerificationFields();
        result = result * 59 + ($verificationFields == null ? 43 : ((Object)$verificationFields).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class VerificationFields
    extends StripeObject {
        Details individual;
        Details company;

        @Generated
        public Details getIndividual() {
            return this.individual;
        }

        @Generated
        public Details getCompany() {
            return this.company;
        }

        @Generated
        public void setIndividual(Details individual) {
            this.individual = individual;
        }

        @Generated
        public void setCompany(Details company) {
            this.company = company;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerificationFields)) {
                return false;
            }
            VerificationFields other = (VerificationFields)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Details this$individual = this.getIndividual();
            Details other$individual = other.getIndividual();
            if (this$individual == null ? other$individual != null : !((Object)this$individual).equals(other$individual)) {
                return false;
            }
            Details this$company = this.getCompany();
            Details other$company = other.getCompany();
            return !(this$company == null ? other$company != null : !((Object)this$company).equals(other$company));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VerificationFields;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Details $individual = this.getIndividual();
            result = result * 59 + ($individual == null ? 43 : ((Object)$individual).hashCode());
            Details $company = this.getCompany();
            result = result * 59 + ($company == null ? 43 : ((Object)$company).hashCode());
            return result;
        }

        public static class Details
        extends StripeObject {
            List<String> additional;
            List<String> minimum;

            @Generated
            public List<String> getAdditional() {
                return this.additional;
            }

            @Generated
            public List<String> getMinimum() {
                return this.minimum;
            }

            @Generated
            public void setAdditional(List<String> additional) {
                this.additional = additional;
            }

            @Generated
            public void setMinimum(List<String> minimum) {
                this.minimum = minimum;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Details)) {
                    return false;
                }
                Details other = (Details)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$additional = this.getAdditional();
                List<String> other$additional = other.getAdditional();
                if (this$additional == null ? other$additional != null : !((Object)this$additional).equals(other$additional)) {
                    return false;
                }
                List<String> this$minimum = this.getMinimum();
                List<String> other$minimum = other.getMinimum();
                return !(this$minimum == null ? other$minimum != null : !((Object)this$minimum).equals(other$minimum));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Details;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $additional = this.getAdditional();
                result = result * 59 + ($additional == null ? 43 : ((Object)$additional).hashCode());
                List<String> $minimum = this.getMinimum();
                result = result * 59 + ($minimum == null ? 43 : ((Object)$minimum).hashCode());
                return result;
            }
        }
    }
}

