/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.model.AccountCollection;
import com.stripe.model.Address;
import com.stripe.model.ExternalAccountCollection;
import com.stripe.model.HasId;
import com.stripe.model.LegalEntity;
import com.stripe.model.LoginLinkCollection;
import com.stripe.model.MetadataStore;
import com.stripe.model.PersonCollection;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Account
extends ApiResource
implements HasId,
MetadataStore<Account> {
    String id;
    String object;
    String businessLogo;
    String businessName;
    String businessPrimaryColor;
    String businessUrl;
    Boolean chargesEnabled;
    String country;
    Long created;
    Boolean debitNegativeBalances;
    DeclineChargeOn declineChargeOn;
    String defaultCurrency;
    Boolean deleted;
    Boolean detailsSubmitted;
    String displayName;
    String email;
    ExternalAccountCollection externalAccounts;
    Keys keys;
    LegalEntity legalEntity;
    LoginLinkCollection loginLinks;
    Map<String, String> metadata;
    PayoutSchedule payoutSchedule;
    String payoutStatementDescriptor;
    Boolean payoutsEnabled;
    String productDescription;
    String statementDescriptor;
    Address supportAddress;
    String supportEmail;
    String supportPhone;
    String supportUrl;
    String timezone;
    TosAcceptance tosAcceptance;
    Boolean transfersEnabled;
    String type;
    Verification verification;
    @Deprecated
    List<String> currenciesSupported;
    @Deprecated
    Boolean managed;
    @Deprecated
    TransferSchedule transferSchedule;

    public static Account create(Map<String, Object> params) throws StripeException {
        return Account.create(params, null);
    }

    public static Account create(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Account.request(ApiResource.RequestMethod.POST, Account.classUrl(Account.class), params, Account.class, options);
    }

    public Account delete() throws StripeException {
        return this.delete(null, null);
    }

    public Account delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Account delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Account delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Account.request(ApiResource.RequestMethod.DELETE, Account.instanceUrl(Account.class, this.id), params, Account.class, options);
    }

    public static AccountCollection list(Map<String, Object> params) throws StripeException {
        return Account.list(params, null);
    }

    public static AccountCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Account.requestCollection(Account.classUrl(Account.class), params, AccountCollection.class, options);
    }

    public PersonCollection persons() throws StripeException {
        return this.persons(null, null);
    }

    public PersonCollection persons(Map<String, Object> params) throws StripeException {
        return this.persons(params, null);
    }

    public PersonCollection persons(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = Account.instanceUrl(Account.class, this.getId()) + "/persons";
        return Account.requestCollection(url, params, PersonCollection.class, options);
    }

    public Account reject(Map<String, Object> params) throws StripeException {
        return this.reject(params, null);
    }

    public Account reject(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Account.request(ApiResource.RequestMethod.POST, String.format("%s/reject", Account.instanceUrl(Account.class, this.getId())), params, Account.class, options);
    }

    public static Account retrieve() throws StripeException {
        return Account.retrieve((RequestOptions)null);
    }

    public static Account retrieve(RequestOptions options) throws StripeException {
        return Account.request(ApiResource.RequestMethod.GET, Account.singleClassUrl(Account.class), null, Account.class, options);
    }

    @Deprecated
    public static Account retrieve(String apiKeyOrAccountId) throws StripeException {
        if (null == apiKeyOrAccountId || apiKeyOrAccountId.startsWith("sk_")) {
            return Account.retrieve(RequestOptions.builder().setApiKey(apiKeyOrAccountId).build());
        }
        return Account.retrieve(apiKeyOrAccountId, null);
    }

    public static Account retrieve(String id, RequestOptions options) throws StripeException {
        return Account.retrieve(id, null, options);
    }

    public static Account retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        return Account.request(ApiResource.RequestMethod.GET, Account.instanceUrl(Account.class, id), params, Account.class, options);
    }

    public Account update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Account update(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Account.request(ApiResource.RequestMethod.POST, Account.instanceUrl(Account.class, this.id), params, Account.class, options);
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getBusinessLogo() {
        return this.businessLogo;
    }

    @Generated
    public String getBusinessName() {
        return this.businessName;
    }

    @Generated
    public String getBusinessPrimaryColor() {
        return this.businessPrimaryColor;
    }

    @Generated
    public String getBusinessUrl() {
        return this.businessUrl;
    }

    @Generated
    public Boolean getChargesEnabled() {
        return this.chargesEnabled;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Boolean getDebitNegativeBalances() {
        return this.debitNegativeBalances;
    }

    @Generated
    public DeclineChargeOn getDeclineChargeOn() {
        return this.declineChargeOn;
    }

    @Generated
    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public Boolean getDetailsSubmitted() {
        return this.detailsSubmitted;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public ExternalAccountCollection getExternalAccounts() {
        return this.externalAccounts;
    }

    @Generated
    public Keys getKeys() {
        return this.keys;
    }

    @Generated
    public LegalEntity getLegalEntity() {
        return this.legalEntity;
    }

    @Generated
    public LoginLinkCollection getLoginLinks() {
        return this.loginLinks;
    }

    @Generated
    public PayoutSchedule getPayoutSchedule() {
        return this.payoutSchedule;
    }

    @Generated
    public String getPayoutStatementDescriptor() {
        return this.payoutStatementDescriptor;
    }

    @Generated
    public Boolean getPayoutsEnabled() {
        return this.payoutsEnabled;
    }

    @Generated
    public String getProductDescription() {
        return this.productDescription;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public Address getSupportAddress() {
        return this.supportAddress;
    }

    @Generated
    public String getSupportEmail() {
        return this.supportEmail;
    }

    @Generated
    public String getSupportPhone() {
        return this.supportPhone;
    }

    @Generated
    public String getSupportUrl() {
        return this.supportUrl;
    }

    @Generated
    public String getTimezone() {
        return this.timezone;
    }

    @Generated
    public TosAcceptance getTosAcceptance() {
        return this.tosAcceptance;
    }

    @Generated
    public Boolean getTransfersEnabled() {
        return this.transfersEnabled;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Verification getVerification() {
        return this.verification;
    }

    @Deprecated
    @Generated
    public List<String> getCurrenciesSupported() {
        return this.currenciesSupported;
    }

    @Deprecated
    @Generated
    public Boolean getManaged() {
        return this.managed;
    }

    @Deprecated
    @Generated
    public TransferSchedule getTransferSchedule() {
        return this.transferSchedule;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setBusinessLogo(String businessLogo) {
        this.businessLogo = businessLogo;
    }

    @Generated
    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    @Generated
    public void setBusinessPrimaryColor(String businessPrimaryColor) {
        this.businessPrimaryColor = businessPrimaryColor;
    }

    @Generated
    public void setBusinessUrl(String businessUrl) {
        this.businessUrl = businessUrl;
    }

    @Generated
    public void setChargesEnabled(Boolean chargesEnabled) {
        this.chargesEnabled = chargesEnabled;
    }

    @Generated
    public void setCountry(String country) {
        this.country = country;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDebitNegativeBalances(Boolean debitNegativeBalances) {
        this.debitNegativeBalances = debitNegativeBalances;
    }

    @Generated
    public void setDeclineChargeOn(DeclineChargeOn declineChargeOn) {
        this.declineChargeOn = declineChargeOn;
    }

    @Generated
    public void setDefaultCurrency(String defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDetailsSubmitted(Boolean detailsSubmitted) {
        this.detailsSubmitted = detailsSubmitted;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setExternalAccounts(ExternalAccountCollection externalAccounts) {
        this.externalAccounts = externalAccounts;
    }

    @Generated
    public void setKeys(Keys keys) {
        this.keys = keys;
    }

    @Generated
    public void setLegalEntity(LegalEntity legalEntity) {
        this.legalEntity = legalEntity;
    }

    @Generated
    public void setLoginLinks(LoginLinkCollection loginLinks) {
        this.loginLinks = loginLinks;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setPayoutSchedule(PayoutSchedule payoutSchedule) {
        this.payoutSchedule = payoutSchedule;
    }

    @Generated
    public void setPayoutStatementDescriptor(String payoutStatementDescriptor) {
        this.payoutStatementDescriptor = payoutStatementDescriptor;
    }

    @Generated
    public void setPayoutsEnabled(Boolean payoutsEnabled) {
        this.payoutsEnabled = payoutsEnabled;
    }

    @Generated
    public void setProductDescription(String productDescription) {
        this.productDescription = productDescription;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setSupportAddress(Address supportAddress) {
        this.supportAddress = supportAddress;
    }

    @Generated
    public void setSupportEmail(String supportEmail) {
        this.supportEmail = supportEmail;
    }

    @Generated
    public void setSupportPhone(String supportPhone) {
        this.supportPhone = supportPhone;
    }

    @Generated
    public void setSupportUrl(String supportUrl) {
        this.supportUrl = supportUrl;
    }

    @Generated
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @Generated
    public void setTosAcceptance(TosAcceptance tosAcceptance) {
        this.tosAcceptance = tosAcceptance;
    }

    @Generated
    public void setTransfersEnabled(Boolean transfersEnabled) {
        this.transfersEnabled = transfersEnabled;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setVerification(Verification verification) {
        this.verification = verification;
    }

    @Deprecated
    @Generated
    public void setCurrenciesSupported(List<String> currenciesSupported) {
        this.currenciesSupported = currenciesSupported;
    }

    @Deprecated
    @Generated
    public void setManaged(Boolean managed) {
        this.managed = managed;
    }

    @Deprecated
    @Generated
    public void setTransferSchedule(TransferSchedule transferSchedule) {
        this.transferSchedule = transferSchedule;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$businessLogo = this.getBusinessLogo();
        String other$businessLogo = other.getBusinessLogo();
        if (this$businessLogo == null ? other$businessLogo != null : !this$businessLogo.equals(other$businessLogo)) {
            return false;
        }
        String this$businessName = this.getBusinessName();
        String other$businessName = other.getBusinessName();
        if (this$businessName == null ? other$businessName != null : !this$businessName.equals(other$businessName)) {
            return false;
        }
        String this$businessPrimaryColor = this.getBusinessPrimaryColor();
        String other$businessPrimaryColor = other.getBusinessPrimaryColor();
        if (this$businessPrimaryColor == null ? other$businessPrimaryColor != null : !this$businessPrimaryColor.equals(other$businessPrimaryColor)) {
            return false;
        }
        String this$businessUrl = this.getBusinessUrl();
        String other$businessUrl = other.getBusinessUrl();
        if (this$businessUrl == null ? other$businessUrl != null : !this$businessUrl.equals(other$businessUrl)) {
            return false;
        }
        Boolean this$chargesEnabled = this.getChargesEnabled();
        Boolean other$chargesEnabled = other.getChargesEnabled();
        if (this$chargesEnabled == null ? other$chargesEnabled != null : !((Object)this$chargesEnabled).equals(other$chargesEnabled)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$debitNegativeBalances = this.getDebitNegativeBalances();
        Boolean other$debitNegativeBalances = other.getDebitNegativeBalances();
        if (this$debitNegativeBalances == null ? other$debitNegativeBalances != null : !((Object)this$debitNegativeBalances).equals(other$debitNegativeBalances)) {
            return false;
        }
        DeclineChargeOn this$declineChargeOn = this.getDeclineChargeOn();
        DeclineChargeOn other$declineChargeOn = other.getDeclineChargeOn();
        if (this$declineChargeOn == null ? other$declineChargeOn != null : !((Object)this$declineChargeOn).equals(other$declineChargeOn)) {
            return false;
        }
        String this$defaultCurrency = this.getDefaultCurrency();
        String other$defaultCurrency = other.getDefaultCurrency();
        if (this$defaultCurrency == null ? other$defaultCurrency != null : !this$defaultCurrency.equals(other$defaultCurrency)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$detailsSubmitted = this.getDetailsSubmitted();
        Boolean other$detailsSubmitted = other.getDetailsSubmitted();
        if (this$detailsSubmitted == null ? other$detailsSubmitted != null : !((Object)this$detailsSubmitted).equals(other$detailsSubmitted)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        ExternalAccountCollection this$externalAccounts = this.getExternalAccounts();
        ExternalAccountCollection other$externalAccounts = other.getExternalAccounts();
        if (this$externalAccounts == null ? other$externalAccounts != null : !((Object)this$externalAccounts).equals(other$externalAccounts)) {
            return false;
        }
        Keys this$keys = this.getKeys();
        Keys other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        LegalEntity this$legalEntity = this.getLegalEntity();
        LegalEntity other$legalEntity = other.getLegalEntity();
        if (this$legalEntity == null ? other$legalEntity != null : !((Object)this$legalEntity).equals(other$legalEntity)) {
            return false;
        }
        LoginLinkCollection this$loginLinks = this.getLoginLinks();
        LoginLinkCollection other$loginLinks = other.getLoginLinks();
        if (this$loginLinks == null ? other$loginLinks != null : !((Object)this$loginLinks).equals(other$loginLinks)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        PayoutSchedule this$payoutSchedule = this.getPayoutSchedule();
        PayoutSchedule other$payoutSchedule = other.getPayoutSchedule();
        if (this$payoutSchedule == null ? other$payoutSchedule != null : !((Object)this$payoutSchedule).equals(other$payoutSchedule)) {
            return false;
        }
        String this$payoutStatementDescriptor = this.getPayoutStatementDescriptor();
        String other$payoutStatementDescriptor = other.getPayoutStatementDescriptor();
        if (this$payoutStatementDescriptor == null ? other$payoutStatementDescriptor != null : !this$payoutStatementDescriptor.equals(other$payoutStatementDescriptor)) {
            return false;
        }
        Boolean this$payoutsEnabled = this.getPayoutsEnabled();
        Boolean other$payoutsEnabled = other.getPayoutsEnabled();
        if (this$payoutsEnabled == null ? other$payoutsEnabled != null : !((Object)this$payoutsEnabled).equals(other$payoutsEnabled)) {
            return false;
        }
        String this$productDescription = this.getProductDescription();
        String other$productDescription = other.getProductDescription();
        if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        Address this$supportAddress = this.getSupportAddress();
        Address other$supportAddress = other.getSupportAddress();
        if (this$supportAddress == null ? other$supportAddress != null : !((Object)this$supportAddress).equals(other$supportAddress)) {
            return false;
        }
        String this$supportEmail = this.getSupportEmail();
        String other$supportEmail = other.getSupportEmail();
        if (this$supportEmail == null ? other$supportEmail != null : !this$supportEmail.equals(other$supportEmail)) {
            return false;
        }
        String this$supportPhone = this.getSupportPhone();
        String other$supportPhone = other.getSupportPhone();
        if (this$supportPhone == null ? other$supportPhone != null : !this$supportPhone.equals(other$supportPhone)) {
            return false;
        }
        String this$supportUrl = this.getSupportUrl();
        String other$supportUrl = other.getSupportUrl();
        if (this$supportUrl == null ? other$supportUrl != null : !this$supportUrl.equals(other$supportUrl)) {
            return false;
        }
        String this$timezone = this.getTimezone();
        String other$timezone = other.getTimezone();
        if (this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone)) {
            return false;
        }
        TosAcceptance this$tosAcceptance = this.getTosAcceptance();
        TosAcceptance other$tosAcceptance = other.getTosAcceptance();
        if (this$tosAcceptance == null ? other$tosAcceptance != null : !((Object)this$tosAcceptance).equals(other$tosAcceptance)) {
            return false;
        }
        Boolean this$transfersEnabled = this.getTransfersEnabled();
        Boolean other$transfersEnabled = other.getTransfersEnabled();
        if (this$transfersEnabled == null ? other$transfersEnabled != null : !((Object)this$transfersEnabled).equals(other$transfersEnabled)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Verification this$verification = this.getVerification();
        Verification other$verification = other.getVerification();
        if (this$verification == null ? other$verification != null : !((Object)this$verification).equals(other$verification)) {
            return false;
        }
        List<String> this$currenciesSupported = this.getCurrenciesSupported();
        List<String> other$currenciesSupported = other.getCurrenciesSupported();
        if (this$currenciesSupported == null ? other$currenciesSupported != null : !((Object)this$currenciesSupported).equals(other$currenciesSupported)) {
            return false;
        }
        Boolean this$managed = this.getManaged();
        Boolean other$managed = other.getManaged();
        if (this$managed == null ? other$managed != null : !((Object)this$managed).equals(other$managed)) {
            return false;
        }
        TransferSchedule this$transferSchedule = this.getTransferSchedule();
        TransferSchedule other$transferSchedule = other.getTransferSchedule();
        return !(this$transferSchedule == null ? other$transferSchedule != null : !((Object)this$transferSchedule).equals(other$transferSchedule));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Account;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $businessLogo = this.getBusinessLogo();
        result = result * 59 + ($businessLogo == null ? 43 : $businessLogo.hashCode());
        String $businessName = this.getBusinessName();
        result = result * 59 + ($businessName == null ? 43 : $businessName.hashCode());
        String $businessPrimaryColor = this.getBusinessPrimaryColor();
        result = result * 59 + ($businessPrimaryColor == null ? 43 : $businessPrimaryColor.hashCode());
        String $businessUrl = this.getBusinessUrl();
        result = result * 59 + ($businessUrl == null ? 43 : $businessUrl.hashCode());
        Boolean $chargesEnabled = this.getChargesEnabled();
        result = result * 59 + ($chargesEnabled == null ? 43 : ((Object)$chargesEnabled).hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $debitNegativeBalances = this.getDebitNegativeBalances();
        result = result * 59 + ($debitNegativeBalances == null ? 43 : ((Object)$debitNegativeBalances).hashCode());
        DeclineChargeOn $declineChargeOn = this.getDeclineChargeOn();
        result = result * 59 + ($declineChargeOn == null ? 43 : ((Object)$declineChargeOn).hashCode());
        String $defaultCurrency = this.getDefaultCurrency();
        result = result * 59 + ($defaultCurrency == null ? 43 : $defaultCurrency.hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $detailsSubmitted = this.getDetailsSubmitted();
        result = result * 59 + ($detailsSubmitted == null ? 43 : ((Object)$detailsSubmitted).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        ExternalAccountCollection $externalAccounts = this.getExternalAccounts();
        result = result * 59 + ($externalAccounts == null ? 43 : ((Object)$externalAccounts).hashCode());
        Keys $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        LegalEntity $legalEntity = this.getLegalEntity();
        result = result * 59 + ($legalEntity == null ? 43 : ((Object)$legalEntity).hashCode());
        LoginLinkCollection $loginLinks = this.getLoginLinks();
        result = result * 59 + ($loginLinks == null ? 43 : ((Object)$loginLinks).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        PayoutSchedule $payoutSchedule = this.getPayoutSchedule();
        result = result * 59 + ($payoutSchedule == null ? 43 : ((Object)$payoutSchedule).hashCode());
        String $payoutStatementDescriptor = this.getPayoutStatementDescriptor();
        result = result * 59 + ($payoutStatementDescriptor == null ? 43 : $payoutStatementDescriptor.hashCode());
        Boolean $payoutsEnabled = this.getPayoutsEnabled();
        result = result * 59 + ($payoutsEnabled == null ? 43 : ((Object)$payoutsEnabled).hashCode());
        String $productDescription = this.getProductDescription();
        result = result * 59 + ($productDescription == null ? 43 : $productDescription.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        Address $supportAddress = this.getSupportAddress();
        result = result * 59 + ($supportAddress == null ? 43 : ((Object)$supportAddress).hashCode());
        String $supportEmail = this.getSupportEmail();
        result = result * 59 + ($supportEmail == null ? 43 : $supportEmail.hashCode());
        String $supportPhone = this.getSupportPhone();
        result = result * 59 + ($supportPhone == null ? 43 : $supportPhone.hashCode());
        String $supportUrl = this.getSupportUrl();
        result = result * 59 + ($supportUrl == null ? 43 : $supportUrl.hashCode());
        String $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        TosAcceptance $tosAcceptance = this.getTosAcceptance();
        result = result * 59 + ($tosAcceptance == null ? 43 : ((Object)$tosAcceptance).hashCode());
        Boolean $transfersEnabled = this.getTransfersEnabled();
        result = result * 59 + ($transfersEnabled == null ? 43 : ((Object)$transfersEnabled).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Verification $verification = this.getVerification();
        result = result * 59 + ($verification == null ? 43 : ((Object)$verification).hashCode());
        List<String> $currenciesSupported = this.getCurrenciesSupported();
        result = result * 59 + ($currenciesSupported == null ? 43 : ((Object)$currenciesSupported).hashCode());
        Boolean $managed = this.getManaged();
        result = result * 59 + ($managed == null ? 43 : ((Object)$managed).hashCode());
        TransferSchedule $transferSchedule = this.getTransferSchedule();
        result = result * 59 + ($transferSchedule == null ? 43 : ((Object)$transferSchedule).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Verification
    extends StripeObject {
        Boolean contacted;
        String disabledReason;
        Long dueBy;
        List<String> fieldsNeeded;

        @Generated
        public Boolean getContacted() {
            return this.contacted;
        }

        @Generated
        public String getDisabledReason() {
            return this.disabledReason;
        }

        @Generated
        public Long getDueBy() {
            return this.dueBy;
        }

        @Generated
        public List<String> getFieldsNeeded() {
            return this.fieldsNeeded;
        }

        @Generated
        public void setContacted(Boolean contacted) {
            this.contacted = contacted;
        }

        @Generated
        public void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @Generated
        public void setDueBy(Long dueBy) {
            this.dueBy = dueBy;
        }

        @Generated
        public void setFieldsNeeded(List<String> fieldsNeeded) {
            this.fieldsNeeded = fieldsNeeded;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Verification)) {
                return false;
            }
            Verification other = (Verification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$contacted = this.getContacted();
            Boolean other$contacted = other.getContacted();
            if (this$contacted == null ? other$contacted != null : !((Object)this$contacted).equals(other$contacted)) {
                return false;
            }
            String this$disabledReason = this.getDisabledReason();
            String other$disabledReason = other.getDisabledReason();
            if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) {
                return false;
            }
            Long this$dueBy = this.getDueBy();
            Long other$dueBy = other.getDueBy();
            if (this$dueBy == null ? other$dueBy != null : !((Object)this$dueBy).equals(other$dueBy)) {
                return false;
            }
            List<String> this$fieldsNeeded = this.getFieldsNeeded();
            List<String> other$fieldsNeeded = other.getFieldsNeeded();
            return !(this$fieldsNeeded == null ? other$fieldsNeeded != null : !((Object)this$fieldsNeeded).equals(other$fieldsNeeded));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Verification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $contacted = this.getContacted();
            result = result * 59 + ($contacted == null ? 43 : ((Object)$contacted).hashCode());
            String $disabledReason = this.getDisabledReason();
            result = result * 59 + ($disabledReason == null ? 43 : $disabledReason.hashCode());
            Long $dueBy = this.getDueBy();
            result = result * 59 + ($dueBy == null ? 43 : ((Object)$dueBy).hashCode());
            List<String> $fieldsNeeded = this.getFieldsNeeded();
            result = result * 59 + ($fieldsNeeded == null ? 43 : ((Object)$fieldsNeeded).hashCode());
            return result;
        }
    }

    public static class TransferSchedule
    extends StripeObject {
        Long delayDays;
        String interval;
        Long monthlyAnchor;
        String weeklyAnchor;

        @Generated
        public Long getDelayDays() {
            return this.delayDays;
        }

        @Generated
        public String getInterval() {
            return this.interval;
        }

        @Generated
        public Long getMonthlyAnchor() {
            return this.monthlyAnchor;
        }

        @Generated
        public String getWeeklyAnchor() {
            return this.weeklyAnchor;
        }

        @Generated
        public void setDelayDays(Long delayDays) {
            this.delayDays = delayDays;
        }

        @Generated
        public void setInterval(String interval) {
            this.interval = interval;
        }

        @Generated
        public void setMonthlyAnchor(Long monthlyAnchor) {
            this.monthlyAnchor = monthlyAnchor;
        }

        @Generated
        public void setWeeklyAnchor(String weeklyAnchor) {
            this.weeklyAnchor = weeklyAnchor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransferSchedule)) {
                return false;
            }
            TransferSchedule other = (TransferSchedule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$delayDays = this.getDelayDays();
            Long other$delayDays = other.getDelayDays();
            if (this$delayDays == null ? other$delayDays != null : !((Object)this$delayDays).equals(other$delayDays)) {
                return false;
            }
            String this$interval = this.getInterval();
            String other$interval = other.getInterval();
            if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                return false;
            }
            Long this$monthlyAnchor = this.getMonthlyAnchor();
            Long other$monthlyAnchor = other.getMonthlyAnchor();
            if (this$monthlyAnchor == null ? other$monthlyAnchor != null : !((Object)this$monthlyAnchor).equals(other$monthlyAnchor)) {
                return false;
            }
            String this$weeklyAnchor = this.getWeeklyAnchor();
            String other$weeklyAnchor = other.getWeeklyAnchor();
            return !(this$weeklyAnchor == null ? other$weeklyAnchor != null : !this$weeklyAnchor.equals(other$weeklyAnchor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransferSchedule;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $delayDays = this.getDelayDays();
            result = result * 59 + ($delayDays == null ? 43 : ((Object)$delayDays).hashCode());
            String $interval = this.getInterval();
            result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
            Long $monthlyAnchor = this.getMonthlyAnchor();
            result = result * 59 + ($monthlyAnchor == null ? 43 : ((Object)$monthlyAnchor).hashCode());
            String $weeklyAnchor = this.getWeeklyAnchor();
            result = result * 59 + ($weeklyAnchor == null ? 43 : $weeklyAnchor.hashCode());
            return result;
        }
    }

    public static class TosAcceptance
    extends StripeObject {
        Long date;
        String ip;
        String userAgent;

        @Generated
        public Long getDate() {
            return this.date;
        }

        @Generated
        public String getIp() {
            return this.ip;
        }

        @Generated
        public String getUserAgent() {
            return this.userAgent;
        }

        @Generated
        public void setDate(Long date) {
            this.date = date;
        }

        @Generated
        public void setIp(String ip) {
            this.ip = ip;
        }

        @Generated
        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TosAcceptance)) {
                return false;
            }
            TosAcceptance other = (TosAcceptance)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$date = this.getDate();
            Long other$date = other.getDate();
            if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            String this$userAgent = this.getUserAgent();
            String other$userAgent = other.getUserAgent();
            return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TosAcceptance;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            String $userAgent = this.getUserAgent();
            result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
            return result;
        }
    }

    public static class PayoutSchedule
    extends StripeObject {
        Long delayDays;
        String interval;
        Long monthlyAnchor;
        String weeklyAnchor;

        @Generated
        public Long getDelayDays() {
            return this.delayDays;
        }

        @Generated
        public String getInterval() {
            return this.interval;
        }

        @Generated
        public Long getMonthlyAnchor() {
            return this.monthlyAnchor;
        }

        @Generated
        public String getWeeklyAnchor() {
            return this.weeklyAnchor;
        }

        @Generated
        public void setDelayDays(Long delayDays) {
            this.delayDays = delayDays;
        }

        @Generated
        public void setInterval(String interval) {
            this.interval = interval;
        }

        @Generated
        public void setMonthlyAnchor(Long monthlyAnchor) {
            this.monthlyAnchor = monthlyAnchor;
        }

        @Generated
        public void setWeeklyAnchor(String weeklyAnchor) {
            this.weeklyAnchor = weeklyAnchor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PayoutSchedule)) {
                return false;
            }
            PayoutSchedule other = (PayoutSchedule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$delayDays = this.getDelayDays();
            Long other$delayDays = other.getDelayDays();
            if (this$delayDays == null ? other$delayDays != null : !((Object)this$delayDays).equals(other$delayDays)) {
                return false;
            }
            String this$interval = this.getInterval();
            String other$interval = other.getInterval();
            if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                return false;
            }
            Long this$monthlyAnchor = this.getMonthlyAnchor();
            Long other$monthlyAnchor = other.getMonthlyAnchor();
            if (this$monthlyAnchor == null ? other$monthlyAnchor != null : !((Object)this$monthlyAnchor).equals(other$monthlyAnchor)) {
                return false;
            }
            String this$weeklyAnchor = this.getWeeklyAnchor();
            String other$weeklyAnchor = other.getWeeklyAnchor();
            return !(this$weeklyAnchor == null ? other$weeklyAnchor != null : !this$weeklyAnchor.equals(other$weeklyAnchor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PayoutSchedule;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $delayDays = this.getDelayDays();
            result = result * 59 + ($delayDays == null ? 43 : ((Object)$delayDays).hashCode());
            String $interval = this.getInterval();
            result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
            Long $monthlyAnchor = this.getMonthlyAnchor();
            result = result * 59 + ($monthlyAnchor == null ? 43 : ((Object)$monthlyAnchor).hashCode());
            String $weeklyAnchor = this.getWeeklyAnchor();
            result = result * 59 + ($weeklyAnchor == null ? 43 : $weeklyAnchor.hashCode());
            return result;
        }
    }

    public static class Keys
    extends StripeObject {
        String publishable;
        String secret;

        @Generated
        public String getPublishable() {
            return this.publishable;
        }

        @Generated
        public String getSecret() {
            return this.secret;
        }

        @Generated
        public void setPublishable(String publishable) {
            this.publishable = publishable;
        }

        @Generated
        public void setSecret(String secret) {
            this.secret = secret;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Keys)) {
                return false;
            }
            Keys other = (Keys)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$publishable = this.getPublishable();
            String other$publishable = other.getPublishable();
            if (this$publishable == null ? other$publishable != null : !this$publishable.equals(other$publishable)) {
                return false;
            }
            String this$secret = this.getSecret();
            String other$secret = other.getSecret();
            return !(this$secret == null ? other$secret != null : !this$secret.equals(other$secret));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Keys;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $publishable = this.getPublishable();
            result = result * 59 + ($publishable == null ? 43 : $publishable.hashCode());
            String $secret = this.getSecret();
            result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
            return result;
        }
    }

    public static class DeclineChargeOn
    extends StripeObject {
        Boolean avsFailure;
        Boolean cvcFailure;

        @Generated
        public Boolean getAvsFailure() {
            return this.avsFailure;
        }

        @Generated
        public Boolean getCvcFailure() {
            return this.cvcFailure;
        }

        @Generated
        public void setAvsFailure(Boolean avsFailure) {
            this.avsFailure = avsFailure;
        }

        @Generated
        public void setCvcFailure(Boolean cvcFailure) {
            this.cvcFailure = cvcFailure;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeclineChargeOn)) {
                return false;
            }
            DeclineChargeOn other = (DeclineChargeOn)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$avsFailure = this.getAvsFailure();
            Boolean other$avsFailure = other.getAvsFailure();
            if (this$avsFailure == null ? other$avsFailure != null : !((Object)this$avsFailure).equals(other$avsFailure)) {
                return false;
            }
            Boolean this$cvcFailure = this.getCvcFailure();
            Boolean other$cvcFailure = other.getCvcFailure();
            return !(this$cvcFailure == null ? other$cvcFailure != null : !((Object)this$cvcFailure).equals(other$cvcFailure));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DeclineChargeOn;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $avsFailure = this.getAvsFailure();
            result = result * 59 + ($avsFailure == null ? 43 : ((Object)$avsFailure).hashCode());
            Boolean $cvcFailure = this.getCvcFailure();
            result = result * 59 + ($cvcFailure == null ? 43 : ((Object)$cvcFailure).hashCode());
            return result;
        }
    }
}

