// Generated by delombok at Thu Jan 17 17:48:56 PST 2019
package com.stripe.model.issuing;

import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class Authorization extends ApiResource implements MetadataStore<Authorization>, HasId {
  String id;
  String object;
  Boolean approved;
  String authorizationMethod;
  String authorizedAmount;
  String authorizedCurrency;
  List<BalanceTransaction> balanceTransactions;
  ExpandableField<Card> card;
  ExpandableField<Cardholder> cardholder;
  Long created;
  Long heldAmount;
  String heldCurrency;
  Boolean isHeldAmountControllable;
  Boolean livemode;
  MerchantData merchantData;
  Map<String, String> metadata;
  Long pendingAuthorizedAmount;
  Long pendingHeldAmount;
  List<RequestHistory> requestHistory;
  String status;
  List<Transaction> transactions;
  VerificationData verificationData;
  String walletProvider;

  // <editor-fold desc="card">
  public String getCard() {
    return (this.card != null) ? this.card.getId() : null;
  }

  public void setCard(String cardId) {
    this.card = setExpandableFieldId(cardId, this.card);
  }

  public Card getCardObject() {
    return (this.card != null) ? this.card.getExpanded() : null;
  }

  public void setCardObject(Card c) {
    this.card = new ExpandableField<Card>(c.getId(), c);
  }

  // </editor-fold>
  // <editor-fold desc="cardholder">
  public String getCardholder() {
    return (this.cardholder != null) ? this.cardholder.getId() : null;
  }

  public void setCardholder(String cardholderId) {
    this.cardholder = setExpandableFieldId(cardholderId, this.cardholder);
  }

  public Cardholder getCardholderObject() {
    return (this.cardholder != null) ? this.cardholder.getExpanded() : null;
  }

  public void setCardholderObject(Cardholder c) {
    this.cardholder = new ExpandableField<Cardholder>(c.getId(), c);
  }

  // </editor-fold>
  // <editor-fold desc="approve">
  /**
   * Approve an issuing authorization.
   */
  public Authorization approve(Map<String, Object> params) throws StripeException {
    return approve(params, null);
  }

  /**
   * Approve an issuing authorization.
   */
  public Authorization approve(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, String.format("%s/approve", instanceUrl(Authorization.class, this.getId())), params, Authorization.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="decline">
  /**
   * Decline an issuing authorization.
   */
  public Authorization decline(Map<String, Object> params) throws StripeException {
    return decline(params, null);
  }

  /**
   * Decline an issuing authorization.
   */
  public Authorization decline(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, String.format("%s/decline", instanceUrl(Authorization.class, this.getId())), params, Authorization.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="list">
  /**
   * List all issuing authorizations.
   */
  public static AuthorizationCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all issuing authorizations.
   */
  public static AuthorizationCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(Authorization.class), params, AuthorizationCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve an issuing authorization.
   */
  public static Authorization retrieve(String id) throws StripeException {
    return retrieve(id, null);
  }

  /**
   * Retrieve an issuing authorization.
   */
  public static Authorization retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve an issuing authorization.
   */
  public static Authorization retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(Authorization.class, id), params, Authorization.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="update">
  /**
   * Update an issuing authorization.
   */
  @Override
  public Authorization update(Map<String, Object> params) throws StripeException {
    return update(params, null);
  }

  /**
   * Update an issuing authorization.
   */
  @Override
  public Authorization update(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, instanceUrl(Authorization.class, this.id), params, Authorization.class, options);
  }

  // </editor-fold>
  public final class RequestHistory extends StripeObject {
    Boolean approved;
    Long authorizedAmount;
    String authorizedCurrency;
    Long created;
    Long heldAmount;
    String heldCurrency;
    String reason;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getApproved() {
      return this.approved;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAuthorizedAmount() {
      return this.authorizedAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAuthorizedCurrency() {
      return this.authorizedCurrency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCreated() {
      return this.created;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getHeldAmount() {
      return this.heldAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getHeldCurrency() {
      return this.heldCurrency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReason() {
      return this.reason;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setApproved(final Boolean approved) {
      this.approved = approved;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAuthorizedAmount(final Long authorizedAmount) {
      this.authorizedAmount = authorizedAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAuthorizedCurrency(final String authorizedCurrency) {
      this.authorizedCurrency = authorizedCurrency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCreated(final Long created) {
      this.created = created;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setHeldAmount(final Long heldAmount) {
      this.heldAmount = heldAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setHeldCurrency(final String heldCurrency) {
      this.heldCurrency = heldCurrency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReason(final String reason) {
      this.reason = reason;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Authorization.RequestHistory)) return false;
      final Authorization.RequestHistory other = (Authorization.RequestHistory) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$approved = this.getApproved();
      final java.lang.Object other$approved = other.getApproved();
      if (this$approved == null ? other$approved != null : !this$approved.equals(other$approved)) return false;
      final java.lang.Object this$authorizedAmount = this.getAuthorizedAmount();
      final java.lang.Object other$authorizedAmount = other.getAuthorizedAmount();
      if (this$authorizedAmount == null ? other$authorizedAmount != null : !this$authorizedAmount.equals(other$authorizedAmount)) return false;
      final java.lang.Object this$authorizedCurrency = this.getAuthorizedCurrency();
      final java.lang.Object other$authorizedCurrency = other.getAuthorizedCurrency();
      if (this$authorizedCurrency == null ? other$authorizedCurrency != null : !this$authorizedCurrency.equals(other$authorizedCurrency)) return false;
      final java.lang.Object this$created = this.getCreated();
      final java.lang.Object other$created = other.getCreated();
      if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
      final java.lang.Object this$heldAmount = this.getHeldAmount();
      final java.lang.Object other$heldAmount = other.getHeldAmount();
      if (this$heldAmount == null ? other$heldAmount != null : !this$heldAmount.equals(other$heldAmount)) return false;
      final java.lang.Object this$heldCurrency = this.getHeldCurrency();
      final java.lang.Object other$heldCurrency = other.getHeldCurrency();
      if (this$heldCurrency == null ? other$heldCurrency != null : !this$heldCurrency.equals(other$heldCurrency)) return false;
      final java.lang.Object this$reason = this.getReason();
      final java.lang.Object other$reason = other.getReason();
      if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Authorization.RequestHistory;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $approved = this.getApproved();
      result = result * PRIME + ($approved == null ? 43 : $approved.hashCode());
      final java.lang.Object $authorizedAmount = this.getAuthorizedAmount();
      result = result * PRIME + ($authorizedAmount == null ? 43 : $authorizedAmount.hashCode());
      final java.lang.Object $authorizedCurrency = this.getAuthorizedCurrency();
      result = result * PRIME + ($authorizedCurrency == null ? 43 : $authorizedCurrency.hashCode());
      final java.lang.Object $created = this.getCreated();
      result = result * PRIME + ($created == null ? 43 : $created.hashCode());
      final java.lang.Object $heldAmount = this.getHeldAmount();
      result = result * PRIME + ($heldAmount == null ? 43 : $heldAmount.hashCode());
      final java.lang.Object $heldCurrency = this.getHeldCurrency();
      result = result * PRIME + ($heldCurrency == null ? 43 : $heldCurrency.hashCode());
      final java.lang.Object $reason = this.getReason();
      result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
      return result;
    }
  }


  public final class VerificationData extends StripeObject {
    String addressLine1Check;
    String addressZipCheck;
    String cvcCheck;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAddressLine1Check() {
      return this.addressLine1Check;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAddressZipCheck() {
      return this.addressZipCheck;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCvcCheck() {
      return this.cvcCheck;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddressLine1Check(final String addressLine1Check) {
      this.addressLine1Check = addressLine1Check;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddressZipCheck(final String addressZipCheck) {
      this.addressZipCheck = addressZipCheck;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCvcCheck(final String cvcCheck) {
      this.cvcCheck = cvcCheck;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Authorization.VerificationData)) return false;
      final Authorization.VerificationData other = (Authorization.VerificationData) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$addressLine1Check = this.getAddressLine1Check();
      final java.lang.Object other$addressLine1Check = other.getAddressLine1Check();
      if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) return false;
      final java.lang.Object this$addressZipCheck = this.getAddressZipCheck();
      final java.lang.Object other$addressZipCheck = other.getAddressZipCheck();
      if (this$addressZipCheck == null ? other$addressZipCheck != null : !this$addressZipCheck.equals(other$addressZipCheck)) return false;
      final java.lang.Object this$cvcCheck = this.getCvcCheck();
      final java.lang.Object other$cvcCheck = other.getCvcCheck();
      if (this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Authorization.VerificationData;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $addressLine1Check = this.getAddressLine1Check();
      result = result * PRIME + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
      final java.lang.Object $addressZipCheck = this.getAddressZipCheck();
      result = result * PRIME + ($addressZipCheck == null ? 43 : $addressZipCheck.hashCode());
      final java.lang.Object $cvcCheck = this.getCvcCheck();
      result = result * PRIME + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getApproved() {
    return this.approved;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAuthorizationMethod() {
    return this.authorizationMethod;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAuthorizedAmount() {
    return this.authorizedAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAuthorizedCurrency() {
    return this.authorizedCurrency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<BalanceTransaction> getBalanceTransactions() {
    return this.balanceTransactions;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getHeldAmount() {
    return this.heldAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHeldCurrency() {
    return this.heldCurrency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getIsHeldAmountControllable() {
    return this.isHeldAmountControllable;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public MerchantData getMerchantData() {
    return this.merchantData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getPendingAuthorizedAmount() {
    return this.pendingAuthorizedAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getPendingHeldAmount() {
    return this.pendingHeldAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<RequestHistory> getRequestHistory() {
    return this.requestHistory;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<Transaction> getTransactions() {
    return this.transactions;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public VerificationData getVerificationData() {
    return this.verificationData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getWalletProvider() {
    return this.walletProvider;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApproved(final Boolean approved) {
    this.approved = approved;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAuthorizationMethod(final String authorizationMethod) {
    this.authorizationMethod = authorizationMethod;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAuthorizedAmount(final String authorizedAmount) {
    this.authorizedAmount = authorizedAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAuthorizedCurrency(final String authorizedCurrency) {
    this.authorizedCurrency = authorizedCurrency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBalanceTransactions(final List<BalanceTransaction> balanceTransactions) {
    this.balanceTransactions = balanceTransactions;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHeldAmount(final Long heldAmount) {
    this.heldAmount = heldAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHeldCurrency(final String heldCurrency) {
    this.heldCurrency = heldCurrency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIsHeldAmountControllable(final Boolean isHeldAmountControllable) {
    this.isHeldAmountControllable = isHeldAmountControllable;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMerchantData(final MerchantData merchantData) {
    this.merchantData = merchantData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPendingAuthorizedAmount(final Long pendingAuthorizedAmount) {
    this.pendingAuthorizedAmount = pendingAuthorizedAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPendingHeldAmount(final Long pendingHeldAmount) {
    this.pendingHeldAmount = pendingHeldAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRequestHistory(final List<RequestHistory> requestHistory) {
    this.requestHistory = requestHistory;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransactions(final List<Transaction> transactions) {
    this.transactions = transactions;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVerificationData(final VerificationData verificationData) {
    this.verificationData = verificationData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWalletProvider(final String walletProvider) {
    this.walletProvider = walletProvider;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Authorization)) return false;
    final Authorization other = (Authorization) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$approved = this.getApproved();
    final java.lang.Object other$approved = other.getApproved();
    if (this$approved == null ? other$approved != null : !this$approved.equals(other$approved)) return false;
    final java.lang.Object this$authorizationMethod = this.getAuthorizationMethod();
    final java.lang.Object other$authorizationMethod = other.getAuthorizationMethod();
    if (this$authorizationMethod == null ? other$authorizationMethod != null : !this$authorizationMethod.equals(other$authorizationMethod)) return false;
    final java.lang.Object this$authorizedAmount = this.getAuthorizedAmount();
    final java.lang.Object other$authorizedAmount = other.getAuthorizedAmount();
    if (this$authorizedAmount == null ? other$authorizedAmount != null : !this$authorizedAmount.equals(other$authorizedAmount)) return false;
    final java.lang.Object this$authorizedCurrency = this.getAuthorizedCurrency();
    final java.lang.Object other$authorizedCurrency = other.getAuthorizedCurrency();
    if (this$authorizedCurrency == null ? other$authorizedCurrency != null : !this$authorizedCurrency.equals(other$authorizedCurrency)) return false;
    final java.lang.Object this$balanceTransactions = this.getBalanceTransactions();
    final java.lang.Object other$balanceTransactions = other.getBalanceTransactions();
    if (this$balanceTransactions == null ? other$balanceTransactions != null : !this$balanceTransactions.equals(other$balanceTransactions)) return false;
    final java.lang.Object this$card = this.getCard();
    final java.lang.Object other$card = other.getCard();
    if (this$card == null ? other$card != null : !this$card.equals(other$card)) return false;
    final java.lang.Object this$cardholder = this.getCardholder();
    final java.lang.Object other$cardholder = other.getCardholder();
    if (this$cardholder == null ? other$cardholder != null : !this$cardholder.equals(other$cardholder)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$heldAmount = this.getHeldAmount();
    final java.lang.Object other$heldAmount = other.getHeldAmount();
    if (this$heldAmount == null ? other$heldAmount != null : !this$heldAmount.equals(other$heldAmount)) return false;
    final java.lang.Object this$heldCurrency = this.getHeldCurrency();
    final java.lang.Object other$heldCurrency = other.getHeldCurrency();
    if (this$heldCurrency == null ? other$heldCurrency != null : !this$heldCurrency.equals(other$heldCurrency)) return false;
    final java.lang.Object this$isHeldAmountControllable = this.getIsHeldAmountControllable();
    final java.lang.Object other$isHeldAmountControllable = other.getIsHeldAmountControllable();
    if (this$isHeldAmountControllable == null ? other$isHeldAmountControllable != null : !this$isHeldAmountControllable.equals(other$isHeldAmountControllable)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$merchantData = this.getMerchantData();
    final java.lang.Object other$merchantData = other.getMerchantData();
    if (this$merchantData == null ? other$merchantData != null : !this$merchantData.equals(other$merchantData)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$pendingAuthorizedAmount = this.getPendingAuthorizedAmount();
    final java.lang.Object other$pendingAuthorizedAmount = other.getPendingAuthorizedAmount();
    if (this$pendingAuthorizedAmount == null ? other$pendingAuthorizedAmount != null : !this$pendingAuthorizedAmount.equals(other$pendingAuthorizedAmount)) return false;
    final java.lang.Object this$pendingHeldAmount = this.getPendingHeldAmount();
    final java.lang.Object other$pendingHeldAmount = other.getPendingHeldAmount();
    if (this$pendingHeldAmount == null ? other$pendingHeldAmount != null : !this$pendingHeldAmount.equals(other$pendingHeldAmount)) return false;
    final java.lang.Object this$requestHistory = this.getRequestHistory();
    final java.lang.Object other$requestHistory = other.getRequestHistory();
    if (this$requestHistory == null ? other$requestHistory != null : !this$requestHistory.equals(other$requestHistory)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$transactions = this.getTransactions();
    final java.lang.Object other$transactions = other.getTransactions();
    if (this$transactions == null ? other$transactions != null : !this$transactions.equals(other$transactions)) return false;
    final java.lang.Object this$verificationData = this.getVerificationData();
    final java.lang.Object other$verificationData = other.getVerificationData();
    if (this$verificationData == null ? other$verificationData != null : !this$verificationData.equals(other$verificationData)) return false;
    final java.lang.Object this$walletProvider = this.getWalletProvider();
    final java.lang.Object other$walletProvider = other.getWalletProvider();
    if (this$walletProvider == null ? other$walletProvider != null : !this$walletProvider.equals(other$walletProvider)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Authorization;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $approved = this.getApproved();
    result = result * PRIME + ($approved == null ? 43 : $approved.hashCode());
    final java.lang.Object $authorizationMethod = this.getAuthorizationMethod();
    result = result * PRIME + ($authorizationMethod == null ? 43 : $authorizationMethod.hashCode());
    final java.lang.Object $authorizedAmount = this.getAuthorizedAmount();
    result = result * PRIME + ($authorizedAmount == null ? 43 : $authorizedAmount.hashCode());
    final java.lang.Object $authorizedCurrency = this.getAuthorizedCurrency();
    result = result * PRIME + ($authorizedCurrency == null ? 43 : $authorizedCurrency.hashCode());
    final java.lang.Object $balanceTransactions = this.getBalanceTransactions();
    result = result * PRIME + ($balanceTransactions == null ? 43 : $balanceTransactions.hashCode());
    final java.lang.Object $card = this.getCard();
    result = result * PRIME + ($card == null ? 43 : $card.hashCode());
    final java.lang.Object $cardholder = this.getCardholder();
    result = result * PRIME + ($cardholder == null ? 43 : $cardholder.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $heldAmount = this.getHeldAmount();
    result = result * PRIME + ($heldAmount == null ? 43 : $heldAmount.hashCode());
    final java.lang.Object $heldCurrency = this.getHeldCurrency();
    result = result * PRIME + ($heldCurrency == null ? 43 : $heldCurrency.hashCode());
    final java.lang.Object $isHeldAmountControllable = this.getIsHeldAmountControllable();
    result = result * PRIME + ($isHeldAmountControllable == null ? 43 : $isHeldAmountControllable.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $merchantData = this.getMerchantData();
    result = result * PRIME + ($merchantData == null ? 43 : $merchantData.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $pendingAuthorizedAmount = this.getPendingAuthorizedAmount();
    result = result * PRIME + ($pendingAuthorizedAmount == null ? 43 : $pendingAuthorizedAmount.hashCode());
    final java.lang.Object $pendingHeldAmount = this.getPendingHeldAmount();
    result = result * PRIME + ($pendingHeldAmount == null ? 43 : $pendingHeldAmount.hashCode());
    final java.lang.Object $requestHistory = this.getRequestHistory();
    result = result * PRIME + ($requestHistory == null ? 43 : $requestHistory.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $transactions = this.getTransactions();
    result = result * PRIME + ($transactions == null ? 43 : $transactions.hashCode());
    final java.lang.Object $verificationData = this.getVerificationData();
    result = result * PRIME + ($verificationData == null ? 43 : $verificationData.hashCode());
    final java.lang.Object $walletProvider = this.getWalletProvider();
    result = result * PRIME + ($walletProvider == null ? 43 : $walletProvider.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
