// Generated by delombok at Wed Feb 06 10:35:01 CET 2019
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class Dispute extends ApiResource implements HasId {
  String id;
  String object;
  Long amount;
  List<BalanceTransaction> balanceTransactions;
  ExpandableField<Charge> charge;
  Long created;
  String currency;
  EvidenceSubObject evidenceSubObject; // `evidence`
  EvidenceDetails evidenceDetails;
  Boolean isChargeRefundable;
  Boolean livemode;
  Map<String, String> metadata;
  String reason;
  String status;
  String networkReasonCode; // Not part of the public API.
  /**
   * The {@code balance_transaction} attribute.
   *
   * @deprecated Prefer using the {@link #balanceTransactions} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2014-08-20">API version 2014-08-20</a>
   */
  @Deprecated
  String balanceTransaction;
  /**
   * The {@code evidence} String attribute.
   *
   * @deprecated Prefer using the {@link #getEvidenceSubObject} method instead.
   * @see <a href="https://stripe.com/docs/upgrades#2014-12-08">API version 2014-12-08</a>
   */
  @Deprecated
  String evidence;
  /**
   * The {@code evidence_due_by} attribute.
   *
   * @deprecated Prefer using the {@code getEvidenceDetails().getDueBy()} method instead.
   * @see <a href="https://stripe.com/docs/upgrades#2014-12-08">API version 2014-12-08</a>
   */
  @Deprecated
  Long evidenceDueBy;

  // <editor-fold desc="charge">
  public String getCharge() {
    return (this.charge != null) ? this.charge.getId() : null;
  }

  public void setCharge(String chargeId) {
    this.charge = setExpandableFieldId(chargeId, this.charge);
  }

  public Charge getChargeObject() {
    return (this.charge != null) ? this.charge.getExpanded() : null;
  }

  public void setChargeObject(Charge charge) {
    this.charge = new ExpandableField<>(charge.getId(), charge);
  }

  // </editor-fold>
  // <editor-fold desc="close">
  /**
   * Close a dispute.
   */
  public Dispute close() throws StripeException {
    return close(null);
  }

  /**
   * Close a dispute.
   */
  public Dispute close(RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, String.format("%s/close", instanceUrl(Dispute.class, this.getId())), null, Dispute.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="list">
  /**
   * List all disputes.
   */
  public static DisputeCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all disputes.
   */
  public static DisputeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(Dispute.class), params, DisputeCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve a dispute.
   */
  public static Dispute retrieve(String id) throws StripeException {
    return retrieve(id, null, null);
  }

  /**
   * Retrieve a dispute.
   */
  public static Dispute retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve a dispute.
   */
  public static Dispute retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(Dispute.class, id), params, Dispute.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="update">
  /**
   * Update a dispute.
   */
  public Dispute update(Map<String, Object> params) throws StripeException {
    return update(params, null);
  }

  /**
   * Update a dispute.
   */
  public Dispute update(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, instanceUrl(Dispute.class, this.getId()), params, Dispute.class, options);
  }

  // </editor-fold>
  public static class EvidenceDetails extends StripeObject {
    Long dueBy;
    Long submissionCount;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDueBy() {
      return this.dueBy;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSubmissionCount() {
      return this.submissionCount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDueBy(final Long dueBy) {
      this.dueBy = dueBy;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSubmissionCount(final Long submissionCount) {
      this.submissionCount = submissionCount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Dispute.EvidenceDetails)) return false;
      final Dispute.EvidenceDetails other = (Dispute.EvidenceDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$dueBy = this.getDueBy();
      final java.lang.Object other$dueBy = other.getDueBy();
      if (this$dueBy == null ? other$dueBy != null : !this$dueBy.equals(other$dueBy)) return false;
      final java.lang.Object this$submissionCount = this.getSubmissionCount();
      final java.lang.Object other$submissionCount = other.getSubmissionCount();
      if (this$submissionCount == null ? other$submissionCount != null : !this$submissionCount.equals(other$submissionCount)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Dispute.EvidenceDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $dueBy = this.getDueBy();
      result = result * PRIME + ($dueBy == null ? 43 : $dueBy.hashCode());
      final java.lang.Object $submissionCount = this.getSubmissionCount();
      result = result * PRIME + ($submissionCount == null ? 43 : $submissionCount.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<BalanceTransaction> getBalanceTransactions() {
    return this.balanceTransactions;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public EvidenceSubObject getEvidenceSubObject() {
    return this.evidenceSubObject;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public EvidenceDetails getEvidenceDetails() {
    return this.evidenceDetails;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getIsChargeRefundable() {
    return this.isChargeRefundable;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReason() {
    return this.reason;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getNetworkReasonCode() {
    return this.networkReasonCode;
  }

  /**
   * The {@code balance_transaction} attribute.
   *
   * @return the {@code balance_transaction} attribute
   * @deprecated Prefer using the {@link #balanceTransactions} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2014-08-20">API version 2014-08-20</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBalanceTransaction() {
    return this.balanceTransaction;
  }

  /**
   * The {@code evidence} String attribute.
   *
   * @return the {@code evidence} String attribute
   * @deprecated Prefer using the {@link #getEvidenceSubObject} method instead.
   * @see <a href="https://stripe.com/docs/upgrades#2014-12-08">API version 2014-12-08</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEvidence() {
    return this.evidence;
  }

  /**
   * The {@code evidence_due_by} attribute.
   *
   * @return the {@code evidence_due_by} attribute
   * @deprecated Prefer using the {@code getEvidenceDetails().getDueBy()} method instead.
   * @see <a href="https://stripe.com/docs/upgrades#2014-12-08">API version 2014-12-08</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getEvidenceDueBy() {
    return this.evidenceDueBy;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBalanceTransactions(final List<BalanceTransaction> balanceTransactions) {
    this.balanceTransactions = balanceTransactions;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEvidenceSubObject(final EvidenceSubObject evidenceSubObject) {
    this.evidenceSubObject = evidenceSubObject;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEvidenceDetails(final EvidenceDetails evidenceDetails) {
    this.evidenceDetails = evidenceDetails;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIsChargeRefundable(final Boolean isChargeRefundable) {
    this.isChargeRefundable = isChargeRefundable;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReason(final String reason) {
    this.reason = reason;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNetworkReasonCode(final String networkReasonCode) {
    this.networkReasonCode = networkReasonCode;
  }

  /**
   * The {@code balance_transaction} attribute.
   *
   * @deprecated Prefer using the {@link #balanceTransactions} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2014-08-20">API version 2014-08-20</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBalanceTransaction(final String balanceTransaction) {
    this.balanceTransaction = balanceTransaction;
  }

  /**
   * The {@code evidence} String attribute.
   *
   * @deprecated Prefer using the {@link #getEvidenceSubObject} method instead.
   * @see <a href="https://stripe.com/docs/upgrades#2014-12-08">API version 2014-12-08</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEvidence(final String evidence) {
    this.evidence = evidence;
  }

  /**
   * The {@code evidence_due_by} attribute.
   *
   * @deprecated Prefer using the {@code getEvidenceDetails().getDueBy()} method instead.
   * @see <a href="https://stripe.com/docs/upgrades#2014-12-08">API version 2014-12-08</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEvidenceDueBy(final Long evidenceDueBy) {
    this.evidenceDueBy = evidenceDueBy;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Dispute)) return false;
    final Dispute other = (Dispute) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$balanceTransactions = this.getBalanceTransactions();
    final java.lang.Object other$balanceTransactions = other.getBalanceTransactions();
    if (this$balanceTransactions == null ? other$balanceTransactions != null : !this$balanceTransactions.equals(other$balanceTransactions)) return false;
    final java.lang.Object this$charge = this.getCharge();
    final java.lang.Object other$charge = other.getCharge();
    if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$evidenceSubObject = this.getEvidenceSubObject();
    final java.lang.Object other$evidenceSubObject = other.getEvidenceSubObject();
    if (this$evidenceSubObject == null ? other$evidenceSubObject != null : !this$evidenceSubObject.equals(other$evidenceSubObject)) return false;
    final java.lang.Object this$evidenceDetails = this.getEvidenceDetails();
    final java.lang.Object other$evidenceDetails = other.getEvidenceDetails();
    if (this$evidenceDetails == null ? other$evidenceDetails != null : !this$evidenceDetails.equals(other$evidenceDetails)) return false;
    final java.lang.Object this$isChargeRefundable = this.getIsChargeRefundable();
    final java.lang.Object other$isChargeRefundable = other.getIsChargeRefundable();
    if (this$isChargeRefundable == null ? other$isChargeRefundable != null : !this$isChargeRefundable.equals(other$isChargeRefundable)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$reason = this.getReason();
    final java.lang.Object other$reason = other.getReason();
    if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$networkReasonCode = this.getNetworkReasonCode();
    final java.lang.Object other$networkReasonCode = other.getNetworkReasonCode();
    if (this$networkReasonCode == null ? other$networkReasonCode != null : !this$networkReasonCode.equals(other$networkReasonCode)) return false;
    final java.lang.Object this$balanceTransaction = this.getBalanceTransaction();
    final java.lang.Object other$balanceTransaction = other.getBalanceTransaction();
    if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) return false;
    final java.lang.Object this$evidence = this.getEvidence();
    final java.lang.Object other$evidence = other.getEvidence();
    if (this$evidence == null ? other$evidence != null : !this$evidence.equals(other$evidence)) return false;
    final java.lang.Object this$evidenceDueBy = this.getEvidenceDueBy();
    final java.lang.Object other$evidenceDueBy = other.getEvidenceDueBy();
    if (this$evidenceDueBy == null ? other$evidenceDueBy != null : !this$evidenceDueBy.equals(other$evidenceDueBy)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Dispute;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $balanceTransactions = this.getBalanceTransactions();
    result = result * PRIME + ($balanceTransactions == null ? 43 : $balanceTransactions.hashCode());
    final java.lang.Object $charge = this.getCharge();
    result = result * PRIME + ($charge == null ? 43 : $charge.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $evidenceSubObject = this.getEvidenceSubObject();
    result = result * PRIME + ($evidenceSubObject == null ? 43 : $evidenceSubObject.hashCode());
    final java.lang.Object $evidenceDetails = this.getEvidenceDetails();
    result = result * PRIME + ($evidenceDetails == null ? 43 : $evidenceDetails.hashCode());
    final java.lang.Object $isChargeRefundable = this.getIsChargeRefundable();
    result = result * PRIME + ($isChargeRefundable == null ? 43 : $isChargeRefundable.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $reason = this.getReason();
    result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $networkReasonCode = this.getNetworkReasonCode();
    result = result * PRIME + ($networkReasonCode == null ? 43 : $networkReasonCode.hashCode());
    final java.lang.Object $balanceTransaction = this.getBalanceTransaction();
    result = result * PRIME + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
    final java.lang.Object $evidence = this.getEvidence();
    result = result * PRIME + ($evidence == null ? 43 : $evidence.hashCode());
    final java.lang.Object $evidenceDueBy = this.getEvidenceDueBy();
    result = result * PRIME + ($evidenceDueBy == null ? 43 : $evidenceDueBy.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
