// Generated by delombok at Wed Oct 31 12:31:58 PDT 2018
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class InvoiceItem extends ApiResource implements MetadataStore<InvoiceItem>, HasId {
  String id;
  String object;
  Long amount;
  String currency;
  ExpandableField<Customer> customer;
  Long date;
  String description;
  Boolean discountable;
  ExpandableField<Invoice> invoice;
  Boolean livemode;
  Map<String, String> metadata;
  InvoiceLineItemPeriod period;
  Plan plan;
  Boolean proration;
  Long quantity;
  ExpandableField<Subscription> subscription;
  String subscriptionItem;
  Long unitAmount;
  Boolean deleted;

  // <editor-fold desc="customer">
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String customerId) {
    this.customer = setExpandableFieldId(customerId, this.customer);
  }

  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer c) {
    this.customer = new ExpandableField<Customer>(c.getId(), c);
  }

  // </editor-fold>
  // <editor-fold desc="invoice">
  public String getInvoice() {
    return (this.invoice != null) ? this.invoice.getId() : null;
  }

  public void setInvoice(String invoiceId) {
    this.invoice = setExpandableFieldId(invoiceId, this.invoice);
  }

  public Invoice getInvoiceObject() {
    return (this.invoice != null) ? this.invoice.getExpanded() : null;
  }

  public void setInvoiceObject(Invoice invoice) {
    this.invoice = new ExpandableField<Invoice>(invoice.getId(), invoice);
  }

  // </editor-fold>
  // <editor-fold desc="subscription">
  public String getSubscription() {
    return (this.subscription != null) ? this.subscription.getId() : null;
  }

  public void setSubscription(String subscriptionId) {
    this.subscription = setExpandableFieldId(subscriptionId, this.subscription);
  }

  public Subscription getSubscriptionObject() {
    return (this.subscription != null) ? this.subscription.getExpanded() : null;
  }

  public void setSubscriptionObject(Subscription subscription) {
    this.subscription = new ExpandableField<Subscription>(subscription.getId(), subscription);
  }

  // </editor-fold>
  // <editor-fold desc="create">
  /**
   * Create an invoice item.
   */
  public static InvoiceItem create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Create an invoice item.
   */
  public static InvoiceItem create(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, classUrl(InvoiceItem.class), params, InvoiceItem.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="delete">
  /**
   * Delete an invoice item.
   */
  public InvoiceItem delete() throws StripeException {
    return delete((RequestOptions) null);
  }

  /**
   * Delete an invoice item.
   */
  public InvoiceItem delete(RequestOptions options) throws StripeException {
    return request(RequestMethod.DELETE, instanceUrl(InvoiceItem.class, this.id), null, InvoiceItem.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="list">
  /**
   * List all invoice items.
   */
  public static InvoiceItemCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all invoice items.
   */
  public static InvoiceItemCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(InvoiceItem.class), params, InvoiceItemCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve an invoice item.
   */
  public static InvoiceItem retrieve(String id) throws StripeException {
    return retrieve(id, (RequestOptions) null);
  }

  /**
   * Retrieve an invoice item.
   */
  public static InvoiceItem retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve an invoice item.
   */
  public static InvoiceItem retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(InvoiceItem.class, id), params, InvoiceItem.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="update">
  /**
   * Update an invoice item.
   */
  @Override
  public InvoiceItem update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Update an invoice item.
   */
  @Override
  public InvoiceItem update(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, instanceUrl(InvoiceItem.class, this.id), params, InvoiceItem.class, options);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getDate() {
    return this.date;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDiscountable() {
    return this.discountable;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public InvoiceLineItemPeriod getPeriod() {
    return this.period;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Plan getPlan() {
    return this.plan;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getProration() {
    return this.proration;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getQuantity() {
    return this.quantity;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSubscriptionItem() {
    return this.subscriptionItem;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getUnitAmount() {
    return this.unitAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDate(final Long date) {
    this.date = date;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiscountable(final Boolean discountable) {
    this.discountable = discountable;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPeriod(final InvoiceLineItemPeriod period) {
    this.period = period;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPlan(final Plan plan) {
    this.plan = plan;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setProration(final Boolean proration) {
    this.proration = proration;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setQuantity(final Long quantity) {
    this.quantity = quantity;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSubscriptionItem(final String subscriptionItem) {
    this.subscriptionItem = subscriptionItem;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUnitAmount(final Long unitAmount) {
    this.unitAmount = unitAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof InvoiceItem)) return false;
    final InvoiceItem other = (InvoiceItem) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$date = this.getDate();
    final java.lang.Object other$date = other.getDate();
    if (this$date == null ? other$date != null : !this$date.equals(other$date)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$discountable = this.getDiscountable();
    final java.lang.Object other$discountable = other.getDiscountable();
    if (this$discountable == null ? other$discountable != null : !this$discountable.equals(other$discountable)) return false;
    final java.lang.Object this$invoice = this.getInvoice();
    final java.lang.Object other$invoice = other.getInvoice();
    if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$period = this.getPeriod();
    final java.lang.Object other$period = other.getPeriod();
    if (this$period == null ? other$period != null : !this$period.equals(other$period)) return false;
    final java.lang.Object this$plan = this.getPlan();
    final java.lang.Object other$plan = other.getPlan();
    if (this$plan == null ? other$plan != null : !this$plan.equals(other$plan)) return false;
    final java.lang.Object this$proration = this.getProration();
    final java.lang.Object other$proration = other.getProration();
    if (this$proration == null ? other$proration != null : !this$proration.equals(other$proration)) return false;
    final java.lang.Object this$quantity = this.getQuantity();
    final java.lang.Object other$quantity = other.getQuantity();
    if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) return false;
    final java.lang.Object this$subscription = this.getSubscription();
    final java.lang.Object other$subscription = other.getSubscription();
    if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) return false;
    final java.lang.Object this$subscriptionItem = this.getSubscriptionItem();
    final java.lang.Object other$subscriptionItem = other.getSubscriptionItem();
    if (this$subscriptionItem == null ? other$subscriptionItem != null : !this$subscriptionItem.equals(other$subscriptionItem)) return false;
    final java.lang.Object this$unitAmount = this.getUnitAmount();
    final java.lang.Object other$unitAmount = other.getUnitAmount();
    if (this$unitAmount == null ? other$unitAmount != null : !this$unitAmount.equals(other$unitAmount)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof InvoiceItem;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $date = this.getDate();
    result = result * PRIME + ($date == null ? 43 : $date.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $discountable = this.getDiscountable();
    result = result * PRIME + ($discountable == null ? 43 : $discountable.hashCode());
    final java.lang.Object $invoice = this.getInvoice();
    result = result * PRIME + ($invoice == null ? 43 : $invoice.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $period = this.getPeriod();
    result = result * PRIME + ($period == null ? 43 : $period.hashCode());
    final java.lang.Object $plan = this.getPlan();
    result = result * PRIME + ($plan == null ? 43 : $plan.hashCode());
    final java.lang.Object $proration = this.getProration();
    result = result * PRIME + ($proration == null ? 43 : $proration.hashCode());
    final java.lang.Object $quantity = this.getQuantity();
    result = result * PRIME + ($quantity == null ? 43 : $quantity.hashCode());
    final java.lang.Object $subscription = this.getSubscription();
    result = result * PRIME + ($subscription == null ? 43 : $subscription.hashCode());
    final java.lang.Object $subscriptionItem = this.getSubscriptionItem();
    result = result * PRIME + ($subscriptionItem == null ? 43 : $subscriptionItem.hashCode());
    final java.lang.Object $unitAmount = this.getUnitAmount();
    result = result * PRIME + ($unitAmount == null ? 43 : $unitAmount.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
  // </editor-fold>
}
