/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.model.Charge;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExternalAccount;
import com.stripe.model.HasId;
import com.stripe.model.InvoiceCollection;
import com.stripe.model.InvoiceLineItemCollection;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.Subscription;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Invoice
extends ApiResource
implements MetadataStore<Invoice>,
HasId {
    String id;
    String object;
    Long amountDue;
    Long amountPaid;
    Long amountRemaining;
    Long applicationFee;
    Long attemptCount;
    Boolean attempted;
    Boolean autoAdvance;
    String billing;
    String billingReason;
    ExpandableField<Charge> charge;
    Long created;
    String currency;
    List<CustomField> customFields;
    ExpandableField<Customer> customer;
    Long date;
    ExpandableField<ExternalAccount> defaultSource;
    Boolean deleted;
    String description;
    Discount discount;
    Long dueDate;
    Long endingBalance;
    Long finalizedAt;
    String footer;
    String hostedInvoiceUrl;
    String invoicePdf;
    InvoiceLineItemCollection lines;
    Boolean livemode;
    Map<String, String> metadata;
    Long nextPaymentAttempt;
    String number;
    Boolean paid;
    Long periodEnd;
    Long periodStart;
    String receiptNumber;
    Long startingBalance;
    String statementDescriptor;
    String status;
    ExpandableField<Subscription> subscription;
    Long subscriptionProrationDate;
    Long subtotal;
    Long tax;
    BigDecimal taxPercent;
    ThresholdReason thresholdReason;
    Long total;
    Long webhooksDeliveredAt;
    @Deprecated
    Boolean closed;
    @Deprecated
    Boolean forgiven;

    public String getCharge() {
        return this.charge != null ? this.charge.getId() : null;
    }

    public void setCharge(String chargeId) {
        this.charge = Invoice.setExpandableFieldId(chargeId, this.charge);
    }

    public Charge getChargeObject() {
        return this.charge != null ? this.charge.getExpanded() : null;
    }

    public void setChargeObject(Charge charge) {
        this.charge = new ExpandableField<Charge>(charge.getId(), charge);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String customerId) {
        this.customer = Invoice.setExpandableFieldId(customerId, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer customer) {
        this.customer = new ExpandableField<Customer>(customer.getId(), customer);
    }

    public String getDefaultSource() {
        return this.defaultSource != null ? this.defaultSource.getId() : null;
    }

    public void setDefaultSource(String defaultSourceId) {
        this.defaultSource = Invoice.setExpandableFieldId(defaultSourceId, this.defaultSource);
    }

    public ExternalAccount getDefaultSourceObject() {
        return this.defaultSource != null ? this.defaultSource.getExpanded() : null;
    }

    public void setDefaultSourceObject(ExternalAccount c) {
        this.defaultSource = new ExpandableField<ExternalAccount>(c.getId(), c);
    }

    public String getSubscription() {
        return this.subscription != null ? this.subscription.getId() : null;
    }

    public void setSubscription(String subscriptionId) {
        this.subscription = Invoice.setExpandableFieldId(subscriptionId, this.subscription);
    }

    public Subscription getSubscriptionObject() {
        return this.subscription != null ? this.subscription.getExpanded() : null;
    }

    public void setSubscriptionObject(Subscription subscription) {
        this.subscription = new ExpandableField<Subscription>(subscription.getId(), subscription);
    }

    public static Invoice create(Map<String, Object> params) throws StripeException {
        return Invoice.create(params, null);
    }

    public static Invoice create(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Invoice.request(ApiResource.RequestMethod.POST, Invoice.classUrl(Invoice.class), params, Invoice.class, options);
    }

    public Invoice delete() throws StripeException {
        return this.delete(null);
    }

    public Invoice delete(RequestOptions options) throws StripeException {
        return Invoice.request(ApiResource.RequestMethod.DELETE, Invoice.instanceUrl(Invoice.class, this.id), null, Invoice.class, options);
    }

    public static InvoiceCollection list(Map<String, Object> params) throws StripeException {
        return Invoice.list(params, null);
    }

    public static InvoiceCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Invoice.requestCollection(Invoice.classUrl(Invoice.class), params, InvoiceCollection.class, options);
    }

    public Invoice finalizeInvoice() throws StripeException {
        return this.finalizeInvoice((RequestOptions)null);
    }

    public Invoice finalizeInvoice(RequestOptions options) throws StripeException {
        return this.finalizeInvoice(null, options);
    }

    public Invoice finalizeInvoice(Map<String, Object> params) throws StripeException {
        return this.finalizeInvoice(params, null);
    }

    public Invoice finalizeInvoice(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Invoice.request(ApiResource.RequestMethod.POST, String.format("%s/finalize", Invoice.instanceUrl(Invoice.class, this.getId())), params, Invoice.class, options);
    }

    public Invoice markUncollectible() throws StripeException {
        return this.markUncollectible((RequestOptions)null);
    }

    public Invoice markUncollectible(RequestOptions options) throws StripeException {
        return this.markUncollectible(null, options);
    }

    public Invoice markUncollectible(Map<String, Object> params) throws StripeException {
        return this.markUncollectible(params, null);
    }

    public Invoice markUncollectible(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Invoice.request(ApiResource.RequestMethod.POST, String.format("%s/mark_uncollectible", Invoice.instanceUrl(Invoice.class, this.getId())), params, Invoice.class, options);
    }

    public Invoice pay() throws StripeException {
        return this.pay((RequestOptions)null);
    }

    public Invoice pay(RequestOptions options) throws StripeException {
        return this.pay(null, options);
    }

    public Invoice pay(Map<String, Object> params) throws StripeException {
        return this.pay(params, null);
    }

    public Invoice pay(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Invoice.request(ApiResource.RequestMethod.POST, String.format("%s/pay", Invoice.instanceUrl(Invoice.class, this.getId())), params, Invoice.class, options);
    }

    public static Invoice retrieve(String id) throws StripeException {
        return Invoice.retrieve(id, null);
    }

    public static Invoice retrieve(String id, RequestOptions options) throws StripeException {
        return Invoice.retrieve(id, null, options);
    }

    public static Invoice retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        return Invoice.request(ApiResource.RequestMethod.GET, Invoice.instanceUrl(Invoice.class, id), params, Invoice.class, options);
    }

    public Invoice sendInvoice() throws StripeException {
        return this.sendInvoice((RequestOptions)null);
    }

    public Invoice sendInvoice(RequestOptions options) throws StripeException {
        return this.sendInvoice(null, options);
    }

    public Invoice sendInvoice(Map<String, Object> params) throws StripeException {
        return this.sendInvoice(params, null);
    }

    public Invoice sendInvoice(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Invoice.request(ApiResource.RequestMethod.POST, String.format("%s/send", Invoice.instanceUrl(Invoice.class, this.getId())), params, Invoice.class, options);
    }

    public static Invoice upcoming(Map<String, Object> params) throws StripeException {
        return Invoice.upcoming(params, null);
    }

    public static Invoice upcoming(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Invoice.request(ApiResource.RequestMethod.GET, String.format("%s/upcoming", Invoice.classUrl(Invoice.class)), params, Invoice.class, options);
    }

    public Invoice update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Invoice update(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Invoice.request(ApiResource.RequestMethod.POST, Invoice.instanceUrl(Invoice.class, this.id), params, Invoice.class, options);
    }

    public Invoice voidInvoice() throws StripeException {
        return this.voidInvoice((RequestOptions)null);
    }

    public Invoice voidInvoice(RequestOptions options) throws StripeException {
        return this.voidInvoice(null, options);
    }

    public Invoice voidInvoice(Map<String, Object> params) throws StripeException {
        return this.voidInvoice(params, null);
    }

    public Invoice voidInvoice(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Invoice.request(ApiResource.RequestMethod.POST, String.format("%s/void", Invoice.instanceUrl(Invoice.class, this.getId())), params, Invoice.class, options);
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getAmountDue() {
        return this.amountDue;
    }

    @Generated
    public Long getAmountPaid() {
        return this.amountPaid;
    }

    @Generated
    public Long getAmountRemaining() {
        return this.amountRemaining;
    }

    @Generated
    public Long getApplicationFee() {
        return this.applicationFee;
    }

    @Generated
    public Long getAttemptCount() {
        return this.attemptCount;
    }

    @Generated
    public Boolean getAttempted() {
        return this.attempted;
    }

    @Generated
    public Boolean getAutoAdvance() {
        return this.autoAdvance;
    }

    @Generated
    public String getBilling() {
        return this.billing;
    }

    @Generated
    public String getBillingReason() {
        return this.billingReason;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public List<CustomField> getCustomFields() {
        return this.customFields;
    }

    @Generated
    public Long getDate() {
        return this.date;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Discount getDiscount() {
        return this.discount;
    }

    @Generated
    public Long getDueDate() {
        return this.dueDate;
    }

    @Generated
    public Long getEndingBalance() {
        return this.endingBalance;
    }

    @Generated
    public Long getFinalizedAt() {
        return this.finalizedAt;
    }

    @Generated
    public String getFooter() {
        return this.footer;
    }

    @Generated
    public String getHostedInvoiceUrl() {
        return this.hostedInvoiceUrl;
    }

    @Generated
    public String getInvoicePdf() {
        return this.invoicePdf;
    }

    @Generated
    public InvoiceLineItemCollection getLines() {
        return this.lines;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Long getNextPaymentAttempt() {
        return this.nextPaymentAttempt;
    }

    @Generated
    public String getNumber() {
        return this.number;
    }

    @Generated
    public Boolean getPaid() {
        return this.paid;
    }

    @Generated
    public Long getPeriodEnd() {
        return this.periodEnd;
    }

    @Generated
    public Long getPeriodStart() {
        return this.periodStart;
    }

    @Generated
    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    @Generated
    public Long getStartingBalance() {
        return this.startingBalance;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public Long getSubscriptionProrationDate() {
        return this.subscriptionProrationDate;
    }

    @Generated
    public Long getSubtotal() {
        return this.subtotal;
    }

    @Generated
    public Long getTax() {
        return this.tax;
    }

    @Generated
    public BigDecimal getTaxPercent() {
        return this.taxPercent;
    }

    @Generated
    public ThresholdReason getThresholdReason() {
        return this.thresholdReason;
    }

    @Generated
    public Long getTotal() {
        return this.total;
    }

    @Generated
    public Long getWebhooksDeliveredAt() {
        return this.webhooksDeliveredAt;
    }

    @Deprecated
    @Generated
    public Boolean getClosed() {
        return this.closed;
    }

    @Deprecated
    @Generated
    public Boolean getForgiven() {
        return this.forgiven;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setAmountDue(Long amountDue) {
        this.amountDue = amountDue;
    }

    @Generated
    public void setAmountPaid(Long amountPaid) {
        this.amountPaid = amountPaid;
    }

    @Generated
    public void setAmountRemaining(Long amountRemaining) {
        this.amountRemaining = amountRemaining;
    }

    @Generated
    public void setApplicationFee(Long applicationFee) {
        this.applicationFee = applicationFee;
    }

    @Generated
    public void setAttemptCount(Long attemptCount) {
        this.attemptCount = attemptCount;
    }

    @Generated
    public void setAttempted(Boolean attempted) {
        this.attempted = attempted;
    }

    @Generated
    public void setAutoAdvance(Boolean autoAdvance) {
        this.autoAdvance = autoAdvance;
    }

    @Generated
    public void setBilling(String billing) {
        this.billing = billing;
    }

    @Generated
    public void setBillingReason(String billingReason) {
        this.billingReason = billingReason;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCustomFields(List<CustomField> customFields) {
        this.customFields = customFields;
    }

    @Generated
    public void setDate(Long date) {
        this.date = date;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    @Generated
    public void setDueDate(Long dueDate) {
        this.dueDate = dueDate;
    }

    @Generated
    public void setEndingBalance(Long endingBalance) {
        this.endingBalance = endingBalance;
    }

    @Generated
    public void setFinalizedAt(Long finalizedAt) {
        this.finalizedAt = finalizedAt;
    }

    @Generated
    public void setFooter(String footer) {
        this.footer = footer;
    }

    @Generated
    public void setHostedInvoiceUrl(String hostedInvoiceUrl) {
        this.hostedInvoiceUrl = hostedInvoiceUrl;
    }

    @Generated
    public void setInvoicePdf(String invoicePdf) {
        this.invoicePdf = invoicePdf;
    }

    @Generated
    public void setLines(InvoiceLineItemCollection lines) {
        this.lines = lines;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNextPaymentAttempt(Long nextPaymentAttempt) {
        this.nextPaymentAttempt = nextPaymentAttempt;
    }

    @Generated
    public void setNumber(String number) {
        this.number = number;
    }

    @Generated
    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    @Generated
    public void setPeriodEnd(Long periodEnd) {
        this.periodEnd = periodEnd;
    }

    @Generated
    public void setPeriodStart(Long periodStart) {
        this.periodStart = periodStart;
    }

    @Generated
    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    @Generated
    public void setStartingBalance(Long startingBalance) {
        this.startingBalance = startingBalance;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setSubscriptionProrationDate(Long subscriptionProrationDate) {
        this.subscriptionProrationDate = subscriptionProrationDate;
    }

    @Generated
    public void setSubtotal(Long subtotal) {
        this.subtotal = subtotal;
    }

    @Generated
    public void setTax(Long tax) {
        this.tax = tax;
    }

    @Generated
    public void setTaxPercent(BigDecimal taxPercent) {
        this.taxPercent = taxPercent;
    }

    @Generated
    public void setThresholdReason(ThresholdReason thresholdReason) {
        this.thresholdReason = thresholdReason;
    }

    @Generated
    public void setTotal(Long total) {
        this.total = total;
    }

    @Generated
    public void setWebhooksDeliveredAt(Long webhooksDeliveredAt) {
        this.webhooksDeliveredAt = webhooksDeliveredAt;
    }

    @Deprecated
    @Generated
    public void setClosed(Boolean closed) {
        this.closed = closed;
    }

    @Deprecated
    @Generated
    public void setForgiven(Boolean forgiven) {
        this.forgiven = forgiven;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Invoice)) {
            return false;
        }
        Invoice other = (Invoice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$amountDue = this.getAmountDue();
        Long other$amountDue = other.getAmountDue();
        if (this$amountDue == null ? other$amountDue != null : !((Object)this$amountDue).equals(other$amountDue)) {
            return false;
        }
        Long this$amountPaid = this.getAmountPaid();
        Long other$amountPaid = other.getAmountPaid();
        if (this$amountPaid == null ? other$amountPaid != null : !((Object)this$amountPaid).equals(other$amountPaid)) {
            return false;
        }
        Long this$amountRemaining = this.getAmountRemaining();
        Long other$amountRemaining = other.getAmountRemaining();
        if (this$amountRemaining == null ? other$amountRemaining != null : !((Object)this$amountRemaining).equals(other$amountRemaining)) {
            return false;
        }
        Long this$applicationFee = this.getApplicationFee();
        Long other$applicationFee = other.getApplicationFee();
        if (this$applicationFee == null ? other$applicationFee != null : !((Object)this$applicationFee).equals(other$applicationFee)) {
            return false;
        }
        Long this$attemptCount = this.getAttemptCount();
        Long other$attemptCount = other.getAttemptCount();
        if (this$attemptCount == null ? other$attemptCount != null : !((Object)this$attemptCount).equals(other$attemptCount)) {
            return false;
        }
        Boolean this$attempted = this.getAttempted();
        Boolean other$attempted = other.getAttempted();
        if (this$attempted == null ? other$attempted != null : !((Object)this$attempted).equals(other$attempted)) {
            return false;
        }
        Boolean this$autoAdvance = this.getAutoAdvance();
        Boolean other$autoAdvance = other.getAutoAdvance();
        if (this$autoAdvance == null ? other$autoAdvance != null : !((Object)this$autoAdvance).equals(other$autoAdvance)) {
            return false;
        }
        String this$billing = this.getBilling();
        String other$billing = other.getBilling();
        if (this$billing == null ? other$billing != null : !this$billing.equals(other$billing)) {
            return false;
        }
        String this$billingReason = this.getBillingReason();
        String other$billingReason = other.getBillingReason();
        if (this$billingReason == null ? other$billingReason != null : !this$billingReason.equals(other$billingReason)) {
            return false;
        }
        String this$charge = this.getCharge();
        String other$charge = other.getCharge();
        if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        List<CustomField> this$customFields = this.getCustomFields();
        List<CustomField> other$customFields = other.getCustomFields();
        if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        Long this$date = this.getDate();
        Long other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$defaultSource = this.getDefaultSource();
        String other$defaultSource = other.getDefaultSource();
        if (this$defaultSource == null ? other$defaultSource != null : !this$defaultSource.equals(other$defaultSource)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Discount this$discount = this.getDiscount();
        Discount other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        Long this$dueDate = this.getDueDate();
        Long other$dueDate = other.getDueDate();
        if (this$dueDate == null ? other$dueDate != null : !((Object)this$dueDate).equals(other$dueDate)) {
            return false;
        }
        Long this$endingBalance = this.getEndingBalance();
        Long other$endingBalance = other.getEndingBalance();
        if (this$endingBalance == null ? other$endingBalance != null : !((Object)this$endingBalance).equals(other$endingBalance)) {
            return false;
        }
        Long this$finalizedAt = this.getFinalizedAt();
        Long other$finalizedAt = other.getFinalizedAt();
        if (this$finalizedAt == null ? other$finalizedAt != null : !((Object)this$finalizedAt).equals(other$finalizedAt)) {
            return false;
        }
        String this$footer = this.getFooter();
        String other$footer = other.getFooter();
        if (this$footer == null ? other$footer != null : !this$footer.equals(other$footer)) {
            return false;
        }
        String this$hostedInvoiceUrl = this.getHostedInvoiceUrl();
        String other$hostedInvoiceUrl = other.getHostedInvoiceUrl();
        if (this$hostedInvoiceUrl == null ? other$hostedInvoiceUrl != null : !this$hostedInvoiceUrl.equals(other$hostedInvoiceUrl)) {
            return false;
        }
        String this$invoicePdf = this.getInvoicePdf();
        String other$invoicePdf = other.getInvoicePdf();
        if (this$invoicePdf == null ? other$invoicePdf != null : !this$invoicePdf.equals(other$invoicePdf)) {
            return false;
        }
        InvoiceLineItemCollection this$lines = this.getLines();
        InvoiceLineItemCollection other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Long this$nextPaymentAttempt = this.getNextPaymentAttempt();
        Long other$nextPaymentAttempt = other.getNextPaymentAttempt();
        if (this$nextPaymentAttempt == null ? other$nextPaymentAttempt != null : !((Object)this$nextPaymentAttempt).equals(other$nextPaymentAttempt)) {
            return false;
        }
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        Boolean this$paid = this.getPaid();
        Boolean other$paid = other.getPaid();
        if (this$paid == null ? other$paid != null : !((Object)this$paid).equals(other$paid)) {
            return false;
        }
        Long this$periodEnd = this.getPeriodEnd();
        Long other$periodEnd = other.getPeriodEnd();
        if (this$periodEnd == null ? other$periodEnd != null : !((Object)this$periodEnd).equals(other$periodEnd)) {
            return false;
        }
        Long this$periodStart = this.getPeriodStart();
        Long other$periodStart = other.getPeriodStart();
        if (this$periodStart == null ? other$periodStart != null : !((Object)this$periodStart).equals(other$periodStart)) {
            return false;
        }
        String this$receiptNumber = this.getReceiptNumber();
        String other$receiptNumber = other.getReceiptNumber();
        if (this$receiptNumber == null ? other$receiptNumber != null : !this$receiptNumber.equals(other$receiptNumber)) {
            return false;
        }
        Long this$startingBalance = this.getStartingBalance();
        Long other$startingBalance = other.getStartingBalance();
        if (this$startingBalance == null ? other$startingBalance != null : !((Object)this$startingBalance).equals(other$startingBalance)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        Long this$subscriptionProrationDate = this.getSubscriptionProrationDate();
        Long other$subscriptionProrationDate = other.getSubscriptionProrationDate();
        if (this$subscriptionProrationDate == null ? other$subscriptionProrationDate != null : !((Object)this$subscriptionProrationDate).equals(other$subscriptionProrationDate)) {
            return false;
        }
        Long this$subtotal = this.getSubtotal();
        Long other$subtotal = other.getSubtotal();
        if (this$subtotal == null ? other$subtotal != null : !((Object)this$subtotal).equals(other$subtotal)) {
            return false;
        }
        Long this$tax = this.getTax();
        Long other$tax = other.getTax();
        if (this$tax == null ? other$tax != null : !((Object)this$tax).equals(other$tax)) {
            return false;
        }
        BigDecimal this$taxPercent = this.getTaxPercent();
        BigDecimal other$taxPercent = other.getTaxPercent();
        if (this$taxPercent == null ? other$taxPercent != null : !((Object)this$taxPercent).equals(other$taxPercent)) {
            return false;
        }
        ThresholdReason this$thresholdReason = this.getThresholdReason();
        ThresholdReason other$thresholdReason = other.getThresholdReason();
        if (this$thresholdReason == null ? other$thresholdReason != null : !((Object)this$thresholdReason).equals(other$thresholdReason)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Long this$webhooksDeliveredAt = this.getWebhooksDeliveredAt();
        Long other$webhooksDeliveredAt = other.getWebhooksDeliveredAt();
        if (this$webhooksDeliveredAt == null ? other$webhooksDeliveredAt != null : !((Object)this$webhooksDeliveredAt).equals(other$webhooksDeliveredAt)) {
            return false;
        }
        Boolean this$closed = this.getClosed();
        Boolean other$closed = other.getClosed();
        if (this$closed == null ? other$closed != null : !((Object)this$closed).equals(other$closed)) {
            return false;
        }
        Boolean this$forgiven = this.getForgiven();
        Boolean other$forgiven = other.getForgiven();
        return !(this$forgiven == null ? other$forgiven != null : !((Object)this$forgiven).equals(other$forgiven));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Invoice;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $amountDue = this.getAmountDue();
        result = result * 59 + ($amountDue == null ? 43 : ((Object)$amountDue).hashCode());
        Long $amountPaid = this.getAmountPaid();
        result = result * 59 + ($amountPaid == null ? 43 : ((Object)$amountPaid).hashCode());
        Long $amountRemaining = this.getAmountRemaining();
        result = result * 59 + ($amountRemaining == null ? 43 : ((Object)$amountRemaining).hashCode());
        Long $applicationFee = this.getApplicationFee();
        result = result * 59 + ($applicationFee == null ? 43 : ((Object)$applicationFee).hashCode());
        Long $attemptCount = this.getAttemptCount();
        result = result * 59 + ($attemptCount == null ? 43 : ((Object)$attemptCount).hashCode());
        Boolean $attempted = this.getAttempted();
        result = result * 59 + ($attempted == null ? 43 : ((Object)$attempted).hashCode());
        Boolean $autoAdvance = this.getAutoAdvance();
        result = result * 59 + ($autoAdvance == null ? 43 : ((Object)$autoAdvance).hashCode());
        String $billing = this.getBilling();
        result = result * 59 + ($billing == null ? 43 : $billing.hashCode());
        String $billingReason = this.getBillingReason();
        result = result * 59 + ($billingReason == null ? 43 : $billingReason.hashCode());
        String $charge = this.getCharge();
        result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        List<CustomField> $customFields = this.getCustomFields();
        result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        Long $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $defaultSource = this.getDefaultSource();
        result = result * 59 + ($defaultSource == null ? 43 : $defaultSource.hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Discount $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        Long $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : ((Object)$dueDate).hashCode());
        Long $endingBalance = this.getEndingBalance();
        result = result * 59 + ($endingBalance == null ? 43 : ((Object)$endingBalance).hashCode());
        Long $finalizedAt = this.getFinalizedAt();
        result = result * 59 + ($finalizedAt == null ? 43 : ((Object)$finalizedAt).hashCode());
        String $footer = this.getFooter();
        result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
        String $hostedInvoiceUrl = this.getHostedInvoiceUrl();
        result = result * 59 + ($hostedInvoiceUrl == null ? 43 : $hostedInvoiceUrl.hashCode());
        String $invoicePdf = this.getInvoicePdf();
        result = result * 59 + ($invoicePdf == null ? 43 : $invoicePdf.hashCode());
        InvoiceLineItemCollection $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Long $nextPaymentAttempt = this.getNextPaymentAttempt();
        result = result * 59 + ($nextPaymentAttempt == null ? 43 : ((Object)$nextPaymentAttempt).hashCode());
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        Boolean $paid = this.getPaid();
        result = result * 59 + ($paid == null ? 43 : ((Object)$paid).hashCode());
        Long $periodEnd = this.getPeriodEnd();
        result = result * 59 + ($periodEnd == null ? 43 : ((Object)$periodEnd).hashCode());
        Long $periodStart = this.getPeriodStart();
        result = result * 59 + ($periodStart == null ? 43 : ((Object)$periodStart).hashCode());
        String $receiptNumber = this.getReceiptNumber();
        result = result * 59 + ($receiptNumber == null ? 43 : $receiptNumber.hashCode());
        Long $startingBalance = this.getStartingBalance();
        result = result * 59 + ($startingBalance == null ? 43 : ((Object)$startingBalance).hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        Long $subscriptionProrationDate = this.getSubscriptionProrationDate();
        result = result * 59 + ($subscriptionProrationDate == null ? 43 : ((Object)$subscriptionProrationDate).hashCode());
        Long $subtotal = this.getSubtotal();
        result = result * 59 + ($subtotal == null ? 43 : ((Object)$subtotal).hashCode());
        Long $tax = this.getTax();
        result = result * 59 + ($tax == null ? 43 : ((Object)$tax).hashCode());
        BigDecimal $taxPercent = this.getTaxPercent();
        result = result * 59 + ($taxPercent == null ? 43 : ((Object)$taxPercent).hashCode());
        ThresholdReason $thresholdReason = this.getThresholdReason();
        result = result * 59 + ($thresholdReason == null ? 43 : ((Object)$thresholdReason).hashCode());
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Long $webhooksDeliveredAt = this.getWebhooksDeliveredAt();
        result = result * 59 + ($webhooksDeliveredAt == null ? 43 : ((Object)$webhooksDeliveredAt).hashCode());
        Boolean $closed = this.getClosed();
        result = result * 59 + ($closed == null ? 43 : ((Object)$closed).hashCode());
        Boolean $forgiven = this.getForgiven();
        result = result * 59 + ($forgiven == null ? 43 : ((Object)$forgiven).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class ThresholdItemReason
    extends StripeObject {
        List<String> lineItemIds;
        Long usageGte;

        @Generated
        public List<String> getLineItemIds() {
            return this.lineItemIds;
        }

        @Generated
        public Long getUsageGte() {
            return this.usageGte;
        }

        @Generated
        public void setLineItemIds(List<String> lineItemIds) {
            this.lineItemIds = lineItemIds;
        }

        @Generated
        public void setUsageGte(Long usageGte) {
            this.usageGte = usageGte;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThresholdItemReason)) {
                return false;
            }
            ThresholdItemReason other = (ThresholdItemReason)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$lineItemIds = this.getLineItemIds();
            List<String> other$lineItemIds = other.getLineItemIds();
            if (this$lineItemIds == null ? other$lineItemIds != null : !((Object)this$lineItemIds).equals(other$lineItemIds)) {
                return false;
            }
            Long this$usageGte = this.getUsageGte();
            Long other$usageGte = other.getUsageGte();
            return !(this$usageGte == null ? other$usageGte != null : !((Object)this$usageGte).equals(other$usageGte));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ThresholdItemReason;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $lineItemIds = this.getLineItemIds();
            result = result * 59 + ($lineItemIds == null ? 43 : ((Object)$lineItemIds).hashCode());
            Long $usageGte = this.getUsageGte();
            result = result * 59 + ($usageGte == null ? 43 : ((Object)$usageGte).hashCode());
            return result;
        }
    }

    public static class ThresholdReason
    extends StripeObject {
        Long amountGte;
        List<ThresholdItemReason> itemReasons;

        @Generated
        public Long getAmountGte() {
            return this.amountGte;
        }

        @Generated
        public List<ThresholdItemReason> getItemReasons() {
            return this.itemReasons;
        }

        @Generated
        public void setAmountGte(Long amountGte) {
            this.amountGte = amountGte;
        }

        @Generated
        public void setItemReasons(List<ThresholdItemReason> itemReasons) {
            this.itemReasons = itemReasons;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThresholdReason)) {
                return false;
            }
            ThresholdReason other = (ThresholdReason)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountGte = this.getAmountGte();
            Long other$amountGte = other.getAmountGte();
            if (this$amountGte == null ? other$amountGte != null : !((Object)this$amountGte).equals(other$amountGte)) {
                return false;
            }
            List<ThresholdItemReason> this$itemReasons = this.getItemReasons();
            List<ThresholdItemReason> other$itemReasons = other.getItemReasons();
            return !(this$itemReasons == null ? other$itemReasons != null : !((Object)this$itemReasons).equals(other$itemReasons));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ThresholdReason;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountGte = this.getAmountGte();
            result = result * 59 + ($amountGte == null ? 43 : ((Object)$amountGte).hashCode());
            List<ThresholdItemReason> $itemReasons = this.getItemReasons();
            result = result * 59 + ($itemReasons == null ? 43 : ((Object)$itemReasons).hashCode());
            return result;
        }
    }

    public static class CustomField
    extends StripeObject {
        String name;
        String value;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setValue(String value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomField)) {
                return false;
            }
            CustomField other = (CustomField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomField;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }
}

