/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Application;
import com.stripe.model.ChargeCollection;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExternalAccount;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentIntentCollection;
import com.stripe.model.PaymentIntentLastPaymentError;
import com.stripe.model.PaymentIntentSourceAction;
import com.stripe.model.Review;
import com.stripe.model.ShippingDetails;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PaymentIntent
extends ApiResource
implements MetadataStore<PaymentIntent>,
HasId {
    String id;
    String object;
    Long amount;
    Long amountCapturable;
    Long amountReceived;
    ExpandableField<Application> application;
    Long applicationFeeAmount;
    Long canceledAt;
    String cancellationReason;
    String captureMethod;
    ChargeCollection charges;
    String clientSecret;
    String confirmationMethod;
    Long created;
    String currency;
    ExpandableField<Customer> customer;
    PaymentIntentLastPaymentError lastPaymentError;
    Boolean livemode;
    Map<String, String> metadata;
    NextAction nextAction;
    ExpandableField<Account> onBehalfOf;
    List<String> paymentMethodTypes;
    String receiptEmail;
    ExpandableField<Review> review;
    ShippingDetails shipping;
    ExpandableField<ExternalAccount> source;
    String statementDescriptor;
    TransferData transferData;
    String status;
    @Deprecated
    List<String> allowedSourceTypes;
    @Deprecated
    PaymentIntentSourceAction nextSourceAction;
    @Deprecated
    String returnUrl;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String applicationId) {
        this.application = PaymentIntent.setExpandableFieldId(applicationId, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application c) {
        this.application = new ExpandableField<Application>(c.getId(), c);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String customerId) {
        this.customer = PaymentIntent.setExpandableFieldId(customerId, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer c) {
        this.customer = new ExpandableField<Customer>(c.getId(), c);
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String onBehalfOfId) {
        this.onBehalfOf = PaymentIntent.setExpandableFieldId(onBehalfOfId, this.onBehalfOf);
    }

    public Account getOnBehalfOfObject() {
        return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account c) {
        this.onBehalfOf = new ExpandableField<Account>(c.getId(), c);
    }

    public String getReview() {
        return this.review != null ? this.review.getId() : null;
    }

    public void setReview(String reviewId) {
        this.review = PaymentIntent.setExpandableFieldId(reviewId, this.review);
    }

    public Review getReviewObject() {
        return this.review != null ? this.review.getExpanded() : null;
    }

    public void setReviewObject(Review c) {
        this.review = new ExpandableField<Review>(c.getId(), c);
    }

    public String getSource() {
        return this.source != null ? this.source.getId() : null;
    }

    public void setSource(String sourceId) {
        this.source = PaymentIntent.setExpandableFieldId(sourceId, this.source);
    }

    public ExternalAccount getSourceObject() {
        return this.source != null ? this.source.getExpanded() : null;
    }

    public void setSourceObject(ExternalAccount c) {
        this.source = new ExpandableField<ExternalAccount>(c.getId(), c);
    }

    public PaymentIntent cancel() throws StripeException {
        return this.cancel(null, null);
    }

    public PaymentIntent cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, null);
    }

    public PaymentIntent cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        return PaymentIntent.request(ApiResource.RequestMethod.POST, PaymentIntent.instanceUrl(PaymentIntent.class, this.id) + "/cancel", params, PaymentIntent.class, options);
    }

    public PaymentIntent capture() throws StripeException {
        return this.capture(null, null);
    }

    public PaymentIntent capture(Map<String, Object> params) throws StripeException {
        return this.capture(params, null);
    }

    public PaymentIntent capture(Map<String, Object> params, RequestOptions options) throws StripeException {
        return PaymentIntent.request(ApiResource.RequestMethod.POST, PaymentIntent.instanceUrl(PaymentIntent.class, this.id) + "/capture", params, PaymentIntent.class, options);
    }

    public PaymentIntent confirm() throws StripeException {
        return this.confirm(null, null);
    }

    public PaymentIntent confirm(Map<String, Object> params) throws StripeException {
        return this.confirm(params, null);
    }

    public PaymentIntent confirm(Map<String, Object> params, RequestOptions options) throws StripeException {
        return PaymentIntent.request(ApiResource.RequestMethod.POST, PaymentIntent.instanceUrl(PaymentIntent.class, this.id) + "/confirm", params, PaymentIntent.class, options);
    }

    public static PaymentIntent create(Map<String, Object> params) throws StripeException {
        return PaymentIntent.create(params, null);
    }

    public static PaymentIntent create(Map<String, Object> params, RequestOptions options) throws StripeException {
        return PaymentIntent.request(ApiResource.RequestMethod.POST, PaymentIntent.classUrl(PaymentIntent.class), params, PaymentIntent.class, options);
    }

    public static PaymentIntentCollection list(Map<String, Object> params) throws StripeException {
        return PaymentIntent.list(params, null);
    }

    public static PaymentIntentCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        return PaymentIntent.requestCollection(PaymentIntent.classUrl(PaymentIntent.class), params, PaymentIntentCollection.class, options);
    }

    public static PaymentIntent retrieve(String id) throws StripeException {
        return PaymentIntent.retrieve(id, null);
    }

    public static PaymentIntent retrieve(String id, RequestOptions options) throws StripeException {
        return PaymentIntent.retrieve(id, null, options);
    }

    public static PaymentIntent retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        return PaymentIntent.request(ApiResource.RequestMethod.GET, PaymentIntent.instanceUrl(PaymentIntent.class, id), params, PaymentIntent.class, options);
    }

    public PaymentIntent update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public PaymentIntent update(Map<String, Object> params, RequestOptions options) throws StripeException {
        return PaymentIntent.request(ApiResource.RequestMethod.POST, PaymentIntent.instanceUrl(PaymentIntent.class, this.id), params, PaymentIntent.class, options);
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getAmountCapturable() {
        return this.amountCapturable;
    }

    @Generated
    public Long getAmountReceived() {
        return this.amountReceived;
    }

    @Generated
    public Long getApplicationFeeAmount() {
        return this.applicationFeeAmount;
    }

    @Generated
    public Long getCanceledAt() {
        return this.canceledAt;
    }

    @Generated
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    @Generated
    public String getCaptureMethod() {
        return this.captureMethod;
    }

    @Generated
    public ChargeCollection getCharges() {
        return this.charges;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getConfirmationMethod() {
        return this.confirmationMethod;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public PaymentIntentLastPaymentError getLastPaymentError() {
        return this.lastPaymentError;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public NextAction getNextAction() {
        return this.nextAction;
    }

    @Generated
    public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Generated
    public String getReceiptEmail() {
        return this.receiptEmail;
    }

    @Generated
    public ShippingDetails getShipping() {
        return this.shipping;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Deprecated
    @Generated
    public List<String> getAllowedSourceTypes() {
        return this.allowedSourceTypes;
    }

    @Deprecated
    @Generated
    public PaymentIntentSourceAction getNextSourceAction() {
        return this.nextSourceAction;
    }

    @Deprecated
    @Generated
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAmountCapturable(Long amountCapturable) {
        this.amountCapturable = amountCapturable;
    }

    @Generated
    public void setAmountReceived(Long amountReceived) {
        this.amountReceived = amountReceived;
    }

    @Generated
    public void setApplicationFeeAmount(Long applicationFeeAmount) {
        this.applicationFeeAmount = applicationFeeAmount;
    }

    @Generated
    public void setCanceledAt(Long canceledAt) {
        this.canceledAt = canceledAt;
    }

    @Generated
    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    @Generated
    public void setCaptureMethod(String captureMethod) {
        this.captureMethod = captureMethod;
    }

    @Generated
    public void setCharges(ChargeCollection charges) {
        this.charges = charges;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setConfirmationMethod(String confirmationMethod) {
        this.confirmationMethod = confirmationMethod;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setLastPaymentError(PaymentIntentLastPaymentError lastPaymentError) {
        this.lastPaymentError = lastPaymentError;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNextAction(NextAction nextAction) {
        this.nextAction = nextAction;
    }

    @Generated
    public void setPaymentMethodTypes(List<String> paymentMethodTypes) {
        this.paymentMethodTypes = paymentMethodTypes;
    }

    @Generated
    public void setReceiptEmail(String receiptEmail) {
        this.receiptEmail = receiptEmail;
    }

    @Generated
    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setTransferData(TransferData transferData) {
        this.transferData = transferData;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Deprecated
    @Generated
    public void setAllowedSourceTypes(List<String> allowedSourceTypes) {
        this.allowedSourceTypes = allowedSourceTypes;
    }

    @Deprecated
    @Generated
    public void setNextSourceAction(PaymentIntentSourceAction nextSourceAction) {
        this.nextSourceAction = nextSourceAction;
    }

    @Deprecated
    @Generated
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentIntent)) {
            return false;
        }
        PaymentIntent other = (PaymentIntent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$amountCapturable = this.getAmountCapturable();
        Long other$amountCapturable = other.getAmountCapturable();
        if (this$amountCapturable == null ? other$amountCapturable != null : !((Object)this$amountCapturable).equals(other$amountCapturable)) {
            return false;
        }
        Long this$amountReceived = this.getAmountReceived();
        Long other$amountReceived = other.getAmountReceived();
        if (this$amountReceived == null ? other$amountReceived != null : !((Object)this$amountReceived).equals(other$amountReceived)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        Long this$applicationFeeAmount = this.getApplicationFeeAmount();
        Long other$applicationFeeAmount = other.getApplicationFeeAmount();
        if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !((Object)this$applicationFeeAmount).equals(other$applicationFeeAmount)) {
            return false;
        }
        Long this$canceledAt = this.getCanceledAt();
        Long other$canceledAt = other.getCanceledAt();
        if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
            return false;
        }
        String this$cancellationReason = this.getCancellationReason();
        String other$cancellationReason = other.getCancellationReason();
        if (this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason)) {
            return false;
        }
        String this$captureMethod = this.getCaptureMethod();
        String other$captureMethod = other.getCaptureMethod();
        if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
            return false;
        }
        ChargeCollection this$charges = this.getCharges();
        ChargeCollection other$charges = other.getCharges();
        if (this$charges == null ? other$charges != null : !((Object)this$charges).equals(other$charges)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$confirmationMethod = this.getConfirmationMethod();
        String other$confirmationMethod = other.getConfirmationMethod();
        if (this$confirmationMethod == null ? other$confirmationMethod != null : !this$confirmationMethod.equals(other$confirmationMethod)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        PaymentIntentLastPaymentError this$lastPaymentError = this.getLastPaymentError();
        PaymentIntentLastPaymentError other$lastPaymentError = other.getLastPaymentError();
        if (this$lastPaymentError == null ? other$lastPaymentError != null : !((Object)this$lastPaymentError).equals(other$lastPaymentError)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        NextAction this$nextAction = this.getNextAction();
        NextAction other$nextAction = other.getNextAction();
        if (this$nextAction == null ? other$nextAction != null : !((Object)this$nextAction).equals(other$nextAction)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        List<String> this$paymentMethodTypes = this.getPaymentMethodTypes();
        List<String> other$paymentMethodTypes = other.getPaymentMethodTypes();
        if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !((Object)this$paymentMethodTypes).equals(other$paymentMethodTypes)) {
            return false;
        }
        String this$receiptEmail = this.getReceiptEmail();
        String other$receiptEmail = other.getReceiptEmail();
        if (this$receiptEmail == null ? other$receiptEmail != null : !this$receiptEmail.equals(other$receiptEmail)) {
            return false;
        }
        String this$review = this.getReview();
        String other$review = other.getReview();
        if (this$review == null ? other$review != null : !this$review.equals(other$review)) {
            return false;
        }
        ShippingDetails this$shipping = this.getShipping();
        ShippingDetails other$shipping = other.getShipping();
        if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        TransferData this$transferData = this.getTransferData();
        TransferData other$transferData = other.getTransferData();
        if (this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        List<String> this$allowedSourceTypes = this.getAllowedSourceTypes();
        List<String> other$allowedSourceTypes = other.getAllowedSourceTypes();
        if (this$allowedSourceTypes == null ? other$allowedSourceTypes != null : !((Object)this$allowedSourceTypes).equals(other$allowedSourceTypes)) {
            return false;
        }
        PaymentIntentSourceAction this$nextSourceAction = this.getNextSourceAction();
        PaymentIntentSourceAction other$nextSourceAction = other.getNextSourceAction();
        if (this$nextSourceAction == null ? other$nextSourceAction != null : !((Object)this$nextSourceAction).equals(other$nextSourceAction)) {
            return false;
        }
        String this$returnUrl = this.getReturnUrl();
        String other$returnUrl = other.getReturnUrl();
        return !(this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentIntent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $amountCapturable = this.getAmountCapturable();
        result = result * 59 + ($amountCapturable == null ? 43 : ((Object)$amountCapturable).hashCode());
        Long $amountReceived = this.getAmountReceived();
        result = result * 59 + ($amountReceived == null ? 43 : ((Object)$amountReceived).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        Long $applicationFeeAmount = this.getApplicationFeeAmount();
        result = result * 59 + ($applicationFeeAmount == null ? 43 : ((Object)$applicationFeeAmount).hashCode());
        Long $canceledAt = this.getCanceledAt();
        result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
        String $cancellationReason = this.getCancellationReason();
        result = result * 59 + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
        String $captureMethod = this.getCaptureMethod();
        result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
        ChargeCollection $charges = this.getCharges();
        result = result * 59 + ($charges == null ? 43 : ((Object)$charges).hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $confirmationMethod = this.getConfirmationMethod();
        result = result * 59 + ($confirmationMethod == null ? 43 : $confirmationMethod.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        PaymentIntentLastPaymentError $lastPaymentError = this.getLastPaymentError();
        result = result * 59 + ($lastPaymentError == null ? 43 : ((Object)$lastPaymentError).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        NextAction $nextAction = this.getNextAction();
        result = result * 59 + ($nextAction == null ? 43 : ((Object)$nextAction).hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        List<String> $paymentMethodTypes = this.getPaymentMethodTypes();
        result = result * 59 + ($paymentMethodTypes == null ? 43 : ((Object)$paymentMethodTypes).hashCode());
        String $receiptEmail = this.getReceiptEmail();
        result = result * 59 + ($receiptEmail == null ? 43 : $receiptEmail.hashCode());
        String $review = this.getReview();
        result = result * 59 + ($review == null ? 43 : $review.hashCode());
        ShippingDetails $shipping = this.getShipping();
        result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        TransferData $transferData = this.getTransferData();
        result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        List<String> $allowedSourceTypes = this.getAllowedSourceTypes();
        result = result * 59 + ($allowedSourceTypes == null ? 43 : ((Object)$allowedSourceTypes).hashCode());
        PaymentIntentSourceAction $nextSourceAction = this.getNextSourceAction();
        result = result * 59 + ($nextSourceAction == null ? 43 : ((Object)$nextSourceAction).hashCode());
        String $returnUrl = this.getReturnUrl();
        result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class NextActionRedirectToUrl
    extends StripeObject {
        String returnUrl;
        String url;

        @Generated
        public String getReturnUrl() {
            return this.returnUrl;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setReturnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextActionRedirectToUrl)) {
                return false;
            }
            NextActionRedirectToUrl other = (NextActionRedirectToUrl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$returnUrl = this.getReturnUrl();
            String other$returnUrl = other.getReturnUrl();
            if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NextActionRedirectToUrl;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $returnUrl = this.getReturnUrl();
            result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }
    }

    public static class NextAction
    extends StripeObject {
        NextActionRedirectToUrl redirectToUrl;
        String type;

        @Generated
        public NextActionRedirectToUrl getRedirectToUrl() {
            return this.redirectToUrl;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setRedirectToUrl(NextActionRedirectToUrl redirectToUrl) {
            this.redirectToUrl = redirectToUrl;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextAction)) {
                return false;
            }
            NextAction other = (NextAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            NextActionRedirectToUrl this$redirectToUrl = this.getRedirectToUrl();
            NextActionRedirectToUrl other$redirectToUrl = other.getRedirectToUrl();
            if (this$redirectToUrl == null ? other$redirectToUrl != null : !((Object)this$redirectToUrl).equals(other$redirectToUrl)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NextAction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            NextActionRedirectToUrl $redirectToUrl = this.getRedirectToUrl();
            result = result * 59 + ($redirectToUrl == null ? 43 : ((Object)$redirectToUrl).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }

    public static class TransferData
    extends StripeObject {
        ExpandableField<Account> destination;
        @Deprecated
        Long amount;

        public String getDestination() {
            return this.destination != null ? this.destination.getId() : null;
        }

        public void setDestination(String destinationId) {
            this.destination = ApiResource.setExpandableFieldId(destinationId, this.destination);
        }

        public Account getDestinationObject() {
            return this.destination != null ? this.destination.getExpanded() : null;
        }

        public void setDestinationObject(Account c) {
            this.destination = new ExpandableField<Account>(c.getId(), c);
        }

        @Deprecated
        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Deprecated
        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransferData)) {
                return false;
            }
            TransferData other = (TransferData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$destination = this.getDestination();
            String other$destination = other.getDestination();
            if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            return !(this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransferData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            return result;
        }
    }
}

