/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExternalAccount;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.Plan;
import com.stripe.model.StripeObject;
import com.stripe.model.SubscriptionCollection;
import com.stripe.model.SubscriptionItemCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.math.BigDecimal;
import java.util.Map;
import lombok.Generated;

public class Subscription
extends ApiResource
implements MetadataStore<Subscription>,
HasId {
    String id;
    String object;
    BigDecimal applicationFeePercent;
    String billing;
    Long billingCycleAnchor;
    BillingThresholds billingThresholds;
    Boolean cancelAtPeriodEnd;
    Long canceledAt;
    Long created;
    Long currentPeriodEnd;
    Long currentPeriodStart;
    ExpandableField<Customer> customer;
    Long daysUntilDue;
    ExpandableField<ExternalAccount> defaultSource;
    Discount discount;
    Long endedAt;
    SubscriptionItemCollection items;
    Boolean livemode;
    Map<String, String> metadata;
    Plan plan;
    Long quantity;
    Long start;
    String status;
    BigDecimal taxPercent;
    TransferData transferData;
    Long trialEnd;
    Long trialStart;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String customerId) {
        this.customer = Subscription.setExpandableFieldId(customerId, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer c) {
        this.customer = new ExpandableField<Customer>(c.getId(), c);
    }

    public String getDefaultSource() {
        return this.defaultSource != null ? this.defaultSource.getId() : null;
    }

    public void setDefaultSource(String defaultSourceId) {
        this.defaultSource = Subscription.setExpandableFieldId(defaultSourceId, this.defaultSource);
    }

    public ExternalAccount getDefaultSourceObject() {
        return this.defaultSource != null ? this.defaultSource.getExpanded() : null;
    }

    public void setDefaultSourceObject(ExternalAccount c) {
        this.defaultSource = new ExpandableField<ExternalAccount>(c.getId(), c);
    }

    public SubscriptionItemCollection getSubscriptionItems() {
        return this.items;
    }

    public void setSubscriptionItems(SubscriptionItemCollection items) {
        this.items = items;
    }

    public Subscription cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, null);
    }

    public Subscription cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Subscription.request(ApiResource.RequestMethod.DELETE, Subscription.instanceUrl(Subscription.class, this.id), params, Subscription.class, options);
    }

    public static Subscription create(Map<String, Object> params) throws StripeException {
        return Subscription.create(params, null);
    }

    public static Subscription create(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Subscription.request(ApiResource.RequestMethod.POST, Subscription.classUrl(Subscription.class), params, Subscription.class, options);
    }

    public void deleteDiscount() throws StripeException {
        this.deleteDiscount(null);
    }

    public void deleteDiscount(RequestOptions options) throws StripeException {
        Subscription.request(ApiResource.RequestMethod.DELETE, String.format("%s/discount", Subscription.instanceUrl(Subscription.class, this.id)), null, Discount.class, options);
    }

    public static SubscriptionCollection list(Map<String, Object> params) throws StripeException {
        return Subscription.list(params, null);
    }

    public static SubscriptionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Subscription.requestCollection(Subscription.classUrl(Subscription.class), params, SubscriptionCollection.class, options);
    }

    public static Subscription retrieve(String id) throws StripeException {
        return Subscription.retrieve(id, null);
    }

    public static Subscription retrieve(String id, RequestOptions options) throws StripeException {
        return Subscription.retrieve(id, null, options);
    }

    public static Subscription retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        return Subscription.request(ApiResource.RequestMethod.GET, Subscription.instanceUrl(Subscription.class, id), params, Subscription.class, options);
    }

    public Subscription update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Subscription update(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Subscription.request(ApiResource.RequestMethod.POST, Subscription.instanceUrl(Subscription.class, this.id), params, Subscription.class, options);
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public BigDecimal getApplicationFeePercent() {
        return this.applicationFeePercent;
    }

    @Generated
    public String getBilling() {
        return this.billing;
    }

    @Generated
    public Long getBillingCycleAnchor() {
        return this.billingCycleAnchor;
    }

    @Generated
    public BillingThresholds getBillingThresholds() {
        return this.billingThresholds;
    }

    @Generated
    public Boolean getCancelAtPeriodEnd() {
        return this.cancelAtPeriodEnd;
    }

    @Generated
    public Long getCanceledAt() {
        return this.canceledAt;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Long getCurrentPeriodEnd() {
        return this.currentPeriodEnd;
    }

    @Generated
    public Long getCurrentPeriodStart() {
        return this.currentPeriodStart;
    }

    @Generated
    public Long getDaysUntilDue() {
        return this.daysUntilDue;
    }

    @Generated
    public Discount getDiscount() {
        return this.discount;
    }

    @Generated
    public Long getEndedAt() {
        return this.endedAt;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Plan getPlan() {
        return this.plan;
    }

    @Generated
    public Long getQuantity() {
        return this.quantity;
    }

    @Generated
    public Long getStart() {
        return this.start;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public BigDecimal getTaxPercent() {
        return this.taxPercent;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    @Generated
    public Long getTrialEnd() {
        return this.trialEnd;
    }

    @Generated
    public Long getTrialStart() {
        return this.trialStart;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setApplicationFeePercent(BigDecimal applicationFeePercent) {
        this.applicationFeePercent = applicationFeePercent;
    }

    @Generated
    public void setBilling(String billing) {
        this.billing = billing;
    }

    @Generated
    public void setBillingCycleAnchor(Long billingCycleAnchor) {
        this.billingCycleAnchor = billingCycleAnchor;
    }

    @Generated
    public void setBillingThresholds(BillingThresholds billingThresholds) {
        this.billingThresholds = billingThresholds;
    }

    @Generated
    public void setCancelAtPeriodEnd(Boolean cancelAtPeriodEnd) {
        this.cancelAtPeriodEnd = cancelAtPeriodEnd;
    }

    @Generated
    public void setCanceledAt(Long canceledAt) {
        this.canceledAt = canceledAt;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrentPeriodEnd(Long currentPeriodEnd) {
        this.currentPeriodEnd = currentPeriodEnd;
    }

    @Generated
    public void setCurrentPeriodStart(Long currentPeriodStart) {
        this.currentPeriodStart = currentPeriodStart;
    }

    @Generated
    public void setDaysUntilDue(Long daysUntilDue) {
        this.daysUntilDue = daysUntilDue;
    }

    @Generated
    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    @Generated
    public void setEndedAt(Long endedAt) {
        this.endedAt = endedAt;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    @Generated
    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    @Generated
    public void setStart(Long start) {
        this.start = start;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTaxPercent(BigDecimal taxPercent) {
        this.taxPercent = taxPercent;
    }

    @Generated
    public void setTransferData(TransferData transferData) {
        this.transferData = transferData;
    }

    @Generated
    public void setTrialEnd(Long trialEnd) {
        this.trialEnd = trialEnd;
    }

    @Generated
    public void setTrialStart(Long trialStart) {
        this.trialStart = trialStart;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        BigDecimal this$applicationFeePercent = this.getApplicationFeePercent();
        BigDecimal other$applicationFeePercent = other.getApplicationFeePercent();
        if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !((Object)this$applicationFeePercent).equals(other$applicationFeePercent)) {
            return false;
        }
        String this$billing = this.getBilling();
        String other$billing = other.getBilling();
        if (this$billing == null ? other$billing != null : !this$billing.equals(other$billing)) {
            return false;
        }
        Long this$billingCycleAnchor = this.getBillingCycleAnchor();
        Long other$billingCycleAnchor = other.getBillingCycleAnchor();
        if (this$billingCycleAnchor == null ? other$billingCycleAnchor != null : !((Object)this$billingCycleAnchor).equals(other$billingCycleAnchor)) {
            return false;
        }
        BillingThresholds this$billingThresholds = this.getBillingThresholds();
        BillingThresholds other$billingThresholds = other.getBillingThresholds();
        if (this$billingThresholds == null ? other$billingThresholds != null : !((Object)this$billingThresholds).equals(other$billingThresholds)) {
            return false;
        }
        Boolean this$cancelAtPeriodEnd = this.getCancelAtPeriodEnd();
        Boolean other$cancelAtPeriodEnd = other.getCancelAtPeriodEnd();
        if (this$cancelAtPeriodEnd == null ? other$cancelAtPeriodEnd != null : !((Object)this$cancelAtPeriodEnd).equals(other$cancelAtPeriodEnd)) {
            return false;
        }
        Long this$canceledAt = this.getCanceledAt();
        Long other$canceledAt = other.getCanceledAt();
        if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$currentPeriodEnd = this.getCurrentPeriodEnd();
        Long other$currentPeriodEnd = other.getCurrentPeriodEnd();
        if (this$currentPeriodEnd == null ? other$currentPeriodEnd != null : !((Object)this$currentPeriodEnd).equals(other$currentPeriodEnd)) {
            return false;
        }
        Long this$currentPeriodStart = this.getCurrentPeriodStart();
        Long other$currentPeriodStart = other.getCurrentPeriodStart();
        if (this$currentPeriodStart == null ? other$currentPeriodStart != null : !((Object)this$currentPeriodStart).equals(other$currentPeriodStart)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        Long this$daysUntilDue = this.getDaysUntilDue();
        Long other$daysUntilDue = other.getDaysUntilDue();
        if (this$daysUntilDue == null ? other$daysUntilDue != null : !((Object)this$daysUntilDue).equals(other$daysUntilDue)) {
            return false;
        }
        String this$defaultSource = this.getDefaultSource();
        String other$defaultSource = other.getDefaultSource();
        if (this$defaultSource == null ? other$defaultSource != null : !this$defaultSource.equals(other$defaultSource)) {
            return false;
        }
        Discount this$discount = this.getDiscount();
        Discount other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        Long this$endedAt = this.getEndedAt();
        Long other$endedAt = other.getEndedAt();
        if (this$endedAt == null ? other$endedAt != null : !((Object)this$endedAt).equals(other$endedAt)) {
            return false;
        }
        SubscriptionItemCollection this$items = this.items;
        SubscriptionItemCollection other$items = other.items;
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Plan this$plan = this.getPlan();
        Plan other$plan = other.getPlan();
        if (this$plan == null ? other$plan != null : !((Object)this$plan).equals(other$plan)) {
            return false;
        }
        Long this$quantity = this.getQuantity();
        Long other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        Long this$start = this.getStart();
        Long other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        BigDecimal this$taxPercent = this.getTaxPercent();
        BigDecimal other$taxPercent = other.getTaxPercent();
        if (this$taxPercent == null ? other$taxPercent != null : !((Object)this$taxPercent).equals(other$taxPercent)) {
            return false;
        }
        TransferData this$transferData = this.getTransferData();
        TransferData other$transferData = other.getTransferData();
        if (this$transferData == null ? other$transferData != null : !this$transferData.equals(other$transferData)) {
            return false;
        }
        Long this$trialEnd = this.getTrialEnd();
        Long other$trialEnd = other.getTrialEnd();
        if (this$trialEnd == null ? other$trialEnd != null : !((Object)this$trialEnd).equals(other$trialEnd)) {
            return false;
        }
        Long this$trialStart = this.getTrialStart();
        Long other$trialStart = other.getTrialStart();
        return !(this$trialStart == null ? other$trialStart != null : !((Object)this$trialStart).equals(other$trialStart));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Subscription;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        BigDecimal $applicationFeePercent = this.getApplicationFeePercent();
        result = result * 59 + ($applicationFeePercent == null ? 43 : ((Object)$applicationFeePercent).hashCode());
        String $billing = this.getBilling();
        result = result * 59 + ($billing == null ? 43 : $billing.hashCode());
        Long $billingCycleAnchor = this.getBillingCycleAnchor();
        result = result * 59 + ($billingCycleAnchor == null ? 43 : ((Object)$billingCycleAnchor).hashCode());
        BillingThresholds $billingThresholds = this.getBillingThresholds();
        result = result * 59 + ($billingThresholds == null ? 43 : ((Object)$billingThresholds).hashCode());
        Boolean $cancelAtPeriodEnd = this.getCancelAtPeriodEnd();
        result = result * 59 + ($cancelAtPeriodEnd == null ? 43 : ((Object)$cancelAtPeriodEnd).hashCode());
        Long $canceledAt = this.getCanceledAt();
        result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $currentPeriodEnd = this.getCurrentPeriodEnd();
        result = result * 59 + ($currentPeriodEnd == null ? 43 : ((Object)$currentPeriodEnd).hashCode());
        Long $currentPeriodStart = this.getCurrentPeriodStart();
        result = result * 59 + ($currentPeriodStart == null ? 43 : ((Object)$currentPeriodStart).hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        Long $daysUntilDue = this.getDaysUntilDue();
        result = result * 59 + ($daysUntilDue == null ? 43 : ((Object)$daysUntilDue).hashCode());
        String $defaultSource = this.getDefaultSource();
        result = result * 59 + ($defaultSource == null ? 43 : $defaultSource.hashCode());
        Discount $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        Long $endedAt = this.getEndedAt();
        result = result * 59 + ($endedAt == null ? 43 : ((Object)$endedAt).hashCode());
        SubscriptionItemCollection $items = this.items;
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Plan $plan = this.getPlan();
        result = result * 59 + ($plan == null ? 43 : ((Object)$plan).hashCode());
        Long $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        Long $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        BigDecimal $taxPercent = this.getTaxPercent();
        result = result * 59 + ($taxPercent == null ? 43 : ((Object)$taxPercent).hashCode());
        TransferData $transferData = this.getTransferData();
        result = result * 59 + ($transferData == null ? 43 : $transferData.hashCode());
        Long $trialEnd = this.getTrialEnd();
        result = result * 59 + ($trialEnd == null ? 43 : ((Object)$trialEnd).hashCode());
        Long $trialStart = this.getTrialStart();
        result = result * 59 + ($trialStart == null ? 43 : ((Object)$trialStart).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class TransferData
    extends StripeObject {
        ExpandableField<Account> destination;

        public String getDestination() {
            return this.destination != null ? this.destination.getId() : null;
        }

        public void setDestination(String destinationId) {
            this.destination = ApiResource.setExpandableFieldId(destinationId, this.destination);
        }

        public Account getDestinationObject() {
            return this.destination != null ? this.destination.getExpanded() : null;
        }

        public void setDestinationObject(Account c) {
            this.destination = new ExpandableField<Account>(c.getId(), c);
        }
    }

    public static class BillingThresholds
    extends StripeObject {
        Long amountGte;
        Boolean resetBillingCycleAnchor;

        @Generated
        public Long getAmountGte() {
            return this.amountGte;
        }

        @Generated
        public Boolean getResetBillingCycleAnchor() {
            return this.resetBillingCycleAnchor;
        }

        @Generated
        public void setAmountGte(Long amountGte) {
            this.amountGte = amountGte;
        }

        @Generated
        public void setResetBillingCycleAnchor(Boolean resetBillingCycleAnchor) {
            this.resetBillingCycleAnchor = resetBillingCycleAnchor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BillingThresholds)) {
                return false;
            }
            BillingThresholds other = (BillingThresholds)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountGte = this.getAmountGte();
            Long other$amountGte = other.getAmountGte();
            if (this$amountGte == null ? other$amountGte != null : !((Object)this$amountGte).equals(other$amountGte)) {
                return false;
            }
            Boolean this$resetBillingCycleAnchor = this.getResetBillingCycleAnchor();
            Boolean other$resetBillingCycleAnchor = other.getResetBillingCycleAnchor();
            return !(this$resetBillingCycleAnchor == null ? other$resetBillingCycleAnchor != null : !((Object)this$resetBillingCycleAnchor).equals(other$resetBillingCycleAnchor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BillingThresholds;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountGte = this.getAmountGte();
            result = result * 59 + ($amountGte == null ? 43 : ((Object)$amountGte).hashCode());
            Boolean $resetBillingCycleAnchor = this.getResetBillingCycleAnchor();
            result = result * 59 + ($resetBillingCycleAnchor == null ? 43 : ((Object)$resetBillingCycleAnchor).hashCode());
            return result;
        }
    }
}

