// Generated by delombok at Fri Feb 22 14:40:51 PST 2019
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.math.BigDecimal;
import java.util.Map;

public class Coupon extends ApiResource implements MetadataStore<Coupon>, HasId {
  String id;
  String object;
  Long amountOff;
  Long created;
  String currency;
  Boolean deleted;
  String duration;
  Long durationInMonths;
  Boolean livemode;
  Long maxRedemptions;
  Map<String, String> metadata;
  String name;
  BigDecimal percentOff;
  Long redeemBy;
  Long timesRedeemed;
  Boolean valid;
  /**
   * The {@code percent_off_precise} attribute.
   *
   * @deprecated Prefer using the {@link #percentOff} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2018-07-27">API version 2018-07-27</a>
   */
  @Deprecated
  BigDecimal percentOffPrecise;

  // <editor-fold desc="create">
  /**
   * Create a coupon.
   */
  public static Coupon create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Create a coupon.
   */
  public static Coupon create(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, classUrl(Coupon.class), params, Coupon.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="delete">
  /**
   * Delete a coupon.
   */
  public Coupon delete() throws StripeException {
    return delete((RequestOptions) null);
  }

  /**
   * Delete a coupon.
   */
  public Coupon delete(RequestOptions options) throws StripeException {
    return request(RequestMethod.DELETE, instanceUrl(Coupon.class, this.id), null, Coupon.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="list">
  /**
   * List all coupons.
   */
  public static CouponCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all coupons.
   */
  public static CouponCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(Coupon.class), params, CouponCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve a coupon.
   */
  public static Coupon retrieve(String id) throws StripeException {
    return retrieve(id, (RequestOptions) null);
  }

  /**
   * Retrieve a coupon.
   */
  public static Coupon retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve a coupon.
   */
  public static Coupon retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(Coupon.class, id), params, Coupon.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="update">
  /**
   * Update a coupon.
   */
  @Override
  public Coupon update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Update a coupon.
   */
  @Override
  public Coupon update(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, instanceUrl(Coupon.class, this.id), params, Coupon.class, options);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountOff() {
    return this.amountOff;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDuration() {
    return this.duration;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getDurationInMonths() {
    return this.durationInMonths;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getMaxRedemptions() {
    return this.maxRedemptions;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getName() {
    return this.name;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPercentOff() {
    return this.percentOff;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getRedeemBy() {
    return this.redeemBy;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getTimesRedeemed() {
    return this.timesRedeemed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getValid() {
    return this.valid;
  }

  /**
   * The {@code percent_off_precise} attribute.
   *
   * @return the {@code percent_off_precise} attribute
   * @deprecated Prefer using the {@link #percentOff} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2018-07-27">API version 2018-07-27</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPercentOffPrecise() {
    return this.percentOffPrecise;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountOff(final Long amountOff) {
    this.amountOff = amountOff;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDuration(final String duration) {
    this.duration = duration;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDurationInMonths(final Long durationInMonths) {
    this.durationInMonths = durationInMonths;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMaxRedemptions(final Long maxRedemptions) {
    this.maxRedemptions = maxRedemptions;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setName(final String name) {
    this.name = name;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPercentOff(final BigDecimal percentOff) {
    this.percentOff = percentOff;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRedeemBy(final Long redeemBy) {
    this.redeemBy = redeemBy;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTimesRedeemed(final Long timesRedeemed) {
    this.timesRedeemed = timesRedeemed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setValid(final Boolean valid) {
    this.valid = valid;
  }

  /**
   * The {@code percent_off_precise} attribute.
   *
   * @deprecated Prefer using the {@link #percentOff} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2018-07-27">API version 2018-07-27</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPercentOffPrecise(final BigDecimal percentOffPrecise) {
    this.percentOffPrecise = percentOffPrecise;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Coupon)) return false;
    final Coupon other = (Coupon) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$amountOff = this.getAmountOff();
    final java.lang.Object other$amountOff = other.getAmountOff();
    if (this$amountOff == null ? other$amountOff != null : !this$amountOff.equals(other$amountOff)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$duration = this.getDuration();
    final java.lang.Object other$duration = other.getDuration();
    if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) return false;
    final java.lang.Object this$durationInMonths = this.getDurationInMonths();
    final java.lang.Object other$durationInMonths = other.getDurationInMonths();
    if (this$durationInMonths == null ? other$durationInMonths != null : !this$durationInMonths.equals(other$durationInMonths)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$maxRedemptions = this.getMaxRedemptions();
    final java.lang.Object other$maxRedemptions = other.getMaxRedemptions();
    if (this$maxRedemptions == null ? other$maxRedemptions != null : !this$maxRedemptions.equals(other$maxRedemptions)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$name = this.getName();
    final java.lang.Object other$name = other.getName();
    if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
    final java.lang.Object this$percentOff = this.getPercentOff();
    final java.lang.Object other$percentOff = other.getPercentOff();
    if (this$percentOff == null ? other$percentOff != null : !this$percentOff.equals(other$percentOff)) return false;
    final java.lang.Object this$redeemBy = this.getRedeemBy();
    final java.lang.Object other$redeemBy = other.getRedeemBy();
    if (this$redeemBy == null ? other$redeemBy != null : !this$redeemBy.equals(other$redeemBy)) return false;
    final java.lang.Object this$timesRedeemed = this.getTimesRedeemed();
    final java.lang.Object other$timesRedeemed = other.getTimesRedeemed();
    if (this$timesRedeemed == null ? other$timesRedeemed != null : !this$timesRedeemed.equals(other$timesRedeemed)) return false;
    final java.lang.Object this$valid = this.getValid();
    final java.lang.Object other$valid = other.getValid();
    if (this$valid == null ? other$valid != null : !this$valid.equals(other$valid)) return false;
    final java.lang.Object this$percentOffPrecise = this.getPercentOffPrecise();
    final java.lang.Object other$percentOffPrecise = other.getPercentOffPrecise();
    if (this$percentOffPrecise == null ? other$percentOffPrecise != null : !this$percentOffPrecise.equals(other$percentOffPrecise)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Coupon;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $amountOff = this.getAmountOff();
    result = result * PRIME + ($amountOff == null ? 43 : $amountOff.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $duration = this.getDuration();
    result = result * PRIME + ($duration == null ? 43 : $duration.hashCode());
    final java.lang.Object $durationInMonths = this.getDurationInMonths();
    result = result * PRIME + ($durationInMonths == null ? 43 : $durationInMonths.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $maxRedemptions = this.getMaxRedemptions();
    result = result * PRIME + ($maxRedemptions == null ? 43 : $maxRedemptions.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $name = this.getName();
    result = result * PRIME + ($name == null ? 43 : $name.hashCode());
    final java.lang.Object $percentOff = this.getPercentOff();
    result = result * PRIME + ($percentOff == null ? 43 : $percentOff.hashCode());
    final java.lang.Object $redeemBy = this.getRedeemBy();
    result = result * PRIME + ($redeemBy == null ? 43 : $redeemBy.hashCode());
    final java.lang.Object $timesRedeemed = this.getTimesRedeemed();
    result = result * PRIME + ($timesRedeemed == null ? 43 : $timesRedeemed.hashCode());
    final java.lang.Object $valid = this.getValid();
    result = result * PRIME + ($valid == null ? 43 : $valid.hashCode());
    final java.lang.Object $percentOffPrecise = this.getPercentOffPrecise();
    result = result * PRIME + ($percentOffPrecise == null ? 43 : $percentOffPrecise.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
  // </editor-fold>
}
