// Generated by delombok at Wed Mar 06 18:34:36 PST 2019
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class ApplicationFee extends ApiResource implements HasId {
  String id;
  String object;
  ExpandableField<Account> account;
  Long amount;
  Long amountRefunded;
  ExpandableField<Application> application;
  ExpandableField<BalanceTransaction> balanceTransaction;
  ExpandableField<Charge> charge;
  Long created;
  String currency;
  Boolean livemode;
  ExpandableField<Charge> originatingTransaction;
  Boolean refunded;
  FeeRefundCollection refunds;
  /**
   * The {@code user} attribute.
   *
   * @deprecated Prefer using the {@link #account} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2013-12-03">API version 2013-12-03</a>
   */
  @Deprecated
  String user;

  // <editor-fold desc="account">
  public String getAccount() {
    return (this.account != null) ? this.account.getId() : null;
  }

  public void setAccount(String accountId) {
    this.account = setExpandableFieldId(accountId, this.account);
  }

  public Account getAccountObject() {
    return (this.account != null) ? this.account.getExpanded() : null;
  }

  public void setAccountObject(Account c) {
    this.account = new ExpandableField<Account>(c.getId(), c);
  }

  // </editor-fold>
  // <editor-fold desc="application">
  public String getApplication() {
    return (this.application != null) ? this.application.getId() : null;
  }

  public void setApplication(String applicationId) {
    this.application = setExpandableFieldId(applicationId, this.application);
  }

  public Application getApplicationObject() {
    return (this.application != null) ? this.application.getExpanded() : null;
  }

  public void setApplicationObject(Application c) {
    this.application = new ExpandableField<Application>(c.getId(), c);
  }

  // </editor-fold>
  // <editor-fold desc="balanceTransaction">
  public String getBalanceTransaction() {
    return (this.balanceTransaction != null) ? this.balanceTransaction.getId() : null;
  }

  public void setBalanceTransaction(String balanceTransactionId) {
    this.balanceTransaction = setExpandableFieldId(balanceTransactionId, this.balanceTransaction);
  }

  public BalanceTransaction getBalanceTransactionObject() {
    return (this.balanceTransaction != null) ? this.balanceTransaction.getExpanded() : null;
  }

  public void setBalanceTransactionObject(BalanceTransaction c) {
    this.balanceTransaction = new ExpandableField<BalanceTransaction>(c.getId(), c);
  }

  // </editor-fold>
  // <editor-fold desc="charge">
  public String getCharge() {
    return (this.charge != null) ? this.charge.getId() : null;
  }

  public void setCharge(String chargeId) {
    this.charge = setExpandableFieldId(chargeId, this.charge);
  }

  public Charge getChargeObject() {
    return (this.charge != null) ? this.charge.getExpanded() : null;
  }

  public void setChargeObject(Charge c) {
    this.charge = new ExpandableField<Charge>(c.getId(), c);
  }

  // </editor-fold>
  // <editor-fold desc="originatingTransaction">
  public String getOriginatingTransaction() {
    return (this.originatingTransaction != null) ? this.originatingTransaction.getId() : null;
  }

  public void setOriginatingTransaction(String originatingTransactionId) {
    this.originatingTransaction = setExpandableFieldId(originatingTransactionId, this.originatingTransaction);
  }

  public Charge getOriginatingTransactionObject() {
    return (this.originatingTransaction != null) ? this.originatingTransaction.getExpanded() : null;
  }

  public void setOriginatingTransactionObject(Charge c) {
    this.originatingTransaction = new ExpandableField<Charge>(c.getId(), c);
  }

  // </editor-fold>
  /**
   * Returns the {@code refunds} list.
   *
   * @return the {@code refunds} list
   */
  public FeeRefundCollection getRefunds() {
    // API versions 2014-07-26 and earlier render charge refunds as an array
    // instead of an object, meaning there is no sublist URL.
    if (refunds.getUrl() == null) {
      refunds.setUrl(String.format("/v1/application_fees/%s/refunds", getId()));
    }
    return refunds;
  }

  // <editor-fold desc="list">
  /**
   * List all application fees.
   */
  public static ApplicationFeeCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all application fees.
   */
  public static ApplicationFeeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(ApplicationFee.class), params, ApplicationFeeCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve an application fee.
   */
  public static ApplicationFee retrieve(String id) throws StripeException {
    return retrieve(id, (RequestOptions) null);
  }

  /**
   * Retrieve an application fee.
   */
  public static ApplicationFee retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve an application fee.
   */
  public static ApplicationFee retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(ApplicationFee.class, id), params, ApplicationFee.class, options);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountRefunded() {
    return this.amountRefunded;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getRefunded() {
    return this.refunded;
  }

  /**
   * The {@code user} attribute.
   *
   * @return the {@code user} attribute
   * @deprecated Prefer using the {@link #account} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2013-12-03">API version 2013-12-03</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getUser() {
    return this.user;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountRefunded(final Long amountRefunded) {
    this.amountRefunded = amountRefunded;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRefunded(final Boolean refunded) {
    this.refunded = refunded;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRefunds(final FeeRefundCollection refunds) {
    this.refunds = refunds;
  }

  /**
   * The {@code user} attribute.
   *
   * @deprecated Prefer using the {@link #account} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2013-12-03">API version 2013-12-03</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUser(final String user) {
    this.user = user;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ApplicationFee)) return false;
    final ApplicationFee other = (ApplicationFee) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$account = this.getAccount();
    final java.lang.Object other$account = other.getAccount();
    if (this$account == null ? other$account != null : !this$account.equals(other$account)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$amountRefunded = this.getAmountRefunded();
    final java.lang.Object other$amountRefunded = other.getAmountRefunded();
    if (this$amountRefunded == null ? other$amountRefunded != null : !this$amountRefunded.equals(other$amountRefunded)) return false;
    final java.lang.Object this$application = this.getApplication();
    final java.lang.Object other$application = other.getApplication();
    if (this$application == null ? other$application != null : !this$application.equals(other$application)) return false;
    final java.lang.Object this$balanceTransaction = this.getBalanceTransaction();
    final java.lang.Object other$balanceTransaction = other.getBalanceTransaction();
    if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) return false;
    final java.lang.Object this$charge = this.getCharge();
    final java.lang.Object other$charge = other.getCharge();
    if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$originatingTransaction = this.getOriginatingTransaction();
    final java.lang.Object other$originatingTransaction = other.getOriginatingTransaction();
    if (this$originatingTransaction == null ? other$originatingTransaction != null : !this$originatingTransaction.equals(other$originatingTransaction)) return false;
    final java.lang.Object this$refunded = this.getRefunded();
    final java.lang.Object other$refunded = other.getRefunded();
    if (this$refunded == null ? other$refunded != null : !this$refunded.equals(other$refunded)) return false;
    final java.lang.Object this$refunds = this.getRefunds();
    final java.lang.Object other$refunds = other.getRefunds();
    if (this$refunds == null ? other$refunds != null : !this$refunds.equals(other$refunds)) return false;
    final java.lang.Object this$user = this.getUser();
    final java.lang.Object other$user = other.getUser();
    if (this$user == null ? other$user != null : !this$user.equals(other$user)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ApplicationFee;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $account = this.getAccount();
    result = result * PRIME + ($account == null ? 43 : $account.hashCode());
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $amountRefunded = this.getAmountRefunded();
    result = result * PRIME + ($amountRefunded == null ? 43 : $amountRefunded.hashCode());
    final java.lang.Object $application = this.getApplication();
    result = result * PRIME + ($application == null ? 43 : $application.hashCode());
    final java.lang.Object $balanceTransaction = this.getBalanceTransaction();
    result = result * PRIME + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
    final java.lang.Object $charge = this.getCharge();
    result = result * PRIME + ($charge == null ? 43 : $charge.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $originatingTransaction = this.getOriginatingTransaction();
    result = result * PRIME + ($originatingTransaction == null ? 43 : $originatingTransaction.hashCode());
    final java.lang.Object $refunded = this.getRefunded();
    result = result * PRIME + ($refunded == null ? 43 : $refunded.hashCode());
    final java.lang.Object $refunds = this.getRefunds();
    result = result * PRIME + ($refunds == null ? 43 : $refunds.hashCode());
    final java.lang.Object $user = this.getUser();
    result = result * PRIME + ($user == null ? 43 : $user.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
  // </editor-fold>
}
