// Generated by delombok at Wed Mar 06 18:34:36 PST 2019
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class BalanceTransaction extends ApiResource implements HasId {
  String id;
  String object;
  Long amount;
  Long availableOn;
  Long created;
  String currency;
  String description;
  BigDecimal exchangeRate;
  Long fee;
  List<Fee> feeDetails;
  Long net;
  ExpandableField<HasId> source;
  String status;
  String type;
  /**
   * The {@code sourced_transfers} attribute.
   *
   * @deprecated Prefer using the {@link Transfer#list} method with the {@code transfer_group}
   *     parameter.
   * @see <a href="https://stripe.com/docs/upgrades#2017-01-27">API version 2017-01-27</a>
   */
  @Deprecated
  TransferCollection sourcedTransfers;

  // <editor-fold desc="source">
  public String getSource() {
    return (this.source != null) ? this.source.getId() : null;
  }

  public void setSource(String sourceId) {
    this.source = setExpandableFieldId(sourceId, this.source);
  }

  public HasId getSourceObject() {
    return (this.source != null) ? this.source.getExpanded() : null;
  }

  public void setSourceObject(HasId o) {
    this.source = new ExpandableField<HasId>(o.getId(), o);
  }

  @SuppressWarnings("unchecked")
  public <O extends HasId> O getSourceObjectAs() {
    return (this.source != null) ? (O) this.source.getExpanded() : null;
  }

  // </editor-fold>
  // <editor-fold desc="list">
  /**
   * List all balance history.
   */
  public static BalanceTransactionCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all balance history.
   */
  public static BalanceTransactionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s/%s", Stripe.getApiBase(), "v1/balance/history");
    return requestCollection(url, params, BalanceTransactionCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve a balance transaction.
   */
  public static BalanceTransaction retrieve(String id) throws StripeException {
    return retrieve(id, (RequestOptions) null);
  }

  /**
   * Retrieve a balance transaction.
   */
  public static BalanceTransaction retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve a balance transaction.
   */
  public static BalanceTransaction retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s/%s/%s", Stripe.getApiBase(), "v1/balance/history", id);
    return request(RequestMethod.GET, url, params, BalanceTransaction.class, options);
  }

  // </editor-fold>
  public static class Fee extends ApiResource {
    Long amount;
    String application;
    String currency;
    String description;
    String type;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApplication() {
      return this.application;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCurrency() {
      return this.currency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
      return this.description;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setApplication(final String application) {
      this.application = application;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrency(final String currency) {
      this.currency = currency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDescription(final String description) {
      this.description = description;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof BalanceTransaction.Fee)) return false;
      final BalanceTransaction.Fee other = (BalanceTransaction.Fee) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$application = this.getApplication();
      final java.lang.Object other$application = other.getApplication();
      if (this$application == null ? other$application != null : !this$application.equals(other$application)) return false;
      final java.lang.Object this$currency = this.getCurrency();
      final java.lang.Object other$currency = other.getCurrency();
      if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
      final java.lang.Object this$description = this.getDescription();
      final java.lang.Object other$description = other.getDescription();
      if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof BalanceTransaction.Fee;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $application = this.getApplication();
      result = result * PRIME + ($application == null ? 43 : $application.hashCode());
      final java.lang.Object $currency = this.getCurrency();
      result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
      final java.lang.Object $description = this.getDescription();
      result = result * PRIME + ($description == null ? 43 : $description.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAvailableOn() {
    return this.availableOn;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getExchangeRate() {
    return this.exchangeRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getFee() {
    return this.fee;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<Fee> getFeeDetails() {
    return this.feeDetails;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getNet() {
    return this.net;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * The {@code sourced_transfers} attribute.
   *
   * @deprecated Prefer using the {@link Transfer#list} method with the {@code transfer_group}
   *     parameter.
   * @see <a href="https://stripe.com/docs/upgrades#2017-01-27">API version 2017-01-27</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TransferCollection getSourcedTransfers() {
    return this.sourcedTransfers;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAvailableOn(final Long availableOn) {
    this.availableOn = availableOn;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExchangeRate(final BigDecimal exchangeRate) {
    this.exchangeRate = exchangeRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFee(final Long fee) {
    this.fee = fee;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFeeDetails(final List<Fee> feeDetails) {
    this.feeDetails = feeDetails;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNet(final Long net) {
    this.net = net;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  /**
   * The {@code sourced_transfers} attribute.
   *
   * @deprecated Prefer using the {@link Transfer#list} method with the {@code transfer_group}
   *     parameter.
   * @see <a href="https://stripe.com/docs/upgrades#2017-01-27">API version 2017-01-27</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSourcedTransfers(final TransferCollection sourcedTransfers) {
    this.sourcedTransfers = sourcedTransfers;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof BalanceTransaction)) return false;
    final BalanceTransaction other = (BalanceTransaction) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$availableOn = this.getAvailableOn();
    final java.lang.Object other$availableOn = other.getAvailableOn();
    if (this$availableOn == null ? other$availableOn != null : !this$availableOn.equals(other$availableOn)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$exchangeRate = this.getExchangeRate();
    final java.lang.Object other$exchangeRate = other.getExchangeRate();
    if (this$exchangeRate == null ? other$exchangeRate != null : !this$exchangeRate.equals(other$exchangeRate)) return false;
    final java.lang.Object this$fee = this.getFee();
    final java.lang.Object other$fee = other.getFee();
    if (this$fee == null ? other$fee != null : !this$fee.equals(other$fee)) return false;
    final java.lang.Object this$feeDetails = this.getFeeDetails();
    final java.lang.Object other$feeDetails = other.getFeeDetails();
    if (this$feeDetails == null ? other$feeDetails != null : !this$feeDetails.equals(other$feeDetails)) return false;
    final java.lang.Object this$net = this.getNet();
    final java.lang.Object other$net = other.getNet();
    if (this$net == null ? other$net != null : !this$net.equals(other$net)) return false;
    final java.lang.Object this$source = this.getSource();
    final java.lang.Object other$source = other.getSource();
    if (this$source == null ? other$source != null : !this$source.equals(other$source)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    final java.lang.Object this$sourcedTransfers = this.getSourcedTransfers();
    final java.lang.Object other$sourcedTransfers = other.getSourcedTransfers();
    if (this$sourcedTransfers == null ? other$sourcedTransfers != null : !this$sourcedTransfers.equals(other$sourcedTransfers)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof BalanceTransaction;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $availableOn = this.getAvailableOn();
    result = result * PRIME + ($availableOn == null ? 43 : $availableOn.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $exchangeRate = this.getExchangeRate();
    result = result * PRIME + ($exchangeRate == null ? 43 : $exchangeRate.hashCode());
    final java.lang.Object $fee = this.getFee();
    result = result * PRIME + ($fee == null ? 43 : $fee.hashCode());
    final java.lang.Object $feeDetails = this.getFeeDetails();
    result = result * PRIME + ($feeDetails == null ? 43 : $feeDetails.hashCode());
    final java.lang.Object $net = this.getNet();
    result = result * PRIME + ($net == null ? 43 : $net.hashCode());
    final java.lang.Object $source = this.getSource();
    result = result * PRIME + ($source == null ? 43 : $source.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    final java.lang.Object $sourcedTransfers = this.getSourcedTransfers();
    result = result * PRIME + ($sourcedTransfers == null ? 43 : $sourcedTransfers.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
