// Generated by delombok at Wed Mar 06 18:34:36 PST 2019
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class Recipient extends ApiResource implements MetadataStore<Recipient>, HasId {
  String id;
  String object;
  BankAccount activeAccount;
  RecipientCardCollection cards;
  Long created;
  ExpandableField<Card> defaultCard;
  Boolean deleted;
  String description;
  String email;
  Boolean livemode;
  Map<String, String> metadata;
  ExpandableField<Account> migratedTo;
  String name;
  String type;
  Boolean verified;

  // <editor-fold desc="defaultCard">
  public String getDefaultCard() {
    return (this.defaultCard != null) ? this.defaultCard.getId() : null;
  }

  public void setDefaultCard(String defaultCardId) {
    this.defaultCard = ApiResource.setExpandableFieldId(defaultCardId, this.defaultCard);
  }

  public Card getDefaultCardObject() {
    return (this.defaultCard != null) ? this.defaultCard.getExpanded() : null;
  }

  public void setDefaultCardObject(Card c) {
    this.defaultCard = new ExpandableField<>(c.getId(), c);
  }

  // </editor-fold>
  // <editor-fold desc="migratedTo">
  public String getMigratedTo() {
    return (this.migratedTo != null) ? this.migratedTo.getId() : null;
  }

  public void setMigratedTo(String migratedToId) {
    this.migratedTo = ApiResource.setExpandableFieldId(migratedToId, this.migratedTo);
  }

  public Account getMigratedToObject() {
    return (this.migratedTo != null) ? this.migratedTo.getExpanded() : null;
  }

  public void setMigratedToObject(Account c) {
    this.migratedTo = new ExpandableField<>(c.getId(), c);
  }

  // </editor-fold>
  // <editor-fold desc="create">
  /**
   * Create a recipient.
   */
  public static Recipient create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Create a recipient.
   */
  public static Recipient create(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, classUrl(Recipient.class), params, Recipient.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="delete">
  /**
   * Delete a recipient.
   */
  public Recipient delete() throws StripeException {
    return delete((RequestOptions) null);
  }

  /**
   * Delete a recipient.
   */
  public Recipient delete(RequestOptions options) throws StripeException {
    return request(RequestMethod.DELETE, instanceUrl(Recipient.class, this.id), null, Recipient.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="list">
  /**
   * List all recipients.
   */
  public static RecipientCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all recipients.
   */
  public static RecipientCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(Recipient.class), params, RecipientCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve a recipient.
   */
  public static Recipient retrieve(String id) throws StripeException {
    return retrieve(id, (RequestOptions) null);
  }

  /**
   * Retrieve a recipient.
   */
  public static Recipient retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve a recipient.
   */
  public static Recipient retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(Recipient.class, id), params, Recipient.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="update">
  /**
   * Update a recipient.
   */
  @Override
  public Recipient update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Update a recipient.
   */
  @Override
  public Recipient update(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, instanceUrl(Recipient.class, this.id), params, Recipient.class, options);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BankAccount getActiveAccount() {
    return this.activeAccount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public RecipientCardCollection getCards() {
    return this.cards;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEmail() {
    return this.email;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getName() {
    return this.name;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getVerified() {
    return this.verified;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setActiveAccount(final BankAccount activeAccount) {
    this.activeAccount = activeAccount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCards(final RecipientCardCollection cards) {
    this.cards = cards;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEmail(final String email) {
    this.email = email;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setName(final String name) {
    this.name = name;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVerified(final Boolean verified) {
    this.verified = verified;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Recipient)) return false;
    final Recipient other = (Recipient) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$activeAccount = this.getActiveAccount();
    final java.lang.Object other$activeAccount = other.getActiveAccount();
    if (this$activeAccount == null ? other$activeAccount != null : !this$activeAccount.equals(other$activeAccount)) return false;
    final java.lang.Object this$cards = this.getCards();
    final java.lang.Object other$cards = other.getCards();
    if (this$cards == null ? other$cards != null : !this$cards.equals(other$cards)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$defaultCard = this.getDefaultCard();
    final java.lang.Object other$defaultCard = other.getDefaultCard();
    if (this$defaultCard == null ? other$defaultCard != null : !this$defaultCard.equals(other$defaultCard)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$email = this.getEmail();
    final java.lang.Object other$email = other.getEmail();
    if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$migratedTo = this.getMigratedTo();
    final java.lang.Object other$migratedTo = other.getMigratedTo();
    if (this$migratedTo == null ? other$migratedTo != null : !this$migratedTo.equals(other$migratedTo)) return false;
    final java.lang.Object this$name = this.getName();
    final java.lang.Object other$name = other.getName();
    if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    final java.lang.Object this$verified = this.getVerified();
    final java.lang.Object other$verified = other.getVerified();
    if (this$verified == null ? other$verified != null : !this$verified.equals(other$verified)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Recipient;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $activeAccount = this.getActiveAccount();
    result = result * PRIME + ($activeAccount == null ? 43 : $activeAccount.hashCode());
    final java.lang.Object $cards = this.getCards();
    result = result * PRIME + ($cards == null ? 43 : $cards.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $defaultCard = this.getDefaultCard();
    result = result * PRIME + ($defaultCard == null ? 43 : $defaultCard.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $email = this.getEmail();
    result = result * PRIME + ($email == null ? 43 : $email.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $migratedTo = this.getMigratedTo();
    result = result * PRIME + ($migratedTo == null ? 43 : $migratedTo.hashCode());
    final java.lang.Object $name = this.getName();
    result = result * PRIME + ($name == null ? 43 : $name.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    final java.lang.Object $verified = this.getVerified();
    result = result * PRIME + ($verified == null ? 43 : $verified.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
  // </editor-fold>
}
