// Generated by delombok at Wed Mar 06 18:34:36 PST 2019
package com.stripe.model.issuing;

import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class Cardholder extends ApiResource implements MetadataStore<Cardholder>, HasId {
  String id;
  String object;
  Billing billing;
  Long created;
  String email;
  Boolean livemode;
  Map<String, String> metadata;
  String name;
  String phoneNumber;
  String status;
  String type;

  // <editor-fold desc="create">
  /**
   * Create an issuing cardholder.
   */
  public static Cardholder create(Map<String, Object> params) throws StripeException {
    return create(params, null);
  }

  /**
   * Create an issuing cardholder.
   */
  public static Cardholder create(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, classUrl(Cardholder.class), params, Cardholder.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="list">
  /**
   * List all issuing cardholders.
   */
  public static CardholderCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all issuing cardholders.
   */
  public static CardholderCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(Cardholder.class), params, CardholderCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve an issuing cardholder.
   */
  public static Cardholder retrieve(String id) throws StripeException {
    return retrieve(id, null);
  }

  /**
   * Retrieve an issuing cardholder.
   */
  public static Cardholder retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve an issuing cardholder.
   */
  public static Cardholder retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(Cardholder.class, id), params, Cardholder.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="update">
  /**
   * Update an issuing cardholder.
   */
  @Override
  public Cardholder update(Map<String, Object> params) throws StripeException {
    return update(params, null);
  }

  /**
   * Update an issuing cardholder.
   */
  @Override
  public Cardholder update(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, instanceUrl(Cardholder.class, this.id), params, Cardholder.class, options);
  }

  // </editor-fold>
  public final class Billing extends StripeObject {
    Address address;
    String name;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Address getAddress() {
      return this.address;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
      return this.name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddress(final Address address) {
      this.address = address;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
      this.name = name;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Cardholder.Billing)) return false;
      final Cardholder.Billing other = (Cardholder.Billing) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$address = this.getAddress();
      final java.lang.Object other$address = other.getAddress();
      if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
      final java.lang.Object this$name = this.getName();
      final java.lang.Object other$name = other.getName();
      if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Cardholder.Billing;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $address = this.getAddress();
      result = result * PRIME + ($address == null ? 43 : $address.hashCode());
      final java.lang.Object $name = this.getName();
      result = result * PRIME + ($name == null ? 43 : $name.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Billing getBilling() {
    return this.billing;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEmail() {
    return this.email;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getName() {
    return this.name;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPhoneNumber() {
    return this.phoneNumber;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBilling(final Billing billing) {
    this.billing = billing;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEmail(final String email) {
    this.email = email;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setName(final String name) {
    this.name = name;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPhoneNumber(final String phoneNumber) {
    this.phoneNumber = phoneNumber;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Cardholder)) return false;
    final Cardholder other = (Cardholder) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$billing = this.getBilling();
    final java.lang.Object other$billing = other.getBilling();
    if (this$billing == null ? other$billing != null : !this$billing.equals(other$billing)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$email = this.getEmail();
    final java.lang.Object other$email = other.getEmail();
    if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$name = this.getName();
    final java.lang.Object other$name = other.getName();
    if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
    final java.lang.Object this$phoneNumber = this.getPhoneNumber();
    final java.lang.Object other$phoneNumber = other.getPhoneNumber();
    if (this$phoneNumber == null ? other$phoneNumber != null : !this$phoneNumber.equals(other$phoneNumber)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Cardholder;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $billing = this.getBilling();
    result = result * PRIME + ($billing == null ? 43 : $billing.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $email = this.getEmail();
    result = result * PRIME + ($email == null ? 43 : $email.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $name = this.getName();
    result = result * PRIME + ($name == null ? 43 : $name.hashCode());
    final java.lang.Object $phoneNumber = this.getPhoneNumber();
    result = result * PRIME + ($phoneNumber == null ? 43 : $phoneNumber.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
