/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExpandableFieldDeserializer;
import com.stripe.model.File;
import com.stripe.model.Person;
import java.lang.reflect.Type;

public class PersonVerificationDeserializer
implements JsonDeserializer<Person.Verification> {
    public Person.Verification deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(ExpandableField.class, (Object)new ExpandableFieldDeserializer()).create();
        if (json.isJsonNull()) {
            return null;
        }
        if (!json.isJsonObject()) {
            throw new JsonParseException("Person.Verification type was not an object, which is problematic.");
        }
        JsonObject verificationAsJsonObject = json.getAsJsonObject();
        JsonElement rawDocument = verificationAsJsonObject.get("document");
        String documentString = null;
        File documentFile = null;
        Person.VerificationDocument documentSubObject = null;
        if (rawDocument.isJsonPrimitive()) {
            JsonPrimitive documentJsonPrimitive = rawDocument.getAsJsonPrimitive();
            if (!documentJsonPrimitive.isString()) {
                throw new JsonParseException("document field on a Person.Verification was a primitive non-string type.");
            }
            documentString = documentJsonPrimitive.getAsString();
        } else if (rawDocument.isJsonObject()) {
            JsonObject documentJsonObject = rawDocument.getAsJsonObject();
            if (documentJsonObject.has("object")) {
                documentFile = (File)gson.fromJson((JsonElement)documentJsonObject, File.class);
            } else {
                documentSubObject = (Person.VerificationDocument)gson.fromJson((JsonElement)documentJsonObject, Person.VerificationDocument.class);
            }
        } else if (!rawDocument.isJsonNull()) {
            throw new JsonParseException("document field on a Person.Verification was a non-primitive, non-object type.");
        }
        verificationAsJsonObject.remove("document");
        Person.Verification parsedData = (Person.Verification)gson.fromJson(json, typeOfT);
        if (documentFile != null) {
            PersonVerificationDeserializer.setDocumentFile(parsedData, documentFile);
        } else {
            PersonVerificationDeserializer.setDocumentString(parsedData, documentString);
        }
        parsedData.setDocumentSubObject(documentSubObject);
        return parsedData;
    }

    private static void setDocumentString(Person.Verification verification, String documentString) {
        verification.setDocument(documentString);
    }

    private static void setDocumentFile(Person.Verification verification, File documentFile) {
        verification.setDocumentObject(documentFile);
    }
}

