/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Random;

public class MultipartProcessor {
    private final String boundary;
    private static final String LINE_BREAK = "\r\n";
    private OutputStream outputStream;
    private PrintWriter writer;

    public static String getBoundary() {
        Random random = new Random();
        Long positiveRandomLong = Math.abs(random.nextLong());
        return String.valueOf(positiveRandomLong);
    }

    public MultipartProcessor(HttpURLConnection conn, String boundary, String charset) throws IOException {
        this.boundary = boundary;
        this.outputStream = conn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, charset), true);
    }

    public void addFormField(String name, String value) {
        this.writer.append("--" + this.boundary).append(LINE_BREAK);
        this.writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(LINE_BREAK);
        this.writer.append(LINE_BREAK);
        this.writer.append(value).append(LINE_BREAK);
        this.writer.flush();
    }

    public void addFileField(String name, String fileName, InputStream inputStream) throws IOException {
        this.writer.append("--").append(this.boundary).append(LINE_BREAK);
        this.writer.append("Content-Disposition: form-data; name=\"").append(name).append("\"; filename=\"").append(fileName).append("\"").append(LINE_BREAK);
        String probableContentType = URLConnection.guessContentTypeFromName(fileName);
        this.writer.append("Content-Type: ").append(probableContentType).append(LINE_BREAK);
        this.writer.append("Content-Transfer-Encoding: binary").append(LINE_BREAK);
        this.writer.append(LINE_BREAK);
        this.writer.flush();
        this.streamToOutput(inputStream);
        this.writer.append(LINE_BREAK);
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamToOutput(InputStream inputStream) throws IOException {
        try {
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                this.outputStream.write(buffer, 0, bytesRead);
            }
            this.outputStream.flush();
        }
        finally {
            inputStream.close();
        }
    }

    public void finish() throws IOException {
        this.writer.append("--" + this.boundary + "--").append(LINE_BREAK);
        this.writer.flush();
        this.writer.close();
        this.outputStream.flush();
        this.outputStream.close();
    }
}

