/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.model.AccountCollection;
import com.stripe.model.Address;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExternalAccountCollection;
import com.stripe.model.File;
import com.stripe.model.HasId;
import com.stripe.model.LegalEntity;
import com.stripe.model.LoginLinkCollection;
import com.stripe.model.MetadataStore;
import com.stripe.model.Person;
import com.stripe.model.PersonCollection;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Account
extends ApiResource
implements HasId,
MetadataStore<Account> {
    String id;
    String object;
    BusinessProfile businessProfile;
    String businessType;
    Capabilities capabilities;
    Boolean chargesEnabled;
    Company company;
    String country;
    Long created;
    String defaultCurrency;
    Boolean deleted;
    Boolean detailsSubmitted;
    String email;
    ExternalAccountCollection externalAccounts;
    Person individual;
    LoginLinkCollection loginLinks;
    Map<String, String> metadata;
    Boolean payoutsEnabled;
    Requirements requirements;
    Settings settings;
    TosAcceptance tosAcceptance;
    String type;
    @Deprecated
    String businessLogoLarge;
    @Deprecated
    String businessLogo;
    @Deprecated
    String businessName;
    @Deprecated
    String businessPrimaryColor;
    @Deprecated
    String businessUrl;
    @Deprecated
    List<String> currenciesSupported;
    @Deprecated
    DeclineChargeOn declineChargeOn;
    @Deprecated
    Boolean debitNegativeBalances;
    @Deprecated
    Keys keys;
    @Deprecated
    LegalEntity legalEntity;
    @Deprecated
    Boolean managed;
    @Deprecated
    String mcc;
    @Deprecated
    PayoutSchedule payoutSchedule;
    @Deprecated
    String payoutStatementDescriptor;
    @Deprecated
    String productDescription;
    @Deprecated
    String statementDescriptor;
    @Deprecated
    Address supportAddress;
    @Deprecated
    String supportEmail;
    @Deprecated
    String supportPhone;
    @Deprecated
    String supportUrl;
    @Deprecated
    Boolean transfersEnabled;
    @Deprecated
    TransferSchedule transferSchedule;
    @Deprecated
    Verification verification;

    public static Account create(Map<String, Object> params) throws StripeException {
        return Account.create(params, null);
    }

    public static Account create(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Account.request(ApiResource.RequestMethod.POST, Account.classUrl(Account.class), params, Account.class, options);
    }

    public Account delete() throws StripeException {
        return this.delete(null, null);
    }

    public Account delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Account delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Account delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Account.request(ApiResource.RequestMethod.DELETE, Account.instanceUrl(Account.class, this.id), params, Account.class, options);
    }

    public static AccountCollection list(Map<String, Object> params) throws StripeException {
        return Account.list(params, null);
    }

    public static AccountCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Account.requestCollection(Account.classUrl(Account.class), params, AccountCollection.class, options);
    }

    public PersonCollection persons() throws StripeException {
        return this.persons(null, null);
    }

    public PersonCollection persons(Map<String, Object> params) throws StripeException {
        return this.persons(params, null);
    }

    public PersonCollection persons(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = Account.instanceUrl(Account.class, this.getId()) + "/persons";
        return Account.requestCollection(url, params, PersonCollection.class, options);
    }

    public Account reject(Map<String, Object> params) throws StripeException {
        return this.reject(params, null);
    }

    public Account reject(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Account.request(ApiResource.RequestMethod.POST, String.format("%s/reject", Account.instanceUrl(Account.class, this.getId())), params, Account.class, options);
    }

    public static Account retrieve() throws StripeException {
        return Account.retrieve((RequestOptions)null);
    }

    public static Account retrieve(RequestOptions options) throws StripeException {
        return Account.request(ApiResource.RequestMethod.GET, Account.singleClassUrl(Account.class), null, Account.class, options);
    }

    @Deprecated
    public static Account retrieve(String apiKeyOrAccountId) throws StripeException {
        if (null == apiKeyOrAccountId || apiKeyOrAccountId.startsWith("sk_")) {
            return Account.retrieve(RequestOptions.builder().setApiKey(apiKeyOrAccountId).build());
        }
        return Account.retrieve(apiKeyOrAccountId, null);
    }

    public static Account retrieve(String id, RequestOptions options) throws StripeException {
        return Account.retrieve(id, null, options);
    }

    public static Account retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        return Account.request(ApiResource.RequestMethod.GET, Account.instanceUrl(Account.class, id), params, Account.class, options);
    }

    public Account update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Account update(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Account.request(ApiResource.RequestMethod.POST, Account.instanceUrl(Account.class, this.id), params, Account.class, options);
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public BusinessProfile getBusinessProfile() {
        return this.businessProfile;
    }

    @Generated
    public String getBusinessType() {
        return this.businessType;
    }

    @Generated
    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    @Generated
    public Boolean getChargesEnabled() {
        return this.chargesEnabled;
    }

    @Generated
    public Company getCompany() {
        return this.company;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public Boolean getDetailsSubmitted() {
        return this.detailsSubmitted;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public ExternalAccountCollection getExternalAccounts() {
        return this.externalAccounts;
    }

    @Generated
    public Person getIndividual() {
        return this.individual;
    }

    @Generated
    public LoginLinkCollection getLoginLinks() {
        return this.loginLinks;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Boolean getPayoutsEnabled() {
        return this.payoutsEnabled;
    }

    @Generated
    public Requirements getRequirements() {
        return this.requirements;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public TosAcceptance getTosAcceptance() {
        return this.tosAcceptance;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Deprecated
    @Generated
    public String getBusinessLogoLarge() {
        return this.businessLogoLarge;
    }

    @Deprecated
    @Generated
    public String getBusinessLogo() {
        return this.businessLogo;
    }

    @Deprecated
    @Generated
    public String getBusinessName() {
        return this.businessName;
    }

    @Deprecated
    @Generated
    public String getBusinessPrimaryColor() {
        return this.businessPrimaryColor;
    }

    @Deprecated
    @Generated
    public String getBusinessUrl() {
        return this.businessUrl;
    }

    @Deprecated
    @Generated
    public List<String> getCurrenciesSupported() {
        return this.currenciesSupported;
    }

    @Deprecated
    @Generated
    public DeclineChargeOn getDeclineChargeOn() {
        return this.declineChargeOn;
    }

    @Deprecated
    @Generated
    public Boolean getDebitNegativeBalances() {
        return this.debitNegativeBalances;
    }

    @Deprecated
    @Generated
    public Keys getKeys() {
        return this.keys;
    }

    @Deprecated
    @Generated
    public LegalEntity getLegalEntity() {
        return this.legalEntity;
    }

    @Deprecated
    @Generated
    public Boolean getManaged() {
        return this.managed;
    }

    @Deprecated
    @Generated
    public String getMcc() {
        return this.mcc;
    }

    @Deprecated
    @Generated
    public PayoutSchedule getPayoutSchedule() {
        return this.payoutSchedule;
    }

    @Deprecated
    @Generated
    public String getPayoutStatementDescriptor() {
        return this.payoutStatementDescriptor;
    }

    @Deprecated
    @Generated
    public String getProductDescription() {
        return this.productDescription;
    }

    @Deprecated
    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Deprecated
    @Generated
    public Address getSupportAddress() {
        return this.supportAddress;
    }

    @Deprecated
    @Generated
    public String getSupportEmail() {
        return this.supportEmail;
    }

    @Deprecated
    @Generated
    public String getSupportPhone() {
        return this.supportPhone;
    }

    @Deprecated
    @Generated
    public String getSupportUrl() {
        return this.supportUrl;
    }

    @Deprecated
    @Generated
    public Boolean getTransfersEnabled() {
        return this.transfersEnabled;
    }

    @Deprecated
    @Generated
    public TransferSchedule getTransferSchedule() {
        return this.transferSchedule;
    }

    @Deprecated
    @Generated
    public Verification getVerification() {
        return this.verification;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setBusinessProfile(BusinessProfile businessProfile) {
        this.businessProfile = businessProfile;
    }

    @Generated
    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    @Generated
    public void setCapabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    @Generated
    public void setChargesEnabled(Boolean chargesEnabled) {
        this.chargesEnabled = chargesEnabled;
    }

    @Generated
    public void setCompany(Company company) {
        this.company = company;
    }

    @Generated
    public void setCountry(String country) {
        this.country = country;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDefaultCurrency(String defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDetailsSubmitted(Boolean detailsSubmitted) {
        this.detailsSubmitted = detailsSubmitted;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setExternalAccounts(ExternalAccountCollection externalAccounts) {
        this.externalAccounts = externalAccounts;
    }

    @Generated
    public void setIndividual(Person individual) {
        this.individual = individual;
    }

    @Generated
    public void setLoginLinks(LoginLinkCollection loginLinks) {
        this.loginLinks = loginLinks;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setPayoutsEnabled(Boolean payoutsEnabled) {
        this.payoutsEnabled = payoutsEnabled;
    }

    @Generated
    public void setRequirements(Requirements requirements) {
        this.requirements = requirements;
    }

    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Generated
    public void setTosAcceptance(TosAcceptance tosAcceptance) {
        this.tosAcceptance = tosAcceptance;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Deprecated
    @Generated
    public void setBusinessLogoLarge(String businessLogoLarge) {
        this.businessLogoLarge = businessLogoLarge;
    }

    @Deprecated
    @Generated
    public void setBusinessLogo(String businessLogo) {
        this.businessLogo = businessLogo;
    }

    @Deprecated
    @Generated
    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    @Deprecated
    @Generated
    public void setBusinessPrimaryColor(String businessPrimaryColor) {
        this.businessPrimaryColor = businessPrimaryColor;
    }

    @Deprecated
    @Generated
    public void setBusinessUrl(String businessUrl) {
        this.businessUrl = businessUrl;
    }

    @Deprecated
    @Generated
    public void setCurrenciesSupported(List<String> currenciesSupported) {
        this.currenciesSupported = currenciesSupported;
    }

    @Deprecated
    @Generated
    public void setDeclineChargeOn(DeclineChargeOn declineChargeOn) {
        this.declineChargeOn = declineChargeOn;
    }

    @Deprecated
    @Generated
    public void setDebitNegativeBalances(Boolean debitNegativeBalances) {
        this.debitNegativeBalances = debitNegativeBalances;
    }

    @Deprecated
    @Generated
    public void setKeys(Keys keys) {
        this.keys = keys;
    }

    @Deprecated
    @Generated
    public void setLegalEntity(LegalEntity legalEntity) {
        this.legalEntity = legalEntity;
    }

    @Deprecated
    @Generated
    public void setManaged(Boolean managed) {
        this.managed = managed;
    }

    @Deprecated
    @Generated
    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    @Deprecated
    @Generated
    public void setPayoutSchedule(PayoutSchedule payoutSchedule) {
        this.payoutSchedule = payoutSchedule;
    }

    @Deprecated
    @Generated
    public void setPayoutStatementDescriptor(String payoutStatementDescriptor) {
        this.payoutStatementDescriptor = payoutStatementDescriptor;
    }

    @Deprecated
    @Generated
    public void setProductDescription(String productDescription) {
        this.productDescription = productDescription;
    }

    @Deprecated
    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Deprecated
    @Generated
    public void setSupportAddress(Address supportAddress) {
        this.supportAddress = supportAddress;
    }

    @Deprecated
    @Generated
    public void setSupportEmail(String supportEmail) {
        this.supportEmail = supportEmail;
    }

    @Deprecated
    @Generated
    public void setSupportPhone(String supportPhone) {
        this.supportPhone = supportPhone;
    }

    @Deprecated
    @Generated
    public void setSupportUrl(String supportUrl) {
        this.supportUrl = supportUrl;
    }

    @Deprecated
    @Generated
    public void setTransfersEnabled(Boolean transfersEnabled) {
        this.transfersEnabled = transfersEnabled;
    }

    @Deprecated
    @Generated
    public void setTransferSchedule(TransferSchedule transferSchedule) {
        this.transferSchedule = transferSchedule;
    }

    @Deprecated
    @Generated
    public void setVerification(Verification verification) {
        this.verification = verification;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        BusinessProfile this$businessProfile = this.getBusinessProfile();
        BusinessProfile other$businessProfile = other.getBusinessProfile();
        if (this$businessProfile == null ? other$businessProfile != null : !((Object)this$businessProfile).equals(other$businessProfile)) {
            return false;
        }
        String this$businessType = this.getBusinessType();
        String other$businessType = other.getBusinessType();
        if (this$businessType == null ? other$businessType != null : !this$businessType.equals(other$businessType)) {
            return false;
        }
        Capabilities this$capabilities = this.getCapabilities();
        Capabilities other$capabilities = other.getCapabilities();
        if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
            return false;
        }
        Boolean this$chargesEnabled = this.getChargesEnabled();
        Boolean other$chargesEnabled = other.getChargesEnabled();
        if (this$chargesEnabled == null ? other$chargesEnabled != null : !((Object)this$chargesEnabled).equals(other$chargesEnabled)) {
            return false;
        }
        Company this$company = this.getCompany();
        Company other$company = other.getCompany();
        if (this$company == null ? other$company != null : !((Object)this$company).equals(other$company)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$defaultCurrency = this.getDefaultCurrency();
        String other$defaultCurrency = other.getDefaultCurrency();
        if (this$defaultCurrency == null ? other$defaultCurrency != null : !this$defaultCurrency.equals(other$defaultCurrency)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$detailsSubmitted = this.getDetailsSubmitted();
        Boolean other$detailsSubmitted = other.getDetailsSubmitted();
        if (this$detailsSubmitted == null ? other$detailsSubmitted != null : !((Object)this$detailsSubmitted).equals(other$detailsSubmitted)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        ExternalAccountCollection this$externalAccounts = this.getExternalAccounts();
        ExternalAccountCollection other$externalAccounts = other.getExternalAccounts();
        if (this$externalAccounts == null ? other$externalAccounts != null : !((Object)this$externalAccounts).equals(other$externalAccounts)) {
            return false;
        }
        Person this$individual = this.getIndividual();
        Person other$individual = other.getIndividual();
        if (this$individual == null ? other$individual != null : !((Object)this$individual).equals(other$individual)) {
            return false;
        }
        LoginLinkCollection this$loginLinks = this.getLoginLinks();
        LoginLinkCollection other$loginLinks = other.getLoginLinks();
        if (this$loginLinks == null ? other$loginLinks != null : !((Object)this$loginLinks).equals(other$loginLinks)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Boolean this$payoutsEnabled = this.getPayoutsEnabled();
        Boolean other$payoutsEnabled = other.getPayoutsEnabled();
        if (this$payoutsEnabled == null ? other$payoutsEnabled != null : !((Object)this$payoutsEnabled).equals(other$payoutsEnabled)) {
            return false;
        }
        Requirements this$requirements = this.getRequirements();
        Requirements other$requirements = other.getRequirements();
        if (this$requirements == null ? other$requirements != null : !((Object)this$requirements).equals(other$requirements)) {
            return false;
        }
        Settings this$settings = this.getSettings();
        Settings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        TosAcceptance this$tosAcceptance = this.getTosAcceptance();
        TosAcceptance other$tosAcceptance = other.getTosAcceptance();
        if (this$tosAcceptance == null ? other$tosAcceptance != null : !((Object)this$tosAcceptance).equals(other$tosAcceptance)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$businessLogoLarge = this.getBusinessLogoLarge();
        String other$businessLogoLarge = other.getBusinessLogoLarge();
        if (this$businessLogoLarge == null ? other$businessLogoLarge != null : !this$businessLogoLarge.equals(other$businessLogoLarge)) {
            return false;
        }
        String this$businessLogo = this.getBusinessLogo();
        String other$businessLogo = other.getBusinessLogo();
        if (this$businessLogo == null ? other$businessLogo != null : !this$businessLogo.equals(other$businessLogo)) {
            return false;
        }
        String this$businessName = this.getBusinessName();
        String other$businessName = other.getBusinessName();
        if (this$businessName == null ? other$businessName != null : !this$businessName.equals(other$businessName)) {
            return false;
        }
        String this$businessPrimaryColor = this.getBusinessPrimaryColor();
        String other$businessPrimaryColor = other.getBusinessPrimaryColor();
        if (this$businessPrimaryColor == null ? other$businessPrimaryColor != null : !this$businessPrimaryColor.equals(other$businessPrimaryColor)) {
            return false;
        }
        String this$businessUrl = this.getBusinessUrl();
        String other$businessUrl = other.getBusinessUrl();
        if (this$businessUrl == null ? other$businessUrl != null : !this$businessUrl.equals(other$businessUrl)) {
            return false;
        }
        List<String> this$currenciesSupported = this.getCurrenciesSupported();
        List<String> other$currenciesSupported = other.getCurrenciesSupported();
        if (this$currenciesSupported == null ? other$currenciesSupported != null : !((Object)this$currenciesSupported).equals(other$currenciesSupported)) {
            return false;
        }
        DeclineChargeOn this$declineChargeOn = this.getDeclineChargeOn();
        DeclineChargeOn other$declineChargeOn = other.getDeclineChargeOn();
        if (this$declineChargeOn == null ? other$declineChargeOn != null : !((Object)this$declineChargeOn).equals(other$declineChargeOn)) {
            return false;
        }
        Boolean this$debitNegativeBalances = this.getDebitNegativeBalances();
        Boolean other$debitNegativeBalances = other.getDebitNegativeBalances();
        if (this$debitNegativeBalances == null ? other$debitNegativeBalances != null : !((Object)this$debitNegativeBalances).equals(other$debitNegativeBalances)) {
            return false;
        }
        Keys this$keys = this.getKeys();
        Keys other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        LegalEntity this$legalEntity = this.getLegalEntity();
        LegalEntity other$legalEntity = other.getLegalEntity();
        if (this$legalEntity == null ? other$legalEntity != null : !((Object)this$legalEntity).equals(other$legalEntity)) {
            return false;
        }
        Boolean this$managed = this.getManaged();
        Boolean other$managed = other.getManaged();
        if (this$managed == null ? other$managed != null : !((Object)this$managed).equals(other$managed)) {
            return false;
        }
        String this$mcc = this.getMcc();
        String other$mcc = other.getMcc();
        if (this$mcc == null ? other$mcc != null : !this$mcc.equals(other$mcc)) {
            return false;
        }
        PayoutSchedule this$payoutSchedule = this.getPayoutSchedule();
        PayoutSchedule other$payoutSchedule = other.getPayoutSchedule();
        if (this$payoutSchedule == null ? other$payoutSchedule != null : !((Object)this$payoutSchedule).equals(other$payoutSchedule)) {
            return false;
        }
        String this$payoutStatementDescriptor = this.getPayoutStatementDescriptor();
        String other$payoutStatementDescriptor = other.getPayoutStatementDescriptor();
        if (this$payoutStatementDescriptor == null ? other$payoutStatementDescriptor != null : !this$payoutStatementDescriptor.equals(other$payoutStatementDescriptor)) {
            return false;
        }
        String this$productDescription = this.getProductDescription();
        String other$productDescription = other.getProductDescription();
        if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        Address this$supportAddress = this.getSupportAddress();
        Address other$supportAddress = other.getSupportAddress();
        if (this$supportAddress == null ? other$supportAddress != null : !((Object)this$supportAddress).equals(other$supportAddress)) {
            return false;
        }
        String this$supportEmail = this.getSupportEmail();
        String other$supportEmail = other.getSupportEmail();
        if (this$supportEmail == null ? other$supportEmail != null : !this$supportEmail.equals(other$supportEmail)) {
            return false;
        }
        String this$supportPhone = this.getSupportPhone();
        String other$supportPhone = other.getSupportPhone();
        if (this$supportPhone == null ? other$supportPhone != null : !this$supportPhone.equals(other$supportPhone)) {
            return false;
        }
        String this$supportUrl = this.getSupportUrl();
        String other$supportUrl = other.getSupportUrl();
        if (this$supportUrl == null ? other$supportUrl != null : !this$supportUrl.equals(other$supportUrl)) {
            return false;
        }
        Boolean this$transfersEnabled = this.getTransfersEnabled();
        Boolean other$transfersEnabled = other.getTransfersEnabled();
        if (this$transfersEnabled == null ? other$transfersEnabled != null : !((Object)this$transfersEnabled).equals(other$transfersEnabled)) {
            return false;
        }
        TransferSchedule this$transferSchedule = this.getTransferSchedule();
        TransferSchedule other$transferSchedule = other.getTransferSchedule();
        if (this$transferSchedule == null ? other$transferSchedule != null : !((Object)this$transferSchedule).equals(other$transferSchedule)) {
            return false;
        }
        Verification this$verification = this.getVerification();
        Verification other$verification = other.getVerification();
        return !(this$verification == null ? other$verification != null : !((Object)this$verification).equals(other$verification));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Account;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        BusinessProfile $businessProfile = this.getBusinessProfile();
        result = result * 59 + ($businessProfile == null ? 43 : ((Object)$businessProfile).hashCode());
        String $businessType = this.getBusinessType();
        result = result * 59 + ($businessType == null ? 43 : $businessType.hashCode());
        Capabilities $capabilities = this.getCapabilities();
        result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
        Boolean $chargesEnabled = this.getChargesEnabled();
        result = result * 59 + ($chargesEnabled == null ? 43 : ((Object)$chargesEnabled).hashCode());
        Company $company = this.getCompany();
        result = result * 59 + ($company == null ? 43 : ((Object)$company).hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $defaultCurrency = this.getDefaultCurrency();
        result = result * 59 + ($defaultCurrency == null ? 43 : $defaultCurrency.hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $detailsSubmitted = this.getDetailsSubmitted();
        result = result * 59 + ($detailsSubmitted == null ? 43 : ((Object)$detailsSubmitted).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        ExternalAccountCollection $externalAccounts = this.getExternalAccounts();
        result = result * 59 + ($externalAccounts == null ? 43 : ((Object)$externalAccounts).hashCode());
        Person $individual = this.getIndividual();
        result = result * 59 + ($individual == null ? 43 : ((Object)$individual).hashCode());
        LoginLinkCollection $loginLinks = this.getLoginLinks();
        result = result * 59 + ($loginLinks == null ? 43 : ((Object)$loginLinks).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Boolean $payoutsEnabled = this.getPayoutsEnabled();
        result = result * 59 + ($payoutsEnabled == null ? 43 : ((Object)$payoutsEnabled).hashCode());
        Requirements $requirements = this.getRequirements();
        result = result * 59 + ($requirements == null ? 43 : ((Object)$requirements).hashCode());
        Settings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        TosAcceptance $tosAcceptance = this.getTosAcceptance();
        result = result * 59 + ($tosAcceptance == null ? 43 : ((Object)$tosAcceptance).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $businessLogoLarge = this.getBusinessLogoLarge();
        result = result * 59 + ($businessLogoLarge == null ? 43 : $businessLogoLarge.hashCode());
        String $businessLogo = this.getBusinessLogo();
        result = result * 59 + ($businessLogo == null ? 43 : $businessLogo.hashCode());
        String $businessName = this.getBusinessName();
        result = result * 59 + ($businessName == null ? 43 : $businessName.hashCode());
        String $businessPrimaryColor = this.getBusinessPrimaryColor();
        result = result * 59 + ($businessPrimaryColor == null ? 43 : $businessPrimaryColor.hashCode());
        String $businessUrl = this.getBusinessUrl();
        result = result * 59 + ($businessUrl == null ? 43 : $businessUrl.hashCode());
        List<String> $currenciesSupported = this.getCurrenciesSupported();
        result = result * 59 + ($currenciesSupported == null ? 43 : ((Object)$currenciesSupported).hashCode());
        DeclineChargeOn $declineChargeOn = this.getDeclineChargeOn();
        result = result * 59 + ($declineChargeOn == null ? 43 : ((Object)$declineChargeOn).hashCode());
        Boolean $debitNegativeBalances = this.getDebitNegativeBalances();
        result = result * 59 + ($debitNegativeBalances == null ? 43 : ((Object)$debitNegativeBalances).hashCode());
        Keys $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        LegalEntity $legalEntity = this.getLegalEntity();
        result = result * 59 + ($legalEntity == null ? 43 : ((Object)$legalEntity).hashCode());
        Boolean $managed = this.getManaged();
        result = result * 59 + ($managed == null ? 43 : ((Object)$managed).hashCode());
        String $mcc = this.getMcc();
        result = result * 59 + ($mcc == null ? 43 : $mcc.hashCode());
        PayoutSchedule $payoutSchedule = this.getPayoutSchedule();
        result = result * 59 + ($payoutSchedule == null ? 43 : ((Object)$payoutSchedule).hashCode());
        String $payoutStatementDescriptor = this.getPayoutStatementDescriptor();
        result = result * 59 + ($payoutStatementDescriptor == null ? 43 : $payoutStatementDescriptor.hashCode());
        String $productDescription = this.getProductDescription();
        result = result * 59 + ($productDescription == null ? 43 : $productDescription.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        Address $supportAddress = this.getSupportAddress();
        result = result * 59 + ($supportAddress == null ? 43 : ((Object)$supportAddress).hashCode());
        String $supportEmail = this.getSupportEmail();
        result = result * 59 + ($supportEmail == null ? 43 : $supportEmail.hashCode());
        String $supportPhone = this.getSupportPhone();
        result = result * 59 + ($supportPhone == null ? 43 : $supportPhone.hashCode());
        String $supportUrl = this.getSupportUrl();
        result = result * 59 + ($supportUrl == null ? 43 : $supportUrl.hashCode());
        Boolean $transfersEnabled = this.getTransfersEnabled();
        result = result * 59 + ($transfersEnabled == null ? 43 : ((Object)$transfersEnabled).hashCode());
        TransferSchedule $transferSchedule = this.getTransferSchedule();
        result = result * 59 + ($transferSchedule == null ? 43 : ((Object)$transferSchedule).hashCode());
        Verification $verification = this.getVerification();
        result = result * 59 + ($verification == null ? 43 : ((Object)$verification).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Deprecated
    public static class Verification
    extends StripeObject {
        Boolean contacted;
        String disabledReason;
        Long dueBy;
        List<String> fieldsNeeded;

        @Generated
        public Boolean getContacted() {
            return this.contacted;
        }

        @Generated
        public String getDisabledReason() {
            return this.disabledReason;
        }

        @Generated
        public Long getDueBy() {
            return this.dueBy;
        }

        @Generated
        public List<String> getFieldsNeeded() {
            return this.fieldsNeeded;
        }

        @Generated
        public void setContacted(Boolean contacted) {
            this.contacted = contacted;
        }

        @Generated
        public void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @Generated
        public void setDueBy(Long dueBy) {
            this.dueBy = dueBy;
        }

        @Generated
        public void setFieldsNeeded(List<String> fieldsNeeded) {
            this.fieldsNeeded = fieldsNeeded;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Verification)) {
                return false;
            }
            Verification other = (Verification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$contacted = this.getContacted();
            Boolean other$contacted = other.getContacted();
            if (this$contacted == null ? other$contacted != null : !((Object)this$contacted).equals(other$contacted)) {
                return false;
            }
            String this$disabledReason = this.getDisabledReason();
            String other$disabledReason = other.getDisabledReason();
            if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) {
                return false;
            }
            Long this$dueBy = this.getDueBy();
            Long other$dueBy = other.getDueBy();
            if (this$dueBy == null ? other$dueBy != null : !((Object)this$dueBy).equals(other$dueBy)) {
                return false;
            }
            List<String> this$fieldsNeeded = this.getFieldsNeeded();
            List<String> other$fieldsNeeded = other.getFieldsNeeded();
            return !(this$fieldsNeeded == null ? other$fieldsNeeded != null : !((Object)this$fieldsNeeded).equals(other$fieldsNeeded));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Verification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $contacted = this.getContacted();
            result = result * 59 + ($contacted == null ? 43 : ((Object)$contacted).hashCode());
            String $disabledReason = this.getDisabledReason();
            result = result * 59 + ($disabledReason == null ? 43 : $disabledReason.hashCode());
            Long $dueBy = this.getDueBy();
            result = result * 59 + ($dueBy == null ? 43 : ((Object)$dueBy).hashCode());
            List<String> $fieldsNeeded = this.getFieldsNeeded();
            result = result * 59 + ($fieldsNeeded == null ? 43 : ((Object)$fieldsNeeded).hashCode());
            return result;
        }
    }

    @Deprecated
    public static class TransferSchedule
    extends StripeObject {
        Long delayDays;
        String interval;
        Long monthlyAnchor;
        String weeklyAnchor;

        @Generated
        public Long getDelayDays() {
            return this.delayDays;
        }

        @Generated
        public String getInterval() {
            return this.interval;
        }

        @Generated
        public Long getMonthlyAnchor() {
            return this.monthlyAnchor;
        }

        @Generated
        public String getWeeklyAnchor() {
            return this.weeklyAnchor;
        }

        @Generated
        public void setDelayDays(Long delayDays) {
            this.delayDays = delayDays;
        }

        @Generated
        public void setInterval(String interval) {
            this.interval = interval;
        }

        @Generated
        public void setMonthlyAnchor(Long monthlyAnchor) {
            this.monthlyAnchor = monthlyAnchor;
        }

        @Generated
        public void setWeeklyAnchor(String weeklyAnchor) {
            this.weeklyAnchor = weeklyAnchor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransferSchedule)) {
                return false;
            }
            TransferSchedule other = (TransferSchedule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$delayDays = this.getDelayDays();
            Long other$delayDays = other.getDelayDays();
            if (this$delayDays == null ? other$delayDays != null : !((Object)this$delayDays).equals(other$delayDays)) {
                return false;
            }
            String this$interval = this.getInterval();
            String other$interval = other.getInterval();
            if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                return false;
            }
            Long this$monthlyAnchor = this.getMonthlyAnchor();
            Long other$monthlyAnchor = other.getMonthlyAnchor();
            if (this$monthlyAnchor == null ? other$monthlyAnchor != null : !((Object)this$monthlyAnchor).equals(other$monthlyAnchor)) {
                return false;
            }
            String this$weeklyAnchor = this.getWeeklyAnchor();
            String other$weeklyAnchor = other.getWeeklyAnchor();
            return !(this$weeklyAnchor == null ? other$weeklyAnchor != null : !this$weeklyAnchor.equals(other$weeklyAnchor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransferSchedule;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $delayDays = this.getDelayDays();
            result = result * 59 + ($delayDays == null ? 43 : ((Object)$delayDays).hashCode());
            String $interval = this.getInterval();
            result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
            Long $monthlyAnchor = this.getMonthlyAnchor();
            result = result * 59 + ($monthlyAnchor == null ? 43 : ((Object)$monthlyAnchor).hashCode());
            String $weeklyAnchor = this.getWeeklyAnchor();
            result = result * 59 + ($weeklyAnchor == null ? 43 : $weeklyAnchor.hashCode());
            return result;
        }
    }

    @Deprecated
    public static class Keys
    extends StripeObject {
        String publishable;
        String secret;

        @Generated
        public String getPublishable() {
            return this.publishable;
        }

        @Generated
        public String getSecret() {
            return this.secret;
        }

        @Generated
        public void setPublishable(String publishable) {
            this.publishable = publishable;
        }

        @Generated
        public void setSecret(String secret) {
            this.secret = secret;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Keys)) {
                return false;
            }
            Keys other = (Keys)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$publishable = this.getPublishable();
            String other$publishable = other.getPublishable();
            if (this$publishable == null ? other$publishable != null : !this$publishable.equals(other$publishable)) {
                return false;
            }
            String this$secret = this.getSecret();
            String other$secret = other.getSecret();
            return !(this$secret == null ? other$secret != null : !this$secret.equals(other$secret));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Keys;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $publishable = this.getPublishable();
            result = result * 59 + ($publishable == null ? 43 : $publishable.hashCode());
            String $secret = this.getSecret();
            result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
            return result;
        }
    }

    public static class TosAcceptance
    extends StripeObject {
        Long date;
        String ip;
        String userAgent;

        @Generated
        public Long getDate() {
            return this.date;
        }

        @Generated
        public String getIp() {
            return this.ip;
        }

        @Generated
        public String getUserAgent() {
            return this.userAgent;
        }

        @Generated
        public void setDate(Long date) {
            this.date = date;
        }

        @Generated
        public void setIp(String ip) {
            this.ip = ip;
        }

        @Generated
        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TosAcceptance)) {
                return false;
            }
            TosAcceptance other = (TosAcceptance)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$date = this.getDate();
            Long other$date = other.getDate();
            if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            String this$userAgent = this.getUserAgent();
            String other$userAgent = other.getUserAgent();
            return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TosAcceptance;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            String $userAgent = this.getUserAgent();
            result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
            return result;
        }
    }

    public static class Settings
    extends StripeObject {
        SettingsBranding branding;
        SettingsCardPayments cardPayments;
        SettingsDashboard dashboard;
        SettingsPayments payments;
        SettingsPayouts payouts;

        @Generated
        public SettingsBranding getBranding() {
            return this.branding;
        }

        @Generated
        public SettingsCardPayments getCardPayments() {
            return this.cardPayments;
        }

        @Generated
        public SettingsDashboard getDashboard() {
            return this.dashboard;
        }

        @Generated
        public SettingsPayments getPayments() {
            return this.payments;
        }

        @Generated
        public SettingsPayouts getPayouts() {
            return this.payouts;
        }

        @Generated
        public void setBranding(SettingsBranding branding) {
            this.branding = branding;
        }

        @Generated
        public void setCardPayments(SettingsCardPayments cardPayments) {
            this.cardPayments = cardPayments;
        }

        @Generated
        public void setDashboard(SettingsDashboard dashboard) {
            this.dashboard = dashboard;
        }

        @Generated
        public void setPayments(SettingsPayments payments) {
            this.payments = payments;
        }

        @Generated
        public void setPayouts(SettingsPayouts payouts) {
            this.payouts = payouts;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Settings)) {
                return false;
            }
            Settings other = (Settings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SettingsBranding this$branding = this.getBranding();
            SettingsBranding other$branding = other.getBranding();
            if (this$branding == null ? other$branding != null : !((Object)this$branding).equals(other$branding)) {
                return false;
            }
            SettingsCardPayments this$cardPayments = this.getCardPayments();
            SettingsCardPayments other$cardPayments = other.getCardPayments();
            if (this$cardPayments == null ? other$cardPayments != null : !((Object)this$cardPayments).equals(other$cardPayments)) {
                return false;
            }
            SettingsDashboard this$dashboard = this.getDashboard();
            SettingsDashboard other$dashboard = other.getDashboard();
            if (this$dashboard == null ? other$dashboard != null : !((Object)this$dashboard).equals(other$dashboard)) {
                return false;
            }
            SettingsPayments this$payments = this.getPayments();
            SettingsPayments other$payments = other.getPayments();
            if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
                return false;
            }
            SettingsPayouts this$payouts = this.getPayouts();
            SettingsPayouts other$payouts = other.getPayouts();
            return !(this$payouts == null ? other$payouts != null : !((Object)this$payouts).equals(other$payouts));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Settings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SettingsBranding $branding = this.getBranding();
            result = result * 59 + ($branding == null ? 43 : ((Object)$branding).hashCode());
            SettingsCardPayments $cardPayments = this.getCardPayments();
            result = result * 59 + ($cardPayments == null ? 43 : ((Object)$cardPayments).hashCode());
            SettingsDashboard $dashboard = this.getDashboard();
            result = result * 59 + ($dashboard == null ? 43 : ((Object)$dashboard).hashCode());
            SettingsPayments $payments = this.getPayments();
            result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
            SettingsPayouts $payouts = this.getPayouts();
            result = result * 59 + ($payouts == null ? 43 : ((Object)$payouts).hashCode());
            return result;
        }
    }

    public static class SettingsPayouts
    extends StripeObject {
        Boolean debitNegativeBalances;
        PayoutSchedule schedule;
        String statementDescriptor;

        @Generated
        public Boolean getDebitNegativeBalances() {
            return this.debitNegativeBalances;
        }

        @Generated
        public PayoutSchedule getSchedule() {
            return this.schedule;
        }

        @Generated
        public String getStatementDescriptor() {
            return this.statementDescriptor;
        }

        @Generated
        public void setDebitNegativeBalances(Boolean debitNegativeBalances) {
            this.debitNegativeBalances = debitNegativeBalances;
        }

        @Generated
        public void setSchedule(PayoutSchedule schedule) {
            this.schedule = schedule;
        }

        @Generated
        public void setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SettingsPayouts)) {
                return false;
            }
            SettingsPayouts other = (SettingsPayouts)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$debitNegativeBalances = this.getDebitNegativeBalances();
            Boolean other$debitNegativeBalances = other.getDebitNegativeBalances();
            if (this$debitNegativeBalances == null ? other$debitNegativeBalances != null : !((Object)this$debitNegativeBalances).equals(other$debitNegativeBalances)) {
                return false;
            }
            PayoutSchedule this$schedule = this.getSchedule();
            PayoutSchedule other$schedule = other.getSchedule();
            if (this$schedule == null ? other$schedule != null : !((Object)this$schedule).equals(other$schedule)) {
                return false;
            }
            String this$statementDescriptor = this.getStatementDescriptor();
            String other$statementDescriptor = other.getStatementDescriptor();
            return !(this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SettingsPayouts;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $debitNegativeBalances = this.getDebitNegativeBalances();
            result = result * 59 + ($debitNegativeBalances == null ? 43 : ((Object)$debitNegativeBalances).hashCode());
            PayoutSchedule $schedule = this.getSchedule();
            result = result * 59 + ($schedule == null ? 43 : ((Object)$schedule).hashCode());
            String $statementDescriptor = this.getStatementDescriptor();
            result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
            return result;
        }
    }

    public static class SettingsPayments
    extends StripeObject {
        String statementDescriptor;

        @Generated
        public String getStatementDescriptor() {
            return this.statementDescriptor;
        }

        @Generated
        public void setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SettingsPayments)) {
                return false;
            }
            SettingsPayments other = (SettingsPayments)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$statementDescriptor = this.getStatementDescriptor();
            String other$statementDescriptor = other.getStatementDescriptor();
            return !(this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SettingsPayments;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $statementDescriptor = this.getStatementDescriptor();
            result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
            return result;
        }
    }

    public static class SettingsDashboard
    extends StripeObject {
        String displayName;
        String timezone;

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getTimezone() {
            return this.timezone;
        }

        @Generated
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Generated
        public void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SettingsDashboard)) {
                return false;
            }
            SettingsDashboard other = (SettingsDashboard)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$timezone = this.getTimezone();
            String other$timezone = other.getTimezone();
            return !(this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SettingsDashboard;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $timezone = this.getTimezone();
            result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
            return result;
        }
    }

    public static class SettingsCardPayments
    extends StripeObject {
        DeclineChargeOn declineOn;
        String statementDescriptorPrefix;

        @Generated
        public DeclineChargeOn getDeclineOn() {
            return this.declineOn;
        }

        @Generated
        public String getStatementDescriptorPrefix() {
            return this.statementDescriptorPrefix;
        }

        @Generated
        public void setDeclineOn(DeclineChargeOn declineOn) {
            this.declineOn = declineOn;
        }

        @Generated
        public void setStatementDescriptorPrefix(String statementDescriptorPrefix) {
            this.statementDescriptorPrefix = statementDescriptorPrefix;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SettingsCardPayments)) {
                return false;
            }
            SettingsCardPayments other = (SettingsCardPayments)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DeclineChargeOn this$declineOn = this.getDeclineOn();
            DeclineChargeOn other$declineOn = other.getDeclineOn();
            if (this$declineOn == null ? other$declineOn != null : !((Object)this$declineOn).equals(other$declineOn)) {
                return false;
            }
            String this$statementDescriptorPrefix = this.getStatementDescriptorPrefix();
            String other$statementDescriptorPrefix = other.getStatementDescriptorPrefix();
            return !(this$statementDescriptorPrefix == null ? other$statementDescriptorPrefix != null : !this$statementDescriptorPrefix.equals(other$statementDescriptorPrefix));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SettingsCardPayments;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DeclineChargeOn $declineOn = this.getDeclineOn();
            result = result * 59 + ($declineOn == null ? 43 : ((Object)$declineOn).hashCode());
            String $statementDescriptorPrefix = this.getStatementDescriptorPrefix();
            result = result * 59 + ($statementDescriptorPrefix == null ? 43 : $statementDescriptorPrefix.hashCode());
            return result;
        }
    }

    public static class Requirements
    extends StripeObject {
        Long currentDeadline;
        List<String> currentlyDue;
        String disabledReason;
        List<String> eventuallyDue;
        List<String> pastDue;

        @Generated
        public Long getCurrentDeadline() {
            return this.currentDeadline;
        }

        @Generated
        public List<String> getCurrentlyDue() {
            return this.currentlyDue;
        }

        @Generated
        public String getDisabledReason() {
            return this.disabledReason;
        }

        @Generated
        public List<String> getEventuallyDue() {
            return this.eventuallyDue;
        }

        @Generated
        public List<String> getPastDue() {
            return this.pastDue;
        }

        @Generated
        public void setCurrentDeadline(Long currentDeadline) {
            this.currentDeadline = currentDeadline;
        }

        @Generated
        public void setCurrentlyDue(List<String> currentlyDue) {
            this.currentlyDue = currentlyDue;
        }

        @Generated
        public void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @Generated
        public void setEventuallyDue(List<String> eventuallyDue) {
            this.eventuallyDue = eventuallyDue;
        }

        @Generated
        public void setPastDue(List<String> pastDue) {
            this.pastDue = pastDue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Requirements)) {
                return false;
            }
            Requirements other = (Requirements)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$currentDeadline = this.getCurrentDeadline();
            Long other$currentDeadline = other.getCurrentDeadline();
            if (this$currentDeadline == null ? other$currentDeadline != null : !((Object)this$currentDeadline).equals(other$currentDeadline)) {
                return false;
            }
            List<String> this$currentlyDue = this.getCurrentlyDue();
            List<String> other$currentlyDue = other.getCurrentlyDue();
            if (this$currentlyDue == null ? other$currentlyDue != null : !((Object)this$currentlyDue).equals(other$currentlyDue)) {
                return false;
            }
            String this$disabledReason = this.getDisabledReason();
            String other$disabledReason = other.getDisabledReason();
            if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) {
                return false;
            }
            List<String> this$eventuallyDue = this.getEventuallyDue();
            List<String> other$eventuallyDue = other.getEventuallyDue();
            if (this$eventuallyDue == null ? other$eventuallyDue != null : !((Object)this$eventuallyDue).equals(other$eventuallyDue)) {
                return false;
            }
            List<String> this$pastDue = this.getPastDue();
            List<String> other$pastDue = other.getPastDue();
            return !(this$pastDue == null ? other$pastDue != null : !((Object)this$pastDue).equals(other$pastDue));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Requirements;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $currentDeadline = this.getCurrentDeadline();
            result = result * 59 + ($currentDeadline == null ? 43 : ((Object)$currentDeadline).hashCode());
            List<String> $currentlyDue = this.getCurrentlyDue();
            result = result * 59 + ($currentlyDue == null ? 43 : ((Object)$currentlyDue).hashCode());
            String $disabledReason = this.getDisabledReason();
            result = result * 59 + ($disabledReason == null ? 43 : $disabledReason.hashCode());
            List<String> $eventuallyDue = this.getEventuallyDue();
            result = result * 59 + ($eventuallyDue == null ? 43 : ((Object)$eventuallyDue).hashCode());
            List<String> $pastDue = this.getPastDue();
            result = result * 59 + ($pastDue == null ? 43 : ((Object)$pastDue).hashCode());
            return result;
        }
    }

    public static class PayoutSchedule
    extends StripeObject {
        Long delayDays;
        String interval;
        Long monthlyAnchor;
        String weeklyAnchor;

        @Generated
        public Long getDelayDays() {
            return this.delayDays;
        }

        @Generated
        public String getInterval() {
            return this.interval;
        }

        @Generated
        public Long getMonthlyAnchor() {
            return this.monthlyAnchor;
        }

        @Generated
        public String getWeeklyAnchor() {
            return this.weeklyAnchor;
        }

        @Generated
        public void setDelayDays(Long delayDays) {
            this.delayDays = delayDays;
        }

        @Generated
        public void setInterval(String interval) {
            this.interval = interval;
        }

        @Generated
        public void setMonthlyAnchor(Long monthlyAnchor) {
            this.monthlyAnchor = monthlyAnchor;
        }

        @Generated
        public void setWeeklyAnchor(String weeklyAnchor) {
            this.weeklyAnchor = weeklyAnchor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PayoutSchedule)) {
                return false;
            }
            PayoutSchedule other = (PayoutSchedule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$delayDays = this.getDelayDays();
            Long other$delayDays = other.getDelayDays();
            if (this$delayDays == null ? other$delayDays != null : !((Object)this$delayDays).equals(other$delayDays)) {
                return false;
            }
            String this$interval = this.getInterval();
            String other$interval = other.getInterval();
            if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                return false;
            }
            Long this$monthlyAnchor = this.getMonthlyAnchor();
            Long other$monthlyAnchor = other.getMonthlyAnchor();
            if (this$monthlyAnchor == null ? other$monthlyAnchor != null : !((Object)this$monthlyAnchor).equals(other$monthlyAnchor)) {
                return false;
            }
            String this$weeklyAnchor = this.getWeeklyAnchor();
            String other$weeklyAnchor = other.getWeeklyAnchor();
            return !(this$weeklyAnchor == null ? other$weeklyAnchor != null : !this$weeklyAnchor.equals(other$weeklyAnchor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PayoutSchedule;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $delayDays = this.getDelayDays();
            result = result * 59 + ($delayDays == null ? 43 : ((Object)$delayDays).hashCode());
            String $interval = this.getInterval();
            result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
            Long $monthlyAnchor = this.getMonthlyAnchor();
            result = result * 59 + ($monthlyAnchor == null ? 43 : ((Object)$monthlyAnchor).hashCode());
            String $weeklyAnchor = this.getWeeklyAnchor();
            result = result * 59 + ($weeklyAnchor == null ? 43 : $weeklyAnchor.hashCode());
            return result;
        }
    }

    public static class DeclineChargeOn
    extends StripeObject {
        Boolean avsFailure;
        Boolean cvcFailure;

        @Generated
        public Boolean getAvsFailure() {
            return this.avsFailure;
        }

        @Generated
        public Boolean getCvcFailure() {
            return this.cvcFailure;
        }

        @Generated
        public void setAvsFailure(Boolean avsFailure) {
            this.avsFailure = avsFailure;
        }

        @Generated
        public void setCvcFailure(Boolean cvcFailure) {
            this.cvcFailure = cvcFailure;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeclineChargeOn)) {
                return false;
            }
            DeclineChargeOn other = (DeclineChargeOn)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$avsFailure = this.getAvsFailure();
            Boolean other$avsFailure = other.getAvsFailure();
            if (this$avsFailure == null ? other$avsFailure != null : !((Object)this$avsFailure).equals(other$avsFailure)) {
                return false;
            }
            Boolean this$cvcFailure = this.getCvcFailure();
            Boolean other$cvcFailure = other.getCvcFailure();
            return !(this$cvcFailure == null ? other$cvcFailure != null : !((Object)this$cvcFailure).equals(other$cvcFailure));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DeclineChargeOn;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $avsFailure = this.getAvsFailure();
            result = result * 59 + ($avsFailure == null ? 43 : ((Object)$avsFailure).hashCode());
            Boolean $cvcFailure = this.getCvcFailure();
            result = result * 59 + ($cvcFailure == null ? 43 : ((Object)$cvcFailure).hashCode());
            return result;
        }
    }

    public static class SettingsBranding
    extends StripeObject {
        ExpandableField<File> icon;
        ExpandableField<File> logo;
        String primaryColor;

        public String getIcon() {
            return this.icon != null ? this.icon.getId() : null;
        }

        public void setIcon(String iconId) {
            this.icon = ApiResource.setExpandableFieldId(iconId, this.icon);
        }

        public File getIconObject() {
            return this.icon != null ? this.icon.getExpanded() : null;
        }

        public void setIconObject(File c) {
            this.icon = new ExpandableField<File>(c.getId(), c);
        }

        public String getLogo() {
            return this.logo != null ? this.logo.getId() : null;
        }

        public void setLogo(String logoId) {
            this.logo = ApiResource.setExpandableFieldId(logoId, this.logo);
        }

        public File getLogoObject() {
            return this.logo != null ? this.logo.getExpanded() : null;
        }

        public void setLogoObject(File c) {
            this.logo = new ExpandableField<File>(c.getId(), c);
        }

        @Generated
        public String getPrimaryColor() {
            return this.primaryColor;
        }

        @Generated
        public void setPrimaryColor(String primaryColor) {
            this.primaryColor = primaryColor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SettingsBranding)) {
                return false;
            }
            SettingsBranding other = (SettingsBranding)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$icon = this.getIcon();
            String other$icon = other.getIcon();
            if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
                return false;
            }
            String this$logo = this.getLogo();
            String other$logo = other.getLogo();
            if (this$logo == null ? other$logo != null : !this$logo.equals(other$logo)) {
                return false;
            }
            String this$primaryColor = this.getPrimaryColor();
            String other$primaryColor = other.getPrimaryColor();
            return !(this$primaryColor == null ? other$primaryColor != null : !this$primaryColor.equals(other$primaryColor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SettingsBranding;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $icon = this.getIcon();
            result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
            String $logo = this.getLogo();
            result = result * 59 + ($logo == null ? 43 : $logo.hashCode());
            String $primaryColor = this.getPrimaryColor();
            result = result * 59 + ($primaryColor == null ? 43 : $primaryColor.hashCode());
            return result;
        }
    }

    public static class Company
    extends StripeObject {
        Address address;
        Person.JapanAddress addressKana;
        Person.JapanAddress addressKanji;
        Boolean directorsProvided;
        String name;
        String nameKana;
        String nameKanji;
        Boolean ownersProvided;
        String phone;
        Boolean taxIdProvided;
        String taxIdRegistrar;
        Boolean vatIdProvided;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public Person.JapanAddress getAddressKana() {
            return this.addressKana;
        }

        @Generated
        public Person.JapanAddress getAddressKanji() {
            return this.addressKanji;
        }

        @Generated
        public Boolean getDirectorsProvided() {
            return this.directorsProvided;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getNameKana() {
            return this.nameKana;
        }

        @Generated
        public String getNameKanji() {
            return this.nameKanji;
        }

        @Generated
        public Boolean getOwnersProvided() {
            return this.ownersProvided;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public Boolean getTaxIdProvided() {
            return this.taxIdProvided;
        }

        @Generated
        public String getTaxIdRegistrar() {
            return this.taxIdRegistrar;
        }

        @Generated
        public Boolean getVatIdProvided() {
            return this.vatIdProvided;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setAddressKana(Person.JapanAddress addressKana) {
            this.addressKana = addressKana;
        }

        @Generated
        public void setAddressKanji(Person.JapanAddress addressKanji) {
            this.addressKanji = addressKanji;
        }

        @Generated
        public void setDirectorsProvided(Boolean directorsProvided) {
            this.directorsProvided = directorsProvided;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setNameKana(String nameKana) {
            this.nameKana = nameKana;
        }

        @Generated
        public void setNameKanji(String nameKanji) {
            this.nameKanji = nameKanji;
        }

        @Generated
        public void setOwnersProvided(Boolean ownersProvided) {
            this.ownersProvided = ownersProvided;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public void setTaxIdProvided(Boolean taxIdProvided) {
            this.taxIdProvided = taxIdProvided;
        }

        @Generated
        public void setTaxIdRegistrar(String taxIdRegistrar) {
            this.taxIdRegistrar = taxIdRegistrar;
        }

        @Generated
        public void setVatIdProvided(Boolean vatIdProvided) {
            this.vatIdProvided = vatIdProvided;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Company)) {
                return false;
            }
            Company other = (Company)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            Person.JapanAddress this$addressKana = this.getAddressKana();
            Person.JapanAddress other$addressKana = other.getAddressKana();
            if (this$addressKana == null ? other$addressKana != null : !((Object)this$addressKana).equals(other$addressKana)) {
                return false;
            }
            Person.JapanAddress this$addressKanji = this.getAddressKanji();
            Person.JapanAddress other$addressKanji = other.getAddressKanji();
            if (this$addressKanji == null ? other$addressKanji != null : !((Object)this$addressKanji).equals(other$addressKanji)) {
                return false;
            }
            Boolean this$directorsProvided = this.getDirectorsProvided();
            Boolean other$directorsProvided = other.getDirectorsProvided();
            if (this$directorsProvided == null ? other$directorsProvided != null : !((Object)this$directorsProvided).equals(other$directorsProvided)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$nameKana = this.getNameKana();
            String other$nameKana = other.getNameKana();
            if (this$nameKana == null ? other$nameKana != null : !this$nameKana.equals(other$nameKana)) {
                return false;
            }
            String this$nameKanji = this.getNameKanji();
            String other$nameKanji = other.getNameKanji();
            if (this$nameKanji == null ? other$nameKanji != null : !this$nameKanji.equals(other$nameKanji)) {
                return false;
            }
            Boolean this$ownersProvided = this.getOwnersProvided();
            Boolean other$ownersProvided = other.getOwnersProvided();
            if (this$ownersProvided == null ? other$ownersProvided != null : !((Object)this$ownersProvided).equals(other$ownersProvided)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
                return false;
            }
            Boolean this$taxIdProvided = this.getTaxIdProvided();
            Boolean other$taxIdProvided = other.getTaxIdProvided();
            if (this$taxIdProvided == null ? other$taxIdProvided != null : !((Object)this$taxIdProvided).equals(other$taxIdProvided)) {
                return false;
            }
            String this$taxIdRegistrar = this.getTaxIdRegistrar();
            String other$taxIdRegistrar = other.getTaxIdRegistrar();
            if (this$taxIdRegistrar == null ? other$taxIdRegistrar != null : !this$taxIdRegistrar.equals(other$taxIdRegistrar)) {
                return false;
            }
            Boolean this$vatIdProvided = this.getVatIdProvided();
            Boolean other$vatIdProvided = other.getVatIdProvided();
            return !(this$vatIdProvided == null ? other$vatIdProvided != null : !((Object)this$vatIdProvided).equals(other$vatIdProvided));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Company;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            Person.JapanAddress $addressKana = this.getAddressKana();
            result = result * 59 + ($addressKana == null ? 43 : ((Object)$addressKana).hashCode());
            Person.JapanAddress $addressKanji = this.getAddressKanji();
            result = result * 59 + ($addressKanji == null ? 43 : ((Object)$addressKanji).hashCode());
            Boolean $directorsProvided = this.getDirectorsProvided();
            result = result * 59 + ($directorsProvided == null ? 43 : ((Object)$directorsProvided).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $nameKana = this.getNameKana();
            result = result * 59 + ($nameKana == null ? 43 : $nameKana.hashCode());
            String $nameKanji = this.getNameKanji();
            result = result * 59 + ($nameKanji == null ? 43 : $nameKanji.hashCode());
            Boolean $ownersProvided = this.getOwnersProvided();
            result = result * 59 + ($ownersProvided == null ? 43 : ((Object)$ownersProvided).hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            Boolean $taxIdProvided = this.getTaxIdProvided();
            result = result * 59 + ($taxIdProvided == null ? 43 : ((Object)$taxIdProvided).hashCode());
            String $taxIdRegistrar = this.getTaxIdRegistrar();
            result = result * 59 + ($taxIdRegistrar == null ? 43 : $taxIdRegistrar.hashCode());
            Boolean $vatIdProvided = this.getVatIdProvided();
            result = result * 59 + ($vatIdProvided == null ? 43 : ((Object)$vatIdProvided).hashCode());
            return result;
        }
    }

    public static class Capabilities
    extends StripeObject {
        String cardPayments;
        String legacyPayments;
        String platformPayments;

        @Generated
        public String getCardPayments() {
            return this.cardPayments;
        }

        @Generated
        public String getLegacyPayments() {
            return this.legacyPayments;
        }

        @Generated
        public String getPlatformPayments() {
            return this.platformPayments;
        }

        @Generated
        public void setCardPayments(String cardPayments) {
            this.cardPayments = cardPayments;
        }

        @Generated
        public void setLegacyPayments(String legacyPayments) {
            this.legacyPayments = legacyPayments;
        }

        @Generated
        public void setPlatformPayments(String platformPayments) {
            this.platformPayments = platformPayments;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Capabilities)) {
                return false;
            }
            Capabilities other = (Capabilities)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$cardPayments = this.getCardPayments();
            String other$cardPayments = other.getCardPayments();
            if (this$cardPayments == null ? other$cardPayments != null : !this$cardPayments.equals(other$cardPayments)) {
                return false;
            }
            String this$legacyPayments = this.getLegacyPayments();
            String other$legacyPayments = other.getLegacyPayments();
            if (this$legacyPayments == null ? other$legacyPayments != null : !this$legacyPayments.equals(other$legacyPayments)) {
                return false;
            }
            String this$platformPayments = this.getPlatformPayments();
            String other$platformPayments = other.getPlatformPayments();
            return !(this$platformPayments == null ? other$platformPayments != null : !this$platformPayments.equals(other$platformPayments));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Capabilities;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $cardPayments = this.getCardPayments();
            result = result * 59 + ($cardPayments == null ? 43 : $cardPayments.hashCode());
            String $legacyPayments = this.getLegacyPayments();
            result = result * 59 + ($legacyPayments == null ? 43 : $legacyPayments.hashCode());
            String $platformPayments = this.getPlatformPayments();
            result = result * 59 + ($platformPayments == null ? 43 : $platformPayments.hashCode());
            return result;
        }
    }

    public static class BusinessProfile
    extends StripeObject {
        String mcc;
        String name;
        String productDescription;
        Address supportAddress;
        String supportEmail;
        String supportPhone;
        String supportUrl;
        String url;

        @Generated
        public String getMcc() {
            return this.mcc;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getProductDescription() {
            return this.productDescription;
        }

        @Generated
        public Address getSupportAddress() {
            return this.supportAddress;
        }

        @Generated
        public String getSupportEmail() {
            return this.supportEmail;
        }

        @Generated
        public String getSupportPhone() {
            return this.supportPhone;
        }

        @Generated
        public String getSupportUrl() {
            return this.supportUrl;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setMcc(String mcc) {
            this.mcc = mcc;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        @Generated
        public void setSupportAddress(Address supportAddress) {
            this.supportAddress = supportAddress;
        }

        @Generated
        public void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        @Generated
        public void setSupportPhone(String supportPhone) {
            this.supportPhone = supportPhone;
        }

        @Generated
        public void setSupportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BusinessProfile)) {
                return false;
            }
            BusinessProfile other = (BusinessProfile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$mcc = this.getMcc();
            String other$mcc = other.getMcc();
            if (this$mcc == null ? other$mcc != null : !this$mcc.equals(other$mcc)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$productDescription = this.getProductDescription();
            String other$productDescription = other.getProductDescription();
            if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) {
                return false;
            }
            Address this$supportAddress = this.getSupportAddress();
            Address other$supportAddress = other.getSupportAddress();
            if (this$supportAddress == null ? other$supportAddress != null : !((Object)this$supportAddress).equals(other$supportAddress)) {
                return false;
            }
            String this$supportEmail = this.getSupportEmail();
            String other$supportEmail = other.getSupportEmail();
            if (this$supportEmail == null ? other$supportEmail != null : !this$supportEmail.equals(other$supportEmail)) {
                return false;
            }
            String this$supportPhone = this.getSupportPhone();
            String other$supportPhone = other.getSupportPhone();
            if (this$supportPhone == null ? other$supportPhone != null : !this$supportPhone.equals(other$supportPhone)) {
                return false;
            }
            String this$supportUrl = this.getSupportUrl();
            String other$supportUrl = other.getSupportUrl();
            if (this$supportUrl == null ? other$supportUrl != null : !this$supportUrl.equals(other$supportUrl)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BusinessProfile;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $mcc = this.getMcc();
            result = result * 59 + ($mcc == null ? 43 : $mcc.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $productDescription = this.getProductDescription();
            result = result * 59 + ($productDescription == null ? 43 : $productDescription.hashCode());
            Address $supportAddress = this.getSupportAddress();
            result = result * 59 + ($supportAddress == null ? 43 : ((Object)$supportAddress).hashCode());
            String $supportEmail = this.getSupportEmail();
            result = result * 59 + ($supportEmail == null ? 43 : $supportEmail.hashCode());
            String $supportPhone = this.getSupportPhone();
            result = result * 59 + ($supportPhone == null ? 43 : $supportPhone.hashCode());
            String $supportUrl = this.getSupportUrl();
            result = result * 59 + ($supportUrl == null ? 43 : $supportUrl.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }
    }
}

