// Generated by delombok at Wed Nov 07 22:01:07 CET 2018
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class Order extends ApiResource implements HasId, MetadataStore<Order> {
  String id;
  String object;
  Long amount;
  Long amountReturned;
  String application;
  Long applicationFee;
  ExpandableField<Charge> charge;
  Long created;
  String currency;
  ExpandableField<Customer> customer;
  String email;
  String externalCouponCode;
  List<OrderItem> items;
  Boolean livemode;
  Map<String, String> metadata;
  OrderReturnCollection returns;
  String selectedShippingMethod;
  ShippingDetails shipping;
  List<ShippingMethod> shippingMethods;
  String status;
  StatusTransitions statusTransitions;
  Long updated;
  String upstreamId;

  // <editor-fold desc="charge">
  public String getCharge() {
    return (this.charge != null) ? this.charge.getId() : null;
  }

  public void setCharge(String chargeId) {
    this.charge = setExpandableFieldId(chargeId, this.charge);
  }

  public Charge getChargeObject() {
    return (this.charge != null) ? this.charge.getExpanded() : null;
  }

  public void setChargeObject(Charge charge) {
    this.charge = new ExpandableField<Charge>(charge.getId(), charge);
  }

  // </editor-fold>
  // <editor-fold desc="customer">
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String customerId) {
    this.customer = setExpandableFieldId(customerId, this.customer);
  }

  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer customer) {
    this.customer = new ExpandableField<Customer>(customer.getId(), customer);
  }

  // </editor-fold>
  // <editor-fold desc="create">
  /**
   * Create an order.
   */
  public static Order create(Map<String, Object> params) throws StripeException {
    return create(params, null);
  }

  /**
   * Create an order.
   */
  public static Order create(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, classUrl(Order.class), params, Order.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="list">
  /**
   * List all orders.
   */
  public static OrderCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all orders.
   */
  public static OrderCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(Order.class), params, OrderCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="pay">
  /**
   * Pay an order.
   */
  public Order pay(Map<String, Object> params) throws StripeException {
    return this.pay(params, null);
  }

  /**
   * Pay an order.
   */
  public Order pay(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, String.format("%s/pay", instanceUrl(Order.class, this.getId())), params, Order.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve an order.
   */
  public static Order retrieve(String id) throws StripeException {
    return retrieve(id, null);
  }

  /**
   * Retrieve an order.
   */
  public static Order retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve an order.
   */
  public static Order retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(Order.class, id), params, Order.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="returnOrder">
  /**
   * Return an order.
   */
  public OrderReturn returnOrder(Map<String, Object> params) throws StripeException {
    return this.returnOrder(params, null);
  }

  /**
   * Return an order.
   */
  public OrderReturn returnOrder(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, String.format("%s/returns", instanceUrl(Order.class, this.getId())), params, OrderReturn.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="update">
  /**
   * Update an order.
   */
  @Override
  public Order update(Map<String, Object> params) throws StripeException {
    return update(params, null);
  }

  /**
   * Update an order.
   */
  @Override
  public Order update(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, instanceUrl(Order.class, this.id), params, Order.class, options);
  }

  // </editor-fold>
  public static class ShippingMethod extends StripeObject {
    String id;
    Long amount;
    String currency;
    String description;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getId() {
      return this.id;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCurrency() {
      return this.currency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
      return this.description;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setId(final String id) {
      this.id = id;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrency(final String currency) {
      this.currency = currency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDescription(final String description) {
      this.description = description;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Order.ShippingMethod)) return false;
      final Order.ShippingMethod other = (Order.ShippingMethod) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$id = this.getId();
      final java.lang.Object other$id = other.getId();
      if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$currency = this.getCurrency();
      final java.lang.Object other$currency = other.getCurrency();
      if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
      final java.lang.Object this$description = this.getDescription();
      final java.lang.Object other$description = other.getDescription();
      if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Order.ShippingMethod;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $id = this.getId();
      result = result * PRIME + ($id == null ? 43 : $id.hashCode());
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $currency = this.getCurrency();
      result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
      final java.lang.Object $description = this.getDescription();
      result = result * PRIME + ($description == null ? 43 : $description.hashCode());
      return result;
    }
  }


  public static class StatusTransitions extends StripeObject {
    Long canceled;
    Long fulfiled;
    Long paid;
    Long returned;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCanceled() {
      return this.canceled;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getFulfiled() {
      return this.fulfiled;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPaid() {
      return this.paid;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getReturned() {
      return this.returned;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCanceled(final Long canceled) {
      this.canceled = canceled;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFulfiled(final Long fulfiled) {
      this.fulfiled = fulfiled;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPaid(final Long paid) {
      this.paid = paid;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReturned(final Long returned) {
      this.returned = returned;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Order.StatusTransitions)) return false;
      final Order.StatusTransitions other = (Order.StatusTransitions) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$canceled = this.getCanceled();
      final java.lang.Object other$canceled = other.getCanceled();
      if (this$canceled == null ? other$canceled != null : !this$canceled.equals(other$canceled)) return false;
      final java.lang.Object this$fulfiled = this.getFulfiled();
      final java.lang.Object other$fulfiled = other.getFulfiled();
      if (this$fulfiled == null ? other$fulfiled != null : !this$fulfiled.equals(other$fulfiled)) return false;
      final java.lang.Object this$paid = this.getPaid();
      final java.lang.Object other$paid = other.getPaid();
      if (this$paid == null ? other$paid != null : !this$paid.equals(other$paid)) return false;
      final java.lang.Object this$returned = this.getReturned();
      final java.lang.Object other$returned = other.getReturned();
      if (this$returned == null ? other$returned != null : !this$returned.equals(other$returned)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Order.StatusTransitions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $canceled = this.getCanceled();
      result = result * PRIME + ($canceled == null ? 43 : $canceled.hashCode());
      final java.lang.Object $fulfiled = this.getFulfiled();
      result = result * PRIME + ($fulfiled == null ? 43 : $fulfiled.hashCode());
      final java.lang.Object $paid = this.getPaid();
      result = result * PRIME + ($paid == null ? 43 : $paid.hashCode());
      final java.lang.Object $returned = this.getReturned();
      result = result * PRIME + ($returned == null ? 43 : $returned.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountReturned() {
    return this.amountReturned;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getApplication() {
    return this.application;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getApplicationFee() {
    return this.applicationFee;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEmail() {
    return this.email;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getExternalCouponCode() {
    return this.externalCouponCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<OrderItem> getItems() {
    return this.items;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public OrderReturnCollection getReturns() {
    return this.returns;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSelectedShippingMethod() {
    return this.selectedShippingMethod;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ShippingDetails getShipping() {
    return this.shipping;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<ShippingMethod> getShippingMethods() {
    return this.shippingMethods;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public StatusTransitions getStatusTransitions() {
    return this.statusTransitions;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getUpdated() {
    return this.updated;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getUpstreamId() {
    return this.upstreamId;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountReturned(final Long amountReturned) {
    this.amountReturned = amountReturned;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApplication(final String application) {
    this.application = application;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApplicationFee(final Long applicationFee) {
    this.applicationFee = applicationFee;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEmail(final String email) {
    this.email = email;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExternalCouponCode(final String externalCouponCode) {
    this.externalCouponCode = externalCouponCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setItems(final List<OrderItem> items) {
    this.items = items;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReturns(final OrderReturnCollection returns) {
    this.returns = returns;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSelectedShippingMethod(final String selectedShippingMethod) {
    this.selectedShippingMethod = selectedShippingMethod;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setShipping(final ShippingDetails shipping) {
    this.shipping = shipping;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setShippingMethods(final List<ShippingMethod> shippingMethods) {
    this.shippingMethods = shippingMethods;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatusTransitions(final StatusTransitions statusTransitions) {
    this.statusTransitions = statusTransitions;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUpdated(final Long updated) {
    this.updated = updated;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUpstreamId(final String upstreamId) {
    this.upstreamId = upstreamId;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Order)) return false;
    final Order other = (Order) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$amountReturned = this.getAmountReturned();
    final java.lang.Object other$amountReturned = other.getAmountReturned();
    if (this$amountReturned == null ? other$amountReturned != null : !this$amountReturned.equals(other$amountReturned)) return false;
    final java.lang.Object this$application = this.getApplication();
    final java.lang.Object other$application = other.getApplication();
    if (this$application == null ? other$application != null : !this$application.equals(other$application)) return false;
    final java.lang.Object this$applicationFee = this.getApplicationFee();
    final java.lang.Object other$applicationFee = other.getApplicationFee();
    if (this$applicationFee == null ? other$applicationFee != null : !this$applicationFee.equals(other$applicationFee)) return false;
    final java.lang.Object this$charge = this.getCharge();
    final java.lang.Object other$charge = other.getCharge();
    if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$email = this.getEmail();
    final java.lang.Object other$email = other.getEmail();
    if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
    final java.lang.Object this$externalCouponCode = this.getExternalCouponCode();
    final java.lang.Object other$externalCouponCode = other.getExternalCouponCode();
    if (this$externalCouponCode == null ? other$externalCouponCode != null : !this$externalCouponCode.equals(other$externalCouponCode)) return false;
    final java.lang.Object this$items = this.getItems();
    final java.lang.Object other$items = other.getItems();
    if (this$items == null ? other$items != null : !this$items.equals(other$items)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$returns = this.getReturns();
    final java.lang.Object other$returns = other.getReturns();
    if (this$returns == null ? other$returns != null : !this$returns.equals(other$returns)) return false;
    final java.lang.Object this$selectedShippingMethod = this.getSelectedShippingMethod();
    final java.lang.Object other$selectedShippingMethod = other.getSelectedShippingMethod();
    if (this$selectedShippingMethod == null ? other$selectedShippingMethod != null : !this$selectedShippingMethod.equals(other$selectedShippingMethod)) return false;
    final java.lang.Object this$shipping = this.getShipping();
    final java.lang.Object other$shipping = other.getShipping();
    if (this$shipping == null ? other$shipping != null : !this$shipping.equals(other$shipping)) return false;
    final java.lang.Object this$shippingMethods = this.getShippingMethods();
    final java.lang.Object other$shippingMethods = other.getShippingMethods();
    if (this$shippingMethods == null ? other$shippingMethods != null : !this$shippingMethods.equals(other$shippingMethods)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$statusTransitions = this.getStatusTransitions();
    final java.lang.Object other$statusTransitions = other.getStatusTransitions();
    if (this$statusTransitions == null ? other$statusTransitions != null : !this$statusTransitions.equals(other$statusTransitions)) return false;
    final java.lang.Object this$updated = this.getUpdated();
    final java.lang.Object other$updated = other.getUpdated();
    if (this$updated == null ? other$updated != null : !this$updated.equals(other$updated)) return false;
    final java.lang.Object this$upstreamId = this.getUpstreamId();
    final java.lang.Object other$upstreamId = other.getUpstreamId();
    if (this$upstreamId == null ? other$upstreamId != null : !this$upstreamId.equals(other$upstreamId)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Order;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $amountReturned = this.getAmountReturned();
    result = result * PRIME + ($amountReturned == null ? 43 : $amountReturned.hashCode());
    final java.lang.Object $application = this.getApplication();
    result = result * PRIME + ($application == null ? 43 : $application.hashCode());
    final java.lang.Object $applicationFee = this.getApplicationFee();
    result = result * PRIME + ($applicationFee == null ? 43 : $applicationFee.hashCode());
    final java.lang.Object $charge = this.getCharge();
    result = result * PRIME + ($charge == null ? 43 : $charge.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $email = this.getEmail();
    result = result * PRIME + ($email == null ? 43 : $email.hashCode());
    final java.lang.Object $externalCouponCode = this.getExternalCouponCode();
    result = result * PRIME + ($externalCouponCode == null ? 43 : $externalCouponCode.hashCode());
    final java.lang.Object $items = this.getItems();
    result = result * PRIME + ($items == null ? 43 : $items.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $returns = this.getReturns();
    result = result * PRIME + ($returns == null ? 43 : $returns.hashCode());
    final java.lang.Object $selectedShippingMethod = this.getSelectedShippingMethod();
    result = result * PRIME + ($selectedShippingMethod == null ? 43 : $selectedShippingMethod.hashCode());
    final java.lang.Object $shipping = this.getShipping();
    result = result * PRIME + ($shipping == null ? 43 : $shipping.hashCode());
    final java.lang.Object $shippingMethods = this.getShippingMethods();
    result = result * PRIME + ($shippingMethods == null ? 43 : $shippingMethods.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $statusTransitions = this.getStatusTransitions();
    result = result * PRIME + ($statusTransitions == null ? 43 : $statusTransitions.hashCode());
    final java.lang.Object $updated = this.getUpdated();
    result = result * PRIME + ($updated == null ? 43 : $updated.hashCode());
    final java.lang.Object $upstreamId = this.getUpstreamId();
    result = result * PRIME + ($upstreamId == null ? 43 : $upstreamId.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
