// Generated by delombok at Wed Nov 07 22:01:07 CET 2018
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class Person extends ApiResource implements MetadataStore<Person>, HasId {
  String id;
  String object;
  String account;
  Address address;
  JapanAddress addressKana;
  JapanAddress addressKanji;
  Long created;
  Boolean deleted;
  DateOfBirth dob;
  String email;
  String firstName;
  String firstNameKana;
  String firstNameKanji;
  String gender;
  Boolean idNumberProvided;
  String lastName;
  String lastNameKana;
  String lastNameKanji;
  String maidenName;
  Map<String, String> metadata;
  String phone;
  Requirements requirements;
  @SerializedName("ssn_last_4_provided")
  Boolean ssnLast4Provided;
  Verification verification;

  // <editor-fold desc="delete">
  /**
   * Delete a person.
   */
  public Person delete() throws StripeException {
    return delete((RequestOptions) null);
  }

  /**
   * Delete a person.
   */
  public Person delete(RequestOptions options) throws StripeException {
    return request(RequestMethod.DELETE, this.getInstanceUrl(), null, Person.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="update">
  /**
   * Update a person.
   */
  public Person update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Update a person.
   */
  public Person update(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, this.getInstanceUrl(), params, Person.class, options);
  }

  // </editor-fold>
  protected String getInstanceUrl() {
    if (this.account != null) {
      return String.format("%s/%s/persons/%s", classUrl(Account.class), this.getAccount(), this.getId());
    }
    return null;
  }

  // TODO: Move this to a top level class instead of duplicating
  // with the LegalEntity resource
  public static class DateOfBirth extends StripeObject {
    Long day;
    Long month;
    Long year;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDay() {
      return this.day;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMonth() {
      return this.month;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getYear() {
      return this.year;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDay(final Long day) {
      this.day = day;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMonth(final Long month) {
      this.month = month;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setYear(final Long year) {
      this.year = year;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Person.DateOfBirth)) return false;
      final Person.DateOfBirth other = (Person.DateOfBirth) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$day = this.getDay();
      final java.lang.Object other$day = other.getDay();
      if (this$day == null ? other$day != null : !this$day.equals(other$day)) return false;
      final java.lang.Object this$month = this.getMonth();
      final java.lang.Object other$month = other.getMonth();
      if (this$month == null ? other$month != null : !this$month.equals(other$month)) return false;
      final java.lang.Object this$year = this.getYear();
      final java.lang.Object other$year = other.getYear();
      if (this$year == null ? other$year != null : !this$year.equals(other$year)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Person.DateOfBirth;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $day = this.getDay();
      result = result * PRIME + ($day == null ? 43 : $day.hashCode());
      final java.lang.Object $month = this.getMonth();
      result = result * PRIME + ($month == null ? 43 : $month.hashCode());
      final java.lang.Object $year = this.getYear();
      result = result * PRIME + ($year == null ? 43 : $year.hashCode());
      return result;
    }
  }

  // TODO: Move this to a top level class instead of duplicating
  // with the LegalEntity resource
  public static class JapanAddress extends StripeObject {
    String city;
    String country;
    String line1;
    String line2;
    String postalCode;
    String state;
    String town;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCity() {
      return this.city;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCountry() {
      return this.country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLine1() {
      return this.line1;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLine2() {
      return this.line2;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPostalCode() {
      return this.postalCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getState() {
      return this.state;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTown() {
      return this.town;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCity(final String city) {
      this.city = city;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCountry(final String country) {
      this.country = country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLine1(final String line1) {
      this.line1 = line1;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLine2(final String line2) {
      this.line2 = line2;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPostalCode(final String postalCode) {
      this.postalCode = postalCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setState(final String state) {
      this.state = state;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTown(final String town) {
      this.town = town;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Person.JapanAddress)) return false;
      final Person.JapanAddress other = (Person.JapanAddress) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$city = this.getCity();
      final java.lang.Object other$city = other.getCity();
      if (this$city == null ? other$city != null : !this$city.equals(other$city)) return false;
      final java.lang.Object this$country = this.getCountry();
      final java.lang.Object other$country = other.getCountry();
      if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
      final java.lang.Object this$line1 = this.getLine1();
      final java.lang.Object other$line1 = other.getLine1();
      if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) return false;
      final java.lang.Object this$line2 = this.getLine2();
      final java.lang.Object other$line2 = other.getLine2();
      if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) return false;
      final java.lang.Object this$postalCode = this.getPostalCode();
      final java.lang.Object other$postalCode = other.getPostalCode();
      if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) return false;
      final java.lang.Object this$state = this.getState();
      final java.lang.Object other$state = other.getState();
      if (this$state == null ? other$state != null : !this$state.equals(other$state)) return false;
      final java.lang.Object this$town = this.getTown();
      final java.lang.Object other$town = other.getTown();
      if (this$town == null ? other$town != null : !this$town.equals(other$town)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Person.JapanAddress;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $city = this.getCity();
      result = result * PRIME + ($city == null ? 43 : $city.hashCode());
      final java.lang.Object $country = this.getCountry();
      result = result * PRIME + ($country == null ? 43 : $country.hashCode());
      final java.lang.Object $line1 = this.getLine1();
      result = result * PRIME + ($line1 == null ? 43 : $line1.hashCode());
      final java.lang.Object $line2 = this.getLine2();
      result = result * PRIME + ($line2 == null ? 43 : $line2.hashCode());
      final java.lang.Object $postalCode = this.getPostalCode();
      result = result * PRIME + ($postalCode == null ? 43 : $postalCode.hashCode());
      final java.lang.Object $state = this.getState();
      result = result * PRIME + ($state == null ? 43 : $state.hashCode());
      final java.lang.Object $town = this.getTown();
      result = result * PRIME + ($town == null ? 43 : $town.hashCode());
      return result;
    }
  }


  public static class Relationship extends StripeObject {
    Boolean accountOpener;
    Boolean director;
    Boolean executive;
    Boolean owner;
    BigDecimal percentOwnership;
    Boolean representative;
    String title;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getAccountOpener() {
      return this.accountOpener;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getDirector() {
      return this.director;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getExecutive() {
      return this.executive;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getOwner() {
      return this.owner;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BigDecimal getPercentOwnership() {
      return this.percentOwnership;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getRepresentative() {
      return this.representative;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTitle() {
      return this.title;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAccountOpener(final Boolean accountOpener) {
      this.accountOpener = accountOpener;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDirector(final Boolean director) {
      this.director = director;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExecutive(final Boolean executive) {
      this.executive = executive;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOwner(final Boolean owner) {
      this.owner = owner;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPercentOwnership(final BigDecimal percentOwnership) {
      this.percentOwnership = percentOwnership;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRepresentative(final Boolean representative) {
      this.representative = representative;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTitle(final String title) {
      this.title = title;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Person.Relationship)) return false;
      final Person.Relationship other = (Person.Relationship) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$accountOpener = this.getAccountOpener();
      final java.lang.Object other$accountOpener = other.getAccountOpener();
      if (this$accountOpener == null ? other$accountOpener != null : !this$accountOpener.equals(other$accountOpener)) return false;
      final java.lang.Object this$director = this.getDirector();
      final java.lang.Object other$director = other.getDirector();
      if (this$director == null ? other$director != null : !this$director.equals(other$director)) return false;
      final java.lang.Object this$executive = this.getExecutive();
      final java.lang.Object other$executive = other.getExecutive();
      if (this$executive == null ? other$executive != null : !this$executive.equals(other$executive)) return false;
      final java.lang.Object this$owner = this.getOwner();
      final java.lang.Object other$owner = other.getOwner();
      if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) return false;
      final java.lang.Object this$percentOwnership = this.getPercentOwnership();
      final java.lang.Object other$percentOwnership = other.getPercentOwnership();
      if (this$percentOwnership == null ? other$percentOwnership != null : !this$percentOwnership.equals(other$percentOwnership)) return false;
      final java.lang.Object this$representative = this.getRepresentative();
      final java.lang.Object other$representative = other.getRepresentative();
      if (this$representative == null ? other$representative != null : !this$representative.equals(other$representative)) return false;
      final java.lang.Object this$title = this.getTitle();
      final java.lang.Object other$title = other.getTitle();
      if (this$title == null ? other$title != null : !this$title.equals(other$title)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Person.Relationship;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $accountOpener = this.getAccountOpener();
      result = result * PRIME + ($accountOpener == null ? 43 : $accountOpener.hashCode());
      final java.lang.Object $director = this.getDirector();
      result = result * PRIME + ($director == null ? 43 : $director.hashCode());
      final java.lang.Object $executive = this.getExecutive();
      result = result * PRIME + ($executive == null ? 43 : $executive.hashCode());
      final java.lang.Object $owner = this.getOwner();
      result = result * PRIME + ($owner == null ? 43 : $owner.hashCode());
      final java.lang.Object $percentOwnership = this.getPercentOwnership();
      result = result * PRIME + ($percentOwnership == null ? 43 : $percentOwnership.hashCode());
      final java.lang.Object $representative = this.getRepresentative();
      result = result * PRIME + ($representative == null ? 43 : $representative.hashCode());
      final java.lang.Object $title = this.getTitle();
      result = result * PRIME + ($title == null ? 43 : $title.hashCode());
      return result;
    }
  }


  public static class Requirements extends StripeObject {
    List<String> currentlyDue;
    List<String> eventuallyDue;
    List<String> pastDue;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getCurrentlyDue() {
      return this.currentlyDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getEventuallyDue() {
      return this.eventuallyDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getPastDue() {
      return this.pastDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrentlyDue(final List<String> currentlyDue) {
      this.currentlyDue = currentlyDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEventuallyDue(final List<String> eventuallyDue) {
      this.eventuallyDue = eventuallyDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPastDue(final List<String> pastDue) {
      this.pastDue = pastDue;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Person.Requirements)) return false;
      final Person.Requirements other = (Person.Requirements) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$currentlyDue = this.getCurrentlyDue();
      final java.lang.Object other$currentlyDue = other.getCurrentlyDue();
      if (this$currentlyDue == null ? other$currentlyDue != null : !this$currentlyDue.equals(other$currentlyDue)) return false;
      final java.lang.Object this$eventuallyDue = this.getEventuallyDue();
      final java.lang.Object other$eventuallyDue = other.getEventuallyDue();
      if (this$eventuallyDue == null ? other$eventuallyDue != null : !this$eventuallyDue.equals(other$eventuallyDue)) return false;
      final java.lang.Object this$pastDue = this.getPastDue();
      final java.lang.Object other$pastDue = other.getPastDue();
      if (this$pastDue == null ? other$pastDue != null : !this$pastDue.equals(other$pastDue)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Person.Requirements;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $currentlyDue = this.getCurrentlyDue();
      result = result * PRIME + ($currentlyDue == null ? 43 : $currentlyDue.hashCode());
      final java.lang.Object $eventuallyDue = this.getEventuallyDue();
      result = result * PRIME + ($eventuallyDue == null ? 43 : $eventuallyDue.hashCode());
      final java.lang.Object $pastDue = this.getPastDue();
      result = result * PRIME + ($pastDue == null ? 43 : $pastDue.hashCode());
      return result;
    }
  }

  // TODO: Move this to a top level class instead of duplicating
  // with the LegalEntity resource
  public static class Verification extends StripeObject {
    String details;
    String detailsCode;
    String document;
    String documentBack;
    String status;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDetails() {
      return this.details;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDetailsCode() {
      return this.detailsCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDocument() {
      return this.document;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDocumentBack() {
      return this.documentBack;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDetails(final String details) {
      this.details = details;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDetailsCode(final String detailsCode) {
      this.detailsCode = detailsCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDocument(final String document) {
      this.document = document;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDocumentBack(final String documentBack) {
      this.documentBack = documentBack;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Person.Verification)) return false;
      final Person.Verification other = (Person.Verification) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$details = this.getDetails();
      final java.lang.Object other$details = other.getDetails();
      if (this$details == null ? other$details != null : !this$details.equals(other$details)) return false;
      final java.lang.Object this$detailsCode = this.getDetailsCode();
      final java.lang.Object other$detailsCode = other.getDetailsCode();
      if (this$detailsCode == null ? other$detailsCode != null : !this$detailsCode.equals(other$detailsCode)) return false;
      final java.lang.Object this$document = this.getDocument();
      final java.lang.Object other$document = other.getDocument();
      if (this$document == null ? other$document != null : !this$document.equals(other$document)) return false;
      final java.lang.Object this$documentBack = this.getDocumentBack();
      final java.lang.Object other$documentBack = other.getDocumentBack();
      if (this$documentBack == null ? other$documentBack != null : !this$documentBack.equals(other$documentBack)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Person.Verification;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $details = this.getDetails();
      result = result * PRIME + ($details == null ? 43 : $details.hashCode());
      final java.lang.Object $detailsCode = this.getDetailsCode();
      result = result * PRIME + ($detailsCode == null ? 43 : $detailsCode.hashCode());
      final java.lang.Object $document = this.getDocument();
      result = result * PRIME + ($document == null ? 43 : $document.hashCode());
      final java.lang.Object $documentBack = this.getDocumentBack();
      result = result * PRIME + ($documentBack == null ? 43 : $documentBack.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAccount() {
    return this.account;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Address getAddress() {
    return this.address;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public JapanAddress getAddressKana() {
    return this.addressKana;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public JapanAddress getAddressKanji() {
    return this.addressKanji;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DateOfBirth getDob() {
    return this.dob;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEmail() {
    return this.email;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFirstName() {
    return this.firstName;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFirstNameKana() {
    return this.firstNameKana;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFirstNameKanji() {
    return this.firstNameKanji;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getGender() {
    return this.gender;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getIdNumberProvided() {
    return this.idNumberProvided;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLastName() {
    return this.lastName;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLastNameKana() {
    return this.lastNameKana;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLastNameKanji() {
    return this.lastNameKanji;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getMaidenName() {
    return this.maidenName;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPhone() {
    return this.phone;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Requirements getRequirements() {
    return this.requirements;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getSsnLast4Provided() {
    return this.ssnLast4Provided;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Verification getVerification() {
    return this.verification;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAccount(final String account) {
    this.account = account;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAddress(final Address address) {
    this.address = address;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAddressKana(final JapanAddress addressKana) {
    this.addressKana = addressKana;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAddressKanji(final JapanAddress addressKanji) {
    this.addressKanji = addressKanji;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDob(final DateOfBirth dob) {
    this.dob = dob;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEmail(final String email) {
    this.email = email;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFirstName(final String firstName) {
    this.firstName = firstName;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFirstNameKana(final String firstNameKana) {
    this.firstNameKana = firstNameKana;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFirstNameKanji(final String firstNameKanji) {
    this.firstNameKanji = firstNameKanji;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setGender(final String gender) {
    this.gender = gender;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIdNumberProvided(final Boolean idNumberProvided) {
    this.idNumberProvided = idNumberProvided;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLastName(final String lastName) {
    this.lastName = lastName;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLastNameKana(final String lastNameKana) {
    this.lastNameKana = lastNameKana;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLastNameKanji(final String lastNameKanji) {
    this.lastNameKanji = lastNameKanji;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMaidenName(final String maidenName) {
    this.maidenName = maidenName;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPhone(final String phone) {
    this.phone = phone;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRequirements(final Requirements requirements) {
    this.requirements = requirements;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSsnLast4Provided(final Boolean ssnLast4Provided) {
    this.ssnLast4Provided = ssnLast4Provided;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVerification(final Verification verification) {
    this.verification = verification;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Person)) return false;
    final Person other = (Person) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$account = this.getAccount();
    final java.lang.Object other$account = other.getAccount();
    if (this$account == null ? other$account != null : !this$account.equals(other$account)) return false;
    final java.lang.Object this$address = this.getAddress();
    final java.lang.Object other$address = other.getAddress();
    if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
    final java.lang.Object this$addressKana = this.getAddressKana();
    final java.lang.Object other$addressKana = other.getAddressKana();
    if (this$addressKana == null ? other$addressKana != null : !this$addressKana.equals(other$addressKana)) return false;
    final java.lang.Object this$addressKanji = this.getAddressKanji();
    final java.lang.Object other$addressKanji = other.getAddressKanji();
    if (this$addressKanji == null ? other$addressKanji != null : !this$addressKanji.equals(other$addressKanji)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$dob = this.getDob();
    final java.lang.Object other$dob = other.getDob();
    if (this$dob == null ? other$dob != null : !this$dob.equals(other$dob)) return false;
    final java.lang.Object this$email = this.getEmail();
    final java.lang.Object other$email = other.getEmail();
    if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
    final java.lang.Object this$firstName = this.getFirstName();
    final java.lang.Object other$firstName = other.getFirstName();
    if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) return false;
    final java.lang.Object this$firstNameKana = this.getFirstNameKana();
    final java.lang.Object other$firstNameKana = other.getFirstNameKana();
    if (this$firstNameKana == null ? other$firstNameKana != null : !this$firstNameKana.equals(other$firstNameKana)) return false;
    final java.lang.Object this$firstNameKanji = this.getFirstNameKanji();
    final java.lang.Object other$firstNameKanji = other.getFirstNameKanji();
    if (this$firstNameKanji == null ? other$firstNameKanji != null : !this$firstNameKanji.equals(other$firstNameKanji)) return false;
    final java.lang.Object this$gender = this.getGender();
    final java.lang.Object other$gender = other.getGender();
    if (this$gender == null ? other$gender != null : !this$gender.equals(other$gender)) return false;
    final java.lang.Object this$idNumberProvided = this.getIdNumberProvided();
    final java.lang.Object other$idNumberProvided = other.getIdNumberProvided();
    if (this$idNumberProvided == null ? other$idNumberProvided != null : !this$idNumberProvided.equals(other$idNumberProvided)) return false;
    final java.lang.Object this$lastName = this.getLastName();
    final java.lang.Object other$lastName = other.getLastName();
    if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) return false;
    final java.lang.Object this$lastNameKana = this.getLastNameKana();
    final java.lang.Object other$lastNameKana = other.getLastNameKana();
    if (this$lastNameKana == null ? other$lastNameKana != null : !this$lastNameKana.equals(other$lastNameKana)) return false;
    final java.lang.Object this$lastNameKanji = this.getLastNameKanji();
    final java.lang.Object other$lastNameKanji = other.getLastNameKanji();
    if (this$lastNameKanji == null ? other$lastNameKanji != null : !this$lastNameKanji.equals(other$lastNameKanji)) return false;
    final java.lang.Object this$maidenName = this.getMaidenName();
    final java.lang.Object other$maidenName = other.getMaidenName();
    if (this$maidenName == null ? other$maidenName != null : !this$maidenName.equals(other$maidenName)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$phone = this.getPhone();
    final java.lang.Object other$phone = other.getPhone();
    if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) return false;
    final java.lang.Object this$requirements = this.getRequirements();
    final java.lang.Object other$requirements = other.getRequirements();
    if (this$requirements == null ? other$requirements != null : !this$requirements.equals(other$requirements)) return false;
    final java.lang.Object this$ssnLast4Provided = this.getSsnLast4Provided();
    final java.lang.Object other$ssnLast4Provided = other.getSsnLast4Provided();
    if (this$ssnLast4Provided == null ? other$ssnLast4Provided != null : !this$ssnLast4Provided.equals(other$ssnLast4Provided)) return false;
    final java.lang.Object this$verification = this.getVerification();
    final java.lang.Object other$verification = other.getVerification();
    if (this$verification == null ? other$verification != null : !this$verification.equals(other$verification)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Person;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $account = this.getAccount();
    result = result * PRIME + ($account == null ? 43 : $account.hashCode());
    final java.lang.Object $address = this.getAddress();
    result = result * PRIME + ($address == null ? 43 : $address.hashCode());
    final java.lang.Object $addressKana = this.getAddressKana();
    result = result * PRIME + ($addressKana == null ? 43 : $addressKana.hashCode());
    final java.lang.Object $addressKanji = this.getAddressKanji();
    result = result * PRIME + ($addressKanji == null ? 43 : $addressKanji.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $dob = this.getDob();
    result = result * PRIME + ($dob == null ? 43 : $dob.hashCode());
    final java.lang.Object $email = this.getEmail();
    result = result * PRIME + ($email == null ? 43 : $email.hashCode());
    final java.lang.Object $firstName = this.getFirstName();
    result = result * PRIME + ($firstName == null ? 43 : $firstName.hashCode());
    final java.lang.Object $firstNameKana = this.getFirstNameKana();
    result = result * PRIME + ($firstNameKana == null ? 43 : $firstNameKana.hashCode());
    final java.lang.Object $firstNameKanji = this.getFirstNameKanji();
    result = result * PRIME + ($firstNameKanji == null ? 43 : $firstNameKanji.hashCode());
    final java.lang.Object $gender = this.getGender();
    result = result * PRIME + ($gender == null ? 43 : $gender.hashCode());
    final java.lang.Object $idNumberProvided = this.getIdNumberProvided();
    result = result * PRIME + ($idNumberProvided == null ? 43 : $idNumberProvided.hashCode());
    final java.lang.Object $lastName = this.getLastName();
    result = result * PRIME + ($lastName == null ? 43 : $lastName.hashCode());
    final java.lang.Object $lastNameKana = this.getLastNameKana();
    result = result * PRIME + ($lastNameKana == null ? 43 : $lastNameKana.hashCode());
    final java.lang.Object $lastNameKanji = this.getLastNameKanji();
    result = result * PRIME + ($lastNameKanji == null ? 43 : $lastNameKanji.hashCode());
    final java.lang.Object $maidenName = this.getMaidenName();
    result = result * PRIME + ($maidenName == null ? 43 : $maidenName.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $phone = this.getPhone();
    result = result * PRIME + ($phone == null ? 43 : $phone.hashCode());
    final java.lang.Object $requirements = this.getRequirements();
    result = result * PRIME + ($requirements == null ? 43 : $requirements.hashCode());
    final java.lang.Object $ssnLast4Provided = this.getSsnLast4Provided();
    result = result * PRIME + ($ssnLast4Provided == null ? 43 : $ssnLast4Provided.hashCode());
    final java.lang.Object $verification = this.getVerification();
    result = result * PRIME + ($verification == null ? 43 : $verification.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
