// Generated by delombok at Fri Nov 09 17:22:57 CET 2018
package com.stripe.model.issuing;

import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class Dispute extends ApiResource implements MetadataStore<Dispute>, HasId {
  String id;
  String object;
  Long amount;
  Long created;
  ExpandableField<Transaction> disputedTransaction;
  Evidence evidence;
  Boolean livemode;
  Map<String, String> metadata;
  String reason;
  String status;

  // <editor-fold desc="transaction">
  public String getDisputedTransaction() {
    return (this.disputedTransaction != null) ? this.disputedTransaction.getId() : null;
  }

  public void setDisputedTransaction(String disputedTransactionId) {
    this.disputedTransaction = setExpandableFieldId(disputedTransactionId, this.disputedTransaction);
  }

  public Transaction getDisputedTransactionObject() {
    return (this.disputedTransaction != null) ? this.disputedTransaction.getExpanded() : null;
  }

  public void setDisputedTransactionObject(Transaction c) {
    this.disputedTransaction = new ExpandableField<Transaction>(c.getId(), c);
  }

  // </editor-fold>
  // <editor-fold desc="create">
  /**
   * Create an issuing dispute.
   */
  public static Dispute create(Map<String, Object> params) throws StripeException {
    return create(params, null);
  }

  /**
   * Create an issuing dispute.
   */
  public static Dispute create(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, classUrl(Dispute.class), params, Dispute.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="list">
  /**
   * List all issuing disputes.
   */
  public static DisputeCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all issuing disputes.
   */
  public static DisputeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(Dispute.class), params, DisputeCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve an issuing dispute.
   */
  public static Dispute retrieve(String id) throws StripeException {
    return retrieve(id, null);
  }

  /**
   * Retrieve an issuing dispute.
   */
  public static Dispute retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve an issuing dispute.
   */
  public static Dispute retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(Dispute.class, id), params, Dispute.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="update">
  /**
   * Update an issuing dispute.
   */
  @Override
  public Dispute update(Map<String, Object> params) throws StripeException {
    return update(params, null);
  }

  /**
   * Update an issuing dispute.
   */
  @Override
  public Dispute update(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, instanceUrl(Dispute.class, this.id), params, Dispute.class, options);
  }

  // </editor-fold>
  public final class EvidenceFraudulent extends StripeObject {
    String disputeExplanation;
    String uncategorizedFile;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisputeExplanation() {
      return this.disputeExplanation;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUncategorizedFile() {
      return this.uncategorizedFile;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDisputeExplanation(final String disputeExplanation) {
      this.disputeExplanation = disputeExplanation;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUncategorizedFile(final String uncategorizedFile) {
      this.uncategorizedFile = uncategorizedFile;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Dispute.EvidenceFraudulent)) return false;
      final Dispute.EvidenceFraudulent other = (Dispute.EvidenceFraudulent) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$disputeExplanation = this.getDisputeExplanation();
      final java.lang.Object other$disputeExplanation = other.getDisputeExplanation();
      if (this$disputeExplanation == null ? other$disputeExplanation != null : !this$disputeExplanation.equals(other$disputeExplanation)) return false;
      final java.lang.Object this$uncategorizedFile = this.getUncategorizedFile();
      final java.lang.Object other$uncategorizedFile = other.getUncategorizedFile();
      if (this$uncategorizedFile == null ? other$uncategorizedFile != null : !this$uncategorizedFile.equals(other$uncategorizedFile)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Dispute.EvidenceFraudulent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $disputeExplanation = this.getDisputeExplanation();
      result = result * PRIME + ($disputeExplanation == null ? 43 : $disputeExplanation.hashCode());
      final java.lang.Object $uncategorizedFile = this.getUncategorizedFile();
      result = result * PRIME + ($uncategorizedFile == null ? 43 : $uncategorizedFile.hashCode());
      return result;
    }
  }


  public final class EvidenceOther extends StripeObject {
    String disputeExplanation;
    String uncategorizedFile;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisputeExplanation() {
      return this.disputeExplanation;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUncategorizedFile() {
      return this.uncategorizedFile;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDisputeExplanation(final String disputeExplanation) {
      this.disputeExplanation = disputeExplanation;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUncategorizedFile(final String uncategorizedFile) {
      this.uncategorizedFile = uncategorizedFile;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Dispute.EvidenceOther)) return false;
      final Dispute.EvidenceOther other = (Dispute.EvidenceOther) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$disputeExplanation = this.getDisputeExplanation();
      final java.lang.Object other$disputeExplanation = other.getDisputeExplanation();
      if (this$disputeExplanation == null ? other$disputeExplanation != null : !this$disputeExplanation.equals(other$disputeExplanation)) return false;
      final java.lang.Object this$uncategorizedFile = this.getUncategorizedFile();
      final java.lang.Object other$uncategorizedFile = other.getUncategorizedFile();
      if (this$uncategorizedFile == null ? other$uncategorizedFile != null : !this$uncategorizedFile.equals(other$uncategorizedFile)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Dispute.EvidenceOther;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $disputeExplanation = this.getDisputeExplanation();
      result = result * PRIME + ($disputeExplanation == null ? 43 : $disputeExplanation.hashCode());
      final java.lang.Object $uncategorizedFile = this.getUncategorizedFile();
      result = result * PRIME + ($uncategorizedFile == null ? 43 : $uncategorizedFile.hashCode());
      return result;
    }
  }


  public final class Evidence extends StripeObject {
    EvidenceFraudulent fraudulent;
    EvidenceOther other;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public EvidenceFraudulent getFraudulent() {
      return this.fraudulent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public EvidenceOther getOther() {
      return this.other;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFraudulent(final EvidenceFraudulent fraudulent) {
      this.fraudulent = fraudulent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOther(final EvidenceOther other) {
      this.other = other;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Dispute.Evidence)) return false;
      final Dispute.Evidence other = (Dispute.Evidence) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$fraudulent = this.getFraudulent();
      final java.lang.Object other$fraudulent = other.getFraudulent();
      if (this$fraudulent == null ? other$fraudulent != null : !this$fraudulent.equals(other$fraudulent)) return false;
      final java.lang.Object this$other = this.getOther();
      final java.lang.Object other$other = other.getOther();
      if (this$other == null ? other$other != null : !this$other.equals(other$other)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Dispute.Evidence;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $fraudulent = this.getFraudulent();
      result = result * PRIME + ($fraudulent == null ? 43 : $fraudulent.hashCode());
      final java.lang.Object $other = this.getOther();
      result = result * PRIME + ($other == null ? 43 : $other.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Evidence getEvidence() {
    return this.evidence;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReason() {
    return this.reason;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEvidence(final Evidence evidence) {
    this.evidence = evidence;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReason(final String reason) {
    this.reason = reason;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Dispute)) return false;
    final Dispute other = (Dispute) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$disputedTransaction = this.getDisputedTransaction();
    final java.lang.Object other$disputedTransaction = other.getDisputedTransaction();
    if (this$disputedTransaction == null ? other$disputedTransaction != null : !this$disputedTransaction.equals(other$disputedTransaction)) return false;
    final java.lang.Object this$evidence = this.getEvidence();
    final java.lang.Object other$evidence = other.getEvidence();
    if (this$evidence == null ? other$evidence != null : !this$evidence.equals(other$evidence)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$reason = this.getReason();
    final java.lang.Object other$reason = other.getReason();
    if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Dispute;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $disputedTransaction = this.getDisputedTransaction();
    result = result * PRIME + ($disputedTransaction == null ? 43 : $disputedTransaction.hashCode());
    final java.lang.Object $evidence = this.getEvidence();
    result = result * PRIME + ($evidence == null ? 43 : $evidence.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $reason = this.getReason();
    result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
