// Generated by delombok at Tue Nov 17 15:34:13 PST 2020
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.BalanceTransactionListParams;
import com.stripe.param.BalanceTransactionRetrieveParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class BalanceTransaction extends ApiResource implements HasId {
  /**
   * Gross amount of the transaction, in %s.
   */
  @SerializedName("amount")
  Long amount;
  /**
   * The date the transaction's net funds will become available in the Stripe balance.
   */
  @SerializedName("available_on")
  Long availableOn;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @SerializedName("description")
  String description;
  /**
   * The exchange rate used, if applicable, for this transaction. Specifically, if money was
   * converted from currency A to currency B, then the {@code amount} in currency A, times {@code
   * exchange_rate}, would be the {@code amount} in currency B. For example, suppose you charged a
   * customer 10.00 EUR. Then the PaymentIntent's {@code amount} would be {@code 1000} and {@code
   * currency} would be {@code eur}. Suppose this was converted into 12.34 USD in your Stripe
   * account. Then the BalanceTransaction's {@code amount} would be {@code 1234}, {@code currency}
   * would be {@code usd}, and {@code exchange_rate} would be {@code 1.234}.
   */
  @SerializedName("exchange_rate")
  BigDecimal exchangeRate;
  /**
   * Fees (in %s) paid for this transaction.
   */
  @SerializedName("fee")
  Long fee;
  /**
   * Detailed breakdown of fees (in %s) paid for this transaction.
   */
  @SerializedName("fee_details")
  List<BalanceTransaction.Fee> feeDetails;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Net amount of the transaction, in %s.
   */
  @SerializedName("net")
  Long net;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code balance_transaction}.
   */
  @SerializedName("object")
  String object;
  /**
   * <a href="https://stripe.com/docs/reports/reporting-categories">Learn more</a> about how
   * reporting categories can help you understand balance transactions from an accounting
   * perspective.
   */
  @SerializedName("reporting_category")
  String reportingCategory;
  /**
   * The Stripe object to which this transaction is related.
   */
  @SerializedName("source")
  ExpandableField<BalanceTransactionSource> source;
  /**
   * If the transaction's net funds are available in the Stripe balance yet. Either {@code
   * available} or {@code pending}.
   */
  @SerializedName("status")
  String status;
  /**
   * Transaction type: {@code adjustment}, {@code advance}, {@code advance_funding}, {@code
   * anticipation_repayment}, {@code application_fee}, {@code application_fee_refund}, {@code
   * charge}, {@code connect_collection_transfer}, {@code contribution}, {@code
   * issuing_authorization_hold}, {@code issuing_authorization_release}, {@code issuing_dispute},
   * {@code issuing_transaction}, {@code payment}, {@code payment_failure_refund}, {@code
   * payment_refund}, {@code payout}, {@code payout_cancel}, {@code payout_failure}, {@code refund},
   * {@code refund_failure}, {@code reserve_transaction}, {@code reserved_funds}, {@code
   * stripe_fee}, {@code stripe_fx_fee}, {@code tax_fee}, {@code topup}, {@code topup_reversal},
   * {@code transfer}, {@code transfer_cancel}, {@code transfer_failure}, or {@code
   * transfer_refund}. <a href="https://stripe.com/docs/reports/balance-transaction-types">Learn
   * more</a> about balance transaction types and what they represent. If you are looking to
   * classify transactions for accounting purposes, you might want to consider {@code
   * reporting_category} instead.
   *
   * <p>One of {@code adjustment}, {@code advance}, {@code advance_funding}, {@code
   * anticipation_repayment}, {@code application_fee}, {@code application_fee_refund}, {@code
   * charge}, {@code connect_collection_transfer}, {@code contribution}, {@code
   * issuing_authorization_hold}, {@code issuing_authorization_release}, {@code issuing_dispute},
   * {@code issuing_transaction}, {@code payment}, {@code payment_failure_refund}, {@code
   * payment_refund}, {@code payout}, {@code payout_cancel}, {@code payout_failure}, {@code refund},
   * {@code refund_failure}, {@code reserve_transaction}, {@code reserved_funds}, {@code
   * stripe_fee}, {@code stripe_fx_fee}, {@code tax_fee}, {@code topup}, {@code topup_reversal},
   * {@code transfer}, {@code transfer_cancel}, {@code transfer_failure}, or {@code
   * transfer_refund}.
   */
  @SerializedName("type")
  String type;

  /**
   * Get ID of expandable {@code source} object.
   */
  public String getSource() {
    return (this.source != null) ? this.source.getId() : null;
  }

  public void setSource(String id) {
    this.source = ApiResource.setExpandableFieldId(id, this.source);
  }

  /**
   * Get expanded {@code source}.
   */
  public BalanceTransactionSource getSourceObject() {
    return (this.source != null) ? this.source.getExpanded() : null;
  }

  public void setSourceObject(BalanceTransactionSource expandableObject) {
    this.source = new ExpandableField<BalanceTransactionSource>(expandableObject.getId(), expandableObject);
  }

  /**
   * Returns a list of transactions that have contributed to the Stripe account balance (e.g.,
   * charges, transfers, and so forth). The transactions are returned in sorted order, with the most
   * recent transactions appearing first.
   *
   * <p>Note that this endpoint was previously called “Balance history” and used the path <code>
   * /v1/balance/history</code>.
   */
  public static BalanceTransactionCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of transactions that have contributed to the Stripe account balance (e.g.,
   * charges, transfers, and so forth). The transactions are returned in sorted order, with the most
   * recent transactions appearing first.
   *
   * <p>Note that this endpoint was previously called “Balance history” and used the path <code>
   * /v1/balance/history</code>.
   */
  public static BalanceTransactionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/balance_transactions");
    return ApiResource.requestCollection(url, params, BalanceTransactionCollection.class, options);
  }

  /**
   * Returns a list of transactions that have contributed to the Stripe account balance (e.g.,
   * charges, transfers, and so forth). The transactions are returned in sorted order, with the most
   * recent transactions appearing first.
   *
   * <p>Note that this endpoint was previously called “Balance history” and used the path <code>
   * /v1/balance/history</code>.
   */
  public static BalanceTransactionCollection list(BalanceTransactionListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of transactions that have contributed to the Stripe account balance (e.g.,
   * charges, transfers, and so forth). The transactions are returned in sorted order, with the most
   * recent transactions appearing first.
   *
   * <p>Note that this endpoint was previously called “Balance history” and used the path <code>
   * /v1/balance/history</code>.
   */
  public static BalanceTransactionCollection list(BalanceTransactionListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/balance_transactions");
    return ApiResource.requestCollection(url, params, BalanceTransactionCollection.class, options);
  }

  /**
   * Retrieves the balance transaction with the given ID.
   *
   * <p>Note that this endpoint previously used the path <code>/v1/balance/history/:id</code>.
   */
  public static BalanceTransaction retrieve(String id) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the balance transaction with the given ID.
   *
   * <p>Note that this endpoint previously used the path <code>/v1/balance/history/:id</code>.
   */
  public static BalanceTransaction retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the balance transaction with the given ID.
   *
   * <p>Note that this endpoint previously used the path <code>/v1/balance/history/:id</code>.
   */
  public static BalanceTransaction retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/balance_transactions/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, BalanceTransaction.class, options);
  }

  /**
   * Retrieves the balance transaction with the given ID.
   *
   * <p>Note that this endpoint previously used the path <code>/v1/balance/history/:id</code>.
   */
  public static BalanceTransaction retrieve(String id, BalanceTransactionRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/balance_transactions/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, BalanceTransaction.class, options);
  }


  public static class Fee extends StripeObject {
    /** Amount of the fee, in cents. */
    @SerializedName("amount")
    Long amount;
    /** ID of the Connect application that earned the fee. */
    @SerializedName("application")
    String application;
    /**
     * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
     * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
     * currency</a>.
     */
    @SerializedName("currency")
    String currency;
    /** An arbitrary string attached to the object. Often useful for displaying to users. */
    @SerializedName("description")
    String description;
    /** Type of the fee, one of: {@code application_fee}, {@code stripe_fee} or {@code tax}. */
    @SerializedName("type")
    String type;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApplication() {
      return this.application;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCurrency() {
      return this.currency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
      return this.description;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setApplication(final String application) {
      this.application = application;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrency(final String currency) {
      this.currency = currency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDescription(final String description) {
      this.description = description;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof BalanceTransaction.Fee)) return false;
      final BalanceTransaction.Fee other = (BalanceTransaction.Fee) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$application = this.getApplication();
      final java.lang.Object other$application = other.getApplication();
      if (this$application == null ? other$application != null : !this$application.equals(other$application)) return false;
      final java.lang.Object this$currency = this.getCurrency();
      final java.lang.Object other$currency = other.getCurrency();
      if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
      final java.lang.Object this$description = this.getDescription();
      final java.lang.Object other$description = other.getDescription();
      if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof BalanceTransaction.Fee;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $application = this.getApplication();
      result = result * PRIME + ($application == null ? 43 : $application.hashCode());
      final java.lang.Object $currency = this.getCurrency();
      result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
      final java.lang.Object $description = this.getDescription();
      result = result * PRIME + ($description == null ? 43 : $description.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }

  /**
   * Gross amount of the transaction, in %s.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * The date the transaction's net funds will become available in the Stripe balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAvailableOn() {
    return this.availableOn;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  /**
   * The exchange rate used, if applicable, for this transaction. Specifically, if money was
   * converted from currency A to currency B, then the {@code amount} in currency A, times {@code
   * exchange_rate}, would be the {@code amount} in currency B. For example, suppose you charged a
   * customer 10.00 EUR. Then the PaymentIntent's {@code amount} would be {@code 1000} and {@code
   * currency} would be {@code eur}. Suppose this was converted into 12.34 USD in your Stripe
   * account. Then the BalanceTransaction's {@code amount} would be {@code 1234}, {@code currency}
   * would be {@code usd}, and {@code exchange_rate} would be {@code 1.234}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getExchangeRate() {
    return this.exchangeRate;
  }

  /**
   * Fees (in %s) paid for this transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getFee() {
    return this.fee;
  }

  /**
   * Detailed breakdown of fees (in %s) paid for this transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<BalanceTransaction.Fee> getFeeDetails() {
    return this.feeDetails;
  }

  /**
   * Net amount of the transaction, in %s.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getNet() {
    return this.net;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code balance_transaction}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * <a href="https://stripe.com/docs/reports/reporting-categories">Learn more</a> about how
   * reporting categories can help you understand balance transactions from an accounting
   * perspective.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReportingCategory() {
    return this.reportingCategory;
  }

  /**
   * If the transaction's net funds are available in the Stripe balance yet. Either {@code
   * available} or {@code pending}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * Transaction type: {@code adjustment}, {@code advance}, {@code advance_funding}, {@code
   * anticipation_repayment}, {@code application_fee}, {@code application_fee_refund}, {@code
   * charge}, {@code connect_collection_transfer}, {@code contribution}, {@code
   * issuing_authorization_hold}, {@code issuing_authorization_release}, {@code issuing_dispute},
   * {@code issuing_transaction}, {@code payment}, {@code payment_failure_refund}, {@code
   * payment_refund}, {@code payout}, {@code payout_cancel}, {@code payout_failure}, {@code refund},
   * {@code refund_failure}, {@code reserve_transaction}, {@code reserved_funds}, {@code
   * stripe_fee}, {@code stripe_fx_fee}, {@code tax_fee}, {@code topup}, {@code topup_reversal},
   * {@code transfer}, {@code transfer_cancel}, {@code transfer_failure}, or {@code
   * transfer_refund}. <a href="https://stripe.com/docs/reports/balance-transaction-types">Learn
   * more</a> about balance transaction types and what they represent. If you are looking to
   * classify transactions for accounting purposes, you might want to consider {@code
   * reporting_category} instead.
   *
   * <p>One of {@code adjustment}, {@code advance}, {@code advance_funding}, {@code
   * anticipation_repayment}, {@code application_fee}, {@code application_fee_refund}, {@code
   * charge}, {@code connect_collection_transfer}, {@code contribution}, {@code
   * issuing_authorization_hold}, {@code issuing_authorization_release}, {@code issuing_dispute},
   * {@code issuing_transaction}, {@code payment}, {@code payment_failure_refund}, {@code
   * payment_refund}, {@code payout}, {@code payout_cancel}, {@code payout_failure}, {@code refund},
   * {@code refund_failure}, {@code reserve_transaction}, {@code reserved_funds}, {@code
   * stripe_fee}, {@code stripe_fx_fee}, {@code tax_fee}, {@code topup}, {@code topup_reversal},
   * {@code transfer}, {@code transfer_cancel}, {@code transfer_failure}, or {@code
   * transfer_refund}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * Gross amount of the transaction, in %s.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * The date the transaction's net funds will become available in the Stripe balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAvailableOn(final Long availableOn) {
    this.availableOn = availableOn;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * The exchange rate used, if applicable, for this transaction. Specifically, if money was
   * converted from currency A to currency B, then the {@code amount} in currency A, times {@code
   * exchange_rate}, would be the {@code amount} in currency B. For example, suppose you charged a
   * customer 10.00 EUR. Then the PaymentIntent's {@code amount} would be {@code 1000} and {@code
   * currency} would be {@code eur}. Suppose this was converted into 12.34 USD in your Stripe
   * account. Then the BalanceTransaction's {@code amount} would be {@code 1234}, {@code currency}
   * would be {@code usd}, and {@code exchange_rate} would be {@code 1.234}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExchangeRate(final BigDecimal exchangeRate) {
    this.exchangeRate = exchangeRate;
  }

  /**
   * Fees (in %s) paid for this transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFee(final Long fee) {
    this.fee = fee;
  }

  /**
   * Detailed breakdown of fees (in %s) paid for this transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFeeDetails(final List<BalanceTransaction.Fee> feeDetails) {
    this.feeDetails = feeDetails;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Net amount of the transaction, in %s.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNet(final Long net) {
    this.net = net;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code balance_transaction}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * <a href="https://stripe.com/docs/reports/reporting-categories">Learn more</a> about how
   * reporting categories can help you understand balance transactions from an accounting
   * perspective.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReportingCategory(final String reportingCategory) {
    this.reportingCategory = reportingCategory;
  }

  /**
   * If the transaction's net funds are available in the Stripe balance yet. Either {@code
   * available} or {@code pending}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * Transaction type: {@code adjustment}, {@code advance}, {@code advance_funding}, {@code
   * anticipation_repayment}, {@code application_fee}, {@code application_fee_refund}, {@code
   * charge}, {@code connect_collection_transfer}, {@code contribution}, {@code
   * issuing_authorization_hold}, {@code issuing_authorization_release}, {@code issuing_dispute},
   * {@code issuing_transaction}, {@code payment}, {@code payment_failure_refund}, {@code
   * payment_refund}, {@code payout}, {@code payout_cancel}, {@code payout_failure}, {@code refund},
   * {@code refund_failure}, {@code reserve_transaction}, {@code reserved_funds}, {@code
   * stripe_fee}, {@code stripe_fx_fee}, {@code tax_fee}, {@code topup}, {@code topup_reversal},
   * {@code transfer}, {@code transfer_cancel}, {@code transfer_failure}, or {@code
   * transfer_refund}. <a href="https://stripe.com/docs/reports/balance-transaction-types">Learn
   * more</a> about balance transaction types and what they represent. If you are looking to
   * classify transactions for accounting purposes, you might want to consider {@code
   * reporting_category} instead.
   *
   * <p>One of {@code adjustment}, {@code advance}, {@code advance_funding}, {@code
   * anticipation_repayment}, {@code application_fee}, {@code application_fee_refund}, {@code
   * charge}, {@code connect_collection_transfer}, {@code contribution}, {@code
   * issuing_authorization_hold}, {@code issuing_authorization_release}, {@code issuing_dispute},
   * {@code issuing_transaction}, {@code payment}, {@code payment_failure_refund}, {@code
   * payment_refund}, {@code payout}, {@code payout_cancel}, {@code payout_failure}, {@code refund},
   * {@code refund_failure}, {@code reserve_transaction}, {@code reserved_funds}, {@code
   * stripe_fee}, {@code stripe_fx_fee}, {@code tax_fee}, {@code topup}, {@code topup_reversal},
   * {@code transfer}, {@code transfer_cancel}, {@code transfer_failure}, or {@code
   * transfer_refund}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof BalanceTransaction)) return false;
    final BalanceTransaction other = (BalanceTransaction) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$availableOn = this.getAvailableOn();
    final java.lang.Object other$availableOn = other.getAvailableOn();
    if (this$availableOn == null ? other$availableOn != null : !this$availableOn.equals(other$availableOn)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$fee = this.getFee();
    final java.lang.Object other$fee = other.getFee();
    if (this$fee == null ? other$fee != null : !this$fee.equals(other$fee)) return false;
    final java.lang.Object this$net = this.getNet();
    final java.lang.Object other$net = other.getNet();
    if (this$net == null ? other$net != null : !this$net.equals(other$net)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$exchangeRate = this.getExchangeRate();
    final java.lang.Object other$exchangeRate = other.getExchangeRate();
    if (this$exchangeRate == null ? other$exchangeRate != null : !this$exchangeRate.equals(other$exchangeRate)) return false;
    final java.lang.Object this$feeDetails = this.getFeeDetails();
    final java.lang.Object other$feeDetails = other.getFeeDetails();
    if (this$feeDetails == null ? other$feeDetails != null : !this$feeDetails.equals(other$feeDetails)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$reportingCategory = this.getReportingCategory();
    final java.lang.Object other$reportingCategory = other.getReportingCategory();
    if (this$reportingCategory == null ? other$reportingCategory != null : !this$reportingCategory.equals(other$reportingCategory)) return false;
    final java.lang.Object this$source = this.getSource();
    final java.lang.Object other$source = other.getSource();
    if (this$source == null ? other$source != null : !this$source.equals(other$source)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof BalanceTransaction;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $availableOn = this.getAvailableOn();
    result = result * PRIME + ($availableOn == null ? 43 : $availableOn.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $fee = this.getFee();
    result = result * PRIME + ($fee == null ? 43 : $fee.hashCode());
    final java.lang.Object $net = this.getNet();
    result = result * PRIME + ($net == null ? 43 : $net.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $exchangeRate = this.getExchangeRate();
    result = result * PRIME + ($exchangeRate == null ? 43 : $exchangeRate.hashCode());
    final java.lang.Object $feeDetails = this.getFeeDetails();
    result = result * PRIME + ($feeDetails == null ? 43 : $feeDetails.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $reportingCategory = this.getReportingCategory();
    result = result * PRIME + ($reportingCategory == null ? 43 : $reportingCategory.hashCode());
    final java.lang.Object $source = this.getSource();
    result = result * PRIME + ($source == null ? 43 : $source.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
