// Generated by delombok at Tue Nov 17 18:17:00 PST 2020
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class Account extends ApiResource implements HasId, MetadataStore<Account> {
  String id;
  String object;
  BusinessProfile businessProfile;
  String businessType;
  Capabilities capabilities;
  Boolean chargesEnabled;
  Company company;
  String country;
  Long created;
  String defaultCurrency;
  Boolean deleted;
  Boolean detailsSubmitted;
  String email;
  ExternalAccountCollection externalAccounts;
  Person individual;
  LoginLinkCollection loginLinks;
  Map<String, String> metadata;
  Boolean payoutsEnabled;
  Requirements requirements;
  Settings settings;
  TosAcceptance tosAcceptance;
  String type;
  /**
   * The {@code business_logo_large} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  String businessLogoLarge;
  /**
   * The {@code business_logo} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  String businessLogo;
  /**
   * The {@code business_name} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  String businessName;
  /**
   * The {@code business_primary_color} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  String businessPrimaryColor;
  /**
   * The {@code business_url} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  String businessUrl;
  /**
   * The {@code currencies_supported} attribute.
   *
   * @deprecated Prefer using the {@link CountrySpec#getSupportedPaymentCurrencies()} method
   *     instead.
   * @see <a href="https://stripe.com/docs/upgrades#2016-03-07">API version 2016-03-07</a>
   */
  @Deprecated
  List<String> currenciesSupported;
  /**
   * The {@code decline_charge_on} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  DeclineChargeOn declineChargeOn;
  /**
   * The {@code debit_negative_balances} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  Boolean debitNegativeBalances;
  /**
   * The {@code keys} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  Keys keys;
  /**
   * The {@code legal_entity} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  LegalEntity legalEntity;
  /**
   * The {@code managed} attribute.
   *
   * @deprecated Prefer using the {@link #type} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2017-05-25">API version 2017-05-25</a>
   */
  @Deprecated
  Boolean managed;
  /**
   * The {@code mcc} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  String mcc;
  /**
   * The {@code payout_schedule} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  PayoutSchedule payoutSchedule;
  /**
   * The {@code payout_statement_descriptor} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  String payoutStatementDescriptor;
  /**
   * The {@code product_description} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  String productDescription;
  /**
   * The {@code statement_descriptor} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  String statementDescriptor;
  /**
   * The {@code support_address} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  Address supportAddress;
  /**
   * The {@code support_email} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  String supportEmail;
  /**
   * The {@code support_phone} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  String supportPhone;
  /**
   * The {@code support_url} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  String supportUrl;
  /**
   * The {@code transfers_enabled} attribute.
   *
   * @deprecated Prefer using the {@link #payoutsEnabled} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2017-04-06">API version 2017-04-06</a>
   */
  @Deprecated
  Boolean transfersEnabled;
  /**
   * The {@code transfer_schedule} attribute.
   *
   * @deprecated Prefer using the {@link #payoutSchedule} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2017-04-06">API version 2017-04-06</a>
   */
  @Deprecated
  TransferSchedule transferSchedule;
  /**
   * The {@code verification} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @Deprecated
  Verification verification;

  // <editor-fold desc="create">
  /**
   * Create an account.
   */
  public static Account create(Map<String, Object> params) throws StripeException {
    return create(params, null);
  }

  /**
   * Create an account.
   */
  public static Account create(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, classUrl(Account.class), params, Account.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="delete">
  /**
   * Delete an account.
   */
  public Account delete() throws StripeException {
    return delete(null, (RequestOptions) null);
  }

  /**
   * Delete an account.
   */
  public Account delete(RequestOptions options) throws StripeException {
    return delete(null, options);
  }

  /**
   * Delete an account.
   */
  public Account delete(Map<String, Object> params) throws StripeException {
    return delete(params, null);
  }

  /**
   * Delete an account.
   */
  public Account delete(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.DELETE, instanceUrl(Account.class, this.id), params, Account.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="list">
  /**
   * List all connected accounts.
   */
  public static AccountCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all connected accounts.
   */
  public static AccountCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(Account.class), params, AccountCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="persons">
  /**
   * List an account's persons.
   */
  public PersonCollection persons() throws StripeException {
    return persons(null, null);
  }

  /**
   * List an account's persons.
   */
  public PersonCollection persons(Map<String, Object> params) throws StripeException {
    return persons(params, null);
  }

  /**
   * List an account's persons.
   */
  public PersonCollection persons(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = instanceUrl(Account.class, this.getId()) + "/persons";
    return requestCollection(url, params, PersonCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="reject">
  /**
   * Reject an account.
   */
  public Account reject(Map<String, Object> params) throws StripeException {
    return reject(params, null);
  }

  /**
   * Reject an account.
   */
  public Account reject(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, String.format("%s/reject", instanceUrl(Account.class, this.getId())), params, Account.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve account details.
   */
  public static Account retrieve() throws StripeException {
    return retrieve((RequestOptions) null);
  }

  /**
   * Retrieve account details.
   */
  public static Account retrieve(RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, singleClassUrl(Account.class), null, Account.class, options);
  }

  /**
   * Retrieve account details.
   *
   * @param apiKeyOrAccountId If the parameter looks like an API key (starts with "sk_"), retrieve
   *     the account resource with no ID parameter set. Otherwise, use the String parameter as the
   *     account ID.
   * @deprecated This method will only accept account IDs in the next major version. If you call
   *     this method with API keys, use the {@link #retrieve(RequestOptions)} method instead.
   */
  @Deprecated
  public static Account retrieve(String apiKeyOrAccountId) throws StripeException {
    if (null == apiKeyOrAccountId || apiKeyOrAccountId.startsWith("sk_")) {
      return retrieve(RequestOptions.builder().setApiKey(apiKeyOrAccountId).build());
    } else {
      return retrieve(apiKeyOrAccountId, null);
    }
  }

  /**
   * Retrieve account details.
   */
  public static Account retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve account details.
   */
  public static Account retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(Account.class, id), params, Account.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="update">
  /**
   * Update an account.
   */
  @Override
  public Account update(Map<String, Object> params) throws StripeException {
    return update(params, null);
  }

  /**
   * Update an account.
   */
  @Override
  public Account update(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, instanceUrl(Account.class, this.id), params, Account.class, options);
  }

  // </editor-fold>
  public static class BusinessProfile extends StripeObject {
    String mcc;
    String name;
    String productDescription;
    Address supportAddress;
    String supportEmail;
    String supportPhone;
    String supportUrl;
    String url;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcc() {
      return this.mcc;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
      return this.name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getProductDescription() {
      return this.productDescription;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Address getSupportAddress() {
      return this.supportAddress;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSupportEmail() {
      return this.supportEmail;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSupportPhone() {
      return this.supportPhone;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSupportUrl() {
      return this.supportUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUrl() {
      return this.url;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMcc(final String mcc) {
      this.mcc = mcc;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
      this.name = name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setProductDescription(final String productDescription) {
      this.productDescription = productDescription;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSupportAddress(final Address supportAddress) {
      this.supportAddress = supportAddress;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSupportEmail(final String supportEmail) {
      this.supportEmail = supportEmail;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSupportPhone(final String supportPhone) {
      this.supportPhone = supportPhone;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSupportUrl(final String supportUrl) {
      this.supportUrl = supportUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUrl(final String url) {
      this.url = url;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.BusinessProfile)) return false;
      final Account.BusinessProfile other = (Account.BusinessProfile) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$mcc = this.getMcc();
      final java.lang.Object other$mcc = other.getMcc();
      if (this$mcc == null ? other$mcc != null : !this$mcc.equals(other$mcc)) return false;
      final java.lang.Object this$name = this.getName();
      final java.lang.Object other$name = other.getName();
      if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
      final java.lang.Object this$productDescription = this.getProductDescription();
      final java.lang.Object other$productDescription = other.getProductDescription();
      if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) return false;
      final java.lang.Object this$supportAddress = this.getSupportAddress();
      final java.lang.Object other$supportAddress = other.getSupportAddress();
      if (this$supportAddress == null ? other$supportAddress != null : !this$supportAddress.equals(other$supportAddress)) return false;
      final java.lang.Object this$supportEmail = this.getSupportEmail();
      final java.lang.Object other$supportEmail = other.getSupportEmail();
      if (this$supportEmail == null ? other$supportEmail != null : !this$supportEmail.equals(other$supportEmail)) return false;
      final java.lang.Object this$supportPhone = this.getSupportPhone();
      final java.lang.Object other$supportPhone = other.getSupportPhone();
      if (this$supportPhone == null ? other$supportPhone != null : !this$supportPhone.equals(other$supportPhone)) return false;
      final java.lang.Object this$supportUrl = this.getSupportUrl();
      final java.lang.Object other$supportUrl = other.getSupportUrl();
      if (this$supportUrl == null ? other$supportUrl != null : !this$supportUrl.equals(other$supportUrl)) return false;
      final java.lang.Object this$url = this.getUrl();
      final java.lang.Object other$url = other.getUrl();
      if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.BusinessProfile;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $mcc = this.getMcc();
      result = result * PRIME + ($mcc == null ? 43 : $mcc.hashCode());
      final java.lang.Object $name = this.getName();
      result = result * PRIME + ($name == null ? 43 : $name.hashCode());
      final java.lang.Object $productDescription = this.getProductDescription();
      result = result * PRIME + ($productDescription == null ? 43 : $productDescription.hashCode());
      final java.lang.Object $supportAddress = this.getSupportAddress();
      result = result * PRIME + ($supportAddress == null ? 43 : $supportAddress.hashCode());
      final java.lang.Object $supportEmail = this.getSupportEmail();
      result = result * PRIME + ($supportEmail == null ? 43 : $supportEmail.hashCode());
      final java.lang.Object $supportPhone = this.getSupportPhone();
      result = result * PRIME + ($supportPhone == null ? 43 : $supportPhone.hashCode());
      final java.lang.Object $supportUrl = this.getSupportUrl();
      result = result * PRIME + ($supportUrl == null ? 43 : $supportUrl.hashCode());
      final java.lang.Object $url = this.getUrl();
      result = result * PRIME + ($url == null ? 43 : $url.hashCode());
      return result;
    }
  }


  public static class Capabilities extends StripeObject {
    String cardPayments;
    String legacyPayments;
    String platformPayments;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCardPayments() {
      return this.cardPayments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLegacyPayments() {
      return this.legacyPayments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPlatformPayments() {
      return this.platformPayments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCardPayments(final String cardPayments) {
      this.cardPayments = cardPayments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLegacyPayments(final String legacyPayments) {
      this.legacyPayments = legacyPayments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPlatformPayments(final String platformPayments) {
      this.platformPayments = platformPayments;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.Capabilities)) return false;
      final Account.Capabilities other = (Account.Capabilities) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$cardPayments = this.getCardPayments();
      final java.lang.Object other$cardPayments = other.getCardPayments();
      if (this$cardPayments == null ? other$cardPayments != null : !this$cardPayments.equals(other$cardPayments)) return false;
      final java.lang.Object this$legacyPayments = this.getLegacyPayments();
      final java.lang.Object other$legacyPayments = other.getLegacyPayments();
      if (this$legacyPayments == null ? other$legacyPayments != null : !this$legacyPayments.equals(other$legacyPayments)) return false;
      final java.lang.Object this$platformPayments = this.getPlatformPayments();
      final java.lang.Object other$platformPayments = other.getPlatformPayments();
      if (this$platformPayments == null ? other$platformPayments != null : !this$platformPayments.equals(other$platformPayments)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.Capabilities;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $cardPayments = this.getCardPayments();
      result = result * PRIME + ($cardPayments == null ? 43 : $cardPayments.hashCode());
      final java.lang.Object $legacyPayments = this.getLegacyPayments();
      result = result * PRIME + ($legacyPayments == null ? 43 : $legacyPayments.hashCode());
      final java.lang.Object $platformPayments = this.getPlatformPayments();
      result = result * PRIME + ($platformPayments == null ? 43 : $platformPayments.hashCode());
      return result;
    }
  }


  public static class Company extends StripeObject {
    Address address;
    Person.JapanAddress addressKana;
    Person.JapanAddress addressKanji;
    Boolean directorsProvided;
    String name;
    String nameKana;
    String nameKanji;
    Boolean ownersProvided;
    String phone;
    Boolean taxIdProvided;
    String taxIdRegistrar;
    Boolean vatIdProvided;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Address getAddress() {
      return this.address;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Person.JapanAddress getAddressKana() {
      return this.addressKana;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Person.JapanAddress getAddressKanji() {
      return this.addressKanji;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getDirectorsProvided() {
      return this.directorsProvided;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
      return this.name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getNameKana() {
      return this.nameKana;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getNameKanji() {
      return this.nameKanji;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getOwnersProvided() {
      return this.ownersProvided;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPhone() {
      return this.phone;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getTaxIdProvided() {
      return this.taxIdProvided;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTaxIdRegistrar() {
      return this.taxIdRegistrar;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getVatIdProvided() {
      return this.vatIdProvided;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddress(final Address address) {
      this.address = address;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddressKana(final Person.JapanAddress addressKana) {
      this.addressKana = addressKana;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddressKanji(final Person.JapanAddress addressKanji) {
      this.addressKanji = addressKanji;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDirectorsProvided(final Boolean directorsProvided) {
      this.directorsProvided = directorsProvided;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
      this.name = name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNameKana(final String nameKana) {
      this.nameKana = nameKana;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNameKanji(final String nameKanji) {
      this.nameKanji = nameKanji;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOwnersProvided(final Boolean ownersProvided) {
      this.ownersProvided = ownersProvided;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPhone(final String phone) {
      this.phone = phone;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTaxIdProvided(final Boolean taxIdProvided) {
      this.taxIdProvided = taxIdProvided;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTaxIdRegistrar(final String taxIdRegistrar) {
      this.taxIdRegistrar = taxIdRegistrar;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVatIdProvided(final Boolean vatIdProvided) {
      this.vatIdProvided = vatIdProvided;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.Company)) return false;
      final Account.Company other = (Account.Company) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$address = this.getAddress();
      final java.lang.Object other$address = other.getAddress();
      if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
      final java.lang.Object this$addressKana = this.getAddressKana();
      final java.lang.Object other$addressKana = other.getAddressKana();
      if (this$addressKana == null ? other$addressKana != null : !this$addressKana.equals(other$addressKana)) return false;
      final java.lang.Object this$addressKanji = this.getAddressKanji();
      final java.lang.Object other$addressKanji = other.getAddressKanji();
      if (this$addressKanji == null ? other$addressKanji != null : !this$addressKanji.equals(other$addressKanji)) return false;
      final java.lang.Object this$directorsProvided = this.getDirectorsProvided();
      final java.lang.Object other$directorsProvided = other.getDirectorsProvided();
      if (this$directorsProvided == null ? other$directorsProvided != null : !this$directorsProvided.equals(other$directorsProvided)) return false;
      final java.lang.Object this$name = this.getName();
      final java.lang.Object other$name = other.getName();
      if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
      final java.lang.Object this$nameKana = this.getNameKana();
      final java.lang.Object other$nameKana = other.getNameKana();
      if (this$nameKana == null ? other$nameKana != null : !this$nameKana.equals(other$nameKana)) return false;
      final java.lang.Object this$nameKanji = this.getNameKanji();
      final java.lang.Object other$nameKanji = other.getNameKanji();
      if (this$nameKanji == null ? other$nameKanji != null : !this$nameKanji.equals(other$nameKanji)) return false;
      final java.lang.Object this$ownersProvided = this.getOwnersProvided();
      final java.lang.Object other$ownersProvided = other.getOwnersProvided();
      if (this$ownersProvided == null ? other$ownersProvided != null : !this$ownersProvided.equals(other$ownersProvided)) return false;
      final java.lang.Object this$phone = this.getPhone();
      final java.lang.Object other$phone = other.getPhone();
      if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) return false;
      final java.lang.Object this$taxIdProvided = this.getTaxIdProvided();
      final java.lang.Object other$taxIdProvided = other.getTaxIdProvided();
      if (this$taxIdProvided == null ? other$taxIdProvided != null : !this$taxIdProvided.equals(other$taxIdProvided)) return false;
      final java.lang.Object this$taxIdRegistrar = this.getTaxIdRegistrar();
      final java.lang.Object other$taxIdRegistrar = other.getTaxIdRegistrar();
      if (this$taxIdRegistrar == null ? other$taxIdRegistrar != null : !this$taxIdRegistrar.equals(other$taxIdRegistrar)) return false;
      final java.lang.Object this$vatIdProvided = this.getVatIdProvided();
      final java.lang.Object other$vatIdProvided = other.getVatIdProvided();
      if (this$vatIdProvided == null ? other$vatIdProvided != null : !this$vatIdProvided.equals(other$vatIdProvided)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.Company;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $address = this.getAddress();
      result = result * PRIME + ($address == null ? 43 : $address.hashCode());
      final java.lang.Object $addressKana = this.getAddressKana();
      result = result * PRIME + ($addressKana == null ? 43 : $addressKana.hashCode());
      final java.lang.Object $addressKanji = this.getAddressKanji();
      result = result * PRIME + ($addressKanji == null ? 43 : $addressKanji.hashCode());
      final java.lang.Object $directorsProvided = this.getDirectorsProvided();
      result = result * PRIME + ($directorsProvided == null ? 43 : $directorsProvided.hashCode());
      final java.lang.Object $name = this.getName();
      result = result * PRIME + ($name == null ? 43 : $name.hashCode());
      final java.lang.Object $nameKana = this.getNameKana();
      result = result * PRIME + ($nameKana == null ? 43 : $nameKana.hashCode());
      final java.lang.Object $nameKanji = this.getNameKanji();
      result = result * PRIME + ($nameKanji == null ? 43 : $nameKanji.hashCode());
      final java.lang.Object $ownersProvided = this.getOwnersProvided();
      result = result * PRIME + ($ownersProvided == null ? 43 : $ownersProvided.hashCode());
      final java.lang.Object $phone = this.getPhone();
      result = result * PRIME + ($phone == null ? 43 : $phone.hashCode());
      final java.lang.Object $taxIdProvided = this.getTaxIdProvided();
      result = result * PRIME + ($taxIdProvided == null ? 43 : $taxIdProvided.hashCode());
      final java.lang.Object $taxIdRegistrar = this.getTaxIdRegistrar();
      result = result * PRIME + ($taxIdRegistrar == null ? 43 : $taxIdRegistrar.hashCode());
      final java.lang.Object $vatIdProvided = this.getVatIdProvided();
      result = result * PRIME + ($vatIdProvided == null ? 43 : $vatIdProvided.hashCode());
      return result;
    }
  }


  public static class SettingsBranding extends StripeObject {
    ExpandableField<File> icon;
    ExpandableField<File> logo;
    String primaryColor;

    // <editor-fold desc="icon">
    public String getIcon() {
      return (this.icon != null) ? this.icon.getId() : null;
    }

    public void setIcon(String iconId) {
      this.icon = setExpandableFieldId(iconId, this.icon);
    }

    public File getIconObject() {
      return (this.icon != null) ? this.icon.getExpanded() : null;
    }

    public void setIconObject(File c) {
      this.icon = new ExpandableField<>(c.getId(), c);
    }

    // </editor-fold>
    // <editor-fold desc="logo">
    public String getLogo() {
      return (this.logo != null) ? this.logo.getId() : null;
    }

    public void setLogo(String logoId) {
      this.logo = setExpandableFieldId(logoId, this.logo);
    }

    public File getLogoObject() {
      return (this.logo != null) ? this.logo.getExpanded() : null;
    }

    public void setLogoObject(File c) {
      this.logo = new ExpandableField<>(c.getId(), c);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPrimaryColor() {
      return this.primaryColor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPrimaryColor(final String primaryColor) {
      this.primaryColor = primaryColor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.SettingsBranding)) return false;
      final Account.SettingsBranding other = (Account.SettingsBranding) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$icon = this.getIcon();
      final java.lang.Object other$icon = other.getIcon();
      if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) return false;
      final java.lang.Object this$logo = this.getLogo();
      final java.lang.Object other$logo = other.getLogo();
      if (this$logo == null ? other$logo != null : !this$logo.equals(other$logo)) return false;
      final java.lang.Object this$primaryColor = this.getPrimaryColor();
      final java.lang.Object other$primaryColor = other.getPrimaryColor();
      if (this$primaryColor == null ? other$primaryColor != null : !this$primaryColor.equals(other$primaryColor)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.SettingsBranding;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $icon = this.getIcon();
      result = result * PRIME + ($icon == null ? 43 : $icon.hashCode());
      final java.lang.Object $logo = this.getLogo();
      result = result * PRIME + ($logo == null ? 43 : $logo.hashCode());
      final java.lang.Object $primaryColor = this.getPrimaryColor();
      result = result * PRIME + ($primaryColor == null ? 43 : $primaryColor.hashCode());
      return result;
    }
    // </editor-fold>
  }


  public static class DeclineChargeOn extends StripeObject {
    Boolean avsFailure;
    Boolean cvcFailure;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getAvsFailure() {
      return this.avsFailure;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getCvcFailure() {
      return this.cvcFailure;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAvsFailure(final Boolean avsFailure) {
      this.avsFailure = avsFailure;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCvcFailure(final Boolean cvcFailure) {
      this.cvcFailure = cvcFailure;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.DeclineChargeOn)) return false;
      final Account.DeclineChargeOn other = (Account.DeclineChargeOn) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$avsFailure = this.getAvsFailure();
      final java.lang.Object other$avsFailure = other.getAvsFailure();
      if (this$avsFailure == null ? other$avsFailure != null : !this$avsFailure.equals(other$avsFailure)) return false;
      final java.lang.Object this$cvcFailure = this.getCvcFailure();
      final java.lang.Object other$cvcFailure = other.getCvcFailure();
      if (this$cvcFailure == null ? other$cvcFailure != null : !this$cvcFailure.equals(other$cvcFailure)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.DeclineChargeOn;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $avsFailure = this.getAvsFailure();
      result = result * PRIME + ($avsFailure == null ? 43 : $avsFailure.hashCode());
      final java.lang.Object $cvcFailure = this.getCvcFailure();
      result = result * PRIME + ($cvcFailure == null ? 43 : $cvcFailure.hashCode());
      return result;
    }
  }


  public static class PayoutSchedule extends StripeObject {
    Long delayDays;
    String interval;
    Long monthlyAnchor;
    String weeklyAnchor;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDelayDays() {
      return this.delayDays;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getInterval() {
      return this.interval;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMonthlyAnchor() {
      return this.monthlyAnchor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWeeklyAnchor() {
      return this.weeklyAnchor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDelayDays(final Long delayDays) {
      this.delayDays = delayDays;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setInterval(final String interval) {
      this.interval = interval;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMonthlyAnchor(final Long monthlyAnchor) {
      this.monthlyAnchor = monthlyAnchor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setWeeklyAnchor(final String weeklyAnchor) {
      this.weeklyAnchor = weeklyAnchor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.PayoutSchedule)) return false;
      final Account.PayoutSchedule other = (Account.PayoutSchedule) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$delayDays = this.getDelayDays();
      final java.lang.Object other$delayDays = other.getDelayDays();
      if (this$delayDays == null ? other$delayDays != null : !this$delayDays.equals(other$delayDays)) return false;
      final java.lang.Object this$interval = this.getInterval();
      final java.lang.Object other$interval = other.getInterval();
      if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) return false;
      final java.lang.Object this$monthlyAnchor = this.getMonthlyAnchor();
      final java.lang.Object other$monthlyAnchor = other.getMonthlyAnchor();
      if (this$monthlyAnchor == null ? other$monthlyAnchor != null : !this$monthlyAnchor.equals(other$monthlyAnchor)) return false;
      final java.lang.Object this$weeklyAnchor = this.getWeeklyAnchor();
      final java.lang.Object other$weeklyAnchor = other.getWeeklyAnchor();
      if (this$weeklyAnchor == null ? other$weeklyAnchor != null : !this$weeklyAnchor.equals(other$weeklyAnchor)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.PayoutSchedule;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $delayDays = this.getDelayDays();
      result = result * PRIME + ($delayDays == null ? 43 : $delayDays.hashCode());
      final java.lang.Object $interval = this.getInterval();
      result = result * PRIME + ($interval == null ? 43 : $interval.hashCode());
      final java.lang.Object $monthlyAnchor = this.getMonthlyAnchor();
      result = result * PRIME + ($monthlyAnchor == null ? 43 : $monthlyAnchor.hashCode());
      final java.lang.Object $weeklyAnchor = this.getWeeklyAnchor();
      result = result * PRIME + ($weeklyAnchor == null ? 43 : $weeklyAnchor.hashCode());
      return result;
    }
  }


  public static class Requirements extends StripeObject {
    Long currentDeadline;
    List<String> currentlyDue;
    String disabledReason;
    List<String> eventuallyDue;
    List<String> pastDue;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCurrentDeadline() {
      return this.currentDeadline;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getCurrentlyDue() {
      return this.currentlyDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisabledReason() {
      return this.disabledReason;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getEventuallyDue() {
      return this.eventuallyDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getPastDue() {
      return this.pastDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrentDeadline(final Long currentDeadline) {
      this.currentDeadline = currentDeadline;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrentlyDue(final List<String> currentlyDue) {
      this.currentlyDue = currentlyDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDisabledReason(final String disabledReason) {
      this.disabledReason = disabledReason;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEventuallyDue(final List<String> eventuallyDue) {
      this.eventuallyDue = eventuallyDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPastDue(final List<String> pastDue) {
      this.pastDue = pastDue;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.Requirements)) return false;
      final Account.Requirements other = (Account.Requirements) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$currentDeadline = this.getCurrentDeadline();
      final java.lang.Object other$currentDeadline = other.getCurrentDeadline();
      if (this$currentDeadline == null ? other$currentDeadline != null : !this$currentDeadline.equals(other$currentDeadline)) return false;
      final java.lang.Object this$currentlyDue = this.getCurrentlyDue();
      final java.lang.Object other$currentlyDue = other.getCurrentlyDue();
      if (this$currentlyDue == null ? other$currentlyDue != null : !this$currentlyDue.equals(other$currentlyDue)) return false;
      final java.lang.Object this$disabledReason = this.getDisabledReason();
      final java.lang.Object other$disabledReason = other.getDisabledReason();
      if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) return false;
      final java.lang.Object this$eventuallyDue = this.getEventuallyDue();
      final java.lang.Object other$eventuallyDue = other.getEventuallyDue();
      if (this$eventuallyDue == null ? other$eventuallyDue != null : !this$eventuallyDue.equals(other$eventuallyDue)) return false;
      final java.lang.Object this$pastDue = this.getPastDue();
      final java.lang.Object other$pastDue = other.getPastDue();
      if (this$pastDue == null ? other$pastDue != null : !this$pastDue.equals(other$pastDue)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.Requirements;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $currentDeadline = this.getCurrentDeadline();
      result = result * PRIME + ($currentDeadline == null ? 43 : $currentDeadline.hashCode());
      final java.lang.Object $currentlyDue = this.getCurrentlyDue();
      result = result * PRIME + ($currentlyDue == null ? 43 : $currentlyDue.hashCode());
      final java.lang.Object $disabledReason = this.getDisabledReason();
      result = result * PRIME + ($disabledReason == null ? 43 : $disabledReason.hashCode());
      final java.lang.Object $eventuallyDue = this.getEventuallyDue();
      result = result * PRIME + ($eventuallyDue == null ? 43 : $eventuallyDue.hashCode());
      final java.lang.Object $pastDue = this.getPastDue();
      result = result * PRIME + ($pastDue == null ? 43 : $pastDue.hashCode());
      return result;
    }
  }


  public static class SettingsCardPayments extends StripeObject {
    DeclineChargeOn declineOn;
    String statementDescriptorPrefix;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DeclineChargeOn getDeclineOn() {
      return this.declineOn;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptorPrefix() {
      return this.statementDescriptorPrefix;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDeclineOn(final DeclineChargeOn declineOn) {
      this.declineOn = declineOn;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptorPrefix(final String statementDescriptorPrefix) {
      this.statementDescriptorPrefix = statementDescriptorPrefix;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.SettingsCardPayments)) return false;
      final Account.SettingsCardPayments other = (Account.SettingsCardPayments) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$declineOn = this.getDeclineOn();
      final java.lang.Object other$declineOn = other.getDeclineOn();
      if (this$declineOn == null ? other$declineOn != null : !this$declineOn.equals(other$declineOn)) return false;
      final java.lang.Object this$statementDescriptorPrefix = this.getStatementDescriptorPrefix();
      final java.lang.Object other$statementDescriptorPrefix = other.getStatementDescriptorPrefix();
      if (this$statementDescriptorPrefix == null ? other$statementDescriptorPrefix != null : !this$statementDescriptorPrefix.equals(other$statementDescriptorPrefix)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.SettingsCardPayments;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $declineOn = this.getDeclineOn();
      result = result * PRIME + ($declineOn == null ? 43 : $declineOn.hashCode());
      final java.lang.Object $statementDescriptorPrefix = this.getStatementDescriptorPrefix();
      result = result * PRIME + ($statementDescriptorPrefix == null ? 43 : $statementDescriptorPrefix.hashCode());
      return result;
    }
  }


  public static class SettingsDashboard extends StripeObject {
    String displayName;
    String timezone;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisplayName() {
      return this.displayName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTimezone() {
      return this.timezone;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDisplayName(final String displayName) {
      this.displayName = displayName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTimezone(final String timezone) {
      this.timezone = timezone;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.SettingsDashboard)) return false;
      final Account.SettingsDashboard other = (Account.SettingsDashboard) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$displayName = this.getDisplayName();
      final java.lang.Object other$displayName = other.getDisplayName();
      if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
      final java.lang.Object this$timezone = this.getTimezone();
      final java.lang.Object other$timezone = other.getTimezone();
      if (this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.SettingsDashboard;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $displayName = this.getDisplayName();
      result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
      final java.lang.Object $timezone = this.getTimezone();
      result = result * PRIME + ($timezone == null ? 43 : $timezone.hashCode());
      return result;
    }
  }


  public static class SettingsPayments extends StripeObject {
    String statementDescriptor;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptor() {
      return this.statementDescriptor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptor(final String statementDescriptor) {
      this.statementDescriptor = statementDescriptor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.SettingsPayments)) return false;
      final Account.SettingsPayments other = (Account.SettingsPayments) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
      final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
      if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.SettingsPayments;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
      result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
      return result;
    }
  }


  public static class SettingsPayouts extends StripeObject {
    Boolean debitNegativeBalances;
    PayoutSchedule schedule;
    String statementDescriptor;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getDebitNegativeBalances() {
      return this.debitNegativeBalances;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PayoutSchedule getSchedule() {
      return this.schedule;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptor() {
      return this.statementDescriptor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDebitNegativeBalances(final Boolean debitNegativeBalances) {
      this.debitNegativeBalances = debitNegativeBalances;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSchedule(final PayoutSchedule schedule) {
      this.schedule = schedule;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptor(final String statementDescriptor) {
      this.statementDescriptor = statementDescriptor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.SettingsPayouts)) return false;
      final Account.SettingsPayouts other = (Account.SettingsPayouts) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$debitNegativeBalances = this.getDebitNegativeBalances();
      final java.lang.Object other$debitNegativeBalances = other.getDebitNegativeBalances();
      if (this$debitNegativeBalances == null ? other$debitNegativeBalances != null : !this$debitNegativeBalances.equals(other$debitNegativeBalances)) return false;
      final java.lang.Object this$schedule = this.getSchedule();
      final java.lang.Object other$schedule = other.getSchedule();
      if (this$schedule == null ? other$schedule != null : !this$schedule.equals(other$schedule)) return false;
      final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
      final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
      if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.SettingsPayouts;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $debitNegativeBalances = this.getDebitNegativeBalances();
      result = result * PRIME + ($debitNegativeBalances == null ? 43 : $debitNegativeBalances.hashCode());
      final java.lang.Object $schedule = this.getSchedule();
      result = result * PRIME + ($schedule == null ? 43 : $schedule.hashCode());
      final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
      result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
      return result;
    }
  }


  public static class Settings extends StripeObject {
    SettingsBranding branding;
    SettingsCardPayments cardPayments;
    SettingsDashboard dashboard;
    SettingsPayments payments;
    SettingsPayouts payouts;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SettingsBranding getBranding() {
      return this.branding;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SettingsCardPayments getCardPayments() {
      return this.cardPayments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SettingsDashboard getDashboard() {
      return this.dashboard;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SettingsPayments getPayments() {
      return this.payments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SettingsPayouts getPayouts() {
      return this.payouts;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBranding(final SettingsBranding branding) {
      this.branding = branding;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCardPayments(final SettingsCardPayments cardPayments) {
      this.cardPayments = cardPayments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDashboard(final SettingsDashboard dashboard) {
      this.dashboard = dashboard;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayments(final SettingsPayments payments) {
      this.payments = payments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayouts(final SettingsPayouts payouts) {
      this.payouts = payouts;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.Settings)) return false;
      final Account.Settings other = (Account.Settings) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$branding = this.getBranding();
      final java.lang.Object other$branding = other.getBranding();
      if (this$branding == null ? other$branding != null : !this$branding.equals(other$branding)) return false;
      final java.lang.Object this$cardPayments = this.getCardPayments();
      final java.lang.Object other$cardPayments = other.getCardPayments();
      if (this$cardPayments == null ? other$cardPayments != null : !this$cardPayments.equals(other$cardPayments)) return false;
      final java.lang.Object this$dashboard = this.getDashboard();
      final java.lang.Object other$dashboard = other.getDashboard();
      if (this$dashboard == null ? other$dashboard != null : !this$dashboard.equals(other$dashboard)) return false;
      final java.lang.Object this$payments = this.getPayments();
      final java.lang.Object other$payments = other.getPayments();
      if (this$payments == null ? other$payments != null : !this$payments.equals(other$payments)) return false;
      final java.lang.Object this$payouts = this.getPayouts();
      final java.lang.Object other$payouts = other.getPayouts();
      if (this$payouts == null ? other$payouts != null : !this$payouts.equals(other$payouts)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.Settings;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $branding = this.getBranding();
      result = result * PRIME + ($branding == null ? 43 : $branding.hashCode());
      final java.lang.Object $cardPayments = this.getCardPayments();
      result = result * PRIME + ($cardPayments == null ? 43 : $cardPayments.hashCode());
      final java.lang.Object $dashboard = this.getDashboard();
      result = result * PRIME + ($dashboard == null ? 43 : $dashboard.hashCode());
      final java.lang.Object $payments = this.getPayments();
      result = result * PRIME + ($payments == null ? 43 : $payments.hashCode());
      final java.lang.Object $payouts = this.getPayouts();
      result = result * PRIME + ($payouts == null ? 43 : $payouts.hashCode());
      return result;
    }
  }


  public static class TosAcceptance extends StripeObject {
    Long date;
    String ip;
    String userAgent;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDate() {
      return this.date;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIp() {
      return this.ip;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUserAgent() {
      return this.userAgent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDate(final Long date) {
      this.date = date;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIp(final String ip) {
      this.ip = ip;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUserAgent(final String userAgent) {
      this.userAgent = userAgent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.TosAcceptance)) return false;
      final Account.TosAcceptance other = (Account.TosAcceptance) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$date = this.getDate();
      final java.lang.Object other$date = other.getDate();
      if (this$date == null ? other$date != null : !this$date.equals(other$date)) return false;
      final java.lang.Object this$ip = this.getIp();
      final java.lang.Object other$ip = other.getIp();
      if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) return false;
      final java.lang.Object this$userAgent = this.getUserAgent();
      final java.lang.Object other$userAgent = other.getUserAgent();
      if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.TosAcceptance;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $date = this.getDate();
      result = result * PRIME + ($date == null ? 43 : $date.hashCode());
      final java.lang.Object $ip = this.getIp();
      result = result * PRIME + ($ip == null ? 43 : $ip.hashCode());
      final java.lang.Object $userAgent = this.getUserAgent();
      result = result * PRIME + ($userAgent == null ? 43 : $userAgent.hashCode());
      return result;
    }
  }


  @Deprecated
  public static class Keys extends StripeObject {
    String publishable;
    String secret;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPublishable() {
      return this.publishable;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSecret() {
      return this.secret;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPublishable(final String publishable) {
      this.publishable = publishable;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSecret(final String secret) {
      this.secret = secret;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.Keys)) return false;
      final Account.Keys other = (Account.Keys) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$publishable = this.getPublishable();
      final java.lang.Object other$publishable = other.getPublishable();
      if (this$publishable == null ? other$publishable != null : !this$publishable.equals(other$publishable)) return false;
      final java.lang.Object this$secret = this.getSecret();
      final java.lang.Object other$secret = other.getSecret();
      if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.Keys;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $publishable = this.getPublishable();
      result = result * PRIME + ($publishable == null ? 43 : $publishable.hashCode());
      final java.lang.Object $secret = this.getSecret();
      result = result * PRIME + ($secret == null ? 43 : $secret.hashCode());
      return result;
    }
  }


  @Deprecated
  public static class TransferSchedule extends StripeObject {
    Long delayDays;
    String interval;
    Long monthlyAnchor;
    String weeklyAnchor;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDelayDays() {
      return this.delayDays;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getInterval() {
      return this.interval;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMonthlyAnchor() {
      return this.monthlyAnchor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWeeklyAnchor() {
      return this.weeklyAnchor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDelayDays(final Long delayDays) {
      this.delayDays = delayDays;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setInterval(final String interval) {
      this.interval = interval;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMonthlyAnchor(final Long monthlyAnchor) {
      this.monthlyAnchor = monthlyAnchor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setWeeklyAnchor(final String weeklyAnchor) {
      this.weeklyAnchor = weeklyAnchor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.TransferSchedule)) return false;
      final Account.TransferSchedule other = (Account.TransferSchedule) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$delayDays = this.getDelayDays();
      final java.lang.Object other$delayDays = other.getDelayDays();
      if (this$delayDays == null ? other$delayDays != null : !this$delayDays.equals(other$delayDays)) return false;
      final java.lang.Object this$interval = this.getInterval();
      final java.lang.Object other$interval = other.getInterval();
      if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) return false;
      final java.lang.Object this$monthlyAnchor = this.getMonthlyAnchor();
      final java.lang.Object other$monthlyAnchor = other.getMonthlyAnchor();
      if (this$monthlyAnchor == null ? other$monthlyAnchor != null : !this$monthlyAnchor.equals(other$monthlyAnchor)) return false;
      final java.lang.Object this$weeklyAnchor = this.getWeeklyAnchor();
      final java.lang.Object other$weeklyAnchor = other.getWeeklyAnchor();
      if (this$weeklyAnchor == null ? other$weeklyAnchor != null : !this$weeklyAnchor.equals(other$weeklyAnchor)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.TransferSchedule;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $delayDays = this.getDelayDays();
      result = result * PRIME + ($delayDays == null ? 43 : $delayDays.hashCode());
      final java.lang.Object $interval = this.getInterval();
      result = result * PRIME + ($interval == null ? 43 : $interval.hashCode());
      final java.lang.Object $monthlyAnchor = this.getMonthlyAnchor();
      result = result * PRIME + ($monthlyAnchor == null ? 43 : $monthlyAnchor.hashCode());
      final java.lang.Object $weeklyAnchor = this.getWeeklyAnchor();
      result = result * PRIME + ($weeklyAnchor == null ? 43 : $weeklyAnchor.hashCode());
      return result;
    }
  }


  @Deprecated
  public static class Verification extends StripeObject {
    Boolean contacted;
    String disabledReason;
    Long dueBy;
    List<String> fieldsNeeded;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getContacted() {
      return this.contacted;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisabledReason() {
      return this.disabledReason;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDueBy() {
      return this.dueBy;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getFieldsNeeded() {
      return this.fieldsNeeded;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setContacted(final Boolean contacted) {
      this.contacted = contacted;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDisabledReason(final String disabledReason) {
      this.disabledReason = disabledReason;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDueBy(final Long dueBy) {
      this.dueBy = dueBy;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFieldsNeeded(final List<String> fieldsNeeded) {
      this.fieldsNeeded = fieldsNeeded;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.Verification)) return false;
      final Account.Verification other = (Account.Verification) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$contacted = this.getContacted();
      final java.lang.Object other$contacted = other.getContacted();
      if (this$contacted == null ? other$contacted != null : !this$contacted.equals(other$contacted)) return false;
      final java.lang.Object this$disabledReason = this.getDisabledReason();
      final java.lang.Object other$disabledReason = other.getDisabledReason();
      if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) return false;
      final java.lang.Object this$dueBy = this.getDueBy();
      final java.lang.Object other$dueBy = other.getDueBy();
      if (this$dueBy == null ? other$dueBy != null : !this$dueBy.equals(other$dueBy)) return false;
      final java.lang.Object this$fieldsNeeded = this.getFieldsNeeded();
      final java.lang.Object other$fieldsNeeded = other.getFieldsNeeded();
      if (this$fieldsNeeded == null ? other$fieldsNeeded != null : !this$fieldsNeeded.equals(other$fieldsNeeded)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.Verification;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $contacted = this.getContacted();
      result = result * PRIME + ($contacted == null ? 43 : $contacted.hashCode());
      final java.lang.Object $disabledReason = this.getDisabledReason();
      result = result * PRIME + ($disabledReason == null ? 43 : $disabledReason.hashCode());
      final java.lang.Object $dueBy = this.getDueBy();
      result = result * PRIME + ($dueBy == null ? 43 : $dueBy.hashCode());
      final java.lang.Object $fieldsNeeded = this.getFieldsNeeded();
      result = result * PRIME + ($fieldsNeeded == null ? 43 : $fieldsNeeded.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BusinessProfile getBusinessProfile() {
    return this.businessProfile;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBusinessType() {
    return this.businessType;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Capabilities getCapabilities() {
    return this.capabilities;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getChargesEnabled() {
    return this.chargesEnabled;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Company getCompany() {
    return this.company;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCountry() {
    return this.country;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDefaultCurrency() {
    return this.defaultCurrency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDetailsSubmitted() {
    return this.detailsSubmitted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEmail() {
    return this.email;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ExternalAccountCollection getExternalAccounts() {
    return this.externalAccounts;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Person getIndividual() {
    return this.individual;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LoginLinkCollection getLoginLinks() {
    return this.loginLinks;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getPayoutsEnabled() {
    return this.payoutsEnabled;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Requirements getRequirements() {
    return this.requirements;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Settings getSettings() {
    return this.settings;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TosAcceptance getTosAcceptance() {
    return this.tosAcceptance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * The {@code business_logo_large} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBusinessLogoLarge() {
    return this.businessLogoLarge;
  }

  /**
   * The {@code business_logo} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBusinessLogo() {
    return this.businessLogo;
  }

  /**
   * The {@code business_name} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBusinessName() {
    return this.businessName;
  }

  /**
   * The {@code business_primary_color} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBusinessPrimaryColor() {
    return this.businessPrimaryColor;
  }

  /**
   * The {@code business_url} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBusinessUrl() {
    return this.businessUrl;
  }

  /**
   * The {@code currencies_supported} attribute.
   *
   * @deprecated Prefer using the {@link CountrySpec#getSupportedPaymentCurrencies()} method
   *     instead.
   * @see <a href="https://stripe.com/docs/upgrades#2016-03-07">API version 2016-03-07</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getCurrenciesSupported() {
    return this.currenciesSupported;
  }

  /**
   * The {@code decline_charge_on} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DeclineChargeOn getDeclineChargeOn() {
    return this.declineChargeOn;
  }

  /**
   * The {@code debit_negative_balances} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDebitNegativeBalances() {
    return this.debitNegativeBalances;
  }

  /**
   * The {@code keys} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Keys getKeys() {
    return this.keys;
  }

  /**
   * The {@code legal_entity} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LegalEntity getLegalEntity() {
    return this.legalEntity;
  }

  /**
   * The {@code managed} attribute.
   *
   * @deprecated Prefer using the {@link #type} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2017-05-25">API version 2017-05-25</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getManaged() {
    return this.managed;
  }

  /**
   * The {@code mcc} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getMcc() {
    return this.mcc;
  }

  /**
   * The {@code payout_schedule} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PayoutSchedule getPayoutSchedule() {
    return this.payoutSchedule;
  }

  /**
   * The {@code payout_statement_descriptor} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPayoutStatementDescriptor() {
    return this.payoutStatementDescriptor;
  }

  /**
   * The {@code product_description} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getProductDescription() {
    return this.productDescription;
  }

  /**
   * The {@code statement_descriptor} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatementDescriptor() {
    return this.statementDescriptor;
  }

  /**
   * The {@code support_address} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Address getSupportAddress() {
    return this.supportAddress;
  }

  /**
   * The {@code support_email} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSupportEmail() {
    return this.supportEmail;
  }

  /**
   * The {@code support_phone} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSupportPhone() {
    return this.supportPhone;
  }

  /**
   * The {@code support_url} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSupportUrl() {
    return this.supportUrl;
  }

  /**
   * The {@code transfers_enabled} attribute.
   *
   * @deprecated Prefer using the {@link #payoutsEnabled} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2017-04-06">API version 2017-04-06</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getTransfersEnabled() {
    return this.transfersEnabled;
  }

  /**
   * The {@code transfer_schedule} attribute.
   *
   * @deprecated Prefer using the {@link #payoutSchedule} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2017-04-06">API version 2017-04-06</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TransferSchedule getTransferSchedule() {
    return this.transferSchedule;
  }

  /**
   * The {@code verification} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Verification getVerification() {
    return this.verification;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBusinessProfile(final BusinessProfile businessProfile) {
    this.businessProfile = businessProfile;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBusinessType(final String businessType) {
    this.businessType = businessType;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapabilities(final Capabilities capabilities) {
    this.capabilities = capabilities;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setChargesEnabled(final Boolean chargesEnabled) {
    this.chargesEnabled = chargesEnabled;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCompany(final Company company) {
    this.company = company;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCountry(final String country) {
    this.country = country;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDefaultCurrency(final String defaultCurrency) {
    this.defaultCurrency = defaultCurrency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDetailsSubmitted(final Boolean detailsSubmitted) {
    this.detailsSubmitted = detailsSubmitted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEmail(final String email) {
    this.email = email;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExternalAccounts(final ExternalAccountCollection externalAccounts) {
    this.externalAccounts = externalAccounts;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIndividual(final Person individual) {
    this.individual = individual;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLoginLinks(final LoginLinkCollection loginLinks) {
    this.loginLinks = loginLinks;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPayoutsEnabled(final Boolean payoutsEnabled) {
    this.payoutsEnabled = payoutsEnabled;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRequirements(final Requirements requirements) {
    this.requirements = requirements;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSettings(final Settings settings) {
    this.settings = settings;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTosAcceptance(final TosAcceptance tosAcceptance) {
    this.tosAcceptance = tosAcceptance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  /**
   * The {@code business_logo_large} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBusinessLogoLarge(final String businessLogoLarge) {
    this.businessLogoLarge = businessLogoLarge;
  }

  /**
   * The {@code business_logo} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBusinessLogo(final String businessLogo) {
    this.businessLogo = businessLogo;
  }

  /**
   * The {@code business_name} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBusinessName(final String businessName) {
    this.businessName = businessName;
  }

  /**
   * The {@code business_primary_color} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBusinessPrimaryColor(final String businessPrimaryColor) {
    this.businessPrimaryColor = businessPrimaryColor;
  }

  /**
   * The {@code business_url} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBusinessUrl(final String businessUrl) {
    this.businessUrl = businessUrl;
  }

  /**
   * The {@code currencies_supported} attribute.
   *
   * @deprecated Prefer using the {@link CountrySpec#getSupportedPaymentCurrencies()} method
   *     instead.
   * @see <a href="https://stripe.com/docs/upgrades#2016-03-07">API version 2016-03-07</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrenciesSupported(final List<String> currenciesSupported) {
    this.currenciesSupported = currenciesSupported;
  }

  /**
   * The {@code decline_charge_on} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeclineChargeOn(final DeclineChargeOn declineChargeOn) {
    this.declineChargeOn = declineChargeOn;
  }

  /**
   * The {@code debit_negative_balances} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDebitNegativeBalances(final Boolean debitNegativeBalances) {
    this.debitNegativeBalances = debitNegativeBalances;
  }

  /**
   * The {@code keys} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setKeys(final Keys keys) {
    this.keys = keys;
  }

  /**
   * The {@code legal_entity} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLegalEntity(final LegalEntity legalEntity) {
    this.legalEntity = legalEntity;
  }

  /**
   * The {@code managed} attribute.
   *
   * @deprecated Prefer using the {@link #type} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2017-05-25">API version 2017-05-25</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setManaged(final Boolean managed) {
    this.managed = managed;
  }

  /**
   * The {@code mcc} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMcc(final String mcc) {
    this.mcc = mcc;
  }

  /**
   * The {@code payout_schedule} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPayoutSchedule(final PayoutSchedule payoutSchedule) {
    this.payoutSchedule = payoutSchedule;
  }

  /**
   * The {@code payout_statement_descriptor} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPayoutStatementDescriptor(final String payoutStatementDescriptor) {
    this.payoutStatementDescriptor = payoutStatementDescriptor;
  }

  /**
   * The {@code product_description} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setProductDescription(final String productDescription) {
    this.productDescription = productDescription;
  }

  /**
   * The {@code statement_descriptor} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatementDescriptor(final String statementDescriptor) {
    this.statementDescriptor = statementDescriptor;
  }

  /**
   * The {@code support_address} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSupportAddress(final Address supportAddress) {
    this.supportAddress = supportAddress;
  }

  /**
   * The {@code support_email} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSupportEmail(final String supportEmail) {
    this.supportEmail = supportEmail;
  }

  /**
   * The {@code support_phone} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSupportPhone(final String supportPhone) {
    this.supportPhone = supportPhone;
  }

  /**
   * The {@code support_url} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSupportUrl(final String supportUrl) {
    this.supportUrl = supportUrl;
  }

  /**
   * The {@code transfers_enabled} attribute.
   *
   * @deprecated Prefer using the {@link #payoutsEnabled} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2017-04-06">API version 2017-04-06</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransfersEnabled(final Boolean transfersEnabled) {
    this.transfersEnabled = transfersEnabled;
  }

  /**
   * The {@code transfer_schedule} attribute.
   *
   * @deprecated Prefer using the {@link #payoutSchedule} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2017-04-06">API version 2017-04-06</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransferSchedule(final TransferSchedule transferSchedule) {
    this.transferSchedule = transferSchedule;
  }

  /**
   * The {@code verification} attribute.
   *
   * @see <a href="https://stripe.com/docs/upgrades#2019-02-19">API version 2019-02-19</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVerification(final Verification verification) {
    this.verification = verification;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Account)) return false;
    final Account other = (Account) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$businessProfile = this.getBusinessProfile();
    final java.lang.Object other$businessProfile = other.getBusinessProfile();
    if (this$businessProfile == null ? other$businessProfile != null : !this$businessProfile.equals(other$businessProfile)) return false;
    final java.lang.Object this$businessType = this.getBusinessType();
    final java.lang.Object other$businessType = other.getBusinessType();
    if (this$businessType == null ? other$businessType != null : !this$businessType.equals(other$businessType)) return false;
    final java.lang.Object this$capabilities = this.getCapabilities();
    final java.lang.Object other$capabilities = other.getCapabilities();
    if (this$capabilities == null ? other$capabilities != null : !this$capabilities.equals(other$capabilities)) return false;
    final java.lang.Object this$chargesEnabled = this.getChargesEnabled();
    final java.lang.Object other$chargesEnabled = other.getChargesEnabled();
    if (this$chargesEnabled == null ? other$chargesEnabled != null : !this$chargesEnabled.equals(other$chargesEnabled)) return false;
    final java.lang.Object this$company = this.getCompany();
    final java.lang.Object other$company = other.getCompany();
    if (this$company == null ? other$company != null : !this$company.equals(other$company)) return false;
    final java.lang.Object this$country = this.getCountry();
    final java.lang.Object other$country = other.getCountry();
    if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$defaultCurrency = this.getDefaultCurrency();
    final java.lang.Object other$defaultCurrency = other.getDefaultCurrency();
    if (this$defaultCurrency == null ? other$defaultCurrency != null : !this$defaultCurrency.equals(other$defaultCurrency)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$detailsSubmitted = this.getDetailsSubmitted();
    final java.lang.Object other$detailsSubmitted = other.getDetailsSubmitted();
    if (this$detailsSubmitted == null ? other$detailsSubmitted != null : !this$detailsSubmitted.equals(other$detailsSubmitted)) return false;
    final java.lang.Object this$email = this.getEmail();
    final java.lang.Object other$email = other.getEmail();
    if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
    final java.lang.Object this$externalAccounts = this.getExternalAccounts();
    final java.lang.Object other$externalAccounts = other.getExternalAccounts();
    if (this$externalAccounts == null ? other$externalAccounts != null : !this$externalAccounts.equals(other$externalAccounts)) return false;
    final java.lang.Object this$individual = this.getIndividual();
    final java.lang.Object other$individual = other.getIndividual();
    if (this$individual == null ? other$individual != null : !this$individual.equals(other$individual)) return false;
    final java.lang.Object this$loginLinks = this.getLoginLinks();
    final java.lang.Object other$loginLinks = other.getLoginLinks();
    if (this$loginLinks == null ? other$loginLinks != null : !this$loginLinks.equals(other$loginLinks)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$payoutsEnabled = this.getPayoutsEnabled();
    final java.lang.Object other$payoutsEnabled = other.getPayoutsEnabled();
    if (this$payoutsEnabled == null ? other$payoutsEnabled != null : !this$payoutsEnabled.equals(other$payoutsEnabled)) return false;
    final java.lang.Object this$requirements = this.getRequirements();
    final java.lang.Object other$requirements = other.getRequirements();
    if (this$requirements == null ? other$requirements != null : !this$requirements.equals(other$requirements)) return false;
    final java.lang.Object this$settings = this.getSettings();
    final java.lang.Object other$settings = other.getSettings();
    if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) return false;
    final java.lang.Object this$tosAcceptance = this.getTosAcceptance();
    final java.lang.Object other$tosAcceptance = other.getTosAcceptance();
    if (this$tosAcceptance == null ? other$tosAcceptance != null : !this$tosAcceptance.equals(other$tosAcceptance)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    final java.lang.Object this$businessLogoLarge = this.getBusinessLogoLarge();
    final java.lang.Object other$businessLogoLarge = other.getBusinessLogoLarge();
    if (this$businessLogoLarge == null ? other$businessLogoLarge != null : !this$businessLogoLarge.equals(other$businessLogoLarge)) return false;
    final java.lang.Object this$businessLogo = this.getBusinessLogo();
    final java.lang.Object other$businessLogo = other.getBusinessLogo();
    if (this$businessLogo == null ? other$businessLogo != null : !this$businessLogo.equals(other$businessLogo)) return false;
    final java.lang.Object this$businessName = this.getBusinessName();
    final java.lang.Object other$businessName = other.getBusinessName();
    if (this$businessName == null ? other$businessName != null : !this$businessName.equals(other$businessName)) return false;
    final java.lang.Object this$businessPrimaryColor = this.getBusinessPrimaryColor();
    final java.lang.Object other$businessPrimaryColor = other.getBusinessPrimaryColor();
    if (this$businessPrimaryColor == null ? other$businessPrimaryColor != null : !this$businessPrimaryColor.equals(other$businessPrimaryColor)) return false;
    final java.lang.Object this$businessUrl = this.getBusinessUrl();
    final java.lang.Object other$businessUrl = other.getBusinessUrl();
    if (this$businessUrl == null ? other$businessUrl != null : !this$businessUrl.equals(other$businessUrl)) return false;
    final java.lang.Object this$currenciesSupported = this.getCurrenciesSupported();
    final java.lang.Object other$currenciesSupported = other.getCurrenciesSupported();
    if (this$currenciesSupported == null ? other$currenciesSupported != null : !this$currenciesSupported.equals(other$currenciesSupported)) return false;
    final java.lang.Object this$declineChargeOn = this.getDeclineChargeOn();
    final java.lang.Object other$declineChargeOn = other.getDeclineChargeOn();
    if (this$declineChargeOn == null ? other$declineChargeOn != null : !this$declineChargeOn.equals(other$declineChargeOn)) return false;
    final java.lang.Object this$debitNegativeBalances = this.getDebitNegativeBalances();
    final java.lang.Object other$debitNegativeBalances = other.getDebitNegativeBalances();
    if (this$debitNegativeBalances == null ? other$debitNegativeBalances != null : !this$debitNegativeBalances.equals(other$debitNegativeBalances)) return false;
    final java.lang.Object this$keys = this.getKeys();
    final java.lang.Object other$keys = other.getKeys();
    if (this$keys == null ? other$keys != null : !this$keys.equals(other$keys)) return false;
    final java.lang.Object this$legalEntity = this.getLegalEntity();
    final java.lang.Object other$legalEntity = other.getLegalEntity();
    if (this$legalEntity == null ? other$legalEntity != null : !this$legalEntity.equals(other$legalEntity)) return false;
    final java.lang.Object this$managed = this.getManaged();
    final java.lang.Object other$managed = other.getManaged();
    if (this$managed == null ? other$managed != null : !this$managed.equals(other$managed)) return false;
    final java.lang.Object this$mcc = this.getMcc();
    final java.lang.Object other$mcc = other.getMcc();
    if (this$mcc == null ? other$mcc != null : !this$mcc.equals(other$mcc)) return false;
    final java.lang.Object this$payoutSchedule = this.getPayoutSchedule();
    final java.lang.Object other$payoutSchedule = other.getPayoutSchedule();
    if (this$payoutSchedule == null ? other$payoutSchedule != null : !this$payoutSchedule.equals(other$payoutSchedule)) return false;
    final java.lang.Object this$payoutStatementDescriptor = this.getPayoutStatementDescriptor();
    final java.lang.Object other$payoutStatementDescriptor = other.getPayoutStatementDescriptor();
    if (this$payoutStatementDescriptor == null ? other$payoutStatementDescriptor != null : !this$payoutStatementDescriptor.equals(other$payoutStatementDescriptor)) return false;
    final java.lang.Object this$productDescription = this.getProductDescription();
    final java.lang.Object other$productDescription = other.getProductDescription();
    if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) return false;
    final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
    final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
    if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
    final java.lang.Object this$supportAddress = this.getSupportAddress();
    final java.lang.Object other$supportAddress = other.getSupportAddress();
    if (this$supportAddress == null ? other$supportAddress != null : !this$supportAddress.equals(other$supportAddress)) return false;
    final java.lang.Object this$supportEmail = this.getSupportEmail();
    final java.lang.Object other$supportEmail = other.getSupportEmail();
    if (this$supportEmail == null ? other$supportEmail != null : !this$supportEmail.equals(other$supportEmail)) return false;
    final java.lang.Object this$supportPhone = this.getSupportPhone();
    final java.lang.Object other$supportPhone = other.getSupportPhone();
    if (this$supportPhone == null ? other$supportPhone != null : !this$supportPhone.equals(other$supportPhone)) return false;
    final java.lang.Object this$supportUrl = this.getSupportUrl();
    final java.lang.Object other$supportUrl = other.getSupportUrl();
    if (this$supportUrl == null ? other$supportUrl != null : !this$supportUrl.equals(other$supportUrl)) return false;
    final java.lang.Object this$transfersEnabled = this.getTransfersEnabled();
    final java.lang.Object other$transfersEnabled = other.getTransfersEnabled();
    if (this$transfersEnabled == null ? other$transfersEnabled != null : !this$transfersEnabled.equals(other$transfersEnabled)) return false;
    final java.lang.Object this$transferSchedule = this.getTransferSchedule();
    final java.lang.Object other$transferSchedule = other.getTransferSchedule();
    if (this$transferSchedule == null ? other$transferSchedule != null : !this$transferSchedule.equals(other$transferSchedule)) return false;
    final java.lang.Object this$verification = this.getVerification();
    final java.lang.Object other$verification = other.getVerification();
    if (this$verification == null ? other$verification != null : !this$verification.equals(other$verification)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Account;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $businessProfile = this.getBusinessProfile();
    result = result * PRIME + ($businessProfile == null ? 43 : $businessProfile.hashCode());
    final java.lang.Object $businessType = this.getBusinessType();
    result = result * PRIME + ($businessType == null ? 43 : $businessType.hashCode());
    final java.lang.Object $capabilities = this.getCapabilities();
    result = result * PRIME + ($capabilities == null ? 43 : $capabilities.hashCode());
    final java.lang.Object $chargesEnabled = this.getChargesEnabled();
    result = result * PRIME + ($chargesEnabled == null ? 43 : $chargesEnabled.hashCode());
    final java.lang.Object $company = this.getCompany();
    result = result * PRIME + ($company == null ? 43 : $company.hashCode());
    final java.lang.Object $country = this.getCountry();
    result = result * PRIME + ($country == null ? 43 : $country.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $defaultCurrency = this.getDefaultCurrency();
    result = result * PRIME + ($defaultCurrency == null ? 43 : $defaultCurrency.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $detailsSubmitted = this.getDetailsSubmitted();
    result = result * PRIME + ($detailsSubmitted == null ? 43 : $detailsSubmitted.hashCode());
    final java.lang.Object $email = this.getEmail();
    result = result * PRIME + ($email == null ? 43 : $email.hashCode());
    final java.lang.Object $externalAccounts = this.getExternalAccounts();
    result = result * PRIME + ($externalAccounts == null ? 43 : $externalAccounts.hashCode());
    final java.lang.Object $individual = this.getIndividual();
    result = result * PRIME + ($individual == null ? 43 : $individual.hashCode());
    final java.lang.Object $loginLinks = this.getLoginLinks();
    result = result * PRIME + ($loginLinks == null ? 43 : $loginLinks.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $payoutsEnabled = this.getPayoutsEnabled();
    result = result * PRIME + ($payoutsEnabled == null ? 43 : $payoutsEnabled.hashCode());
    final java.lang.Object $requirements = this.getRequirements();
    result = result * PRIME + ($requirements == null ? 43 : $requirements.hashCode());
    final java.lang.Object $settings = this.getSettings();
    result = result * PRIME + ($settings == null ? 43 : $settings.hashCode());
    final java.lang.Object $tosAcceptance = this.getTosAcceptance();
    result = result * PRIME + ($tosAcceptance == null ? 43 : $tosAcceptance.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    final java.lang.Object $businessLogoLarge = this.getBusinessLogoLarge();
    result = result * PRIME + ($businessLogoLarge == null ? 43 : $businessLogoLarge.hashCode());
    final java.lang.Object $businessLogo = this.getBusinessLogo();
    result = result * PRIME + ($businessLogo == null ? 43 : $businessLogo.hashCode());
    final java.lang.Object $businessName = this.getBusinessName();
    result = result * PRIME + ($businessName == null ? 43 : $businessName.hashCode());
    final java.lang.Object $businessPrimaryColor = this.getBusinessPrimaryColor();
    result = result * PRIME + ($businessPrimaryColor == null ? 43 : $businessPrimaryColor.hashCode());
    final java.lang.Object $businessUrl = this.getBusinessUrl();
    result = result * PRIME + ($businessUrl == null ? 43 : $businessUrl.hashCode());
    final java.lang.Object $currenciesSupported = this.getCurrenciesSupported();
    result = result * PRIME + ($currenciesSupported == null ? 43 : $currenciesSupported.hashCode());
    final java.lang.Object $declineChargeOn = this.getDeclineChargeOn();
    result = result * PRIME + ($declineChargeOn == null ? 43 : $declineChargeOn.hashCode());
    final java.lang.Object $debitNegativeBalances = this.getDebitNegativeBalances();
    result = result * PRIME + ($debitNegativeBalances == null ? 43 : $debitNegativeBalances.hashCode());
    final java.lang.Object $keys = this.getKeys();
    result = result * PRIME + ($keys == null ? 43 : $keys.hashCode());
    final java.lang.Object $legalEntity = this.getLegalEntity();
    result = result * PRIME + ($legalEntity == null ? 43 : $legalEntity.hashCode());
    final java.lang.Object $managed = this.getManaged();
    result = result * PRIME + ($managed == null ? 43 : $managed.hashCode());
    final java.lang.Object $mcc = this.getMcc();
    result = result * PRIME + ($mcc == null ? 43 : $mcc.hashCode());
    final java.lang.Object $payoutSchedule = this.getPayoutSchedule();
    result = result * PRIME + ($payoutSchedule == null ? 43 : $payoutSchedule.hashCode());
    final java.lang.Object $payoutStatementDescriptor = this.getPayoutStatementDescriptor();
    result = result * PRIME + ($payoutStatementDescriptor == null ? 43 : $payoutStatementDescriptor.hashCode());
    final java.lang.Object $productDescription = this.getProductDescription();
    result = result * PRIME + ($productDescription == null ? 43 : $productDescription.hashCode());
    final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
    result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
    final java.lang.Object $supportAddress = this.getSupportAddress();
    result = result * PRIME + ($supportAddress == null ? 43 : $supportAddress.hashCode());
    final java.lang.Object $supportEmail = this.getSupportEmail();
    result = result * PRIME + ($supportEmail == null ? 43 : $supportEmail.hashCode());
    final java.lang.Object $supportPhone = this.getSupportPhone();
    result = result * PRIME + ($supportPhone == null ? 43 : $supportPhone.hashCode());
    final java.lang.Object $supportUrl = this.getSupportUrl();
    result = result * PRIME + ($supportUrl == null ? 43 : $supportUrl.hashCode());
    final java.lang.Object $transfersEnabled = this.getTransfersEnabled();
    result = result * PRIME + ($transfersEnabled == null ? 43 : $transfersEnabled.hashCode());
    final java.lang.Object $transferSchedule = this.getTransferSchedule();
    result = result * PRIME + ($transferSchedule == null ? 43 : $transferSchedule.hashCode());
    final java.lang.Object $verification = this.getVerification();
    result = result * PRIME + ($verification == null ? 43 : $verification.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
