/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.stripe.model.EventData;
import com.stripe.model.EventDataClassLookup;
import com.stripe.model.StripeObject;
import com.stripe.model.StripeRawJsonObject;
import com.stripe.net.ApiResource;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EventDataDeserializer
implements JsonDeserializer<EventData> {
    private Object deserializeJsonPrimitive(JsonPrimitive element) {
        if (element.isBoolean()) {
            return element.getAsBoolean();
        }
        if (element.isNumber()) {
            return element.getAsNumber();
        }
        return element.getAsString();
    }

    private Object[] deserializeJsonArray(JsonArray arr) {
        Object[] elems = new Object[arr.size()];
        Iterator elemIter = arr.iterator();
        int i = 0;
        while (elemIter.hasNext()) {
            JsonElement elem = (JsonElement)elemIter.next();
            elems[i++] = this.deserializeJsonElement(elem);
        }
        return elems;
    }

    private Object deserializeJsonElement(JsonElement element) {
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonObject()) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            this.populateMapFromJsonObject(valueMap, element.getAsJsonObject());
            return valueMap;
        }
        if (element.isJsonPrimitive()) {
            return this.deserializeJsonPrimitive(element.getAsJsonPrimitive());
        }
        if (element.isJsonArray()) {
            return this.deserializeJsonArray(element.getAsJsonArray());
        }
        System.err.println("Unknown JSON element type for element " + element + ". If you're seeing this messaage, it's probably a bug in the Stripe Java library. Please contact us by email at support@stripe.com.");
        return null;
    }

    private void populateMapFromJsonObject(Map<String, Object> objMap, JsonObject jsonObject) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            objMap.put(key, this.deserializeJsonElement(element));
        }
    }

    public EventData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        EventData eventData = new EventData();
        JsonObject jsonObject = json.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if ("previous_attributes".equals(key)) {
                if (element.isJsonNull()) {
                    eventData.setPreviousAttributes(null);
                    continue;
                }
                if (!element.isJsonObject()) continue;
                HashMap<String, Object> previousAttributes = new HashMap<String, Object>();
                this.populateMapFromJsonObject(previousAttributes, element.getAsJsonObject());
                eventData.setPreviousAttributes(previousAttributes);
                continue;
            }
            if (!"object".equals(key)) continue;
            String type = element.getAsJsonObject().get("object").getAsString();
            Class<? extends StripeObject> cl = EventDataClassLookup.findClass(type);
            StripeObject object = (StripeObject)ApiResource.GSON.fromJson((JsonElement)entry.getValue(), cl != null ? cl : StripeRawJsonObject.class);
            eventData.setObject(object);
        }
        return eventData;
    }
}

