// Generated by delombok at Tue Nov 27 14:24:29 CET 2018
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class Card extends ExternalAccount {
  String addressCity;
  String addressCountry;
  String addressLine1;
  String addressLine1Check;
  String addressLine2;
  String addressState;
  String addressZip;
  String addressZipCheck;
  List<String> availablePayoutMethods;
  String brand;
  String country;
  String currency;
  String cvcCheck;
  Boolean defaultForCurrency;
  String dynamicLast4;
  Long expMonth;
  Long expYear;
  String fingerprint;
  String funding;
  String last4;
  String name;
  String recipient;
  String status;
  ThreeDSecure threeDSecure;
  String tokenizationMethod;
  Boolean deleted;
  // Please note that these field are for internal use only and are not typically returned
  // as part of standard API requests.
  String description;
  String iin;
  String issuer;
  /**
   * The {@code type} attribute.
   *
   * @deprecated Prefer using the {@code brand} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2014-06-13">API version 2014-06-13</a>
   */
  @Deprecated
  String type;

  // <editor-fold desc="delete">
  /**
   * Delete a card.
   */
  @Override
  public Card delete() throws StripeException {
    return delete((RequestOptions) null);
  }

  /**
   * Delete a card.
   */
  @Override
  public Card delete(RequestOptions options) throws StripeException {
    return request(RequestMethod.DELETE, this.getInstanceUrl(), null, Card.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="update">
  /**
   * Update a card.
   */
  @Override
  public Card update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Update a card.
   */
  @Override
  public Card update(Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.POST, this.getInstanceUrl(), params, Card.class, options);
  }

  // </editor-fold>
  @Override
  protected String getInstanceUrl() {
    String result = super.getInstanceUrl();
    if (result != null) {
      return result;
    } else if (this.getRecipient() != null) {
      return String.format("%s/%s/cards/%s", classUrl(Recipient.class), this.getRecipient(), this.getId());
    } else {
      return null;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAddressCity() {
    return this.addressCity;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAddressCountry() {
    return this.addressCountry;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAddressLine1() {
    return this.addressLine1;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAddressLine1Check() {
    return this.addressLine1Check;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAddressLine2() {
    return this.addressLine2;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAddressState() {
    return this.addressState;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAddressZip() {
    return this.addressZip;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAddressZipCheck() {
    return this.addressZipCheck;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getAvailablePayoutMethods() {
    return this.availablePayoutMethods;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBrand() {
    return this.brand;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCountry() {
    return this.country;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCvcCheck() {
    return this.cvcCheck;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDefaultForCurrency() {
    return this.defaultForCurrency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDynamicLast4() {
    return this.dynamicLast4;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getExpMonth() {
    return this.expMonth;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getExpYear() {
    return this.expYear;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFingerprint() {
    return this.fingerprint;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFunding() {
    return this.funding;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLast4() {
    return this.last4;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getName() {
    return this.name;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getRecipient() {
    return this.recipient;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ThreeDSecure getThreeDSecure() {
    return this.threeDSecure;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTokenizationMethod() {
    return this.tokenizationMethod;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getIin() {
    return this.iin;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getIssuer() {
    return this.issuer;
  }

  /**
   * The {@code type} attribute.
   *
   * @deprecated Prefer using the {@code brand} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2014-06-13">API version 2014-06-13</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAddressCity(final String addressCity) {
    this.addressCity = addressCity;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAddressCountry(final String addressCountry) {
    this.addressCountry = addressCountry;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAddressLine1(final String addressLine1) {
    this.addressLine1 = addressLine1;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAddressLine1Check(final String addressLine1Check) {
    this.addressLine1Check = addressLine1Check;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAddressLine2(final String addressLine2) {
    this.addressLine2 = addressLine2;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAddressState(final String addressState) {
    this.addressState = addressState;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAddressZip(final String addressZip) {
    this.addressZip = addressZip;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAddressZipCheck(final String addressZipCheck) {
    this.addressZipCheck = addressZipCheck;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAvailablePayoutMethods(final List<String> availablePayoutMethods) {
    this.availablePayoutMethods = availablePayoutMethods;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBrand(final String brand) {
    this.brand = brand;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCountry(final String country) {
    this.country = country;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCvcCheck(final String cvcCheck) {
    this.cvcCheck = cvcCheck;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDefaultForCurrency(final Boolean defaultForCurrency) {
    this.defaultForCurrency = defaultForCurrency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDynamicLast4(final String dynamicLast4) {
    this.dynamicLast4 = dynamicLast4;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExpMonth(final Long expMonth) {
    this.expMonth = expMonth;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExpYear(final Long expYear) {
    this.expYear = expYear;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFingerprint(final String fingerprint) {
    this.fingerprint = fingerprint;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFunding(final String funding) {
    this.funding = funding;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLast4(final String last4) {
    this.last4 = last4;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setName(final String name) {
    this.name = name;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRecipient(final String recipient) {
    this.recipient = recipient;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setThreeDSecure(final ThreeDSecure threeDSecure) {
    this.threeDSecure = threeDSecure;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTokenizationMethod(final String tokenizationMethod) {
    this.tokenizationMethod = tokenizationMethod;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIin(final String iin) {
    this.iin = iin;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIssuer(final String issuer) {
    this.issuer = issuer;
  }

  /**
   * The {@code type} attribute.
   *
   * @deprecated Prefer using the {@code brand} attribute instead.
   * @see <a href="https://stripe.com/docs/upgrades#2014-06-13">API version 2014-06-13</a>
   */
  @java.lang.Deprecated
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Card)) return false;
    final Card other = (Card) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    final java.lang.Object this$addressCity = this.getAddressCity();
    final java.lang.Object other$addressCity = other.getAddressCity();
    if (this$addressCity == null ? other$addressCity != null : !this$addressCity.equals(other$addressCity)) return false;
    final java.lang.Object this$addressCountry = this.getAddressCountry();
    final java.lang.Object other$addressCountry = other.getAddressCountry();
    if (this$addressCountry == null ? other$addressCountry != null : !this$addressCountry.equals(other$addressCountry)) return false;
    final java.lang.Object this$addressLine1 = this.getAddressLine1();
    final java.lang.Object other$addressLine1 = other.getAddressLine1();
    if (this$addressLine1 == null ? other$addressLine1 != null : !this$addressLine1.equals(other$addressLine1)) return false;
    final java.lang.Object this$addressLine1Check = this.getAddressLine1Check();
    final java.lang.Object other$addressLine1Check = other.getAddressLine1Check();
    if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) return false;
    final java.lang.Object this$addressLine2 = this.getAddressLine2();
    final java.lang.Object other$addressLine2 = other.getAddressLine2();
    if (this$addressLine2 == null ? other$addressLine2 != null : !this$addressLine2.equals(other$addressLine2)) return false;
    final java.lang.Object this$addressState = this.getAddressState();
    final java.lang.Object other$addressState = other.getAddressState();
    if (this$addressState == null ? other$addressState != null : !this$addressState.equals(other$addressState)) return false;
    final java.lang.Object this$addressZip = this.getAddressZip();
    final java.lang.Object other$addressZip = other.getAddressZip();
    if (this$addressZip == null ? other$addressZip != null : !this$addressZip.equals(other$addressZip)) return false;
    final java.lang.Object this$addressZipCheck = this.getAddressZipCheck();
    final java.lang.Object other$addressZipCheck = other.getAddressZipCheck();
    if (this$addressZipCheck == null ? other$addressZipCheck != null : !this$addressZipCheck.equals(other$addressZipCheck)) return false;
    final java.lang.Object this$availablePayoutMethods = this.getAvailablePayoutMethods();
    final java.lang.Object other$availablePayoutMethods = other.getAvailablePayoutMethods();
    if (this$availablePayoutMethods == null ? other$availablePayoutMethods != null : !this$availablePayoutMethods.equals(other$availablePayoutMethods)) return false;
    final java.lang.Object this$brand = this.getBrand();
    final java.lang.Object other$brand = other.getBrand();
    if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) return false;
    final java.lang.Object this$country = this.getCountry();
    final java.lang.Object other$country = other.getCountry();
    if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$cvcCheck = this.getCvcCheck();
    final java.lang.Object other$cvcCheck = other.getCvcCheck();
    if (this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck)) return false;
    final java.lang.Object this$defaultForCurrency = this.getDefaultForCurrency();
    final java.lang.Object other$defaultForCurrency = other.getDefaultForCurrency();
    if (this$defaultForCurrency == null ? other$defaultForCurrency != null : !this$defaultForCurrency.equals(other$defaultForCurrency)) return false;
    final java.lang.Object this$dynamicLast4 = this.getDynamicLast4();
    final java.lang.Object other$dynamicLast4 = other.getDynamicLast4();
    if (this$dynamicLast4 == null ? other$dynamicLast4 != null : !this$dynamicLast4.equals(other$dynamicLast4)) return false;
    final java.lang.Object this$expMonth = this.getExpMonth();
    final java.lang.Object other$expMonth = other.getExpMonth();
    if (this$expMonth == null ? other$expMonth != null : !this$expMonth.equals(other$expMonth)) return false;
    final java.lang.Object this$expYear = this.getExpYear();
    final java.lang.Object other$expYear = other.getExpYear();
    if (this$expYear == null ? other$expYear != null : !this$expYear.equals(other$expYear)) return false;
    final java.lang.Object this$fingerprint = this.getFingerprint();
    final java.lang.Object other$fingerprint = other.getFingerprint();
    if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
    final java.lang.Object this$funding = this.getFunding();
    final java.lang.Object other$funding = other.getFunding();
    if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) return false;
    final java.lang.Object this$last4 = this.getLast4();
    final java.lang.Object other$last4 = other.getLast4();
    if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
    final java.lang.Object this$name = this.getName();
    final java.lang.Object other$name = other.getName();
    if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
    final java.lang.Object this$recipient = this.getRecipient();
    final java.lang.Object other$recipient = other.getRecipient();
    if (this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$threeDSecure = this.getThreeDSecure();
    final java.lang.Object other$threeDSecure = other.getThreeDSecure();
    if (this$threeDSecure == null ? other$threeDSecure != null : !this$threeDSecure.equals(other$threeDSecure)) return false;
    final java.lang.Object this$tokenizationMethod = this.getTokenizationMethod();
    final java.lang.Object other$tokenizationMethod = other.getTokenizationMethod();
    if (this$tokenizationMethod == null ? other$tokenizationMethod != null : !this$tokenizationMethod.equals(other$tokenizationMethod)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$iin = this.getIin();
    final java.lang.Object other$iin = other.getIin();
    if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) return false;
    final java.lang.Object this$issuer = this.getIssuer();
    final java.lang.Object other$issuer = other.getIssuer();
    if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Card;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    final java.lang.Object $addressCity = this.getAddressCity();
    result = result * PRIME + ($addressCity == null ? 43 : $addressCity.hashCode());
    final java.lang.Object $addressCountry = this.getAddressCountry();
    result = result * PRIME + ($addressCountry == null ? 43 : $addressCountry.hashCode());
    final java.lang.Object $addressLine1 = this.getAddressLine1();
    result = result * PRIME + ($addressLine1 == null ? 43 : $addressLine1.hashCode());
    final java.lang.Object $addressLine1Check = this.getAddressLine1Check();
    result = result * PRIME + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
    final java.lang.Object $addressLine2 = this.getAddressLine2();
    result = result * PRIME + ($addressLine2 == null ? 43 : $addressLine2.hashCode());
    final java.lang.Object $addressState = this.getAddressState();
    result = result * PRIME + ($addressState == null ? 43 : $addressState.hashCode());
    final java.lang.Object $addressZip = this.getAddressZip();
    result = result * PRIME + ($addressZip == null ? 43 : $addressZip.hashCode());
    final java.lang.Object $addressZipCheck = this.getAddressZipCheck();
    result = result * PRIME + ($addressZipCheck == null ? 43 : $addressZipCheck.hashCode());
    final java.lang.Object $availablePayoutMethods = this.getAvailablePayoutMethods();
    result = result * PRIME + ($availablePayoutMethods == null ? 43 : $availablePayoutMethods.hashCode());
    final java.lang.Object $brand = this.getBrand();
    result = result * PRIME + ($brand == null ? 43 : $brand.hashCode());
    final java.lang.Object $country = this.getCountry();
    result = result * PRIME + ($country == null ? 43 : $country.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $cvcCheck = this.getCvcCheck();
    result = result * PRIME + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
    final java.lang.Object $defaultForCurrency = this.getDefaultForCurrency();
    result = result * PRIME + ($defaultForCurrency == null ? 43 : $defaultForCurrency.hashCode());
    final java.lang.Object $dynamicLast4 = this.getDynamicLast4();
    result = result * PRIME + ($dynamicLast4 == null ? 43 : $dynamicLast4.hashCode());
    final java.lang.Object $expMonth = this.getExpMonth();
    result = result * PRIME + ($expMonth == null ? 43 : $expMonth.hashCode());
    final java.lang.Object $expYear = this.getExpYear();
    result = result * PRIME + ($expYear == null ? 43 : $expYear.hashCode());
    final java.lang.Object $fingerprint = this.getFingerprint();
    result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
    final java.lang.Object $funding = this.getFunding();
    result = result * PRIME + ($funding == null ? 43 : $funding.hashCode());
    final java.lang.Object $last4 = this.getLast4();
    result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
    final java.lang.Object $name = this.getName();
    result = result * PRIME + ($name == null ? 43 : $name.hashCode());
    final java.lang.Object $recipient = this.getRecipient();
    result = result * PRIME + ($recipient == null ? 43 : $recipient.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $threeDSecure = this.getThreeDSecure();
    result = result * PRIME + ($threeDSecure == null ? 43 : $threeDSecure.hashCode());
    final java.lang.Object $tokenizationMethod = this.getTokenizationMethod();
    result = result * PRIME + ($tokenizationMethod == null ? 43 : $tokenizationMethod.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $iin = this.getIin();
    result = result * PRIME + ($iin == null ? 43 : $iin.hashCode());
    final java.lang.Object $issuer = this.getIssuer();
    result = result * PRIME + ($issuer == null ? 43 : $issuer.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    return result;
  }
}
