/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.stripe.model.Account;
import com.stripe.model.AlipayAccount;
import com.stripe.model.ApplePayDomain;
import com.stripe.model.Application;
import com.stripe.model.ApplicationFee;
import com.stripe.model.Balance;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BankAccount;
import com.stripe.model.BitcoinReceiver;
import com.stripe.model.Card;
import com.stripe.model.Charge;
import com.stripe.model.CountrySpec;
import com.stripe.model.Coupon;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.Dispute;
import com.stripe.model.Event;
import com.stripe.model.EventData;
import com.stripe.model.ExchangeRate;
import com.stripe.model.FeeRefund;
import com.stripe.model.File;
import com.stripe.model.Invoice;
import com.stripe.model.InvoiceItem;
import com.stripe.model.InvoiceLineItem;
import com.stripe.model.Order;
import com.stripe.model.OrderItem;
import com.stripe.model.OrderReturn;
import com.stripe.model.PaymentIntent;
import com.stripe.model.Payout;
import com.stripe.model.Plan;
import com.stripe.model.Product;
import com.stripe.model.Recipient;
import com.stripe.model.Refund;
import com.stripe.model.Reversal;
import com.stripe.model.Review;
import com.stripe.model.Sku;
import com.stripe.model.Source;
import com.stripe.model.SourceMandateNotification;
import com.stripe.model.SourceTransaction;
import com.stripe.model.StripeObject;
import com.stripe.model.StripeRawJsonObject;
import com.stripe.model.Subscription;
import com.stripe.model.SubscriptionItem;
import com.stripe.model.ThreeDSecure;
import com.stripe.model.Token;
import com.stripe.model.Transfer;
import com.stripe.model.issuing.Authorization;
import com.stripe.model.issuing.CardDetails;
import com.stripe.model.issuing.Cardholder;
import com.stripe.model.issuing.Transaction;
import com.stripe.model.radar.ValueList;
import com.stripe.model.radar.ValueListItem;
import com.stripe.model.reporting.ReportRun;
import com.stripe.model.reporting.ReportType;
import com.stripe.model.sigma.ScheduledQueryRun;
import com.stripe.model.terminal.ConnectionToken;
import com.stripe.model.terminal.Location;
import com.stripe.model.terminal.Reader;
import com.stripe.net.ApiResource;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EventDataDeserializer
implements JsonDeserializer<EventData> {
    static final Map<String, Class<? extends StripeObject>> objectMap = new HashMap<String, Class<? extends StripeObject>>();

    private Object deserializeJsonPrimitive(JsonPrimitive element) {
        if (element.isBoolean()) {
            return element.getAsBoolean();
        }
        if (element.isNumber()) {
            return element.getAsNumber();
        }
        return element.getAsString();
    }

    private Object[] deserializeJsonArray(JsonArray arr) {
        Object[] elems = new Object[arr.size()];
        Iterator elemIter = arr.iterator();
        int i = 0;
        while (elemIter.hasNext()) {
            JsonElement elem = (JsonElement)elemIter.next();
            elems[i++] = this.deserializeJsonElement(elem);
        }
        return elems;
    }

    private Object deserializeJsonElement(JsonElement element) {
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonObject()) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            this.populateMapFromJsonObject(valueMap, element.getAsJsonObject());
            return valueMap;
        }
        if (element.isJsonPrimitive()) {
            return this.deserializeJsonPrimitive(element.getAsJsonPrimitive());
        }
        if (element.isJsonArray()) {
            return this.deserializeJsonArray(element.getAsJsonArray());
        }
        System.err.println("Unknown JSON element type for element " + element + ". If you're seeing this messaage, it's probably a bug in the Stripe Java library. Please contact us by email at support@stripe.com.");
        return null;
    }

    private void populateMapFromJsonObject(Map<String, Object> objMap, JsonObject jsonObject) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            objMap.put(key, this.deserializeJsonElement(element));
        }
    }

    public EventData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        EventData eventData = new EventData();
        JsonObject jsonObject = json.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if ("previous_attributes".equals(key)) {
                if (element.isJsonNull()) {
                    eventData.setPreviousAttributes(null);
                    continue;
                }
                if (!element.isJsonObject()) continue;
                HashMap<String, Object> previousAttributes = new HashMap<String, Object>();
                this.populateMapFromJsonObject(previousAttributes, element.getAsJsonObject());
                eventData.setPreviousAttributes(previousAttributes);
                continue;
            }
            if (!"object".equals(key)) continue;
            String type = element.getAsJsonObject().get("object").getAsString();
            Class<? extends StripeObject> cl = objectMap.get(type);
            StripeObject object = (StripeObject)ApiResource.GSON.fromJson((JsonElement)entry.getValue(), cl != null ? cl : StripeRawJsonObject.class);
            eventData.setObject(object);
        }
        return eventData;
    }

    static {
        objectMap.put("account", Account.class);
        objectMap.put("alipay_account", AlipayAccount.class);
        objectMap.put("apple_pay_domain", ApplePayDomain.class);
        objectMap.put("application", Application.class);
        objectMap.put("application_fee", ApplicationFee.class);
        objectMap.put("balance", Balance.class);
        objectMap.put("balance_transaction", BalanceTransaction.class);
        objectMap.put("bank_account", BankAccount.class);
        objectMap.put("bitcoin_receiver", BitcoinReceiver.class);
        objectMap.put("card", Card.class);
        objectMap.put("charge", Charge.class);
        objectMap.put("country_spec", CountrySpec.class);
        objectMap.put("coupon", Coupon.class);
        objectMap.put("customer", Customer.class);
        objectMap.put("discount", Discount.class);
        objectMap.put("dispute", Dispute.class);
        objectMap.put("event", Event.class);
        objectMap.put("exchange_rate", ExchangeRate.class);
        objectMap.put("fee", BalanceTransaction.Fee.class);
        objectMap.put("fee_refund", FeeRefund.class);
        objectMap.put("file", File.class);
        objectMap.put("file_upload", File.class);
        objectMap.put("invoice", Invoice.class);
        objectMap.put("invoice_line_item", InvoiceLineItem.class);
        objectMap.put("invoiceitem", InvoiceItem.class);
        objectMap.put("issuing.authorization", Authorization.class);
        objectMap.put("issuing.card", com.stripe.model.issuing.Card.class);
        objectMap.put("issuing.card_details", CardDetails.class);
        objectMap.put("issuing.cardholder", Cardholder.class);
        objectMap.put("issuing.dispute", com.stripe.model.issuing.Dispute.class);
        objectMap.put("issuing.transaction", Transaction.class);
        objectMap.put("order", Order.class);
        objectMap.put("order_item", OrderItem.class);
        objectMap.put("order_return", OrderReturn.class);
        objectMap.put("payment_intent", PaymentIntent.class);
        objectMap.put("payout", Payout.class);
        objectMap.put("plan", Plan.class);
        objectMap.put("product", Product.class);
        objectMap.put("radar.value_list", ValueList.class);
        objectMap.put("radar.value_list_item", ValueListItem.class);
        objectMap.put("reporting.report_run", ReportRun.class);
        objectMap.put("reporting.report_type", ReportType.class);
        objectMap.put("refund", Refund.class);
        objectMap.put("recipient", Recipient.class);
        objectMap.put("review", Review.class);
        objectMap.put("scheduled_query_run", ScheduledQueryRun.class);
        objectMap.put("sku", Sku.class);
        objectMap.put("source", Source.class);
        objectMap.put("source_mandate_notification", SourceMandateNotification.class);
        objectMap.put("source_transaction", SourceTransaction.class);
        objectMap.put("subscription", Subscription.class);
        objectMap.put("subscription_item", SubscriptionItem.class);
        objectMap.put("summary", Transfer.Summary.class);
        objectMap.put("terminal.connection_token", ConnectionToken.class);
        objectMap.put("terminal.location", Location.class);
        objectMap.put("terminal.reader", Reader.class);
        objectMap.put("three_d_secure", ThreeDSecure.class);
        objectMap.put("token", Token.class);
        objectMap.put("transfer", Transfer.class);
        objectMap.put("transfer_reversal", Reversal.class);
    }
}

