// Generated by delombok at Tue Mar 19 16:30:43 PDT 2019
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class File extends ApiResource implements HasId {
  String id;
  String object;
  Long created;
  String filename;
  FileLinkCollection links;
  String purpose;
  Long size;
  String title;
  String type;
  String url;

  // <editor-fold desc="create">
  /**
   * Create a file.
   */
  public static File create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Create a file.
   */
  public static File create(Map<String, Object> params, RequestOptions options) throws StripeException {
    return multipartRequest(RequestMethod.POST, classUrl(File.class, Stripe.getUploadBase()), params, File.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="list">
  /**
   * List all files.
   */
  public static FileCollection list(Map<String, Object> params) throws StripeException {
    return list(params, null);
  }

  /**
   * List all files.
   */
  public static FileCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    return requestCollection(classUrl(File.class), params, FileCollection.class, options);
  }

  // </editor-fold>
  // <editor-fold desc="retrieve">
  /**
   * Retrieve a file.
   */
  public static File retrieve(String id) throws StripeException {
    return retrieve(id, (RequestOptions) null);
  }

  /**
   * Retrieve a file.
   */
  public static File retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, null, options);
  }

  /**
   * Retrieve a file.
   */
  public static File retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    return request(RequestMethod.GET, instanceUrl(File.class, id), params, File.class, options);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFilename() {
    return this.filename;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public FileLinkCollection getLinks() {
    return this.links;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPurpose() {
    return this.purpose;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getSize() {
    return this.size;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTitle() {
    return this.title;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getUrl() {
    return this.url;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFilename(final String filename) {
    this.filename = filename;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLinks(final FileLinkCollection links) {
    this.links = links;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPurpose(final String purpose) {
    this.purpose = purpose;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSize(final Long size) {
    this.size = size;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTitle(final String title) {
    this.title = title;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUrl(final String url) {
    this.url = url;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof File)) return false;
    final File other = (File) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$filename = this.getFilename();
    final java.lang.Object other$filename = other.getFilename();
    if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) return false;
    final java.lang.Object this$links = this.getLinks();
    final java.lang.Object other$links = other.getLinks();
    if (this$links == null ? other$links != null : !this$links.equals(other$links)) return false;
    final java.lang.Object this$purpose = this.getPurpose();
    final java.lang.Object other$purpose = other.getPurpose();
    if (this$purpose == null ? other$purpose != null : !this$purpose.equals(other$purpose)) return false;
    final java.lang.Object this$size = this.getSize();
    final java.lang.Object other$size = other.getSize();
    if (this$size == null ? other$size != null : !this$size.equals(other$size)) return false;
    final java.lang.Object this$title = this.getTitle();
    final java.lang.Object other$title = other.getTitle();
    if (this$title == null ? other$title != null : !this$title.equals(other$title)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    final java.lang.Object this$url = this.getUrl();
    final java.lang.Object other$url = other.getUrl();
    if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof File;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $filename = this.getFilename();
    result = result * PRIME + ($filename == null ? 43 : $filename.hashCode());
    final java.lang.Object $links = this.getLinks();
    result = result * PRIME + ($links == null ? 43 : $links.hashCode());
    final java.lang.Object $purpose = this.getPurpose();
    result = result * PRIME + ($purpose == null ? 43 : $purpose.hashCode());
    final java.lang.Object $size = this.getSize();
    result = result * PRIME + ($size == null ? 43 : $size.hashCode());
    final java.lang.Object $title = this.getTitle();
    result = result * PRIME + ($title == null ? 43 : $title.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    final java.lang.Object $url = this.getUrl();
    result = result * PRIME + ($url == null ? 43 : $url.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
  // </editor-fold>
}
