// Generated by delombok at Wed Mar 20 11:18:04 PDT 2019
// Generated by com.stripe.generator.entity.SdkBuilder
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class PaymentIntent extends ApiResource implements HasId, MetadataStore<PaymentIntent> {
  /**
   * Amount intended to be collected by this PaymentIntent.
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Amount that can be captured from this PaymentIntent.
   */
  @SerializedName("amount_capturable")
  Long amountCapturable;
  /**
   * Amount that was collected by this PaymentIntent.
   */
  @SerializedName("amount_received")
  Long amountReceived;
  /**
   * ID of the Connect application that created the PaymentIntent.
   */
  @SerializedName("application")
  ExpandableField<Application> application;
  /**
   * The amount of the application fee (if any) for the resulting payment. See the PaymentIntents
   * [Connect usage guide](https://stripe.com/docs/payments/payment-intents/usage#connect) for
   * details.
   */
  @SerializedName("application_fee_amount")
  Long applicationFeeAmount;
  /**
   * Populated when `status` is `canceled`, this is the time at which the PaymentIntent was
   * canceled. Measured in seconds since the Unix epoch.
   */
  @SerializedName("canceled_at")
  Long canceledAt;
  /**
   * User-given reason for cancellation of this PaymentIntent, one of `duplicate`, `fraudulent`,
   * `requested_by_customer`, or `failed_invoice`.
   */
  @SerializedName("cancellation_reason")
  String cancellationReason;
  /**
   * Capture method of this PaymentIntent, one of `automatic` or `manual`.
   */
  @SerializedName("capture_method")
  String captureMethod;
  /**
   * Charges that were created by this PaymentIntent, if any.
   */
  @SerializedName("charges")
  ChargeCollection charges;
  /**
   * The client secret of this PaymentIntent. Used for client-side retrieval using a publishable
   * key. Please refer to [dynamic
   * authentication](https://stripe.com/docs/payments/dynamic-authentication) guide on how
   * `client_secret` should be handled.
   */
  @SerializedName("client_secret")
  String clientSecret;
  /**
   * Confirmation method of this PaymentIntent, one of `secret` or `publishable`.
   */
  @SerializedName("confirmation_method")
  String confirmationMethod;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in
   * lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  @SerializedName("currency")
  String currency;
  /**
   * ID of the Customer this PaymentIntent is for if one exists.
   */
  @SerializedName("customer")
  ExpandableField<Customer> customer;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @SerializedName("description")
  String description;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * The payment error encountered in the previous PaymentIntent confirmation.
   */
  @SerializedName("last_payment_error")
  StripeError lastPaymentError;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format. For more information, see the
   * [documentation](https://stripe.com/docs/payments/payment-intents/creating-payment-intents#storing-information-in-metadata).
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * If present, this property tells you what actions you need to take in order for your customer to
   * fulfill a payment using the provided source.
   */
  @SerializedName("next_action")
  NextAction nextAction;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @SerializedName("object")
  String object;
  /**
   * The account (if any) for which the funds of the PaymentIntent are intended. See the
   * PaymentIntents [Connect usage
   * guide](https://stripe.com/docs/payments/payment-intents/usage#connect) for details.
   */
  @SerializedName("on_behalf_of")
  ExpandableField<Account> onBehalfOf;
  /**
   * ID of the payment method used in this PaymentIntent.
   */
  @SerializedName("payment_method")
  ExpandableField<PaymentMethod> paymentMethod;
  /**
   * The list of payment method types (e.g. card) that this PaymentIntent is allowed to use.
   */
  @SerializedName("payment_method_types")
  List<String> paymentMethodTypes;
  /**
   * Email address that the receipt for the resulting payment will be sent to.
   */
  @SerializedName("receipt_email")
  String receiptEmail;
  /**
   * ID of the review associated with this PaymentIntent, if any.
   */
  @SerializedName("review")
  ExpandableField<Review> review;
  /**
   * Shipping information for this PaymentIntent.
   */
  @SerializedName("shipping")
  ShippingDetails shipping;
  /**
   * ID of the source used in this PaymentIntent.
   */
  @SerializedName("source")
  ExpandableField<PaymentSource> source;
  /**
   * Extra information about a PaymentIntent. This will appear on your customer's statement when
   * this PaymentIntent succeeds in creating a charge.
   */
  @SerializedName("statement_descriptor")
  String statementDescriptor;
  /**
   * Status of this PaymentIntent, one of `requires_payment_method`, `requires_confirmation`,
   * `requires_action`, `processing`, `requires_authorization`, `requires_capture`, `canceled`, or
   * `succeeded`.
   */
  @SerializedName("status")
  String status;
  /**
   * The data with which to automatically create a Transfer when the payment is finalized. See the
   * PaymentIntents [Connect usage
   * guide](https://stripe.com/docs/payments/payment-intents/usage#connect) for details.
   */
  @SerializedName("transfer_data")
  TransferData transferData;
  /**
   * A string that identifies the resulting payment as part of a group. See the PaymentIntents
   * [Connect usage guide](https://stripe.com/docs/payments/payment-intents/usage#connect) for
   * details.
   */
  @SerializedName("transfer_group")
  String transferGroup;

  /**
   * Get id of expandable `application` object.
   */
  public String getApplication() {
    return (this.application != null) ? this.application.getId() : null;
  }

  public void setApplication(String id) {
    this.application = ApiResource.setExpandableFieldId(id, this.application);
  }

  /**
   * Get expanded `application`.
   */
  public Application getApplicationObject() {
    return (this.application != null) ? this.application.getExpanded() : null;
  }

  public void setApplicationObject(Application expandableObject) {
    this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get id of expandable `customer` object.
   */
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String id) {
    this.customer = ApiResource.setExpandableFieldId(id, this.customer);
  }

  /**
   * Get expanded `customer`.
   */
  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer expandableObject) {
    this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get id of expandable `onBehalfOf` object.
   */
  public String getOnBehalfOf() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getId() : null;
  }

  public void setOnBehalfOf(String id) {
    this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
  }

  /**
   * Get expanded `onBehalfOf`.
   */
  public Account getOnBehalfOfObject() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getExpanded() : null;
  }

  public void setOnBehalfOfObject(Account expandableObject) {
    this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get id of expandable `paymentMethod` object.
   */
  public String getPaymentMethod() {
    return (this.paymentMethod != null) ? this.paymentMethod.getId() : null;
  }

  public void setPaymentMethod(String id) {
    this.paymentMethod = ApiResource.setExpandableFieldId(id, this.paymentMethod);
  }

  /**
   * Get expanded `paymentMethod`.
   */
  public PaymentMethod getPaymentMethodObject() {
    return (this.paymentMethod != null) ? this.paymentMethod.getExpanded() : null;
  }

  public void setPaymentMethodObject(PaymentMethod expandableObject) {
    this.paymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get id of expandable `review` object.
   */
  public String getReview() {
    return (this.review != null) ? this.review.getId() : null;
  }

  public void setReview(String id) {
    this.review = ApiResource.setExpandableFieldId(id, this.review);
  }

  /**
   * Get expanded `review`.
   */
  public Review getReviewObject() {
    return (this.review != null) ? this.review.getExpanded() : null;
  }

  public void setReviewObject(Review expandableObject) {
    this.review = new ExpandableField<Review>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get id of expandable `source` object.
   */
  public String getSource() {
    return (this.source != null) ? this.source.getId() : null;
  }

  public void setSource(String id) {
    this.source = ApiResource.setExpandableFieldId(id, this.source);
  }

  /**
   * Get expanded `source`.
   */
  public PaymentSource getSourceObject() {
    return (this.source != null) ? this.source.getExpanded() : null;
  }

  public void setSourceObject(PaymentSource expandableObject) {
    this.source = new ExpandableField<PaymentSource>(expandableObject.getId(), expandableObject);
  }

  /**
   * Creates a PaymentIntent object.
   */
  public static PaymentIntent create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a PaymentIntent object.
   */
  public static PaymentIntent create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
    return request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Returns a list of PaymentIntents.
   */
  public static PaymentIntentCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of PaymentIntents.
   */
  public static PaymentIntentCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
    return requestCollection(url, params, PaymentIntentCollection.class, options);
  }

  /**
   * Retrieves the details of a PaymentIntent that has previously been created.
   *
   * <p>Client-side retrieval using a publishable key is allowed when the <code>client_secret</code>
   * is provided in the query string.
   *
   * <p>When retrieved with a publishable key, only a subset of properties will be returned. Please
   * refer to the <a href="#payment_intent_object">payment intent</a> object reference for more
   * details.
   */
  public static PaymentIntent retrieve(String intent) throws StripeException {
    return retrieve(intent, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of a PaymentIntent that has previously been created.
   *
   * <p>Client-side retrieval using a publishable key is allowed when the <code>client_secret</code>
   * is provided in the query string.
   *
   * <p>When retrieved with a publishable key, only a subset of properties will be returned. Please
   * refer to the <a href="#payment_intent_object">payment intent</a> object reference for more
   * details.
   */
  public static PaymentIntent retrieve(String intent, RequestOptions options) throws StripeException {
    return retrieve(intent, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of a PaymentIntent that has previously been created.
   *
   * <p>Client-side retrieval using a publishable key is allowed when the <code>client_secret</code>
   * is provided in the query string.
   *
   * <p>When retrieved with a publishable key, only a subset of properties will be returned. Please
   * refer to the <a href="#payment_intent_object">payment intent</a> object reference for more
   * details.
   */
  public static PaymentIntent retrieve(String intent, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", intent));
    return request(ApiResource.RequestMethod.GET, url, params, PaymentIntent.class, options);
  }

  /**
   * Updates a PaymentIntent object.
   */
  public PaymentIntent update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates a PaymentIntent object.
   */
  public PaymentIntent update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", this.getId()));
    return request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Confirm that your customer intends to pay with current or provided <code>source</code>. Upon
   * confirmation, the PaymentIntent will attempt to initiate a payment.
   *
   * <p>If the selected <code>source</code> requires additional authentication steps, the
   * PaymentIntent will transition to the <code>requires_action</code> status and suggest additional
   * actions via <code>next_source_action</code>. If payment fails, the PaymentIntent will
   * transition to the <code>requires_payment_method</code> status. If payment succeeds, the
   * PaymentIntent will transition to the <code>succeeded</code> status (or <code>requires_capture
   * </code>, if <code>capture_method</code> is set to <code>manual</code>). Read the <a
   * href="/docs/payments/payment-intents/server-confirmation">expanded documentation</a> to learn
   * more about server-side confirmation.
   *
   * <p>When using a publishable key, the <a
   * href="#payment_intent_object-client_secret">client_secret</a> must be provided to confirm the
   * PaymentIntent.
   */
  public PaymentIntent confirm() throws StripeException {
    return confirm((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Confirm that your customer intends to pay with current or provided <code>source</code>. Upon
   * confirmation, the PaymentIntent will attempt to initiate a payment.
   *
   * <p>If the selected <code>source</code> requires additional authentication steps, the
   * PaymentIntent will transition to the <code>requires_action</code> status and suggest additional
   * actions via <code>next_source_action</code>. If payment fails, the PaymentIntent will
   * transition to the <code>requires_payment_method</code> status. If payment succeeds, the
   * PaymentIntent will transition to the <code>succeeded</code> status (or <code>requires_capture
   * </code>, if <code>capture_method</code> is set to <code>manual</code>). Read the <a
   * href="/docs/payments/payment-intents/server-confirmation">expanded documentation</a> to learn
   * more about server-side confirmation.
   *
   * <p>When using a publishable key, the <a
   * href="#payment_intent_object-client_secret">client_secret</a> must be provided to confirm the
   * PaymentIntent.
   */
  public PaymentIntent confirm(RequestOptions options) throws StripeException {
    return confirm((Map<String, Object>) null, options);
  }

  /**
   * Confirm that your customer intends to pay with current or provided <code>source</code>. Upon
   * confirmation, the PaymentIntent will attempt to initiate a payment.
   *
   * <p>If the selected <code>source</code> requires additional authentication steps, the
   * PaymentIntent will transition to the <code>requires_action</code> status and suggest additional
   * actions via <code>next_source_action</code>. If payment fails, the PaymentIntent will
   * transition to the <code>requires_payment_method</code> status. If payment succeeds, the
   * PaymentIntent will transition to the <code>succeeded</code> status (or <code>requires_capture
   * </code>, if <code>capture_method</code> is set to <code>manual</code>). Read the <a
   * href="/docs/payments/payment-intents/server-confirmation">expanded documentation</a> to learn
   * more about server-side confirmation.
   *
   * <p>When using a publishable key, the <a
   * href="#payment_intent_object-client_secret">client_secret</a> must be provided to confirm the
   * PaymentIntent.
   */
  public PaymentIntent confirm(Map<String, Object> params) throws StripeException {
    return confirm(params, (RequestOptions) null);
  }

  /**
   * Confirm that your customer intends to pay with current or provided <code>source</code>. Upon
   * confirmation, the PaymentIntent will attempt to initiate a payment.
   *
   * <p>If the selected <code>source</code> requires additional authentication steps, the
   * PaymentIntent will transition to the <code>requires_action</code> status and suggest additional
   * actions via <code>next_source_action</code>. If payment fails, the PaymentIntent will
   * transition to the <code>requires_payment_method</code> status. If payment succeeds, the
   * PaymentIntent will transition to the <code>succeeded</code> status (or <code>requires_capture
   * </code>, if <code>capture_method</code> is set to <code>manual</code>). Read the <a
   * href="/docs/payments/payment-intents/server-confirmation">expanded documentation</a> to learn
   * more about server-side confirmation.
   *
   * <p>When using a publishable key, the <a
   * href="#payment_intent_object-client_secret">client_secret</a> must be provided to confirm the
   * PaymentIntent.
   */
  public PaymentIntent confirm(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/confirm", this.getId()));
    return request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * A PaymentIntent object can be canceled when it is in one of these statuses:
   * requires_payment_method, requires_capture, requires_confirmation, requires_action.
   *
   * <p>Once canceled, no additional charges will be made by the PaymentIntent and any operations on
   * the PaymentIntent will fail with an error. For PaymentIntents with <code>
   * status='requires_capture'</code>, the remaining <code>amount_capturable</code> will
   * automatically be refunded.
   */
  public PaymentIntent cancel() throws StripeException {
    return cancel((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * A PaymentIntent object can be canceled when it is in one of these statuses:
   * requires_payment_method, requires_capture, requires_confirmation, requires_action.
   *
   * <p>Once canceled, no additional charges will be made by the PaymentIntent and any operations on
   * the PaymentIntent will fail with an error. For PaymentIntents with <code>
   * status='requires_capture'</code>, the remaining <code>amount_capturable</code> will
   * automatically be refunded.
   */
  public PaymentIntent cancel(RequestOptions options) throws StripeException {
    return cancel((Map<String, Object>) null, options);
  }

  /**
   * A PaymentIntent object can be canceled when it is in one of these statuses:
   * requires_payment_method, requires_capture, requires_confirmation, requires_action.
   *
   * <p>Once canceled, no additional charges will be made by the PaymentIntent and any operations on
   * the PaymentIntent will fail with an error. For PaymentIntents with <code>
   * status='requires_capture'</code>, the remaining <code>amount_capturable</code> will
   * automatically be refunded.
   */
  public PaymentIntent cancel(Map<String, Object> params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * A PaymentIntent object can be canceled when it is in one of these statuses:
   * requires_payment_method, requires_capture, requires_confirmation, requires_action.
   *
   * <p>Once canceled, no additional charges will be made by the PaymentIntent and any operations on
   * the PaymentIntent will fail with an error. For PaymentIntents with <code>
   * status='requires_capture'</code>, the remaining <code>amount_capturable</code> will
   * automatically be refunded.
   */
  public PaymentIntent cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/cancel", this.getId()));
    return request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Capture the funds of an existing uncaptured PaymentIntent where <code>
   * required_action="requires_capture"</code>.
   *
   * <p>Uncaptured PaymentIntents will be canceled exactly seven days after they are created.
   *
   * <p>Read the <a
   * href="/docs/payments/payment-intents/creating-payment-intents#separate-auth-capture">expanded
   * documentation</a> to learn more about separate authorization and capture.
   */
  public PaymentIntent capture() throws StripeException {
    return capture((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Capture the funds of an existing uncaptured PaymentIntent where <code>
   * required_action="requires_capture"</code>.
   *
   * <p>Uncaptured PaymentIntents will be canceled exactly seven days after they are created.
   *
   * <p>Read the <a
   * href="/docs/payments/payment-intents/creating-payment-intents#separate-auth-capture">expanded
   * documentation</a> to learn more about separate authorization and capture.
   */
  public PaymentIntent capture(RequestOptions options) throws StripeException {
    return capture((Map<String, Object>) null, options);
  }

  /**
   * Capture the funds of an existing uncaptured PaymentIntent where <code>
   * required_action="requires_capture"</code>.
   *
   * <p>Uncaptured PaymentIntents will be canceled exactly seven days after they are created.
   *
   * <p>Read the <a
   * href="/docs/payments/payment-intents/creating-payment-intents#separate-auth-capture">expanded
   * documentation</a> to learn more about separate authorization and capture.
   */
  public PaymentIntent capture(Map<String, Object> params) throws StripeException {
    return capture(params, (RequestOptions) null);
  }

  /**
   * Capture the funds of an existing uncaptured PaymentIntent where <code>
   * required_action="requires_capture"</code>.
   *
   * <p>Uncaptured PaymentIntents will be canceled exactly seven days after they are created.
   *
   * <p>Read the <a
   * href="/docs/payments/payment-intents/creating-payment-intents#separate-auth-capture">expanded
   * documentation</a> to learn more about separate authorization and capture.
   */
  public PaymentIntent capture(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/capture", this.getId()));
    return request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }


  public static class NextAction extends StripeObject {
    @SerializedName("redirect_to_url")
    NextActionRedirectToUrl redirectToUrl;
    /**
     * Type of the next action to perform, one of `redirect_to_url` or `use_stripe_sdk`.
     */
    @SerializedName("type")
    String type;
    /**
     * When confirming a PaymentIntent with Stripe.js, Stripe.js depends on the contents of this
     * dictionary to invoke authentication flows. The shape of the contents is subject to change and
     * is only intended to be used by Stripe.js.
     */
    @SerializedName("use_stripe_sdk")
    Map<String, Object> useStripeSdk;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NextActionRedirectToUrl getRedirectToUrl() {
      return this.redirectToUrl;
    }

    /**
     * Type of the next action to perform, one of `redirect_to_url` or `use_stripe_sdk`.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    /**
     * When confirming a PaymentIntent with Stripe.js, Stripe.js depends on the contents of this
     * dictionary to invoke authentication flows. The shape of the contents is subject to change and
     * is only intended to be used by Stripe.js.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getUseStripeSdk() {
      return this.useStripeSdk;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRedirectToUrl(final NextActionRedirectToUrl redirectToUrl) {
      this.redirectToUrl = redirectToUrl;
    }

    /**
     * Type of the next action to perform, one of `redirect_to_url` or `use_stripe_sdk`.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    /**
     * When confirming a PaymentIntent with Stripe.js, Stripe.js depends on the contents of this
     * dictionary to invoke authentication flows. The shape of the contents is subject to change and
     * is only intended to be used by Stripe.js.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUseStripeSdk(final Map<String, Object> useStripeSdk) {
      this.useStripeSdk = useStripeSdk;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.NextAction)) return false;
      final PaymentIntent.NextAction other = (PaymentIntent.NextAction) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$redirectToUrl = this.getRedirectToUrl();
      final java.lang.Object other$redirectToUrl = other.getRedirectToUrl();
      if (this$redirectToUrl == null ? other$redirectToUrl != null : !this$redirectToUrl.equals(other$redirectToUrl)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      final java.lang.Object this$useStripeSdk = this.getUseStripeSdk();
      final java.lang.Object other$useStripeSdk = other.getUseStripeSdk();
      if (this$useStripeSdk == null ? other$useStripeSdk != null : !this$useStripeSdk.equals(other$useStripeSdk)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.NextAction;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $redirectToUrl = this.getRedirectToUrl();
      result = result * PRIME + ($redirectToUrl == null ? 43 : $redirectToUrl.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      final java.lang.Object $useStripeSdk = this.getUseStripeSdk();
      result = result * PRIME + ($useStripeSdk == null ? 43 : $useStripeSdk.hashCode());
      return result;
    }
  }


  public static class NextActionRedirectToUrl extends StripeObject {
    /**
     * If the customer does not exit their browser while authenticating, they will be redirected to
     * this specified URL after completion.
     */
    @SerializedName("return_url")
    String returnUrl;
    /**
     * The URL you must redirect your customer to in order to authenticate the payment.
     */
    @SerializedName("url")
    String url;

    /**
     * If the customer does not exit their browser while authenticating, they will be redirected to
     * this specified URL after completion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReturnUrl() {
      return this.returnUrl;
    }

    /**
     * The URL you must redirect your customer to in order to authenticate the payment.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUrl() {
      return this.url;
    }

    /**
     * If the customer does not exit their browser while authenticating, they will be redirected to
     * this specified URL after completion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReturnUrl(final String returnUrl) {
      this.returnUrl = returnUrl;
    }

    /**
     * The URL you must redirect your customer to in order to authenticate the payment.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUrl(final String url) {
      this.url = url;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.NextActionRedirectToUrl)) return false;
      final PaymentIntent.NextActionRedirectToUrl other = (PaymentIntent.NextActionRedirectToUrl) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$returnUrl = this.getReturnUrl();
      final java.lang.Object other$returnUrl = other.getReturnUrl();
      if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) return false;
      final java.lang.Object this$url = this.getUrl();
      final java.lang.Object other$url = other.getUrl();
      if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.NextActionRedirectToUrl;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $returnUrl = this.getReturnUrl();
      result = result * PRIME + ($returnUrl == null ? 43 : $returnUrl.hashCode());
      final java.lang.Object $url = this.getUrl();
      result = result * PRIME + ($url == null ? 43 : $url.hashCode());
      return result;
    }
  }


  public static class TransferData extends StripeObject {
    /**
     * The account (if any) the payment will be attributed to for tax reporting, and where funds
     * from the payment will be transferred to upon payment success.
     */
    @SerializedName("destination")
    ExpandableField<Account> destination;

    /** Get id of expandable `destination` object. */
    public String getDestination() {
      return (this.destination != null) ? this.destination.getId() : null;
    }

    public void setDestination(String id) {
      this.destination = ApiResource.setExpandableFieldId(id, this.destination);
    }

    /** Get expanded `destination`. */
    public Account getDestinationObject() {
      return (this.destination != null) ? this.destination.getExpanded() : null;
    }

    public void setDestinationObject(Account expandableObject) {
      this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.TransferData)) return false;
      final PaymentIntent.TransferData other = (PaymentIntent.TransferData) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$destination = this.getDestination();
      final java.lang.Object other$destination = other.getDestination();
      if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.TransferData;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $destination = this.getDestination();
      result = result * PRIME + ($destination == null ? 43 : $destination.hashCode());
      return result;
    }
  }

  /**
   * Amount intended to be collected by this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Amount that can be captured from this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountCapturable() {
    return this.amountCapturable;
  }

  /**
   * Amount that was collected by this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountReceived() {
    return this.amountReceived;
  }

  /**
   * The amount of the application fee (if any) for the resulting payment. See the PaymentIntents
   * [Connect usage guide](https://stripe.com/docs/payments/payment-intents/usage#connect) for
   * details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getApplicationFeeAmount() {
    return this.applicationFeeAmount;
  }

  /**
   * Populated when `status` is `canceled`, this is the time at which the PaymentIntent was
   * canceled. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCanceledAt() {
    return this.canceledAt;
  }

  /**
   * User-given reason for cancellation of this PaymentIntent, one of `duplicate`, `fraudulent`,
   * `requested_by_customer`, or `failed_invoice`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCancellationReason() {
    return this.cancellationReason;
  }

  /**
   * Capture method of this PaymentIntent, one of `automatic` or `manual`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCaptureMethod() {
    return this.captureMethod;
  }

  /**
   * Charges that were created by this PaymentIntent, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ChargeCollection getCharges() {
    return this.charges;
  }

  /**
   * The client secret of this PaymentIntent. Used for client-side retrieval using a publishable
   * key. Please refer to [dynamic
   * authentication](https://stripe.com/docs/payments/dynamic-authentication) guide on how
   * `client_secret` should be handled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getClientSecret() {
    return this.clientSecret;
  }

  /**
   * Confirmation method of this PaymentIntent, one of `secret` or `publishable`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getConfirmationMethod() {
    return this.confirmationMethod;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in
   * lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  /**
   * The payment error encountered in the previous PaymentIntent confirmation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public StripeError getLastPaymentError() {
    return this.lastPaymentError;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * If present, this property tells you what actions you need to take in order for your customer to
   * fulfill a payment using the provided source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public NextAction getNextAction() {
    return this.nextAction;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The list of payment method types (e.g. card) that this PaymentIntent is allowed to use.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getPaymentMethodTypes() {
    return this.paymentMethodTypes;
  }

  /**
   * Email address that the receipt for the resulting payment will be sent to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReceiptEmail() {
    return this.receiptEmail;
  }

  /**
   * Shipping information for this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ShippingDetails getShipping() {
    return this.shipping;
  }

  /**
   * Extra information about a PaymentIntent. This will appear on your customer's statement when
   * this PaymentIntent succeeds in creating a charge.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatementDescriptor() {
    return this.statementDescriptor;
  }

  /**
   * Status of this PaymentIntent, one of `requires_payment_method`, `requires_confirmation`,
   * `requires_action`, `processing`, `requires_authorization`, `requires_capture`, `canceled`, or
   * `succeeded`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * The data with which to automatically create a Transfer when the payment is finalized. See the
   * PaymentIntents [Connect usage
   * guide](https://stripe.com/docs/payments/payment-intents/usage#connect) for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TransferData getTransferData() {
    return this.transferData;
  }

  /**
   * A string that identifies the resulting payment as part of a group. See the PaymentIntents
   * [Connect usage guide](https://stripe.com/docs/payments/payment-intents/usage#connect) for
   * details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTransferGroup() {
    return this.transferGroup;
  }

  /**
   * Amount intended to be collected by this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Amount that can be captured from this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountCapturable(final Long amountCapturable) {
    this.amountCapturable = amountCapturable;
  }

  /**
   * Amount that was collected by this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountReceived(final Long amountReceived) {
    this.amountReceived = amountReceived;
  }

  /**
   * The amount of the application fee (if any) for the resulting payment. See the PaymentIntents
   * [Connect usage guide](https://stripe.com/docs/payments/payment-intents/usage#connect) for
   * details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApplicationFeeAmount(final Long applicationFeeAmount) {
    this.applicationFeeAmount = applicationFeeAmount;
  }

  /**
   * Populated when `status` is `canceled`, this is the time at which the PaymentIntent was
   * canceled. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCanceledAt(final Long canceledAt) {
    this.canceledAt = canceledAt;
  }

  /**
   * User-given reason for cancellation of this PaymentIntent, one of `duplicate`, `fraudulent`,
   * `requested_by_customer`, or `failed_invoice`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCancellationReason(final String cancellationReason) {
    this.cancellationReason = cancellationReason;
  }

  /**
   * Capture method of this PaymentIntent, one of `automatic` or `manual`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCaptureMethod(final String captureMethod) {
    this.captureMethod = captureMethod;
  }

  /**
   * Charges that were created by this PaymentIntent, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCharges(final ChargeCollection charges) {
    this.charges = charges;
  }

  /**
   * The client secret of this PaymentIntent. Used for client-side retrieval using a publishable
   * key. Please refer to [dynamic
   * authentication](https://stripe.com/docs/payments/dynamic-authentication) guide on how
   * `client_secret` should be handled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setClientSecret(final String clientSecret) {
    this.clientSecret = clientSecret;
  }

  /**
   * Confirmation method of this PaymentIntent, one of `secret` or `publishable`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setConfirmationMethod(final String confirmationMethod) {
    this.confirmationMethod = confirmationMethod;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in
   * lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The payment error encountered in the previous PaymentIntent confirmation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLastPaymentError(final StripeError lastPaymentError) {
    this.lastPaymentError = lastPaymentError;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format. For more information, see the
   * [documentation](https://stripe.com/docs/payments/payment-intents/creating-payment-intents#storing-information-in-metadata).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * If present, this property tells you what actions you need to take in order for your customer to
   * fulfill a payment using the provided source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNextAction(final NextAction nextAction) {
    this.nextAction = nextAction;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The list of payment method types (e.g. card) that this PaymentIntent is allowed to use.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentMethodTypes(final List<String> paymentMethodTypes) {
    this.paymentMethodTypes = paymentMethodTypes;
  }

  /**
   * Email address that the receipt for the resulting payment will be sent to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReceiptEmail(final String receiptEmail) {
    this.receiptEmail = receiptEmail;
  }

  /**
   * Shipping information for this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setShipping(final ShippingDetails shipping) {
    this.shipping = shipping;
  }

  /**
   * Extra information about a PaymentIntent. This will appear on your customer's statement when
   * this PaymentIntent succeeds in creating a charge.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatementDescriptor(final String statementDescriptor) {
    this.statementDescriptor = statementDescriptor;
  }

  /**
   * Status of this PaymentIntent, one of `requires_payment_method`, `requires_confirmation`,
   * `requires_action`, `processing`, `requires_authorization`, `requires_capture`, `canceled`, or
   * `succeeded`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * The data with which to automatically create a Transfer when the payment is finalized. See the
   * PaymentIntents [Connect usage
   * guide](https://stripe.com/docs/payments/payment-intents/usage#connect) for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransferData(final TransferData transferData) {
    this.transferData = transferData;
  }

  /**
   * A string that identifies the resulting payment as part of a group. See the PaymentIntents
   * [Connect usage guide](https://stripe.com/docs/payments/payment-intents/usage#connect) for
   * details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransferGroup(final String transferGroup) {
    this.transferGroup = transferGroup;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof PaymentIntent)) return false;
    final PaymentIntent other = (PaymentIntent) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$amountCapturable = this.getAmountCapturable();
    final java.lang.Object other$amountCapturable = other.getAmountCapturable();
    if (this$amountCapturable == null ? other$amountCapturable != null : !this$amountCapturable.equals(other$amountCapturable)) return false;
    final java.lang.Object this$amountReceived = this.getAmountReceived();
    final java.lang.Object other$amountReceived = other.getAmountReceived();
    if (this$amountReceived == null ? other$amountReceived != null : !this$amountReceived.equals(other$amountReceived)) return false;
    final java.lang.Object this$application = this.getApplication();
    final java.lang.Object other$application = other.getApplication();
    if (this$application == null ? other$application != null : !this$application.equals(other$application)) return false;
    final java.lang.Object this$applicationFeeAmount = this.getApplicationFeeAmount();
    final java.lang.Object other$applicationFeeAmount = other.getApplicationFeeAmount();
    if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !this$applicationFeeAmount.equals(other$applicationFeeAmount)) return false;
    final java.lang.Object this$canceledAt = this.getCanceledAt();
    final java.lang.Object other$canceledAt = other.getCanceledAt();
    if (this$canceledAt == null ? other$canceledAt != null : !this$canceledAt.equals(other$canceledAt)) return false;
    final java.lang.Object this$cancellationReason = this.getCancellationReason();
    final java.lang.Object other$cancellationReason = other.getCancellationReason();
    if (this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason)) return false;
    final java.lang.Object this$captureMethod = this.getCaptureMethod();
    final java.lang.Object other$captureMethod = other.getCaptureMethod();
    if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) return false;
    final java.lang.Object this$charges = this.getCharges();
    final java.lang.Object other$charges = other.getCharges();
    if (this$charges == null ? other$charges != null : !this$charges.equals(other$charges)) return false;
    final java.lang.Object this$clientSecret = this.getClientSecret();
    final java.lang.Object other$clientSecret = other.getClientSecret();
    if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) return false;
    final java.lang.Object this$confirmationMethod = this.getConfirmationMethod();
    final java.lang.Object other$confirmationMethod = other.getConfirmationMethod();
    if (this$confirmationMethod == null ? other$confirmationMethod != null : !this$confirmationMethod.equals(other$confirmationMethod)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$lastPaymentError = this.getLastPaymentError();
    final java.lang.Object other$lastPaymentError = other.getLastPaymentError();
    if (this$lastPaymentError == null ? other$lastPaymentError != null : !this$lastPaymentError.equals(other$lastPaymentError)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$nextAction = this.getNextAction();
    final java.lang.Object other$nextAction = other.getNextAction();
    if (this$nextAction == null ? other$nextAction != null : !this$nextAction.equals(other$nextAction)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$onBehalfOf = this.getOnBehalfOf();
    final java.lang.Object other$onBehalfOf = other.getOnBehalfOf();
    if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) return false;
    final java.lang.Object this$paymentMethod = this.getPaymentMethod();
    final java.lang.Object other$paymentMethod = other.getPaymentMethod();
    if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) return false;
    final java.lang.Object this$paymentMethodTypes = this.getPaymentMethodTypes();
    final java.lang.Object other$paymentMethodTypes = other.getPaymentMethodTypes();
    if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !this$paymentMethodTypes.equals(other$paymentMethodTypes)) return false;
    final java.lang.Object this$receiptEmail = this.getReceiptEmail();
    final java.lang.Object other$receiptEmail = other.getReceiptEmail();
    if (this$receiptEmail == null ? other$receiptEmail != null : !this$receiptEmail.equals(other$receiptEmail)) return false;
    final java.lang.Object this$review = this.getReview();
    final java.lang.Object other$review = other.getReview();
    if (this$review == null ? other$review != null : !this$review.equals(other$review)) return false;
    final java.lang.Object this$shipping = this.getShipping();
    final java.lang.Object other$shipping = other.getShipping();
    if (this$shipping == null ? other$shipping != null : !this$shipping.equals(other$shipping)) return false;
    final java.lang.Object this$source = this.getSource();
    final java.lang.Object other$source = other.getSource();
    if (this$source == null ? other$source != null : !this$source.equals(other$source)) return false;
    final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
    final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
    if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$transferData = this.getTransferData();
    final java.lang.Object other$transferData = other.getTransferData();
    if (this$transferData == null ? other$transferData != null : !this$transferData.equals(other$transferData)) return false;
    final java.lang.Object this$transferGroup = this.getTransferGroup();
    final java.lang.Object other$transferGroup = other.getTransferGroup();
    if (this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof PaymentIntent;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $amountCapturable = this.getAmountCapturable();
    result = result * PRIME + ($amountCapturable == null ? 43 : $amountCapturable.hashCode());
    final java.lang.Object $amountReceived = this.getAmountReceived();
    result = result * PRIME + ($amountReceived == null ? 43 : $amountReceived.hashCode());
    final java.lang.Object $application = this.getApplication();
    result = result * PRIME + ($application == null ? 43 : $application.hashCode());
    final java.lang.Object $applicationFeeAmount = this.getApplicationFeeAmount();
    result = result * PRIME + ($applicationFeeAmount == null ? 43 : $applicationFeeAmount.hashCode());
    final java.lang.Object $canceledAt = this.getCanceledAt();
    result = result * PRIME + ($canceledAt == null ? 43 : $canceledAt.hashCode());
    final java.lang.Object $cancellationReason = this.getCancellationReason();
    result = result * PRIME + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
    final java.lang.Object $captureMethod = this.getCaptureMethod();
    result = result * PRIME + ($captureMethod == null ? 43 : $captureMethod.hashCode());
    final java.lang.Object $charges = this.getCharges();
    result = result * PRIME + ($charges == null ? 43 : $charges.hashCode());
    final java.lang.Object $clientSecret = this.getClientSecret();
    result = result * PRIME + ($clientSecret == null ? 43 : $clientSecret.hashCode());
    final java.lang.Object $confirmationMethod = this.getConfirmationMethod();
    result = result * PRIME + ($confirmationMethod == null ? 43 : $confirmationMethod.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $lastPaymentError = this.getLastPaymentError();
    result = result * PRIME + ($lastPaymentError == null ? 43 : $lastPaymentError.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $nextAction = this.getNextAction();
    result = result * PRIME + ($nextAction == null ? 43 : $nextAction.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $onBehalfOf = this.getOnBehalfOf();
    result = result * PRIME + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
    final java.lang.Object $paymentMethod = this.getPaymentMethod();
    result = result * PRIME + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
    final java.lang.Object $paymentMethodTypes = this.getPaymentMethodTypes();
    result = result * PRIME + ($paymentMethodTypes == null ? 43 : $paymentMethodTypes.hashCode());
    final java.lang.Object $receiptEmail = this.getReceiptEmail();
    result = result * PRIME + ($receiptEmail == null ? 43 : $receiptEmail.hashCode());
    final java.lang.Object $review = this.getReview();
    result = result * PRIME + ($review == null ? 43 : $review.hashCode());
    final java.lang.Object $shipping = this.getShipping();
    result = result * PRIME + ($shipping == null ? 43 : $shipping.hashCode());
    final java.lang.Object $source = this.getSource();
    result = result * PRIME + ($source == null ? 43 : $source.hashCode());
    final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
    result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $transferData = this.getTransferData();
    result = result * PRIME + ($transferData == null ? 43 : $transferData.hashCode());
    final java.lang.Object $transferGroup = this.getTransferGroup();
    result = result * PRIME + ($transferGroup == null ? 43 : $transferGroup.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format. For more information, see the
   * [documentation](https://stripe.com/docs/payments/payment-intents/creating-payment-intents#storing-information-in-metadata).
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
