/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.stripe.exception.EventDataObjectDeserializationException;
import com.stripe.model.EventDataDeserializer;
import com.stripe.model.StripeObject;
import lombok.Generated;

public class EventDataObjectDeserializer {
    String apiVersion;
    String eventType;
    JsonObject rawJsonObject;
    private StripeObject object;

    EventDataObjectDeserializer(String apiVersion, String eventType, JsonObject rawJsonObject) {
        this.apiVersion = apiVersion;
        this.rawJsonObject = rawJsonObject;
        this.eventType = eventType;
    }

    public StripeObject getObject() {
        if (this.object != null) {
            return this.object;
        }
        if (this.deserialize()) {
            return this.object;
        }
        return null;
    }

    public String getRawJson() {
        return this.rawJsonObject.toString();
    }

    public boolean deserialize() {
        if (!this.apiVersionMatch()) {
            return false;
        }
        if (this.object != null) {
            return true;
        }
        try {
            this.object = EventDataDeserializer.deserializeStripeObject(this.rawJsonObject);
            return true;
        }
        catch (JsonParseException e) {
            return false;
        }
    }

    public StripeObject deserializeUnsafe() throws EventDataObjectDeserializationException {
        try {
            return EventDataDeserializer.deserializeStripeObject(this.rawJsonObject);
        }
        catch (JsonParseException e) {
            String errorMessage = !this.apiVersionMatch() ? String.format("Current `stripe-java` integration has Stripe API version %s, but the event data object has %s. The JSON data might have schema not compatible with the current model classes; such incompatibility can be the cause of deserialization failure. Please see our API version upgrade guide, and consider transforming the raw JSON data object to be compatible with current model class schemas and use `deserializeUnsafeWith`. Original error message: %s", this.getIntegrationApiVersion(), this.apiVersion, e.getMessage()) : String.format("Unable to deserialize event data object to respective Stripe object. Please see the raw JSON, and contact support@stripe.com for assistance. Original error message: %s", e.getMessage());
            throw new EventDataObjectDeserializationException(errorMessage, this.rawJsonObject.toString());
        }
    }

    public StripeObject deserializeUnsafeWith(CompatibilityTransformer transformer) {
        return EventDataDeserializer.deserializeStripeObject(transformer.transform(this.rawJsonObject.deepCopy(), this.apiVersion, this.eventType));
    }

    private boolean apiVersionMatch() {
        return this.getIntegrationApiVersion().equals(this.apiVersion);
    }

    String getIntegrationApiVersion() {
        return "2019-03-14";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventDataObjectDeserializer)) {
            return false;
        }
        EventDataObjectDeserializer other = (EventDataObjectDeserializer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.apiVersion;
        String other$apiVersion = other.apiVersion;
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$eventType = this.eventType;
        String other$eventType = other.eventType;
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        JsonObject this$rawJsonObject = this.rawJsonObject;
        JsonObject other$rawJsonObject = other.rawJsonObject;
        if (this$rawJsonObject == null ? other$rawJsonObject != null : !this$rawJsonObject.equals(other$rawJsonObject)) {
            return false;
        }
        StripeObject this$object = this.getObject();
        StripeObject other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EventDataObjectDeserializer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.apiVersion;
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $eventType = this.eventType;
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        JsonObject $rawJsonObject = this.rawJsonObject;
        result = result * 59 + ($rawJsonObject == null ? 43 : $rawJsonObject.hashCode());
        StripeObject $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    public static interface CompatibilityTransformer {
        public JsonObject transform(JsonObject var1, String var2, String var3);
    }
}

