/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.Charge;
import com.stripe.model.ExpandableField;
import com.stripe.model.MetadataStore;
import com.stripe.model.RefundCollection;
import com.stripe.model.TransferReversal;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.Map;
import lombok.Generated;

public class Refund
extends ApiResource
implements BalanceTransactionSource,
MetadataStore<Refund> {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="balance_transaction")
    ExpandableField<BalanceTransaction> balanceTransaction;
    @SerializedName(value="charge")
    ExpandableField<Charge> charge;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="failure_balance_transaction")
    ExpandableField<BalanceTransaction> failureBalanceTransaction;
    @SerializedName(value="failure_reason")
    String failureReason;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="reason")
    String reason;
    @SerializedName(value="receipt_number")
    String receiptNumber;
    @SerializedName(value="source_transfer_reversal")
    ExpandableField<TransferReversal> sourceTransferReversal;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="transfer_reversal")
    ExpandableField<TransferReversal> transferReversal;

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String id) {
        this.balanceTransaction = ApiResource.setExpandableFieldId(id, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction expandableObject) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public String getCharge() {
        return this.charge != null ? this.charge.getId() : null;
    }

    public void setCharge(String id) {
        this.charge = ApiResource.setExpandableFieldId(id, this.charge);
    }

    public Charge getChargeObject() {
        return this.charge != null ? this.charge.getExpanded() : null;
    }

    public void setChargeObject(Charge expandableObject) {
        this.charge = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
    }

    public String getFailureBalanceTransaction() {
        return this.failureBalanceTransaction != null ? this.failureBalanceTransaction.getId() : null;
    }

    public void setFailureBalanceTransaction(String id) {
        this.failureBalanceTransaction = ApiResource.setExpandableFieldId(id, this.failureBalanceTransaction);
    }

    public BalanceTransaction getFailureBalanceTransactionObject() {
        return this.failureBalanceTransaction != null ? this.failureBalanceTransaction.getExpanded() : null;
    }

    public void setFailureBalanceTransactionObject(BalanceTransaction expandableObject) {
        this.failureBalanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public String getSourceTransferReversal() {
        return this.sourceTransferReversal != null ? this.sourceTransferReversal.getId() : null;
    }

    public void setSourceTransferReversal(String id) {
        this.sourceTransferReversal = ApiResource.setExpandableFieldId(id, this.sourceTransferReversal);
    }

    public TransferReversal getSourceTransferReversalObject() {
        return this.sourceTransferReversal != null ? this.sourceTransferReversal.getExpanded() : null;
    }

    public void setSourceTransferReversalObject(TransferReversal expandableObject) {
        this.sourceTransferReversal = new ExpandableField<TransferReversal>(expandableObject.getId(), expandableObject);
    }

    public String getTransferReversal() {
        return this.transferReversal != null ? this.transferReversal.getId() : null;
    }

    public void setTransferReversal(String id) {
        this.transferReversal = ApiResource.setExpandableFieldId(id, this.transferReversal);
    }

    public TransferReversal getTransferReversalObject() {
        return this.transferReversal != null ? this.transferReversal.getExpanded() : null;
    }

    public void setTransferReversalObject(TransferReversal expandableObject) {
        this.transferReversal = new ExpandableField<TransferReversal>(expandableObject.getId(), expandableObject);
    }

    public static RefundCollection list(Map<String, Object> params) throws StripeException {
        return Refund.list(params, null);
    }

    public static RefundCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/refunds");
        return Refund.requestCollection(url, params, RefundCollection.class, options);
    }

    public static Refund create(Map<String, Object> params) throws StripeException {
        return Refund.create(params, null);
    }

    public static Refund create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/refunds");
        return Refund.request(ApiResource.RequestMethod.POST, url, params, Refund.class, options);
    }

    public static Refund retrieve(String refund) throws StripeException {
        return Refund.retrieve(refund, null, null);
    }

    public static Refund retrieve(String refund, RequestOptions options) throws StripeException {
        return Refund.retrieve(refund, null, options);
    }

    public static Refund retrieve(String refund, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/refunds/%s", refund));
        return Refund.request(ApiResource.RequestMethod.GET, url, params, Refund.class, options);
    }

    public Refund update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Refund update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/refunds/%s", this.getId()));
        return Refund.request(ApiResource.RequestMethod.POST, url, params, Refund.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getFailureReason() {
        return this.failureReason;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Generated
    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Refund)) {
            return false;
        }
        Refund other = (Refund)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        String this$charge = this.getCharge();
        String other$charge = other.getCharge();
        if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$failureBalanceTransaction = this.getFailureBalanceTransaction();
        String other$failureBalanceTransaction = other.getFailureBalanceTransaction();
        if (this$failureBalanceTransaction == null ? other$failureBalanceTransaction != null : !this$failureBalanceTransaction.equals(other$failureBalanceTransaction)) {
            return false;
        }
        String this$failureReason = this.getFailureReason();
        String other$failureReason = other.getFailureReason();
        if (this$failureReason == null ? other$failureReason != null : !this$failureReason.equals(other$failureReason)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$receiptNumber = this.getReceiptNumber();
        String other$receiptNumber = other.getReceiptNumber();
        if (this$receiptNumber == null ? other$receiptNumber != null : !this$receiptNumber.equals(other$receiptNumber)) {
            return false;
        }
        String this$sourceTransferReversal = this.getSourceTransferReversal();
        String other$sourceTransferReversal = other.getSourceTransferReversal();
        if (this$sourceTransferReversal == null ? other$sourceTransferReversal != null : !this$sourceTransferReversal.equals(other$sourceTransferReversal)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$transferReversal = this.getTransferReversal();
        String other$transferReversal = other.getTransferReversal();
        return !(this$transferReversal == null ? other$transferReversal != null : !this$transferReversal.equals(other$transferReversal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Refund;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        String $charge = this.getCharge();
        result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $failureBalanceTransaction = this.getFailureBalanceTransaction();
        result = result * 59 + ($failureBalanceTransaction == null ? 43 : $failureBalanceTransaction.hashCode());
        String $failureReason = this.getFailureReason();
        result = result * 59 + ($failureReason == null ? 43 : $failureReason.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $receiptNumber = this.getReceiptNumber();
        result = result * 59 + ($receiptNumber == null ? 43 : $receiptNumber.hashCode());
        String $sourceTransferReversal = this.getSourceTransferReversal();
        result = result * 59 + ($sourceTransferReversal == null ? 43 : $sourceTransferReversal.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $transferReversal = this.getTransferReversal();
        result = result * 59 + ($transferReversal == null ? 43 : $transferReversal.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

