// Generated by delombok at Tue Apr 09 17:23:04 PDT 2019
// Generated by com.stripe.generator.entity.SdkBuilder
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomerCreateParams extends ApiRequestParams {
  /**
   * An integer amount in %s that represents the account balance for your customer. Account balances
   * only affect invoices. A negative amount represents a credit that decreases the amount due on an
   * invoice; a positive amount increases the amount due on an invoice.
   */
  @SerializedName("account_balance")
  Long accountBalance;
  @SerializedName("coupon")
  String coupon;
  /**
   * An arbitrary string that you can attach to a customer object. It is displayed alongside the
   * customer in the dashboard.
   */
  @SerializedName("description")
  String description;
  /**
   * Customer's email address. It's displayed alongside the customer in your dashboard and can be
   * useful for searching and tracking. This may be up to *512 characters*.
   */
  @SerializedName("email")
  String email;
  /**
   * Specifies which fields in the response should be expanded.
   */
  @SerializedName("expand")
  List<String> expand;
  /**
   * The prefix for the customer used to generate unique invoice numbers. Must be 3–12 uppercase
   * letters or numbers.
   */
  @SerializedName("invoice_prefix")
  String invoicePrefix;
  /**
   * Default invoice settings for this customer.
   */
  @SerializedName("invoice_settings")
  InvoiceSettings invoiceSettings;
  /**
   * A set of key-value pairs that you can attach to a customer object. It can be useful for storing
   * additional information about the customer in a structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  @SerializedName("payment_method")
  String paymentMethod;
  /**
   * The customer's shipping information. Appears on invoices emailed to this customer.
   */
  @SerializedName("shipping")
  Object shipping;
  @SerializedName("source")
  String source;
  /**
   * The customer's tax information. Appears on invoices emailed to this customer.
   */
  @SerializedName("tax_info")
  TaxInfo taxInfo;

  private CustomerCreateParams(Long accountBalance, String coupon, String description, String email, List<String> expand, String invoicePrefix, InvoiceSettings invoiceSettings, Map<String, String> metadata, String paymentMethod, Object shipping, String source, TaxInfo taxInfo) {
    this.accountBalance = accountBalance;
    this.coupon = coupon;
    this.description = description;
    this.email = email;
    this.expand = expand;
    this.invoicePrefix = invoicePrefix;
    this.invoiceSettings = invoiceSettings;
    this.metadata = metadata;
    this.paymentMethod = paymentMethod;
    this.shipping = shipping;
    this.source = source;
    this.taxInfo = taxInfo;
  }

  public static Builder builder() {
    return new com.stripe.param.CustomerCreateParams.Builder();
  }


  public static class Builder {
    private Long accountBalance;
    private String coupon;
    private String description;
    private String email;
    private List<String> expand;
    private String invoicePrefix;
    private InvoiceSettings invoiceSettings;
    private Map<String, String> metadata;
    private String paymentMethod;
    private Object shipping;
    private String source;
    private TaxInfo taxInfo;

    /**
     * Finalize and obtain parameter instance from this builder.
     */
    public CustomerCreateParams build() {
      return new CustomerCreateParams(this.accountBalance, this.coupon, this.description, this.email, this.expand, this.invoicePrefix, this.invoiceSettings, this.metadata, this.paymentMethod, this.shipping, this.source, this.taxInfo);
    }

    /**
     * An integer amount in %s that represents the account balance for your customer. Account
     * balances only affect invoices. A negative amount represents a credit that decreases the
     * amount due on an invoice; a positive amount increases the amount due on an invoice.
     */
    public Builder setAccountBalance(Long accountBalance) {
      this.accountBalance = accountBalance;
      return this;
    }

    public Builder setCoupon(String coupon) {
      this.coupon = coupon;
      return this;
    }

    /**
     * An arbitrary string that you can attach to a customer object. It is displayed alongside the
     * customer in the dashboard.
     */
    public Builder setDescription(String description) {
      this.description = description;
      return this;
    }

    /**
     * Customer's email address. It's displayed alongside the customer in your dashboard and can be
     * useful for searching and tracking. This may be up to *512 characters*.
     */
    public Builder setEmail(String email) {
      this.email = email;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * CustomerCreateParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * CustomerCreateParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * The prefix for the customer used to generate unique invoice numbers. Must be 3–12 uppercase
     * letters or numbers.
     */
    public Builder setInvoicePrefix(String invoicePrefix) {
      this.invoicePrefix = invoicePrefix;
      return this;
    }

    /**
     * Default invoice settings for this customer.
     */
    public Builder setInvoiceSettings(InvoiceSettings invoiceSettings) {
      this.invoiceSettings = invoiceSettings;
      return this;
    }

    /**
     * Add a key/value pair to `metadata` map. A map is initialized for the first `put/putAll` call,
     * and subsequent calls add additional key/value pairs to the original map. See {@link
     * CustomerCreateParams#metadata} for the field documentation.
     */
    public Builder putMetadata(String key, String value) {
      if (this.metadata == null) {
        this.metadata = new HashMap<>();
      }
      this.metadata.put(key, value);
      return this;
    }

    /**
     * Add all map key/value pairs to `metadata` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
     * See {@link CustomerCreateParams#metadata} for the field documentation.
     */
    public Builder putAllMetadata(Map<String, String> map) {
      if (this.metadata == null) {
        this.metadata = new HashMap<>();
      }
      this.metadata.putAll(map);
      return this;
    }

    public Builder setPaymentMethod(String paymentMethod) {
      this.paymentMethod = paymentMethod;
      return this;
    }

    /**
     * The customer's shipping information. Appears on invoices emailed to this customer.
     */
    public Builder setShipping(Shipping shipping) {
      this.shipping = shipping;
      return this;
    }

    /**
     * The customer's shipping information. Appears on invoices emailed to this customer.
     */
    public Builder setShipping(EmptyParam shipping) {
      this.shipping = shipping;
      return this;
    }

    public Builder setSource(String source) {
      this.source = source;
      return this;
    }

    /**
     * The customer's tax information. Appears on invoices emailed to this customer.
     */
    public Builder setTaxInfo(TaxInfo taxInfo) {
      this.taxInfo = taxInfo;
      return this;
    }
  }


  public static class InvoiceSettings {
    /**
     * Default custom fields to be displayed on invoices for this customer.
     */
    @SerializedName("custom_fields")
    Object customFields;
    /**
     * Default footer to be displayed on invoices for this customer.
     */
    @SerializedName("footer")
    String footer;

    private InvoiceSettings(Object customFields, String footer) {
      this.customFields = customFields;
      this.footer = footer;
    }

    public static Builder builder() {
      return new com.stripe.param.CustomerCreateParams.InvoiceSettings.Builder();
    }


    public static class Builder {
      private Object customFields;
      private String footer;

      /**
       * Finalize and obtain parameter instance from this builder.
       */
      public InvoiceSettings build() {
        return new InvoiceSettings(this.customFields, this.footer);
      }

      /**
       * Default custom fields to be displayed on invoices for this customer.
       */
      public Builder setCustomFields(EmptyParam customFields) {
        this.customFields = customFields;
        return this;
      }

      /**
       * Default custom fields to be displayed on invoices for this customer.
       */
      public Builder setCustomFields(List<CustomField> customFields) {
        this.customFields = customFields;
        return this;
      }

      /**
       * Default footer to be displayed on invoices for this customer.
       */
      public Builder setFooter(String footer) {
        this.footer = footer;
        return this;
      }
    }


    public static class CustomField {
      /** The name of the custom field. This may be up to 30 characters. */
      @SerializedName("name")
      String name;
      /** The value of the custom field. This may be up to 30 characters. */
      @SerializedName("value")
      String value;

      private CustomField(String name, String value) {
        this.name = name;
        this.value = value;
      }

      public static Builder builder() {
        return new com.stripe.param.CustomerCreateParams.InvoiceSettings.CustomField.Builder();
      }


      public static class Builder {
        private String name;
        private String value;

        /** Finalize and obtain parameter instance from this builder. */
        public CustomField build() {
          return new CustomField(this.name, this.value);
        }

        /** The name of the custom field. This may be up to 30 characters. */
        public Builder setName(String name) {
          this.name = name;
          return this;
        }

        public Builder setValue(String value) {
          this.value = value;
          return this;
        }
      }
    }
  }


  /**
   * The value of the custom field. This may be up to 30 characters.
   */
  public static class Shipping {
    /**
     * Customer shipping address.
     */
    @SerializedName("address")
    Address address;
    /**
     * Customer name.
     */
    @SerializedName("name")
    String name;
    /**
     * Customer phone (including extension).
     */
    @SerializedName("phone")
    String phone;

    private Shipping(Address address, String name, String phone) {
      this.address = address;
      this.name = name;
      this.phone = phone;
    }

    public static Builder builder() {
      return new com.stripe.param.CustomerCreateParams.Shipping.Builder();
    }


    public static class Builder {
      private Address address;
      private String name;
      private String phone;

      /**
       * Finalize and obtain parameter instance from this builder.
       */
      public Shipping build() {
        return new Shipping(this.address, this.name, this.phone);
      }

      /**
       * Customer shipping address.
       */
      public Builder setAddress(Address address) {
        this.address = address;
        return this;
      }

      /**
       * Customer name.
       */
      public Builder setName(String name) {
        this.name = name;
        return this;
      }

      /**
       * Customer phone (including extension).
       */
      public Builder setPhone(String phone) {
        this.phone = phone;
        return this;
      }
    }


    public static class Address {
      @SerializedName("city")
      String city;
      @SerializedName("country")
      String country;
      @SerializedName("line1")
      String line1;
      @SerializedName("line2")
      String line2;
      @SerializedName("postal_code")
      String postalCode;
      @SerializedName("state")
      String state;

      private Address(String city, String country, String line1, String line2, String postalCode, String state) {
        this.city = city;
        this.country = country;
        this.line1 = line1;
        this.line2 = line2;
        this.postalCode = postalCode;
        this.state = state;
      }

      public static Builder builder() {
        return new com.stripe.param.CustomerCreateParams.Shipping.Address.Builder();
      }


      public static class Builder {
        private String city;
        private String country;
        private String line1;
        private String line2;
        private String postalCode;
        private String state;

        public Address build() {
          return new Address(this.city, this.country, this.line1, this.line2, this.postalCode, this.state);
        }

        public Builder setCity(String city) {
          this.city = city;
          return this;
        }

        public Builder setCountry(String country) {
          this.country = country;
          return this;
        }

        public Builder setLine1(String line1) {
          this.line1 = line1;
          return this;
        }

        public Builder setLine2(String line2) {
          this.line2 = line2;
          return this;
        }

        public Builder setPostalCode(String postalCode) {
          this.postalCode = postalCode;
          return this;
        }

        public Builder setState(String state) {
          this.state = state;
          return this;
        }
      }
    }
  }


  /**
   * Finalize and obtain parameter instance from this builder.
   */
  public static class TaxInfo {
    /** The customer's tax ID number. */
    @SerializedName("tax_id")
    String taxId;
    /** The type of ID number. The only possible value is `vat` */
    @SerializedName("type")
    Type type;

    private TaxInfo(String taxId, Type type) {
      this.taxId = taxId;
      this.type = type;
    }

    public static Builder builder() {
      return new com.stripe.param.CustomerCreateParams.TaxInfo.Builder();
    }


    public static class Builder {
      private String taxId;
      private Type type;

      /** Finalize and obtain parameter instance from this builder. */
      public TaxInfo build() {
        return new TaxInfo(this.taxId, this.type);
      }

      /** The customer's tax ID number. */
      public Builder setTaxId(String taxId) {
        this.taxId = taxId;
        return this;
      }

      /** The type of ID number. The only possible value is `vat` */
      public Builder setType(Type type) {
        this.type = type;
        return this;
      }
    }


    public enum Type implements ApiRequestParams.EnumParam {
      @SerializedName("vat")
      VAT("vat");
      private final String value;

      Type(String value) {
        this.value = value;
      }

      @Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getValue() {
        return this.value;
      }
    }
  }
}
