// Generated by delombok at Tue Apr 09 17:23:04 PDT 2019
// Generated by com.stripe.generator.entity.SdkBuilder
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.List;

public class UsageRecordCreateOnSubscriptionItemParams extends ApiRequestParams {
  /**
   * Valid values are `increment` (default) or `set`. When using `increment` the specified
   * `quantity` will be added to the usage at the specified timestamp. The `set` action will
   * overwrite the usage quantity at that timestamp. If the subscription has [billing
   * thresholds](https://stripe.com/docs/api/subscriptions/object#subscription_object-billing_thresholds),
   * `increment` is the only allowed value.
   */
  @SerializedName("action")
  Action action;
  /**
   * Specifies which fields in the response should be expanded.
   */
  @SerializedName("expand")
  List<String> expand;
  /**
   * The usage quantity for the specified timestamp.
   */
  @SerializedName("quantity")
  Long quantity;
  /**
   * The timestamp for the usage event. This timestamp must be within the current billing period of
   * the subscription of the provided `subscription_item`.
   */
  @SerializedName("timestamp")
  Long timestamp;

  private UsageRecordCreateOnSubscriptionItemParams(Action action, List<String> expand, Long quantity, Long timestamp) {
    this.action = action;
    this.expand = expand;
    this.quantity = quantity;
    this.timestamp = timestamp;
  }

  public static Builder builder() {
    return new com.stripe.param.UsageRecordCreateOnSubscriptionItemParams.Builder();
  }


  public static class Builder {
    private Action action;
    private List<String> expand;
    private Long quantity;
    private Long timestamp;

    /**
     * Finalize and obtain parameter instance from this builder.
     */
    public UsageRecordCreateOnSubscriptionItemParams build() {
      return new UsageRecordCreateOnSubscriptionItemParams(this.action, this.expand, this.quantity, this.timestamp);
    }

    /**
     * Valid values are `increment` (default) or `set`. When using `increment` the specified
     * `quantity` will be added to the usage at the specified timestamp. The `set` action will
     * overwrite the usage quantity at that timestamp. If the subscription has [billing
     * thresholds](https://stripe.com/docs/api/subscriptions/object#subscription_object-billing_thresholds),
     * `increment` is the only allowed value.
     */
    public Builder setAction(Action action) {
      this.action = action;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * UsageRecordCreateOnSubscriptionItemParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * UsageRecordCreateOnSubscriptionItemParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * The usage quantity for the specified timestamp.
     */
    public Builder setQuantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    /**
     * The timestamp for the usage event. This timestamp must be within the current billing period
     * of the subscription of the provided `subscription_item`.
     */
    public Builder setTimestamp(Long timestamp) {
      this.timestamp = timestamp;
      return this;
    }
  }


  public enum Action implements ApiRequestParams.EnumParam {
    @SerializedName("increment")
    INCREMENT("increment"), @SerializedName("set")
    SET("set");
    private final String value;

    Action(String value) {
      this.value = value;
    }

    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }
  }
}
