/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ApplePayDomainCollection;
import com.stripe.model.HasId;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.ApplePayDomainCreateParams;
import com.stripe.param.ApplePayDomainListParams;
import com.stripe.param.ApplePayDomainRetrieveParams;
import java.util.Map;
import lombok.Generated;

public class ApplePayDomain
extends ApiResource
implements HasId {
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="domain_name")
    String domainName;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;

    public static ApplePayDomainCollection list(Map<String, Object> params) throws StripeException {
        return ApplePayDomain.list(params, (RequestOptions)null);
    }

    public static ApplePayDomainCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/apple_pay/domains");
        return ApplePayDomain.requestCollection(url, params, ApplePayDomainCollection.class, options);
    }

    public static ApplePayDomainCollection list(ApplePayDomainListParams params) throws StripeException {
        return ApplePayDomain.list(params, (RequestOptions)null);
    }

    public static ApplePayDomainCollection list(ApplePayDomainListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/apple_pay/domains");
        return ApplePayDomain.requestCollection(url, params, ApplePayDomainCollection.class, options);
    }

    public static ApplePayDomain create(Map<String, Object> params) throws StripeException {
        return ApplePayDomain.create(params, (RequestOptions)null);
    }

    public static ApplePayDomain create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/apple_pay/domains");
        return ApplePayDomain.request(ApiResource.RequestMethod.POST, url, params, ApplePayDomain.class, options);
    }

    public static ApplePayDomain create(ApplePayDomainCreateParams params) throws StripeException {
        return ApplePayDomain.create(params, (RequestOptions)null);
    }

    public static ApplePayDomain create(ApplePayDomainCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/apple_pay/domains");
        return ApplePayDomain.request(ApiResource.RequestMethod.POST, url, params, ApplePayDomain.class, options);
    }

    public static ApplePayDomain retrieve(String domain) throws StripeException {
        return ApplePayDomain.retrieve(domain, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static ApplePayDomain retrieve(String domain, RequestOptions options) throws StripeException {
        return ApplePayDomain.retrieve(domain, (Map<String, Object>)null, options);
    }

    public static ApplePayDomain retrieve(String domain, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/apple_pay/domains/%s", domain));
        return ApplePayDomain.request(ApiResource.RequestMethod.GET, url, params, ApplePayDomain.class, options);
    }

    public static ApplePayDomain retrieve(String domain, ApplePayDomainRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/apple_pay/domains/%s", domain));
        return ApplePayDomain.request(ApiResource.RequestMethod.GET, url, params, ApplePayDomain.class, options);
    }

    public ApplePayDomain delete() throws StripeException {
        return this.delete(null, null);
    }

    public ApplePayDomain delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public ApplePayDomain delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public ApplePayDomain delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/apple_pay/domains/%s", this.getId()));
        return ApplePayDomain.request(ApiResource.RequestMethod.DELETE, url, params, ApplePayDomain.class, options);
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getDomainName() {
        return this.domainName;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplePayDomain)) {
            return false;
        }
        ApplePayDomain other = (ApplePayDomain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        String this$domainName = this.getDomainName();
        String other$domainName = other.getDomainName();
        if (this$domainName == null ? other$domainName != null : !this$domainName.equals(other$domainName)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApplePayDomain;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        String $domainName = this.getDomainName();
        result = result * 59 + ($domainName == null ? 43 : $domainName.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

