/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.CustomerCollection;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentMethod;
import com.stripe.model.PaymentSource;
import com.stripe.model.PaymentSourceCollection;
import com.stripe.model.ShippingDetails;
import com.stripe.model.StripeObject;
import com.stripe.model.SubscriptionCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.CustomerCreateParams;
import com.stripe.param.CustomerListParams;
import com.stripe.param.CustomerRetrieveParams;
import com.stripe.param.CustomerUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Customer
extends ApiResource
implements HasId,
MetadataStore<Customer> {
    @SerializedName(value="account_balance")
    Long accountBalance;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="default_source")
    ExpandableField<PaymentSource> defaultSource;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="delinquent")
    Boolean delinquent;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="discount")
    Discount discount;
    @SerializedName(value="email")
    String email;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="invoice_prefix")
    String invoicePrefix;
    @SerializedName(value="invoice_settings")
    InvoiceSettings invoiceSettings;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="shipping")
    ShippingDetails shipping;
    @SerializedName(value="sources")
    PaymentSourceCollection sources;
    @SerializedName(value="subscriptions")
    SubscriptionCollection subscriptions;
    @SerializedName(value="tax_info")
    TaxInfo taxInfo;
    @SerializedName(value="tax_info_verification")
    TaxInfoVerification taxInfoVerification;

    public String getDefaultSource() {
        return this.defaultSource != null ? this.defaultSource.getId() : null;
    }

    public void setDefaultSource(String id) {
        this.defaultSource = ApiResource.setExpandableFieldId(id, this.defaultSource);
    }

    public PaymentSource getDefaultSourceObject() {
        return this.defaultSource != null ? this.defaultSource.getExpanded() : null;
    }

    public void setDefaultSourceObject(PaymentSource expandableObject) {
        this.defaultSource = new ExpandableField<PaymentSource>(expandableObject.getId(), expandableObject);
    }

    public static CustomerCollection list(Map<String, Object> params) throws StripeException {
        return Customer.list(params, (RequestOptions)null);
    }

    public static CustomerCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/customers");
        return Customer.requestCollection(url, params, CustomerCollection.class, options);
    }

    public static CustomerCollection list(CustomerListParams params) throws StripeException {
        return Customer.list(params, (RequestOptions)null);
    }

    public static CustomerCollection list(CustomerListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/customers");
        return Customer.requestCollection(url, params, CustomerCollection.class, options);
    }

    public static Customer create(Map<String, Object> params) throws StripeException {
        return Customer.create(params, (RequestOptions)null);
    }

    public static Customer create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/customers");
        return Customer.request(ApiResource.RequestMethod.POST, url, params, Customer.class, options);
    }

    public static Customer create(CustomerCreateParams params) throws StripeException {
        return Customer.create(params, (RequestOptions)null);
    }

    public static Customer create(CustomerCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/customers");
        return Customer.request(ApiResource.RequestMethod.POST, url, params, Customer.class, options);
    }

    public static Customer retrieve(String customer) throws StripeException {
        return Customer.retrieve(customer, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Customer retrieve(String customer, RequestOptions options) throws StripeException {
        return Customer.retrieve(customer, (Map<String, Object>)null, options);
    }

    public static Customer retrieve(String customer, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s", customer));
        return Customer.request(ApiResource.RequestMethod.GET, url, params, Customer.class, options);
    }

    public static Customer retrieve(String customer, CustomerRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s", customer));
        return Customer.request(ApiResource.RequestMethod.GET, url, params, Customer.class, options);
    }

    public Customer update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Customer update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s", this.getId()));
        return Customer.request(ApiResource.RequestMethod.POST, url, params, Customer.class, options);
    }

    public Customer update(CustomerUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Customer update(CustomerUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s", this.getId()));
        return Customer.request(ApiResource.RequestMethod.POST, url, params, Customer.class, options);
    }

    public Customer delete() throws StripeException {
        return this.delete(null, null);
    }

    public Customer delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Customer delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Customer delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s", this.getId()));
        return Customer.request(ApiResource.RequestMethod.DELETE, url, params, Customer.class, options);
    }

    public Discount deleteDiscount() throws StripeException {
        return this.deleteDiscount(null, null);
    }

    public Discount deleteDiscount(Map<String, Object> params) throws StripeException {
        return this.deleteDiscount(params, null);
    }

    public Discount deleteDiscount(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/discount", this.getId()));
        return Customer.request(ApiResource.RequestMethod.DELETE, url, params, Discount.class, options);
    }

    @Generated
    public Long getAccountBalance() {
        return this.accountBalance;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public Boolean getDelinquent() {
        return this.delinquent;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Discount getDiscount() {
        return this.discount;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getInvoicePrefix() {
        return this.invoicePrefix;
    }

    @Generated
    public InvoiceSettings getInvoiceSettings() {
        return this.invoiceSettings;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public ShippingDetails getShipping() {
        return this.shipping;
    }

    @Generated
    public PaymentSourceCollection getSources() {
        return this.sources;
    }

    @Generated
    public SubscriptionCollection getSubscriptions() {
        return this.subscriptions;
    }

    @Generated
    public TaxInfo getTaxInfo() {
        return this.taxInfo;
    }

    @Generated
    public TaxInfoVerification getTaxInfoVerification() {
        return this.taxInfoVerification;
    }

    @Generated
    public void setAccountBalance(Long accountBalance) {
        this.accountBalance = accountBalance;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDelinquent(Boolean delinquent) {
        this.delinquent = delinquent;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInvoicePrefix(String invoicePrefix) {
        this.invoicePrefix = invoicePrefix;
    }

    @Generated
    public void setInvoiceSettings(InvoiceSettings invoiceSettings) {
        this.invoiceSettings = invoiceSettings;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    @Generated
    public void setSources(PaymentSourceCollection sources) {
        this.sources = sources;
    }

    @Generated
    public void setSubscriptions(SubscriptionCollection subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Generated
    public void setTaxInfo(TaxInfo taxInfo) {
        this.taxInfo = taxInfo;
    }

    @Generated
    public void setTaxInfoVerification(TaxInfoVerification taxInfoVerification) {
        this.taxInfoVerification = taxInfoVerification;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Customer)) {
            return false;
        }
        Customer other = (Customer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$accountBalance = this.getAccountBalance();
        Long other$accountBalance = other.getAccountBalance();
        if (this$accountBalance == null ? other$accountBalance != null : !((Object)this$accountBalance).equals(other$accountBalance)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$defaultSource = this.getDefaultSource();
        String other$defaultSource = other.getDefaultSource();
        if (this$defaultSource == null ? other$defaultSource != null : !this$defaultSource.equals(other$defaultSource)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$delinquent = this.getDelinquent();
        Boolean other$delinquent = other.getDelinquent();
        if (this$delinquent == null ? other$delinquent != null : !((Object)this$delinquent).equals(other$delinquent)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Discount this$discount = this.getDiscount();
        Discount other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$invoicePrefix = this.getInvoicePrefix();
        String other$invoicePrefix = other.getInvoicePrefix();
        if (this$invoicePrefix == null ? other$invoicePrefix != null : !this$invoicePrefix.equals(other$invoicePrefix)) {
            return false;
        }
        InvoiceSettings this$invoiceSettings = this.getInvoiceSettings();
        InvoiceSettings other$invoiceSettings = other.getInvoiceSettings();
        if (this$invoiceSettings == null ? other$invoiceSettings != null : !((Object)this$invoiceSettings).equals(other$invoiceSettings)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        ShippingDetails this$shipping = this.getShipping();
        ShippingDetails other$shipping = other.getShipping();
        if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
            return false;
        }
        PaymentSourceCollection this$sources = this.getSources();
        PaymentSourceCollection other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources)) {
            return false;
        }
        SubscriptionCollection this$subscriptions = this.getSubscriptions();
        SubscriptionCollection other$subscriptions = other.getSubscriptions();
        if (this$subscriptions == null ? other$subscriptions != null : !((Object)this$subscriptions).equals(other$subscriptions)) {
            return false;
        }
        TaxInfo this$taxInfo = this.getTaxInfo();
        TaxInfo other$taxInfo = other.getTaxInfo();
        if (this$taxInfo == null ? other$taxInfo != null : !((Object)this$taxInfo).equals(other$taxInfo)) {
            return false;
        }
        TaxInfoVerification this$taxInfoVerification = this.getTaxInfoVerification();
        TaxInfoVerification other$taxInfoVerification = other.getTaxInfoVerification();
        return !(this$taxInfoVerification == null ? other$taxInfoVerification != null : !((Object)this$taxInfoVerification).equals(other$taxInfoVerification));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Customer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $accountBalance = this.getAccountBalance();
        result = result * 59 + ($accountBalance == null ? 43 : ((Object)$accountBalance).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $defaultSource = this.getDefaultSource();
        result = result * 59 + ($defaultSource == null ? 43 : $defaultSource.hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $delinquent = this.getDelinquent();
        result = result * 59 + ($delinquent == null ? 43 : ((Object)$delinquent).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Discount $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $invoicePrefix = this.getInvoicePrefix();
        result = result * 59 + ($invoicePrefix == null ? 43 : $invoicePrefix.hashCode());
        InvoiceSettings $invoiceSettings = this.getInvoiceSettings();
        result = result * 59 + ($invoiceSettings == null ? 43 : ((Object)$invoiceSettings).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        ShippingDetails $shipping = this.getShipping();
        result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
        PaymentSourceCollection $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        SubscriptionCollection $subscriptions = this.getSubscriptions();
        result = result * 59 + ($subscriptions == null ? 43 : ((Object)$subscriptions).hashCode());
        TaxInfo $taxInfo = this.getTaxInfo();
        result = result * 59 + ($taxInfo == null ? 43 : ((Object)$taxInfo).hashCode());
        TaxInfoVerification $taxInfoVerification = this.getTaxInfoVerification();
        result = result * 59 + ($taxInfoVerification == null ? 43 : ((Object)$taxInfoVerification).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class TaxInfoVerification
    extends StripeObject {
        @SerializedName(value="status")
        String status;
        @SerializedName(value="verified_name")
        String verifiedName;

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public String getVerifiedName() {
            return this.verifiedName;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setVerifiedName(String verifiedName) {
            this.verifiedName = verifiedName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaxInfoVerification)) {
                return false;
            }
            TaxInfoVerification other = (TaxInfoVerification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$verifiedName = this.getVerifiedName();
            String other$verifiedName = other.getVerifiedName();
            return !(this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaxInfoVerification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $verifiedName = this.getVerifiedName();
            result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
            return result;
        }
    }

    public static class TaxInfo
    extends StripeObject {
        @SerializedName(value="tax_id")
        String taxId;
        @SerializedName(value="type")
        String type;

        @Generated
        public String getTaxId() {
            return this.taxId;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setTaxId(String taxId) {
            this.taxId = taxId;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaxInfo)) {
                return false;
            }
            TaxInfo other = (TaxInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$taxId = this.getTaxId();
            String other$taxId = other.getTaxId();
            if (this$taxId == null ? other$taxId != null : !this$taxId.equals(other$taxId)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaxInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $taxId = this.getTaxId();
            result = result * 59 + ($taxId == null ? 43 : $taxId.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }

    public static class InvoiceSettings
    extends StripeObject {
        @SerializedName(value="custom_fields")
        List<Invoice.CustomField> customFields;
        @SerializedName(value="default_payment_method")
        ExpandableField<PaymentMethod> defaultPaymentMethod;
        @SerializedName(value="footer")
        String footer;

        public String getDefaultPaymentMethod() {
            return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getId() : null;
        }

        public void setDefaultPaymentMethod(String id) {
            this.defaultPaymentMethod = ApiResource.setExpandableFieldId(id, this.defaultPaymentMethod);
        }

        public PaymentMethod getDefaultPaymentMethodObject() {
            return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getExpanded() : null;
        }

        public void setDefaultPaymentMethodObject(PaymentMethod expandableObject) {
            this.defaultPaymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public List<Invoice.CustomField> getCustomFields() {
            return this.customFields;
        }

        @Generated
        public String getFooter() {
            return this.footer;
        }

        @Generated
        public void setCustomFields(List<Invoice.CustomField> customFields) {
            this.customFields = customFields;
        }

        @Generated
        public void setFooter(String footer) {
            this.footer = footer;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvoiceSettings)) {
                return false;
            }
            InvoiceSettings other = (InvoiceSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Invoice.CustomField> this$customFields = this.getCustomFields();
            List<Invoice.CustomField> other$customFields = other.getCustomFields();
            if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
                return false;
            }
            String this$defaultPaymentMethod = this.getDefaultPaymentMethod();
            String other$defaultPaymentMethod = other.getDefaultPaymentMethod();
            if (this$defaultPaymentMethod == null ? other$defaultPaymentMethod != null : !this$defaultPaymentMethod.equals(other$defaultPaymentMethod)) {
                return false;
            }
            String this$footer = this.getFooter();
            String other$footer = other.getFooter();
            return !(this$footer == null ? other$footer != null : !this$footer.equals(other$footer));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InvoiceSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Invoice.CustomField> $customFields = this.getCustomFields();
            result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
            String $defaultPaymentMethod = this.getDefaultPaymentMethod();
            result = result * 59 + ($defaultPaymentMethod == null ? 43 : $defaultPaymentMethod.hashCode());
            String $footer = this.getFooter();
            result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
            return result;
        }
    }
}

