/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExchangeRateCollection;
import com.stripe.model.HasId;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.ExchangeRateListParams;
import com.stripe.param.ExchangeRateRetrieveParams;
import java.math.BigDecimal;
import java.util.Map;
import lombok.Generated;

public class ExchangeRate
extends ApiResource
implements HasId {
    @SerializedName(value="id")
    String id;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="rates")
    Map<String, BigDecimal> rates;

    public static ExchangeRateCollection list(Map<String, Object> params) throws StripeException {
        return ExchangeRate.list(params, (RequestOptions)null);
    }

    public static ExchangeRateCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/exchange_rates");
        return ExchangeRate.requestCollection(url, params, ExchangeRateCollection.class, options);
    }

    public static ExchangeRateCollection list(ExchangeRateListParams params) throws StripeException {
        return ExchangeRate.list(params, (RequestOptions)null);
    }

    public static ExchangeRateCollection list(ExchangeRateListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/exchange_rates");
        return ExchangeRate.requestCollection(url, params, ExchangeRateCollection.class, options);
    }

    public static ExchangeRate retrieve(String currency) throws StripeException {
        return ExchangeRate.retrieve(currency, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static ExchangeRate retrieve(String currency, RequestOptions options) throws StripeException {
        return ExchangeRate.retrieve(currency, (Map<String, Object>)null, options);
    }

    public static ExchangeRate retrieve(String currency, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/exchange_rates/%s", currency));
        return ExchangeRate.request(ApiResource.RequestMethod.GET, url, params, ExchangeRate.class, options);
    }

    public static ExchangeRate retrieve(String currency, ExchangeRateRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/exchange_rates/%s", currency));
        return ExchangeRate.request(ApiResource.RequestMethod.GET, url, params, ExchangeRate.class, options);
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Map<String, BigDecimal> getRates() {
        return this.rates;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setRates(Map<String, BigDecimal> rates) {
        this.rates = rates;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExchangeRate)) {
            return false;
        }
        ExchangeRate other = (ExchangeRate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Map<String, BigDecimal> this$rates = this.getRates();
        Map<String, BigDecimal> other$rates = other.getRates();
        return !(this$rates == null ? other$rates != null : !((Object)this$rates).equals(other$rates));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExchangeRate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Map<String, BigDecimal> $rates = this.getRates();
        result = result * 59 + ($rates == null ? 43 : ((Object)$rates).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

