/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExternalAccount;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.ExternalAccountCollectionCreateParams;
import com.stripe.param.ExternalAccountCollectionListParams;
import com.stripe.param.ExternalAccountCollectionRetrieveParams;
import java.util.Map;

public class ExternalAccountCollection
extends StripeCollection<ExternalAccount> {
    public ExternalAccountCollection list(Map<String, Object> params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public ExternalAccountCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getUrl());
        return ApiResource.requestCollection(url, params, ExternalAccountCollection.class, options);
    }

    public ExternalAccountCollection list(ExternalAccountCollectionListParams params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public ExternalAccountCollection list(ExternalAccountCollectionListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getUrl());
        return ApiResource.requestCollection(url, params, ExternalAccountCollection.class, options);
    }

    public ExternalAccount retrieve(String id) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public ExternalAccount retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, options);
    }

    public ExternalAccount retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("%s/%s", this.getUrl(), id));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ExternalAccount.class, options);
    }

    public ExternalAccount retrieve(String id, ExternalAccountCollectionRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("%s/%s", this.getUrl(), id));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ExternalAccount.class, options);
    }

    public ExternalAccount create(Map<String, Object> params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public ExternalAccount create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getUrl());
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ExternalAccount.class, options);
    }

    public ExternalAccount create(ExternalAccountCollectionCreateParams params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public ExternalAccount create(ExternalAccountCollectionCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getUrl());
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ExternalAccount.class, options);
    }
}

