/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Person;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.PersonCollectionCreateParams;
import com.stripe.param.PersonCollectionListParams;
import com.stripe.param.PersonCollectionRetrieveParams;
import java.util.Map;

public class PersonCollection
extends StripeCollection<Person> {
    public PersonCollection list(Map<String, Object> params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public PersonCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getUrl());
        return ApiResource.requestCollection(url, params, PersonCollection.class, options);
    }

    public PersonCollection list(PersonCollectionListParams params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public PersonCollection list(PersonCollectionListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getUrl());
        return ApiResource.requestCollection(url, params, PersonCollection.class, options);
    }

    public Person retrieve(String id) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public Person retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, options);
    }

    public Person retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("%s/%s", this.getUrl(), id));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Person.class, options);
    }

    public Person retrieve(String id, PersonCollectionRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("%s/%s", this.getUrl(), id));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Person.class, options);
    }

    public Person create(Map<String, Object> params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public Person create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getUrl());
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Person.class, options);
    }

    public Person create(PersonCollectionCreateParams params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public Person create(PersonCollectionCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getUrl());
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Person.class, options);
    }
}

