/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.CardholderCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.issuing.CardholderCreateParams;
import com.stripe.param.issuing.CardholderListParams;
import com.stripe.param.issuing.CardholderRetrieveParams;
import com.stripe.param.issuing.CardholderUpdateParams;
import java.util.Map;
import lombok.Generated;

public class Cardholder
extends ApiResource
implements HasId,
MetadataStore<Cardholder> {
    @SerializedName(value="billing")
    Billing billing;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="email")
    String email;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="is_default")
    Boolean isDefault;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="phone_number")
    String phoneNumber;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="type")
    String type;

    public static CardholderCollection list(Map<String, Object> params) throws StripeException {
        return Cardholder.list(params, (RequestOptions)null);
    }

    public static CardholderCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cardholders");
        return Cardholder.requestCollection(url, params, CardholderCollection.class, options);
    }

    public static CardholderCollection list(CardholderListParams params) throws StripeException {
        return Cardholder.list(params, (RequestOptions)null);
    }

    public static CardholderCollection list(CardholderListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cardholders");
        return Cardholder.requestCollection(url, params, CardholderCollection.class, options);
    }

    public static Cardholder create(Map<String, Object> params) throws StripeException {
        return Cardholder.create(params, (RequestOptions)null);
    }

    public static Cardholder create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cardholders");
        return Cardholder.request(ApiResource.RequestMethod.POST, url, params, Cardholder.class, options);
    }

    public static Cardholder create(CardholderCreateParams params) throws StripeException {
        return Cardholder.create(params, (RequestOptions)null);
    }

    public static Cardholder create(CardholderCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cardholders");
        return Cardholder.request(ApiResource.RequestMethod.POST, url, params, Cardholder.class, options);
    }

    public static Cardholder retrieve(String cardholder) throws StripeException {
        return Cardholder.retrieve(cardholder, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Cardholder retrieve(String cardholder, RequestOptions options) throws StripeException {
        return Cardholder.retrieve(cardholder, (Map<String, Object>)null, options);
    }

    public static Cardholder retrieve(String cardholder, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cardholders/%s", cardholder));
        return Cardholder.request(ApiResource.RequestMethod.GET, url, params, Cardholder.class, options);
    }

    public static Cardholder retrieve(String cardholder, CardholderRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cardholders/%s", cardholder));
        return Cardholder.request(ApiResource.RequestMethod.GET, url, params, Cardholder.class, options);
    }

    public Cardholder update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Cardholder update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cardholders/%s", this.getId()));
        return Cardholder.request(ApiResource.RequestMethod.POST, url, params, Cardholder.class, options);
    }

    public Cardholder update(CardholderUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Cardholder update(CardholderUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cardholders/%s", this.getId()));
        return Cardholder.request(ApiResource.RequestMethod.POST, url, params, Cardholder.class, options);
    }

    @Generated
    public Billing getBilling() {
        return this.billing;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setBilling(Billing billing) {
        this.billing = billing;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cardholder)) {
            return false;
        }
        Cardholder other = (Cardholder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Billing this$billing = this.getBilling();
        Billing other$billing = other.getBilling();
        if (this$billing == null ? other$billing != null : !((Object)this$billing).equals(other$billing)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Boolean this$isDefault = this.getIsDefault();
        Boolean other$isDefault = other.getIsDefault();
        if (this$isDefault == null ? other$isDefault != null : !((Object)this$isDefault).equals(other$isDefault)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$phoneNumber = this.getPhoneNumber();
        String other$phoneNumber = other.getPhoneNumber();
        if (this$phoneNumber == null ? other$phoneNumber != null : !this$phoneNumber.equals(other$phoneNumber)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Cardholder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Billing $billing = this.getBilling();
        result = result * 59 + ($billing == null ? 43 : ((Object)$billing).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Boolean $isDefault = this.getIsDefault();
        result = result * 59 + ($isDefault == null ? 43 : ((Object)$isDefault).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $phoneNumber = this.getPhoneNumber();
        result = result * 59 + ($phoneNumber == null ? 43 : $phoneNumber.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Billing
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="name")
        String name;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Billing)) {
                return false;
            }
            Billing other = (Billing)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Billing;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }
}

