/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.ExpandableField;
import com.stripe.model.MetadataStore;
import com.stripe.model.issuing.Authorization;
import com.stripe.model.issuing.Card;
import com.stripe.model.issuing.Cardholder;
import com.stripe.model.issuing.Dispute;
import com.stripe.model.issuing.MerchantData;
import com.stripe.model.issuing.TransactionCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.issuing.TransactionListParams;
import com.stripe.param.issuing.TransactionRetrieveParams;
import com.stripe.param.issuing.TransactionUpdateParams;
import java.util.Map;
import lombok.Generated;

public class Transaction
extends ApiResource
implements BalanceTransactionSource,
MetadataStore<Transaction> {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="authorization")
    ExpandableField<Authorization> authorization;
    @SerializedName(value="balance_transaction")
    ExpandableField<BalanceTransaction> balanceTransaction;
    @SerializedName(value="card")
    ExpandableField<Card> card;
    @SerializedName(value="cardholder")
    ExpandableField<Cardholder> cardholder;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="dispute")
    ExpandableField<Dispute> dispute;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="merchant_data")
    MerchantData merchantData;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="type")
    String type;

    public String getAuthorization() {
        return this.authorization != null ? this.authorization.getId() : null;
    }

    public void setAuthorization(String id) {
        this.authorization = ApiResource.setExpandableFieldId(id, this.authorization);
    }

    public Authorization getAuthorizationObject() {
        return this.authorization != null ? this.authorization.getExpanded() : null;
    }

    public void setAuthorizationObject(Authorization expandableObject) {
        this.authorization = new ExpandableField<Authorization>(expandableObject.getId(), expandableObject);
    }

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String id) {
        this.balanceTransaction = ApiResource.setExpandableFieldId(id, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction expandableObject) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public String getCard() {
        return this.card != null ? this.card.getId() : null;
    }

    public void setCard(String id) {
        this.card = ApiResource.setExpandableFieldId(id, this.card);
    }

    public Card getCardObject() {
        return this.card != null ? this.card.getExpanded() : null;
    }

    public void setCardObject(Card expandableObject) {
        this.card = new ExpandableField<Card>(expandableObject.getId(), expandableObject);
    }

    public String getCardholder() {
        return this.cardholder != null ? this.cardholder.getId() : null;
    }

    public void setCardholder(String id) {
        this.cardholder = ApiResource.setExpandableFieldId(id, this.cardholder);
    }

    public Cardholder getCardholderObject() {
        return this.cardholder != null ? this.cardholder.getExpanded() : null;
    }

    public void setCardholderObject(Cardholder expandableObject) {
        this.cardholder = new ExpandableField<Cardholder>(expandableObject.getId(), expandableObject);
    }

    public String getDispute() {
        return this.dispute != null ? this.dispute.getId() : null;
    }

    public void setDispute(String id) {
        this.dispute = ApiResource.setExpandableFieldId(id, this.dispute);
    }

    public Dispute getDisputeObject() {
        return this.dispute != null ? this.dispute.getExpanded() : null;
    }

    public void setDisputeObject(Dispute expandableObject) {
        this.dispute = new ExpandableField<Dispute>(expandableObject.getId(), expandableObject);
    }

    public static TransactionCollection list(Map<String, Object> params) throws StripeException {
        return Transaction.list(params, (RequestOptions)null);
    }

    public static TransactionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/transactions");
        return Transaction.requestCollection(url, params, TransactionCollection.class, options);
    }

    public static TransactionCollection list(TransactionListParams params) throws StripeException {
        return Transaction.list(params, (RequestOptions)null);
    }

    public static TransactionCollection list(TransactionListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/transactions");
        return Transaction.requestCollection(url, params, TransactionCollection.class, options);
    }

    public static Transaction retrieve(String transaction) throws StripeException {
        return Transaction.retrieve(transaction, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Transaction retrieve(String transaction, RequestOptions options) throws StripeException {
        return Transaction.retrieve(transaction, (Map<String, Object>)null, options);
    }

    public static Transaction retrieve(String transaction, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/transactions/%s", transaction));
        return Transaction.request(ApiResource.RequestMethod.GET, url, params, Transaction.class, options);
    }

    public static Transaction retrieve(String transaction, TransactionRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/transactions/%s", transaction));
        return Transaction.request(ApiResource.RequestMethod.GET, url, params, Transaction.class, options);
    }

    public Transaction update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Transaction update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/transactions/%s", this.getId()));
        return Transaction.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
    }

    public Transaction update(TransactionUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Transaction update(TransactionUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/transactions/%s", this.getId()));
        return Transaction.request(ApiResource.RequestMethod.POST, url, params, Transaction.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public MerchantData getMerchantData() {
        return this.merchantData;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMerchantData(MerchantData merchantData) {
        this.merchantData = merchantData;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$authorization = this.getAuthorization();
        String other$authorization = other.getAuthorization();
        if (this$authorization == null ? other$authorization != null : !this$authorization.equals(other$authorization)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        String this$card = this.getCard();
        String other$card = other.getCard();
        if (this$card == null ? other$card != null : !this$card.equals(other$card)) {
            return false;
        }
        String this$cardholder = this.getCardholder();
        String other$cardholder = other.getCardholder();
        if (this$cardholder == null ? other$cardholder != null : !this$cardholder.equals(other$cardholder)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$dispute = this.getDispute();
        String other$dispute = other.getDispute();
        if (this$dispute == null ? other$dispute != null : !this$dispute.equals(other$dispute)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        MerchantData this$merchantData = this.getMerchantData();
        MerchantData other$merchantData = other.getMerchantData();
        if (this$merchantData == null ? other$merchantData != null : !((Object)this$merchantData).equals(other$merchantData)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Transaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $authorization = this.getAuthorization();
        result = result * 59 + ($authorization == null ? 43 : $authorization.hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        String $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : $card.hashCode());
        String $cardholder = this.getCardholder();
        result = result * 59 + ($cardholder == null ? 43 : $cardholder.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $dispute = this.getDispute();
        result = result * 59 + ($dispute == null ? 43 : $dispute.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        MerchantData $merchantData = this.getMerchantData();
        result = result * 59 + ($merchantData == null ? 43 : ((Object)$merchantData).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

