/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.sigma;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.File;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.sigma.ScheduledQueryRunCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.sigma.ScheduledQueryRunListParams;
import com.stripe.param.sigma.ScheduledQueryRunRetrieveParams;
import java.util.Map;
import lombok.Generated;

public class ScheduledQueryRun
extends ApiResource
implements HasId {
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="data_load_time")
    Long dataLoadTime;
    @SerializedName(value="error")
    RunError error;
    @SerializedName(value="file")
    File file;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="result_available_until")
    Long resultAvailableUntil;
    @SerializedName(value="sql")
    String sql;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="title")
    String title;

    public static ScheduledQueryRunCollection list(Map<String, Object> params) throws StripeException {
        return ScheduledQueryRun.list(params, (RequestOptions)null);
    }

    public static ScheduledQueryRunCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/sigma/scheduled_query_runs");
        return ScheduledQueryRun.requestCollection(url, params, ScheduledQueryRunCollection.class, options);
    }

    public static ScheduledQueryRunCollection list(ScheduledQueryRunListParams params) throws StripeException {
        return ScheduledQueryRun.list(params, (RequestOptions)null);
    }

    public static ScheduledQueryRunCollection list(ScheduledQueryRunListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/sigma/scheduled_query_runs");
        return ScheduledQueryRun.requestCollection(url, params, ScheduledQueryRunCollection.class, options);
    }

    public static ScheduledQueryRun retrieve(String scheduledQueryRun) throws StripeException {
        return ScheduledQueryRun.retrieve(scheduledQueryRun, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static ScheduledQueryRun retrieve(String scheduledQueryRun, RequestOptions options) throws StripeException {
        return ScheduledQueryRun.retrieve(scheduledQueryRun, (Map<String, Object>)null, options);
    }

    public static ScheduledQueryRun retrieve(String scheduledQueryRun, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sigma/scheduled_query_runs/%s", scheduledQueryRun));
        return ScheduledQueryRun.request(ApiResource.RequestMethod.GET, url, params, ScheduledQueryRun.class, options);
    }

    public static ScheduledQueryRun retrieve(String scheduledQueryRun, ScheduledQueryRunRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sigma/scheduled_query_runs/%s", scheduledQueryRun));
        return ScheduledQueryRun.request(ApiResource.RequestMethod.GET, url, params, ScheduledQueryRun.class, options);
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Long getDataLoadTime() {
        return this.dataLoadTime;
    }

    @Generated
    public RunError getError() {
        return this.error;
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getResultAvailableUntil() {
        return this.resultAvailableUntil;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDataLoadTime(Long dataLoadTime) {
        this.dataLoadTime = dataLoadTime;
    }

    @Generated
    public void setError(RunError error) {
        this.error = error;
    }

    @Generated
    public void setFile(File file) {
        this.file = file;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setResultAvailableUntil(Long resultAvailableUntil) {
        this.resultAvailableUntil = resultAvailableUntil;
    }

    @Generated
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduledQueryRun)) {
            return false;
        }
        ScheduledQueryRun other = (ScheduledQueryRun)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$dataLoadTime = this.getDataLoadTime();
        Long other$dataLoadTime = other.getDataLoadTime();
        if (this$dataLoadTime == null ? other$dataLoadTime != null : !((Object)this$dataLoadTime).equals(other$dataLoadTime)) {
            return false;
        }
        RunError this$error = this.getError();
        RunError other$error = other.getError();
        if (this$error == null ? other$error != null : !((Object)this$error).equals(other$error)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$resultAvailableUntil = this.getResultAvailableUntil();
        Long other$resultAvailableUntil = other.getResultAvailableUntil();
        if (this$resultAvailableUntil == null ? other$resultAvailableUntil != null : !((Object)this$resultAvailableUntil).equals(other$resultAvailableUntil)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        return !(this$title == null ? other$title != null : !this$title.equals(other$title));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScheduledQueryRun;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $dataLoadTime = this.getDataLoadTime();
        result = result * 59 + ($dataLoadTime == null ? 43 : ((Object)$dataLoadTime).hashCode());
        RunError $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $resultAvailableUntil = this.getResultAvailableUntil();
        result = result * 59 + ($resultAvailableUntil == null ? 43 : ((Object)$resultAvailableUntil).hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class RunError
    extends StripeObject {
        @SerializedName(value="message")
        String message;

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RunError)) {
                return false;
            }
            RunError other = (RunError)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RunError;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }
    }
}

