/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.terminal;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.HasId;
import com.stripe.model.terminal.LocationCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.terminal.LocationCreateParams;
import com.stripe.param.terminal.LocationDeleteParams;
import com.stripe.param.terminal.LocationListParams;
import com.stripe.param.terminal.LocationRetrieveParams;
import com.stripe.param.terminal.LocationUpdateParams;
import java.util.Map;
import lombok.Generated;

public class Location
extends ApiResource
implements HasId {
    @SerializedName(value="address")
    Address address;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="display_name")
    String displayName;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="object")
    String object;

    public static Location retrieve(String location) throws StripeException {
        return Location.retrieve(location, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Location retrieve(String location, RequestOptions options) throws StripeException {
        return Location.retrieve(location, (Map<String, Object>)null, options);
    }

    public static Location retrieve(String location, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/locations/%s", location));
        return Location.request(ApiResource.RequestMethod.GET, url, params, Location.class, options);
    }

    public static Location retrieve(String location, LocationRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/locations/%s", location));
        return Location.request(ApiResource.RequestMethod.GET, url, params, Location.class, options);
    }

    public static Location create(Map<String, Object> params) throws StripeException {
        return Location.create(params, (RequestOptions)null);
    }

    public static Location create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/locations");
        return Location.request(ApiResource.RequestMethod.POST, url, params, Location.class, options);
    }

    public static Location create(LocationCreateParams params) throws StripeException {
        return Location.create(params, (RequestOptions)null);
    }

    public static Location create(LocationCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/locations");
        return Location.request(ApiResource.RequestMethod.POST, url, params, Location.class, options);
    }

    public Location update(Map<String, Object> params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Location update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/locations/%s", this.getId()));
        return Location.request(ApiResource.RequestMethod.POST, url, params, Location.class, options);
    }

    public Location update(LocationUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Location update(LocationUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/locations/%s", this.getId()));
        return Location.request(ApiResource.RequestMethod.POST, url, params, Location.class, options);
    }

    public static LocationCollection list(Map<String, Object> params) throws StripeException {
        return Location.list(params, (RequestOptions)null);
    }

    public static LocationCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/locations");
        return Location.requestCollection(url, params, LocationCollection.class, options);
    }

    public static LocationCollection list(LocationListParams params) throws StripeException {
        return Location.list(params, (RequestOptions)null);
    }

    public static LocationCollection list(LocationListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/locations");
        return Location.requestCollection(url, params, LocationCollection.class, options);
    }

    public Location delete() throws StripeException {
        return this.delete((Map<String, Object>)null, (RequestOptions)null);
    }

    public Location delete(RequestOptions options) throws StripeException {
        return this.delete((Map<String, Object>)null, options);
    }

    public Location delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, (RequestOptions)null);
    }

    public Location delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/locations/%s", this.getId()));
        return Location.request(ApiResource.RequestMethod.DELETE, url, params, Location.class, options);
    }

    public Location delete(LocationDeleteParams params) throws StripeException {
        return this.delete(params, (RequestOptions)null);
    }

    public Location delete(LocationDeleteParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/locations/%s", this.getId()));
        return Location.request(ApiResource.RequestMethod.DELETE, url, params, Location.class, options);
    }

    @Generated
    public Address getAddress() {
        return this.address;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setAddress(Address address) {
        this.address = address;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location other = (Location)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Location;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

