/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.stripe.Stripe;
import com.stripe.exception.InvalidRequestException;
import com.stripe.exception.StripeException;
import com.stripe.model.EphemeralKey;
import com.stripe.model.EphemeralKeyDeserializer;
import com.stripe.model.EventData;
import com.stripe.model.EventDataDeserializer;
import com.stripe.model.EventRequest;
import com.stripe.model.EventRequestDeserializer;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExpandableFieldDeserializer;
import com.stripe.model.HasId;
import com.stripe.model.StripeCollectionInterface;
import com.stripe.model.StripeObject;
import com.stripe.model.StripeRawJsonObject;
import com.stripe.model.StripeRawJsonObjectDeserializer;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResourceTypeAdapterFactoryProvider;
import com.stripe.net.LiveStripeResponseGetter;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;

public abstract class ApiResource
extends StripeObject {
    private static StripeResponseGetter stripeResponseGetter = new LiveStripeResponseGetter();
    public static final Gson GSON = ApiResource.createGson();
    public static final String CHARSET = "UTF-8";

    public static void setStripeResponseGetter(StripeResponseGetter srg) {
        stripeResponseGetter = srg;
    }

    private static Gson createGson() {
        GsonBuilder builder = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(EphemeralKey.class, (Object)new EphemeralKeyDeserializer()).registerTypeAdapter(EventData.class, (Object)new EventDataDeserializer()).registerTypeAdapter(EventRequest.class, (Object)new EventRequestDeserializer()).registerTypeAdapter(ExpandableField.class, (Object)new ExpandableFieldDeserializer()).registerTypeAdapter(StripeRawJsonObject.class, (Object)new StripeRawJsonObjectDeserializer());
        for (TypeAdapterFactory factory : ApiResourceTypeAdapterFactoryProvider.getAll()) {
            builder.registerTypeAdapterFactory(factory);
        }
        return builder.create();
    }

    private static String className(Class<?> clazz) {
        String className = clazz.getSimpleName().replaceAll("(.)([A-Z][a-z]+)", "$1_$2").replaceAll("([a-z0-9])([A-Z])", "$1_$2").toLowerCase();
        String[] parts = clazz.getPackage().getName().split("\\.", -1);
        assert (parts.length == 3 || parts.length == 4);
        if (parts.length == 4) {
            className = parts[3] + "/" + className;
        }
        switch (className) {
            case "invoice_item": {
                return "invoiceitem";
            }
            case "file_upload": {
                return "file";
            }
        }
        return className;
    }

    protected static String singleClassUrl(Class<?> clazz) {
        return ApiResource.singleClassUrl(clazz, Stripe.getApiBase());
    }

    protected static String singleClassUrl(Class<?> clazz, String apiBase) {
        return String.format("%s/v1/%s", apiBase, ApiResource.className(clazz));
    }

    protected static String classUrl(Class<?> clazz) {
        return ApiResource.classUrl(clazz, Stripe.getApiBase());
    }

    protected static String classUrl(Class<?> clazz, String apiBase) {
        return String.format("%ss", ApiResource.singleClassUrl(clazz, apiBase));
    }

    protected static String instanceUrl(Class<?> clazz, String id) throws InvalidRequestException {
        return ApiResource.instanceUrl(clazz, id, Stripe.getApiBase());
    }

    protected static String instanceUrl(Class<?> clazz, String id, String apiBase) throws InvalidRequestException {
        try {
            return String.format("%s/%s", ApiResource.classUrl(clazz, apiBase), ApiResource.urlEncode(id));
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8. Please contact support@stripe.com for assistance.", null, null, null, 0, e);
        }
    }

    protected static String subresourceUrl(Class<?> clazz, String id, Class<?> subClazz) throws InvalidRequestException {
        return ApiResource.subresourceUrl(clazz, id, subClazz, Stripe.getApiBase());
    }

    private static String subresourceUrl(Class<?> clazz, String id, Class<?> subClazz, String apiBase) throws InvalidRequestException {
        try {
            return String.format("%s/%s/%ss", ApiResource.classUrl(clazz, apiBase), ApiResource.urlEncode(id), ApiResource.className(subClazz));
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8. Please contact support@stripe.com for assistance.", null, null, null, 0, e);
        }
    }

    public static String urlEncode(String str) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str, CHARSET).replaceAll("%5B", "[").replaceAll("%5D", "]");
    }

    public static <T> T multipartRequest(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz, RequestOptions options) throws StripeException {
        return stripeResponseGetter.request(method, url, params, clazz, RequestType.MULTIPART, options);
    }

    public static <T> T request(RequestMethod method, String url, ApiRequestParams params, Class<T> clazz, RequestOptions options) throws StripeException {
        ApiResource.checkNullTypedParams(url, params);
        return ApiResource.request(method, url, params.toMap(), clazz, options);
    }

    public static <T> T request(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz, RequestOptions options) throws StripeException {
        return stripeResponseGetter.request(method, url, params, clazz, RequestType.NORMAL, options);
    }

    public static <T extends StripeCollectionInterface<?>> T requestCollection(String url, ApiRequestParams params, Class<T> clazz, RequestOptions options) throws StripeException {
        ApiResource.checkNullTypedParams(url, params);
        return ApiResource.requestCollection(url, params.toMap(), clazz, options);
    }

    public static <T extends StripeCollectionInterface<?>> T requestCollection(String url, Map<String, Object> params, Class<T> clazz, RequestOptions options) throws StripeException {
        StripeCollectionInterface collection = (StripeCollectionInterface)ApiResource.request(RequestMethod.GET, url, params, clazz, options);
        if (collection != null) {
            collection.setRequestOptions(options);
            collection.setRequestParams(params);
        }
        return (T)collection;
    }

    public static void checkNullTypedParams(String url, ApiRequestParams params) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Found null params for %s. Please pass empty params using param builder via `builder().build()` instead.", url));
        }
    }

    public static <T extends HasId> ExpandableField<T> setExpandableFieldId(String newId, ExpandableField<T> currentObject) {
        if (currentObject == null || currentObject.isExpanded() && !Objects.equals(currentObject.getId(), newId)) {
            return new ExpandableField<Object>(newId, null);
        }
        return new ExpandableField<T>(newId, currentObject.getExpanded());
    }

    public static enum RequestType {
        NORMAL,
        MULTIPART;

    }

    public static enum RequestMethod {
        GET,
        POST,
        DELETE;

    }
}

